
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Message Parameters.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrdChangeParamsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="ns:Alerts" minOccurs="0"/>
 *     &lt;xs:element ref="ns:Notices" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Reason" minOccurs="0"/>
 *     &lt;xs:element name="RefundFOP_Preference" minOccurs="0">
 *       &lt;!-- Reference to inner class RefundFOPPreference -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="References"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OrdChangeParamsType implements Serializable
{
    private AlertsType alerts;
    private Notices notices;
    private String reason;
    private RefundFOPPreference refundFOPPreference;
    private String references;

    /** 
     * Get the 'Alerts' element value.
     * 
     * @return value
     */
    public AlertsType getAlerts() {
        return alerts;
    }

    /** 
     * Set the 'Alerts' element value.
     * 
     * @param alerts
     */
    public void setAlerts(AlertsType alerts) {
        this.alerts = alerts;
    }

    /** 
     * Get the 'Notices' element value.
     * 
     * @return value
     */
    public Notices getNotices() {
        return notices;
    }

    /** 
     * Set the 'Notices' element value.
     * 
     * @param notices
     */
    public void setNotices(Notices notices) {
        this.notices = notices;
    }

    /** 
     * Get the 'Reason' element value. Reason for change. 

    Encoding Scheme: IATA Padis Codeset REA
     * 
     * @return value
     */
    public String getReason() {
        return reason;
    }

    /** 
     * Set the 'Reason' element value. Reason for change. 

    Encoding Scheme: IATA Padis Codeset REA
     * 
     * @param reason
     */
    public void setReason(String reason) {
        this.reason = reason;
    }

    /** 
     * Get the 'RefundFOP_Preference' element value.
     * 
     * @return value
     */
    public RefundFOPPreference getRefundFOPPreference() {
        return refundFOPPreference;
    }

    /** 
     * Set the 'RefundFOP_Preference' element value.
     * 
     * @param refundFOPPreference
     */
    public void setRefundFOPPreference(RefundFOPPreference refundFOPPreference) {
        this.refundFOPPreference = refundFOPPreference;
    }

    /** 
     * Get the 'References' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getReferences() {
        return references;
    }

    /** 
     * Set the 'References' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param references
     */
    public void setReferences(String references) {
        this.references = references;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RefundFOP_Preference" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice minOccurs="0">
     *       &lt;!-- Reference to inner class Choice -->
     *     &lt;/xs:choice>
     *     &lt;xs:attribute type="xs:boolean" name="OriginalFOP_Ind"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class RefundFOPPreference implements Serializable
    {
        private Choice choice;
        private Boolean originalFOPInd;

        /** 
         * Get the choice value.
         * 
         * @return value
         */
        public Choice getChoice() {
            return choice;
        }

        /** 
         * Set the choice value.
         * 
         * @param choice
         */
        public void setChoice(Choice choice) {
            this.choice = choice;
        }

        /** 
         * Get the 'OriginalFOP_Ind' attribute value. When true, it is requested that the refund be applied to the original FOP
         * 
         * @return value
         */
        public Boolean getOriginalFOPInd() {
            return originalFOPInd;
        }

        /** 
         * Set the 'OriginalFOP_Ind' attribute value. When true, it is requested that the refund be applied to the original FOP
         * 
         * @param originalFOPInd
         */
        public void setOriginalFOPInd(Boolean originalFOPInd) {
            this.originalFOPInd = originalFOPInd;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:choice xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
         *   &lt;xs:element ref="ns:Voucher" minOccurs="0"/>
         *   &lt;xs:element ref="ns:PaymentCard" minOccurs="0"/>
         *   &lt;xs:element ref="ns:Cash" minOccurs="0"/>
         *   &lt;xs:element ref="ns:BankAccount" minOccurs="0"/>
         *   &lt;xs:element ref="ns:Check" minOccurs="0"/>
         *   &lt;xs:element type="xs:boolean" name="CarrierCredit" minOccurs="0"/>
         * &lt;/xs:choice>
         * </pre>
         */
        public static class Choice implements Serializable
        {
            private int choiceSelect = -1;
            private static final int VOUCHER_CHOICE = 0;
            private static final int PAYMENT_CARD_CHOICE = 1;
            private static final int CASH_CHOICE = 2;
            private static final int BANK_ACCOUNT_CHOICE = 3;
            private static final int CHECK_CHOICE = 4;
            private static final int CARRIER_CREDIT_CHOICE = 5;
            private Voucher voucher;
            private PaymentCardType paymentCard;
            private Cash cash;
            private BankAccountType bankAccount;
            private Check check;
            private Boolean carrierCredit;

            private void setChoiceSelect(int choice) {
                if (choiceSelect == -1) {
                    choiceSelect = choice;
                } else if (choiceSelect != choice) {
                    throw new IllegalStateException(
                            "Need to call clearChoiceSelect() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearChoiceSelect() {
                choiceSelect = -1;
            }

            /** 
             * Check if Voucher is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifVoucher() {
                return choiceSelect == VOUCHER_CHOICE;
            }

            /** 
             * Get the 'Voucher' element value. Information relating to prepayment vouchers.
             * 
             * @return value
             */
            public Voucher getVoucher() {
                return voucher;
            }

            /** 
             * Set the 'Voucher' element value. Information relating to prepayment vouchers.
             * 
             * @param voucher
             */
            public void setVoucher(Voucher voucher) {
                setChoiceSelect(VOUCHER_CHOICE);
                this.voucher = voucher;
            }

            /** 
             * Check if PaymentCard is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifPaymentCard() {
                return choiceSelect == PAYMENT_CARD_CHOICE;
            }

            /** 
             * Get the 'PaymentCard' element value.
             * 
             * @return value
             */
            public PaymentCardType getPaymentCard() {
                return paymentCard;
            }

            /** 
             * Set the 'PaymentCard' element value.
             * 
             * @param paymentCard
             */
            public void setPaymentCard(PaymentCardType paymentCard) {
                setChoiceSelect(PAYMENT_CARD_CHOICE);
                this.paymentCard = paymentCard;
            }

            /** 
             * Check if Cash is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifCash() {
                return choiceSelect == CASH_CHOICE;
            }

            /** 
             * Get the 'Cash' element value.
             * 
             * @return value
             */
            public Cash getCash() {
                return cash;
            }

            /** 
             * Set the 'Cash' element value.
             * 
             * @param cash
             */
            public void setCash(Cash cash) {
                setChoiceSelect(CASH_CHOICE);
                this.cash = cash;
            }

            /** 
             * Check if BankAccount is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifBankAccount() {
                return choiceSelect == BANK_ACCOUNT_CHOICE;
            }

            /** 
             * Get the 'BankAccount' element value.
             * 
             * @return value
             */
            public BankAccountType getBankAccount() {
                return bankAccount;
            }

            /** 
             * Set the 'BankAccount' element value.
             * 
             * @param bankAccount
             */
            public void setBankAccount(BankAccountType bankAccount) {
                setChoiceSelect(BANK_ACCOUNT_CHOICE);
                this.bankAccount = bankAccount;
            }

            /** 
             * Check if Check is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifCheck() {
                return choiceSelect == CHECK_CHOICE;
            }

            /** 
             * Get the 'Check' element value. Check (Cheque) Payment
             * 
             * @return value
             */
            public Check getCheck() {
                return check;
            }

            /** 
             * Set the 'Check' element value. Check (Cheque) Payment
             * 
             * @param check
             */
            public void setCheck(Check check) {
                setChoiceSelect(CHECK_CHOICE);
                this.check = check;
            }

            /** 
             * Check if CarrierCredit is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifCarrierCredit() {
                return choiceSelect == CARRIER_CREDIT_CHOICE;
            }

            /** 
             * Get the 'CarrierCredit' element value. If true, preference is to apply refund to carrier credit.
             * 
             * @return value
             */
            public Boolean getCarrierCredit() {
                return carrierCredit;
            }

            /** 
             * Set the 'CarrierCredit' element value. If true, preference is to apply refund to carrier credit.
             * 
             * @param carrierCredit
             */
            public void setCarrierCredit(Boolean carrierCredit) {
                setChoiceSelect(CARRIER_CREDIT_CHOICE);
                this.carrierCredit = carrierCredit;
            }
        }
    }
}
