
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * The OrderCancel transaction set requests the cancellation of a specified order, and returns confirmation of cancellation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderCancelRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:PointOfSale" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element name="OrderCancelParameters" minOccurs="0">
 *         &lt;!-- Reference to inner class OrderCancelParameters -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:DetailCurrencyPriceType" name="ExpectedRefundAmount" minOccurs="0"/>
 *       &lt;xs:element name="Query">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element name="Order" minOccurs="0">
 *               &lt;!-- Reference to inner class Order -->
 *             &lt;/xs:element>
 *             &lt;xs:element ref="ns:BookingReferences" minOccurs="0"/>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OrderCancelRQ implements Serializable
{
    private PointOfSaleType pointOfSale;
    private MsgDocumentType document;
    private MsgPartiesType party;
    private OrderCancelParameters orderCancelParameters;
    private DetailCurrencyPriceType expectedRefundAmount;
    private Order order;
    private BookingReferences queryBookingReferences;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'PointOfSale' element value.
     * 
     * @return value
     */
    public PointOfSaleType getPointOfSale() {
        return pointOfSale;
    }

    /** 
     * Set the 'PointOfSale' element value.
     * 
     * @param pointOfSale
     */
    public void setPointOfSale(PointOfSaleType pointOfSale) {
        this.pointOfSale = pointOfSale;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    /** 
     * Get the 'OrderCancelParameters' element value.
     * 
     * @return value
     */
    public OrderCancelParameters getOrderCancelParameters() {
        return orderCancelParameters;
    }

    /** 
     * Set the 'OrderCancelParameters' element value.
     * 
     * @param orderCancelParameters
     */
    public void setOrderCancelParameters(
            OrderCancelParameters orderCancelParameters) {
        this.orderCancelParameters = orderCancelParameters;
    }

    /** 
     * Get the 'ExpectedRefundAmount' element value. Refund amount expected from requestor.
     * 
     * @return value
     */
    public DetailCurrencyPriceType getExpectedRefundAmount() {
        return expectedRefundAmount;
    }

    /** 
     * Set the 'ExpectedRefundAmount' element value. Refund amount expected from requestor.
     * 
     * @param expectedRefundAmount
     */
    public void setExpectedRefundAmount(
            DetailCurrencyPriceType expectedRefundAmount) {
        this.expectedRefundAmount = expectedRefundAmount;
    }

    /** 
     * Get the 'Order' element value. Order Cancel Query.
     * 
     * @return value
     */
    public Order getOrder() {
        return order;
    }

    /** 
     * Set the 'Order' element value. Order Cancel Query.
     * 
     * @param order
     */
    public void setOrder(Order order) {
        this.order = order;
    }

    /** 
     * Get the 'BookingReferences' element value. Existing Booking Reference (e.g. PNR Record Locator). Example: R1A3SK
     * 
     * @return value
     */
    public BookingReferences getQueryBookingReferences() {
        return queryBookingReferences;
    }

    /** 
     * Set the 'BookingReferences' element value. Existing Booking Reference (e.g. PNR Record Locator). Example: R1A3SK
     * 
     * @param queryBookingReferences
     */
    public void setQueryBookingReferences(
            BookingReferences queryBookingReferences) {
        this.queryBookingReferences = queryBookingReferences;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderCancelParameters" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Reason" minOccurs="0"/>
     *       &lt;xs:element name="RefundFOP_Preference" minOccurs="0">
     *         &lt;!-- Reference to inner class RefundFOPPreference -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OrderCancelParameters implements Serializable
    {
        private String reason;
        private RefundFOPPreference refundFOPPreference;

        /** 
         * Get the 'Reason' element value. Reason for cancellation. 

        Encoding Scheme: IATA Padis Codeset REA
         * 
         * @return value
         */
        public String getReason() {
            return reason;
        }

        /** 
         * Set the 'Reason' element value. Reason for cancellation. 

        Encoding Scheme: IATA Padis Codeset REA
         * 
         * @param reason
         */
        public void setReason(String reason) {
            this.reason = reason;
        }

        /** 
         * Get the 'RefundFOP_Preference' element value.
         * 
         * @return value
         */
        public RefundFOPPreference getRefundFOPPreference() {
            return refundFOPPreference;
        }

        /** 
         * Set the 'RefundFOP_Preference' element value.
         * 
         * @param refundFOPPreference
         */
        public void setRefundFOPPreference(
                RefundFOPPreference refundFOPPreference) {
            this.refundFOPPreference = refundFOPPreference;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RefundFOP_Preference" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:choice minOccurs="0">
         *       &lt;!-- Reference to inner class Choice -->
         *     &lt;/xs:choice>
         *     &lt;xs:attribute type="xs:boolean" name="OriginalFOP_Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class RefundFOPPreference implements Serializable
        {
            private Choice choice;
            private Boolean originalFOPInd;

            /** 
             * Get the choice value.
             * 
             * @return value
             */
            public Choice getChoice() {
                return choice;
            }

            /** 
             * Set the choice value.
             * 
             * @param choice
             */
            public void setChoice(Choice choice) {
                this.choice = choice;
            }

            /** 
             * Get the 'OriginalFOP_Ind' attribute value. When true, it is requested that the refund be applied to the original FOP
             * 
             * @return value
             */
            public Boolean getOriginalFOPInd() {
                return originalFOPInd;
            }

            /** 
             * Set the 'OriginalFOP_Ind' attribute value. When true, it is requested that the refund be applied to the original FOP
             * 
             * @param originalFOPInd
             */
            public void setOriginalFOPInd(Boolean originalFOPInd) {
                this.originalFOPInd = originalFOPInd;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:choice xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
             *   &lt;xs:element ref="ns:Voucher" minOccurs="0"/>
             *   &lt;xs:element ref="ns:PaymentCard" minOccurs="0"/>
             *   &lt;xs:element ref="ns:Cash" minOccurs="0"/>
             *   &lt;xs:element ref="ns:BankAccount" minOccurs="0"/>
             *   &lt;xs:element ref="ns:Check" minOccurs="0"/>
             *   &lt;xs:element type="xs:boolean" name="CarrierCredit" minOccurs="0"/>
             * &lt;/xs:choice>
             * </pre>
             */
            public static class Choice implements Serializable
            {
                private int choiceSelect = -1;
                private static final int VOUCHER_CHOICE = 0;
                private static final int PAYMENT_CARD_CHOICE = 1;
                private static final int CASH_CHOICE = 2;
                private static final int BANK_ACCOUNT_CHOICE = 3;
                private static final int CHECK_CHOICE = 4;
                private static final int CARRIER_CREDIT_CHOICE = 5;
                private Voucher voucher;
                private PaymentCardType paymentCard;
                private Cash cash;
                private BankAccountType bankAccount;
                private Check check;
                private Boolean carrierCredit;

                private void setChoiceSelect(int choice) {
                    if (choiceSelect == -1) {
                        choiceSelect = choice;
                    } else if (choiceSelect != choice) {
                        throw new IllegalStateException(
                                "Need to call clearChoiceSelect() before changing existing choice");
                    }
                }

                /** 
                 * Clear the choice selection.
                 */
                public void clearChoiceSelect() {
                    choiceSelect = -1;
                }

                /** 
                 * Check if Voucher is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifVoucher() {
                    return choiceSelect == VOUCHER_CHOICE;
                }

                /** 
                 * Get the 'Voucher' element value. Information relating to prepayment vouchers.
                 * 
                 * @return value
                 */
                public Voucher getVoucher() {
                    return voucher;
                }

                /** 
                 * Set the 'Voucher' element value. Information relating to prepayment vouchers.
                 * 
                 * @param voucher
                 */
                public void setVoucher(Voucher voucher) {
                    setChoiceSelect(VOUCHER_CHOICE);
                    this.voucher = voucher;
                }

                /** 
                 * Check if PaymentCard is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifPaymentCard() {
                    return choiceSelect == PAYMENT_CARD_CHOICE;
                }

                /** 
                 * Get the 'PaymentCard' element value.
                 * 
                 * @return value
                 */
                public PaymentCardType getPaymentCard() {
                    return paymentCard;
                }

                /** 
                 * Set the 'PaymentCard' element value.
                 * 
                 * @param paymentCard
                 */
                public void setPaymentCard(PaymentCardType paymentCard) {
                    setChoiceSelect(PAYMENT_CARD_CHOICE);
                    this.paymentCard = paymentCard;
                }

                /** 
                 * Check if Cash is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifCash() {
                    return choiceSelect == CASH_CHOICE;
                }

                /** 
                 * Get the 'Cash' element value.
                 * 
                 * @return value
                 */
                public Cash getCash() {
                    return cash;
                }

                /** 
                 * Set the 'Cash' element value.
                 * 
                 * @param cash
                 */
                public void setCash(Cash cash) {
                    setChoiceSelect(CASH_CHOICE);
                    this.cash = cash;
                }

                /** 
                 * Check if BankAccount is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifBankAccount() {
                    return choiceSelect == BANK_ACCOUNT_CHOICE;
                }

                /** 
                 * Get the 'BankAccount' element value.
                 * 
                 * @return value
                 */
                public BankAccountType getBankAccount() {
                    return bankAccount;
                }

                /** 
                 * Set the 'BankAccount' element value.
                 * 
                 * @param bankAccount
                 */
                public void setBankAccount(BankAccountType bankAccount) {
                    setChoiceSelect(BANK_ACCOUNT_CHOICE);
                    this.bankAccount = bankAccount;
                }

                /** 
                 * Check if Check is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifCheck() {
                    return choiceSelect == CHECK_CHOICE;
                }

                /** 
                 * Get the 'Check' element value. Check (Cheque) Payment
                 * 
                 * @return value
                 */
                public Check getCheck() {
                    return check;
                }

                /** 
                 * Set the 'Check' element value. Check (Cheque) Payment
                 * 
                 * @param check
                 */
                public void setCheck(Check check) {
                    setChoiceSelect(CHECK_CHOICE);
                    this.check = check;
                }

                /** 
                 * Check if CarrierCredit is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifCarrierCredit() {
                    return choiceSelect == CARRIER_CREDIT_CHOICE;
                }

                /** 
                 * Get the 'CarrierCredit' element value. If true, preference is to apply refund to carrier credit.
                 * 
                 * @return value
                 */
                public Boolean getCarrierCredit() {
                    return carrierCredit;
                }

                /** 
                 * Set the 'CarrierCredit' element value. If true, preference is to apply refund to carrier credit.
                 * 
                 * @param carrierCredit
                 */
                public void setCarrierCredit(Boolean carrierCredit) {
                    setChoiceSelect(CARRIER_CREDIT_CHOICE);
                    this.carrierCredit = carrierCredit;
                }
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Order" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="required" name="OrderID"/>
     *     &lt;xs:attribute type="xs:string" use="required" name="Owner"/>
     *     &lt;xs:attribute name="OwnerType">
     *       &lt;xs:simpleType>
     *         &lt;!-- Reference to inner class OwnerType -->
     *       &lt;/xs:simpleType>
     *     &lt;/xs:attribute>
     *     &lt;xs:attribute type="xs:string" name="WebAddressID"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="MetadataRefs"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Order implements Serializable
    {
        private String orderID;
        private String owner;
        private OwnerType ownerType;
        private String webAddressID;
        private String metadataRefs;

        /** 
         * Get the 'OrderID' attribute value. The airline-assigned unique Order ID. Example: ORDER-c98c-4759-a20b
         * 
         * @return value
         */
        public String getOrderID() {
            return orderID;
        }

        /** 
         * Set the 'OrderID' attribute value. The airline-assigned unique Order ID. Example: ORDER-c98c-4759-a20b
         * 
         * @param orderID
         */
        public void setOrderID(String orderID) {
            this.orderID = orderID;
        }

        /** 
         * Get the 'Owner' attribute value. Airline Designator of airline that owns/ assigned this ID. Example: BA

        Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Codes
         * 
         * @return value
         */
        public String getOwner() {
            return owner;
        }

        /** 
         * Set the 'Owner' attribute value. Airline Designator of airline that owns/ assigned this ID. Example: BA

        Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Codes
         * 
         * @param owner
         */
        public void setOwner(String owner) {
            this.owner = owner;
        }

        /** 
         * Get the 'OwnerType' attribute value. The POA OrderID should only go to the ORA, not back to the seller.
        1. ORA
        2. POA
         * 
         * @return value
         */
        public OwnerType getOwnerType() {
            return ownerType;
        }

        /** 
         * Set the 'OwnerType' attribute value. The POA OrderID should only go to the ORA, not back to the seller.
        1. ORA
        2. POA
         * 
         * @param ownerType
         */
        public void setOwnerType(OwnerType ownerType) {
            this.ownerType = ownerType;
        }

        /** 
         * Get the 'WebAddressID' attribute value. Deep linking into another site to complete the transaction.
         * 
         * @return value
         */
        public String getWebAddressID() {
            return webAddressID;
        }

        /** 
         * Set the 'WebAddressID' attribute value. Deep linking into another site to complete the transaction.
         * 
         * @param webAddressID
         */
        public void setWebAddressID(String webAddressID) {
            this.webAddressID = webAddressID;
        }

        /** 
         * Get the 'MetadataRefs' attribute value. Object Metadata Association(s). Example: meta1 meta3
         * 
         * @return value
         */
        public String getMetadataRefs() {
            return metadataRefs;
        }

        /** 
         * Set the 'MetadataRefs' attribute value. Object Metadata Association(s). Example: meta1 meta3
         * 
         * @param metadataRefs
         */
        public void setMetadataRefs(String metadataRefs) {
            this.metadataRefs = metadataRefs;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
         *   &lt;xs:restriction base="xs:string">
         *     &lt;xs:enumeration value="ORA"/>
         *     &lt;xs:enumeration value="POA"/>
         *   &lt;/xs:restriction>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static enum OwnerType implements Serializable {
            ORA, POA
        }
    }
}
