
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** 
 * The OrderChangeNotif transaction sends an unsolicited order change notification message. The Acknowledgement message may be returned to acknowledge receipt of the notification request.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderChangeNotif">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element name="Query">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element type="ns:GroupType" name="Group" minOccurs="0"/>
 *             &lt;xs:element name="Order">
 *               &lt;xs:complexType>
 *                 &lt;xs:complexContent>
 *                   &lt;xs:extension base="ns:OrderType">
 *                     &lt;xs:sequence>
 *                       &lt;xs:element type="ns:OrderItemType" name="OrderItems"/>
 *                     &lt;/xs:sequence>
 *                   &lt;/xs:extension>
 *                 &lt;/xs:complexContent>
 *               &lt;/xs:complexType>
 *             &lt;/xs:element>
 *             &lt;xs:element name="TicketDocInfos" minOccurs="0">
 *               &lt;!-- Reference to inner class TicketDocInfos -->
 *             &lt;/xs:element>
 *             &lt;xs:element type="ns:CommissionType" name="Commission" minOccurs="0"/>
 *             &lt;xs:element name="Amendments" minOccurs="0">
 *               &lt;!-- Reference to inner class Amendments -->
 *             &lt;/xs:element>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:element name="DataLists" minOccurs="0">
 *         &lt;!-- Reference to inner class DataLists -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OrderChangeNotif implements Serializable
{
    private MsgDocumentType document;
    private MsgPartiesType party;
    private GroupType queryGroup;
    private OrderType queryOrderOrderType;
    private OrderItemType queryOrderOrderItems;
    private TicketDocInfos ticketDocInfos;
    private CommissionType queryCommission;
    private Amendments amendments;
    private DataLists dataLists;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    /** 
     * Get the 'Group' element value. Group Information.
     * 
     * @return value
     */
    public GroupType getQueryGroup() {
        return queryGroup;
    }

    /** 
     * Set the 'Group' element value. Group Information.
     * 
     * @param queryGroup
     */
    public void setQueryGroup(GroupType queryGroup) {
        this.queryGroup = queryGroup;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public OrderType getQueryOrderOrderType() {
        return queryOrderOrderType;
    }

    /** 
     * Set the extension value.
     * 
     * @param queryOrderOrderType
     */
    public void setQueryOrderOrderType(OrderType queryOrderOrderType) {
        this.queryOrderOrderType = queryOrderOrderType;
    }

    /** 
     * Get the 'OrderItems' element value. Order Item Detail.
     * 
     * @return value
     */
    public OrderItemType getQueryOrderOrderItems() {
        return queryOrderOrderItems;
    }

    /** 
     * Set the 'OrderItems' element value. Order Item Detail.
     * 
     * @param queryOrderOrderItems
     */
    public void setQueryOrderOrderItems(OrderItemType queryOrderOrderItems) {
        this.queryOrderOrderItems = queryOrderOrderItems;
    }

    /** 
     * Get the 'TicketDocInfos' element value. Order Change Notification.
     * 
     * @return value
     */
    public TicketDocInfos getTicketDocInfos() {
        return ticketDocInfos;
    }

    /** 
     * Set the 'TicketDocInfos' element value. Order Change Notification.
     * 
     * @param ticketDocInfos
     */
    public void setTicketDocInfos(TicketDocInfos ticketDocInfos) {
        this.ticketDocInfos = ticketDocInfos;
    }

    /** 
     * Get the 'Commission' element value. Commission information.
     * 
     * @return value
     */
    public CommissionType getQueryCommission() {
        return queryCommission;
    }

    /** 
     * Set the 'Commission' element value. Commission information.
     * 
     * @param queryCommission
     */
    public void setQueryCommission(CommissionType queryCommission) {
        this.queryCommission = queryCommission;
    }

    /** 
     * Get the 'Amendments' element value. Order Change Notification.
     * 
     * @return value
     */
    public Amendments getAmendments() {
        return amendments;
    }

    /** 
     * Set the 'Amendments' element value. Order Change Notification.
     * 
     * @param amendments
     */
    public void setAmendments(Amendments amendments) {
        this.amendments = amendments;
    }

    /** 
     * Get the 'DataLists' element value.
     * 
     * @return value
     */
    public DataLists getDataLists() {
        return dataLists;
    }

    /** 
     * Set the 'DataLists' element value.
     * 
     * @param dataLists
     */
    public void setDataLists(DataLists dataLists) {
        this.dataLists = dataLists;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Ticket/ Document Information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketDocInfos" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="TicketDocInfo" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class TicketDocInfo -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TicketDocInfos implements Serializable
    {
        private List<TicketDocInfo> ticketDocInfoList = new ArrayList<TicketDocInfo>();

        /** 
         * Get the list of 'TicketDocInfo' element items.
         * 
         * @return list
         */
        public List<TicketDocInfo> getTicketDocInfoList() {
            return ticketDocInfoList;
        }

        /** 
         * Set the list of 'TicketDocInfo' element items.
         * 
         * @param list
         */
        public void setTicketDocInfoList(List<TicketDocInfo> list) {
            ticketDocInfoList = list;
        }
        /** 
         * Ticket/document information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketDocInfo" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="AgentIDs" minOccurs="0">
         *         &lt;!-- Reference to inner class AgentIDs -->
         *       &lt;/xs:element>
         *       &lt;xs:element ref="ns:IssuingAirlineInfo" minOccurs="0"/>
         *       &lt;xs:element ref="ns:TicketDocument" maxOccurs="4"/>
         *       &lt;xs:element ref="ns:CarrierFeeInfo" minOccurs="0"/>
         *       &lt;xs:element ref="ns:OriginalIssueInfo" minOccurs="0"/>
         *       &lt;xs:element ref="ns:PassengerReference"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" name="DocActionPref"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TicketDocInfo implements Serializable
        {
            private AgentIDs agentIDs;
            private AirlineIssuanceType issuingAirlineInfo;
            private List<TicketDocument> ticketDocumentList = new ArrayList<TicketDocument>();
            private CarrierFeeInfoType carrierFeeInfo;
            private OriginalIssueType originalIssueInfo;
            private PassengerReference passengerReference;
            private String docActionPref;

            /** 
             * Get the 'AgentIDs' element value.
             * 
             * @return value
             */
            public AgentIDs getAgentIDs() {
                return agentIDs;
            }

            /** 
             * Set the 'AgentIDs' element value.
             * 
             * @param agentIDs
             */
            public void setAgentIDs(AgentIDs agentIDs) {
                this.agentIDs = agentIDs;
            }

            /** 
             * Get the 'IssuingAirlineInfo' element value.
             * 
             * @return value
             */
            public AirlineIssuanceType getIssuingAirlineInfo() {
                return issuingAirlineInfo;
            }

            /** 
             * Set the 'IssuingAirlineInfo' element value.
             * 
             * @param issuingAirlineInfo
             */
            public void setIssuingAirlineInfo(
                    AirlineIssuanceType issuingAirlineInfo) {
                this.issuingAirlineInfo = issuingAirlineInfo;
            }

            /** 
             * Get the list of 'TicketDocument' element items.
             * 
             * @return list
             */
            public List<TicketDocument> getTicketDocumentList() {
                return ticketDocumentList;
            }

            /** 
             * Set the list of 'TicketDocument' element items.
             * 
             * @param list
             */
            public void setTicketDocumentList(List<TicketDocument> list) {
                ticketDocumentList = list;
            }

            /** 
             * Get the 'CarrierFeeInfo' element value.
             * 
             * @return value
             */
            public CarrierFeeInfoType getCarrierFeeInfo() {
                return carrierFeeInfo;
            }

            /** 
             * Set the 'CarrierFeeInfo' element value.
             * 
             * @param carrierFeeInfo
             */
            public void setCarrierFeeInfo(CarrierFeeInfoType carrierFeeInfo) {
                this.carrierFeeInfo = carrierFeeInfo;
            }

            /** 
             * Get the 'OriginalIssueInfo' element value.
             * 
             * @return value
             */
            public OriginalIssueType getOriginalIssueInfo() {
                return originalIssueInfo;
            }

            /** 
             * Set the 'OriginalIssueInfo' element value.
             * 
             * @param originalIssueInfo
             */
            public void setOriginalIssueInfo(OriginalIssueType originalIssueInfo) {
                this.originalIssueInfo = originalIssueInfo;
            }

            /** 
             * Get the 'PassengerReference' element value.
             * 
             * @return value
             */
            public PassengerReference getPassengerReference() {
                return passengerReference;
            }

            /** 
             * Set the 'PassengerReference' element value.
             * 
             * @param passengerReference
             */
            public void setPassengerReference(
                    PassengerReference passengerReference) {
                this.passengerReference = passengerReference;
            }

            /** 
             * Get the 'DocActionPref' attribute value. Document Action Preference  - POA to ORA.

            Encoding Scheme: IATA Padis Codeset - List for data element 1225
             * 
             * @return value
             */
            public String getDocActionPref() {
                return docActionPref;
            }

            /** 
             * Set the 'DocActionPref' attribute value. Document Action Preference  - POA to ORA.

            Encoding Scheme: IATA Padis Codeset - List for data element 1225
             * 
             * @param docActionPref
             */
            public void setDocActionPref(String docActionPref) {
                this.docActionPref = docActionPref;
            }
            /** 
             * Booking and Servicing Agent information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AgentIDs" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element ref="ns:AgentID" maxOccurs="2"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AgentIDs implements Serializable
            {
                private List<CouponAgentType> agentIDList = new ArrayList<CouponAgentType>();

                /** 
                 * Get the list of 'AgentID' element items.
                 * 
                 * @return list
                 */
                public List<CouponAgentType> getAgentIDList() {
                    return agentIDList;
                }

                /** 
                 * Set the list of 'AgentID' element items.
                 * 
                 * @param list
                 */
                public void setAgentIDList(List<CouponAgentType> list) {
                    agentIDList = list;
                }
            }
        }
    }
    /** 
     * Order Amendment information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amendments" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Amendment" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Amendment -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Amendments implements Serializable
    {
        private List<Amendment> amendmentList = new ArrayList<Amendment>();

        /** 
         * Get the list of 'Amendment' element items.
         * 
         * @return list
         */
        public List<Amendment> getAmendmentList() {
            return amendmentList;
        }

        /** 
         * Set the list of 'Amendment' element items.
         * 
         * @param list
         */
        public void setAmendmentList(List<Amendment> list) {
            amendmentList = list;
        }
        /** 
         * Amendment Detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amendment" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="ActionType">
         *         &lt;xs:complexType>
         *           &lt;xs:simpleContent>
         *             &lt;xs:extension base="xs:string">
         *               &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
         *             &lt;/xs:extension>
         *           &lt;/xs:simpleContent>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element ref="ns:Remarks" minOccurs="0"/>
         *       &lt;xs:element name="OfferItem" minOccurs="0">
         *         &lt;!-- Reference to inner class OfferItem -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="TicketDocInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class TicketDocInfo -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Amendment implements Serializable
        {
            private String actionTypeString;
            private String actionTypeContext;
            private Remarks remarks;
            private OfferItem offerItem;
            private TicketDocInfo ticketDocInfo;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getActionTypeString() {
                return actionTypeString;
            }

            /** 
             * Set the extension value.
             * 
             * @param actionTypeString
             */
            public void setActionTypeString(String actionTypeString) {
                this.actionTypeString = actionTypeString;
            }

            /** 
             * Get the 'Context' attribute value. The reason for the action. 

            Encoding Scheme: IATA PADIS Code List for data element REA.
             * 
             * @return value
             */
            public String getActionTypeContext() {
                return actionTypeContext;
            }

            /** 
             * Set the 'Context' attribute value. The reason for the action. 

            Encoding Scheme: IATA PADIS Code List for data element REA.
             * 
             * @param actionTypeContext
             */
            public void setActionTypeContext(String actionTypeContext) {
                this.actionTypeContext = actionTypeContext;
            }

            /** 
             * Get the 'Remarks' element value.
             * 
             * @return value
             */
            public Remarks getRemarks() {
                return remarks;
            }

            /** 
             * Set the 'Remarks' element value.
             * 
             * @param remarks
             */
            public void setRemarks(Remarks remarks) {
                this.remarks = remarks;
            }

            /** 
             * Get the 'OfferItem' element value.
             * 
             * @return value
             */
            public OfferItem getOfferItem() {
                return offerItem;
            }

            /** 
             * Set the 'OfferItem' element value.
             * 
             * @param offerItem
             */
            public void setOfferItem(OfferItem offerItem) {
                this.offerItem = offerItem;
            }

            /** 
             * Get the 'TicketDocInfo' element value.
             * 
             * @return value
             */
            public TicketDocInfo getTicketDocInfo() {
                return ticketDocInfo;
            }

            /** 
             * Set the 'TicketDocInfo' element value.
             * 
             * @param ticketDocInfo
             */
            public void setTicketDocInfo(TicketDocInfo ticketDocInfo) {
                this.ticketDocInfo = ticketDocInfo;
            }
            /** 
             * Offer Item ID with optional Service ID(s).
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferItem" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:complexContent>
             *       &lt;xs:extension base="ns:AssociatedObjectBaseType">
             *         &lt;xs:sequence>
             *           &lt;xs:element ref="ns:OfferItemID"/>
             *           &lt;xs:element name="Passengers" minOccurs="0">
             *             &lt;!-- Reference to inner class Passengers -->
             *           &lt;/xs:element>
             *           &lt;xs:element name="Services" minOccurs="0">
             *             &lt;!-- Reference to inner class Services -->
             *           &lt;/xs:element>
             *           &lt;xs:element name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
             *             &lt;!-- Reference to inner class OtherAssociation -->
             *           &lt;/xs:element>
             *         &lt;/xs:sequence>
             *       &lt;/xs:extension>
             *     &lt;/xs:complexContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class OfferItem extends AssociatedObjectBaseType
                implements Serializable
            {
                private OfferItemID offerItemID;
                private Passengers passengers;
                private Services services;
                private List<OtherAssociation> otherAssociationList = new ArrayList<OtherAssociation>();

                /** 
                 * Get the 'OfferItemID' element value.
                 * 
                 * @return value
                 */
                public OfferItemID getOfferItemID() {
                    return offerItemID;
                }

                /** 
                 * Set the 'OfferItemID' element value.
                 * 
                 * @param offerItemID
                 */
                public void setOfferItemID(OfferItemID offerItemID) {
                    this.offerItemID = offerItemID;
                }

                /** 
                 * Get the 'Passengers' element value.
                 * 
                 * @return value
                 */
                public Passengers getPassengers() {
                    return passengers;
                }

                /** 
                 * Set the 'Passengers' element value.
                 * 
                 * @param passengers
                 */
                public void setPassengers(Passengers passengers) {
                    this.passengers = passengers;
                }

                /** 
                 * Get the 'Services' element value.
                 * 
                 * @return value
                 */
                public Services getServices() {
                    return services;
                }

                /** 
                 * Set the 'Services' element value.
                 * 
                 * @param services
                 */
                public void setServices(Services services) {
                    this.services = services;
                }

                /** 
                 * Get the list of 'OtherAssociation' element items.
                 * 
                 * @return list
                 */
                public List<OtherAssociation> getOtherAssociationList() {
                    return otherAssociationList;
                }

                /** 
                 * Set the list of 'OtherAssociation' element items.
                 * 
                 * @param list
                 */
                public void setOtherAssociationList(List<OtherAssociation> list) {
                    otherAssociationList = list;
                }
                /** 
                 * Passenger(s)/ Group associated with the Offer Item.

                Note: This contains references to Passenger and Group instance(s) defined in the  Passengers node.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:choice>
                 *       &lt;xs:element ref="ns:PassengerReferences"/>
                 *       &lt;xs:element ref="ns:GroupReference"/>
                 *     &lt;/xs:choice>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Passengers implements Serializable
                {
                    private int passengersSelect = -1;
                    private static final int PASSENGER_REFERENCES_CHOICE = 0;
                    private static final int GROUP_REFERENCE_CHOICE = 1;
                    private PassengerReferences passengerReferences;
                    private GroupReference groupReference;

                    private void setPassengersSelect(int choice) {
                        if (passengersSelect == -1) {
                            passengersSelect = choice;
                        } else if (passengersSelect != choice) {
                            throw new IllegalStateException(
                                    "Need to call clearPassengersSelect() before changing existing choice");
                        }
                    }

                    /** 
                     * Clear the choice selection.
                     */
                    public void clearPassengersSelect() {
                        passengersSelect = -1;
                    }

                    /** 
                     * Check if PassengerReferences is current selection for choice.
                     * 
                     * @return <code>true</code> if selection, <code>false</code> if not
                     */
                    public boolean ifPassengerReferences() {
                        return passengersSelect == PASSENGER_REFERENCES_CHOICE;
                    }

                    /** 
                     * Get the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: pax1 pax2
                     * 
                     * @return value
                     */
                    public PassengerReferences getPassengerReferences() {
                        return passengerReferences;
                    }

                    /** 
                     * Set the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: pax1 pax2
                     * 
                     * @param passengerReferences
                     */
                    public void setPassengerReferences(
                            PassengerReferences passengerReferences) {
                        setPassengersSelect(PASSENGER_REFERENCES_CHOICE);
                        this.passengerReferences = passengerReferences;
                    }

                    /** 
                     * Check if GroupReference is current selection for choice.
                     * 
                     * @return <code>true</code> if selection, <code>false</code> if not
                     */
                    public boolean ifGroupReference() {
                        return passengersSelect == GROUP_REFERENCE_CHOICE;
                    }

                    /** 
                     * Get the 'GroupReference' element value.
                     * 
                     * @return value
                     */
                    public GroupReference getGroupReference() {
                        return groupReference;
                    }

                    /** 
                     * Set the 'GroupReference' element value.
                     * 
                     * @param groupReference
                     */
                    public void setGroupReference(GroupReference groupReference) {
                        setPassengersSelect(GROUP_REFERENCE_CHOICE);
                        this.groupReference = groupReference;
                    }
                }
                /** 
                 * Associated Optional Service(s).
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Services" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element ref="ns:ServiceID" maxOccurs="unbounded"/>
                 *       &lt;xs:element name="Passengers" minOccurs="0">
                 *         &lt;!-- Reference to inner class Passengers -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Services implements Serializable
                {
                    private List<ServiceIDType> serviceIDList = new ArrayList<ServiceIDType>();
                    private Passengers passengers;

                    /** 
                     * Get the list of 'ServiceID' element items.
                     * 
                     * @return list
                     */
                    public List<ServiceIDType> getServiceIDList() {
                        return serviceIDList;
                    }

                    /** 
                     * Set the list of 'ServiceID' element items.
                     * 
                     * @param list
                     */
                    public void setServiceIDList(List<ServiceIDType> list) {
                        serviceIDList = list;
                    }

                    /** 
                     * Get the 'Passengers' element value.
                     * 
                     * @return value
                     */
                    public Passengers getPassengers() {
                        return passengers;
                    }

                    /** 
                     * Set the 'Passengers' element value.
                     * 
                     * @param passengers
                     */
                    public void setPassengers(Passengers passengers) {
                        this.passengers = passengers;
                    }
                    /** 
                     * Passenger(s)/ Group associated with the Offer Item.

                    Note: This contains references to Passenger and Group instance(s) defined in the  Passengers node.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:choice>
                     *       &lt;xs:element ref="ns:PassengerReferences"/>
                     *       &lt;xs:element ref="ns:GroupReference"/>
                     *     &lt;/xs:choice>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Passengers implements Serializable
                    {
                        private int passengersSelect = -1;
                        private static final int PASSENGER_REFERENCES_CHOICE = 0;
                        private static final int GROUP_REFERENCE_CHOICE = 1;
                        private PassengerReferences passengerReferences;
                        private GroupReference groupReference;

                        private void setPassengersSelect(int choice) {
                            if (passengersSelect == -1) {
                                passengersSelect = choice;
                            } else if (passengersSelect != choice) {
                                throw new IllegalStateException(
                                        "Need to call clearPassengersSelect() before changing existing choice");
                            }
                        }

                        /** 
                         * Clear the choice selection.
                         */
                        public void clearPassengersSelect() {
                            passengersSelect = -1;
                        }

                        /** 
                         * Check if PassengerReferences is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifPassengerReferences() {
                            return passengersSelect == PASSENGER_REFERENCES_CHOICE;
                        }

                        /** 
                         * Get the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: pax1 pax2
                         * 
                         * @return value
                         */
                        public PassengerReferences getPassengerReferences() {
                            return passengerReferences;
                        }

                        /** 
                         * Set the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: pax1 pax2
                         * 
                         * @param passengerReferences
                         */
                        public void setPassengerReferences(
                                PassengerReferences passengerReferences) {
                            setPassengersSelect(PASSENGER_REFERENCES_CHOICE);
                            this.passengerReferences = passengerReferences;
                        }

                        /** 
                         * Check if GroupReference is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifGroupReference() {
                            return passengersSelect == GROUP_REFERENCE_CHOICE;
                        }

                        /** 
                         * Get the 'GroupReference' element value.
                         * 
                         * @return value
                         */
                        public GroupReference getGroupReference() {
                            return groupReference;
                        }

                        /** 
                         * Set the 'GroupReference' element value.
                         * 
                         * @param groupReference
                         */
                        public void setGroupReference(
                                GroupReference groupReference) {
                            setPassengersSelect(GROUP_REFERENCE_CHOICE);
                            this.groupReference = groupReference;
                        }
                    }
                }
                /** 
                 * Other Named Association(s).

                Note: Includes an association type choice (e.g. MediaGroup) and an instance association value (e.g. mediagrp1).
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="ReferenceValue"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class OtherAssociation implements Serializable
                {
                    private String type;
                    private String referenceValue;

                    /** 
                     * Get the 'Type' attribute value. Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'Type' attribute value. Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }

                    /** 
                     * Get the 'ReferenceValue' attribute value. Associated object instance value.
                    Example: mediagrp1
                     * 
                     * @return value
                     */
                    public String getReferenceValue() {
                        return referenceValue;
                    }

                    /** 
                     * Set the 'ReferenceValue' attribute value. Associated object instance value.
                    Example: mediagrp1
                     * 
                     * @param referenceValue
                     */
                    public void setReferenceValue(String referenceValue) {
                        this.referenceValue = referenceValue;
                    }
                }
            }
            /** 
             * Ticket/document information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketDocInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="AgentIDs" minOccurs="0">
             *         &lt;!-- Reference to inner class AgentIDs -->
             *       &lt;/xs:element>
             *       &lt;xs:element ref="ns:IssuingAirlineInfo" minOccurs="0"/>
             *       &lt;xs:element ref="ns:TicketDocument" maxOccurs="4"/>
             *       &lt;xs:element ref="ns:CarrierFeeInfo" minOccurs="0"/>
             *       &lt;xs:element ref="ns:OriginalIssueInfo" minOccurs="0"/>
             *       &lt;xs:element name="Passengers" minOccurs="0">
             *         &lt;!-- Reference to inner class Passengers -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TicketDocInfo implements Serializable
            {
                private AgentIDs agentIDs;
                private AirlineIssuanceType issuingAirlineInfo;
                private List<TicketDocument> ticketDocumentList = new ArrayList<TicketDocument>();
                private CarrierFeeInfoType carrierFeeInfo;
                private OriginalIssueType originalIssueInfo;
                private Passengers passengers;

                /** 
                 * Get the 'AgentIDs' element value.
                 * 
                 * @return value
                 */
                public AgentIDs getAgentIDs() {
                    return agentIDs;
                }

                /** 
                 * Set the 'AgentIDs' element value.
                 * 
                 * @param agentIDs
                 */
                public void setAgentIDs(AgentIDs agentIDs) {
                    this.agentIDs = agentIDs;
                }

                /** 
                 * Get the 'IssuingAirlineInfo' element value.
                 * 
                 * @return value
                 */
                public AirlineIssuanceType getIssuingAirlineInfo() {
                    return issuingAirlineInfo;
                }

                /** 
                 * Set the 'IssuingAirlineInfo' element value.
                 * 
                 * @param issuingAirlineInfo
                 */
                public void setIssuingAirlineInfo(
                        AirlineIssuanceType issuingAirlineInfo) {
                    this.issuingAirlineInfo = issuingAirlineInfo;
                }

                /** 
                 * Get the list of 'TicketDocument' element items.
                 * 
                 * @return list
                 */
                public List<TicketDocument> getTicketDocumentList() {
                    return ticketDocumentList;
                }

                /** 
                 * Set the list of 'TicketDocument' element items.
                 * 
                 * @param list
                 */
                public void setTicketDocumentList(List<TicketDocument> list) {
                    ticketDocumentList = list;
                }

                /** 
                 * Get the 'CarrierFeeInfo' element value.
                 * 
                 * @return value
                 */
                public CarrierFeeInfoType getCarrierFeeInfo() {
                    return carrierFeeInfo;
                }

                /** 
                 * Set the 'CarrierFeeInfo' element value.
                 * 
                 * @param carrierFeeInfo
                 */
                public void setCarrierFeeInfo(CarrierFeeInfoType carrierFeeInfo) {
                    this.carrierFeeInfo = carrierFeeInfo;
                }

                /** 
                 * Get the 'OriginalIssueInfo' element value.
                 * 
                 * @return value
                 */
                public OriginalIssueType getOriginalIssueInfo() {
                    return originalIssueInfo;
                }

                /** 
                 * Set the 'OriginalIssueInfo' element value.
                 * 
                 * @param originalIssueInfo
                 */
                public void setOriginalIssueInfo(
                        OriginalIssueType originalIssueInfo) {
                    this.originalIssueInfo = originalIssueInfo;
                }

                /** 
                 * Get the 'Passengers' element value.
                 * 
                 * @return value
                 */
                public Passengers getPassengers() {
                    return passengers;
                }

                /** 
                 * Set the 'Passengers' element value.
                 * 
                 * @param passengers
                 */
                public void setPassengers(Passengers passengers) {
                    this.passengers = passengers;
                }
                /** 
                 * Booking and Servicing Agent information.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AgentIDs" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element ref="ns:AgentID" maxOccurs="2"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class AgentIDs implements Serializable
                {
                    private List<CouponAgentType> agentIDList = new ArrayList<CouponAgentType>();

                    /** 
                     * Get the list of 'AgentID' element items.
                     * 
                     * @return list
                     */
                    public List<CouponAgentType> getAgentIDList() {
                        return agentIDList;
                    }

                    /** 
                     * Set the list of 'AgentID' element items.
                     * 
                     * @param list
                     */
                    public void setAgentIDList(List<CouponAgentType> list) {
                        agentIDList = list;
                    }
                }
                /** 
                 * Passenger(s)/ Group associated with the Offer Item.

                Note: This contains references to Passenger and Group instance(s) defined in the  Passengers node.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:choice>
                 *       &lt;xs:element ref="ns:PassengerReferences"/>
                 *       &lt;xs:element ref="ns:GroupReference"/>
                 *     &lt;/xs:choice>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Passengers implements Serializable
                {
                    private int passengersSelect = -1;
                    private static final int PASSENGER_REFERENCES_CHOICE = 0;
                    private static final int GROUP_REFERENCE_CHOICE = 1;
                    private PassengerReferences passengerReferences;
                    private GroupReference groupReference;

                    private void setPassengersSelect(int choice) {
                        if (passengersSelect == -1) {
                            passengersSelect = choice;
                        } else if (passengersSelect != choice) {
                            throw new IllegalStateException(
                                    "Need to call clearPassengersSelect() before changing existing choice");
                        }
                    }

                    /** 
                     * Clear the choice selection.
                     */
                    public void clearPassengersSelect() {
                        passengersSelect = -1;
                    }

                    /** 
                     * Check if PassengerReferences is current selection for choice.
                     * 
                     * @return <code>true</code> if selection, <code>false</code> if not
                     */
                    public boolean ifPassengerReferences() {
                        return passengersSelect == PASSENGER_REFERENCES_CHOICE;
                    }

                    /** 
                     * Get the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: pax1 pax2
                     * 
                     * @return value
                     */
                    public PassengerReferences getPassengerReferences() {
                        return passengerReferences;
                    }

                    /** 
                     * Set the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: pax1 pax2
                     * 
                     * @param passengerReferences
                     */
                    public void setPassengerReferences(
                            PassengerReferences passengerReferences) {
                        setPassengersSelect(PASSENGER_REFERENCES_CHOICE);
                        this.passengerReferences = passengerReferences;
                    }

                    /** 
                     * Check if GroupReference is current selection for choice.
                     * 
                     * @return <code>true</code> if selection, <code>false</code> if not
                     */
                    public boolean ifGroupReference() {
                        return passengersSelect == GROUP_REFERENCE_CHOICE;
                    }

                    /** 
                     * Get the 'GroupReference' element value.
                     * 
                     * @return value
                     */
                    public GroupReference getGroupReference() {
                        return groupReference;
                    }

                    /** 
                     * Set the 'GroupReference' element value.
                     * 
                     * @param groupReference
                     */
                    public void setGroupReference(GroupReference groupReference) {
                        setPassengersSelect(GROUP_REFERENCE_CHOICE);
                        this.groupReference = groupReference;
                    }
                }
            }
        }
    }
    /** 
     * Data Lists(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DataLists" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PassengerList" minOccurs="0">
     *         &lt;!-- Reference to inner class PassengerList -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ContactList" minOccurs="0">
     *         &lt;!-- Reference to inner class ContactList -->
     *       &lt;/xs:element>
     *       &lt;xs:element ref="ns:BagDisclosureList" minOccurs="0"/>
     *       &lt;xs:element name="BaggageAllowanceList" minOccurs="0">
     *         &lt;!-- Reference to inner class BaggageAllowanceList -->
     *       &lt;/xs:element>
     *       &lt;xs:element ref="ns:ClassOfServiceList" minOccurs="0"/>
     *       &lt;xs:element ref="ns:ContentSourceList" minOccurs="0"/>
     *       &lt;xs:element name="DescriptionList" minOccurs="0">
     *         &lt;!-- Reference to inner class DescriptionList -->
     *       &lt;/xs:element>
     *       &lt;xs:element ref="ns:DisclosureList" minOccurs="0"/>
     *       &lt;xs:element ref="ns:FareList" minOccurs="0"/>
     *       &lt;xs:element name="FlightSegmentList" minOccurs="0">
     *         &lt;!-- Reference to inner class FlightSegmentList -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FlightList" minOccurs="0">
     *         &lt;!-- Reference to inner class FlightList -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="OriginDestinationList" minOccurs="0">
     *         &lt;!-- Reference to inner class OriginDestinationList -->
     *       &lt;/xs:element>
     *       &lt;xs:element ref="ns:InstructionsList" minOccurs="0"/>
     *       &lt;xs:element ref="ns:MediaList" minOccurs="0"/>
     *       &lt;xs:element ref="ns:PenaltyList" minOccurs="0"/>
     *       &lt;xs:element name="PriceClassList" minOccurs="0">
     *         &lt;!-- Reference to inner class PriceClassList -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ServiceDefinitionList" minOccurs="0">
     *         &lt;!-- Reference to inner class ServiceDefinitionList -->
     *       &lt;/xs:element>
     *       &lt;xs:element ref="ns:TermsList" minOccurs="0"/>
     *       &lt;xs:element name="SeatDefinitionList" minOccurs="0">
     *         &lt;!-- Reference to inner class SeatDefinitionList -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DataLists implements Serializable
    {
        private PassengerList passengerList;
        private ContactList contactList;
        private ListOfBagDisclosureType bagDisclosureList;
        private BaggageAllowanceList baggageAllowanceList;
        private ListOfClassOfServiceType classOfServiceList;
        private ListOfContentSourceType contentSourceList;
        private DescriptionList descriptionList;
        private ListOfDisclosureType disclosureList;
        private FareList fareList;
        private FlightSegmentList flightSegmentList;
        private FlightList flightList;
        private OriginDestinationList originDestinationList;
        private ListOfOfferInstructionsType instructionsList;
        private ListOfMediaType mediaList;
        private ListOfOfferPenaltyType penaltyList;
        private PriceClassList priceClassList;
        private ServiceDefinitionList serviceDefinitionList;
        private ListOfOfferTermsType termsList;
        private SeatDefinitionList seatDefinitionList;

        /** 
         * Get the 'PassengerList' element value.
         * 
         * @return value
         */
        public PassengerList getPassengerList() {
            return passengerList;
        }

        /** 
         * Set the 'PassengerList' element value.
         * 
         * @param passengerList
         */
        public void setPassengerList(PassengerList passengerList) {
            this.passengerList = passengerList;
        }

        /** 
         * Get the 'ContactList' element value.
         * 
         * @return value
         */
        public ContactList getContactList() {
            return contactList;
        }

        /** 
         * Set the 'ContactList' element value.
         * 
         * @param contactList
         */
        public void setContactList(ContactList contactList) {
            this.contactList = contactList;
        }

        /** 
         * Get the 'BagDisclosureList' element value.
         * 
         * @return value
         */
        public ListOfBagDisclosureType getBagDisclosureList() {
            return bagDisclosureList;
        }

        /** 
         * Set the 'BagDisclosureList' element value.
         * 
         * @param bagDisclosureList
         */
        public void setBagDisclosureList(
                ListOfBagDisclosureType bagDisclosureList) {
            this.bagDisclosureList = bagDisclosureList;
        }

        /** 
         * Get the 'BaggageAllowanceList' element value.
         * 
         * @return value
         */
        public BaggageAllowanceList getBaggageAllowanceList() {
            return baggageAllowanceList;
        }

        /** 
         * Set the 'BaggageAllowanceList' element value.
         * 
         * @param baggageAllowanceList
         */
        public void setBaggageAllowanceList(
                BaggageAllowanceList baggageAllowanceList) {
            this.baggageAllowanceList = baggageAllowanceList;
        }

        /** 
         * Get the 'ClassOfServiceList' element value.
         * 
         * @return value
         */
        public ListOfClassOfServiceType getClassOfServiceList() {
            return classOfServiceList;
        }

        /** 
         * Set the 'ClassOfServiceList' element value.
         * 
         * @param classOfServiceList
         */
        public void setClassOfServiceList(
                ListOfClassOfServiceType classOfServiceList) {
            this.classOfServiceList = classOfServiceList;
        }

        /** 
         * Get the 'ContentSourceList' element value.
         * 
         * @return value
         */
        public ListOfContentSourceType getContentSourceList() {
            return contentSourceList;
        }

        /** 
         * Set the 'ContentSourceList' element value.
         * 
         * @param contentSourceList
         */
        public void setContentSourceList(
                ListOfContentSourceType contentSourceList) {
            this.contentSourceList = contentSourceList;
        }

        /** 
         * Get the 'DescriptionList' element value.
         * 
         * @return value
         */
        public DescriptionList getDescriptionList() {
            return descriptionList;
        }

        /** 
         * Set the 'DescriptionList' element value.
         * 
         * @param descriptionList
         */
        public void setDescriptionList(DescriptionList descriptionList) {
            this.descriptionList = descriptionList;
        }

        /** 
         * Get the 'DisclosureList' element value.
         * 
         * @return value
         */
        public ListOfDisclosureType getDisclosureList() {
            return disclosureList;
        }

        /** 
         * Set the 'DisclosureList' element value.
         * 
         * @param disclosureList
         */
        public void setDisclosureList(ListOfDisclosureType disclosureList) {
            this.disclosureList = disclosureList;
        }

        /** 
         * Get the 'FareList' element value.
         * 
         * @return value
         */
        public FareList getFareList() {
            return fareList;
        }

        /** 
         * Set the 'FareList' element value.
         * 
         * @param fareList
         */
        public void setFareList(FareList fareList) {
            this.fareList = fareList;
        }

        /** 
         * Get the 'FlightSegmentList' element value.
         * 
         * @return value
         */
        public FlightSegmentList getFlightSegmentList() {
            return flightSegmentList;
        }

        /** 
         * Set the 'FlightSegmentList' element value.
         * 
         * @param flightSegmentList
         */
        public void setFlightSegmentList(FlightSegmentList flightSegmentList) {
            this.flightSegmentList = flightSegmentList;
        }

        /** 
         * Get the 'FlightList' element value.
         * 
         * @return value
         */
        public FlightList getFlightList() {
            return flightList;
        }

        /** 
         * Set the 'FlightList' element value.
         * 
         * @param flightList
         */
        public void setFlightList(FlightList flightList) {
            this.flightList = flightList;
        }

        /** 
         * Get the 'OriginDestinationList' element value.
         * 
         * @return value
         */
        public OriginDestinationList getOriginDestinationList() {
            return originDestinationList;
        }

        /** 
         * Set the 'OriginDestinationList' element value.
         * 
         * @param originDestinationList
         */
        public void setOriginDestinationList(
                OriginDestinationList originDestinationList) {
            this.originDestinationList = originDestinationList;
        }

        /** 
         * Get the 'InstructionsList' element value.
         * 
         * @return value
         */
        public ListOfOfferInstructionsType getInstructionsList() {
            return instructionsList;
        }

        /** 
         * Set the 'InstructionsList' element value.
         * 
         * @param instructionsList
         */
        public void setInstructionsList(
                ListOfOfferInstructionsType instructionsList) {
            this.instructionsList = instructionsList;
        }

        /** 
         * Get the 'MediaList' element value.
         * 
         * @return value
         */
        public ListOfMediaType getMediaList() {
            return mediaList;
        }

        /** 
         * Set the 'MediaList' element value.
         * 
         * @param mediaList
         */
        public void setMediaList(ListOfMediaType mediaList) {
            this.mediaList = mediaList;
        }

        /** 
         * Get the 'PenaltyList' element value.
         * 
         * @return value
         */
        public ListOfOfferPenaltyType getPenaltyList() {
            return penaltyList;
        }

        /** 
         * Set the 'PenaltyList' element value.
         * 
         * @param penaltyList
         */
        public void setPenaltyList(ListOfOfferPenaltyType penaltyList) {
            this.penaltyList = penaltyList;
        }

        /** 
         * Get the 'PriceClassList' element value.
         * 
         * @return value
         */
        public PriceClassList getPriceClassList() {
            return priceClassList;
        }

        /** 
         * Set the 'PriceClassList' element value.
         * 
         * @param priceClassList
         */
        public void setPriceClassList(PriceClassList priceClassList) {
            this.priceClassList = priceClassList;
        }

        /** 
         * Get the 'ServiceDefinitionList' element value.
         * 
         * @return value
         */
        public ServiceDefinitionList getServiceDefinitionList() {
            return serviceDefinitionList;
        }

        /** 
         * Set the 'ServiceDefinitionList' element value.
         * 
         * @param serviceDefinitionList
         */
        public void setServiceDefinitionList(
                ServiceDefinitionList serviceDefinitionList) {
            this.serviceDefinitionList = serviceDefinitionList;
        }

        /** 
         * Get the 'TermsList' element value.
         * 
         * @return value
         */
        public ListOfOfferTermsType getTermsList() {
            return termsList;
        }

        /** 
         * Set the 'TermsList' element value.
         * 
         * @param termsList
         */
        public void setTermsList(ListOfOfferTermsType termsList) {
            this.termsList = termsList;
        }

        /** 
         * Get the 'SeatDefinitionList' element value.
         * 
         * @return value
         */
        public SeatDefinitionList getSeatDefinitionList() {
            return seatDefinitionList;
        }

        /** 
         * Set the 'SeatDefinitionList' element value.
         * 
         * @param seatDefinitionList
         */
        public void setSeatDefinitionList(SeatDefinitionList seatDefinitionList) {
            this.seatDefinitionList = seatDefinitionList;
        }
        /** 
         * Passenger data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:PassengerType" name="Passenger" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PassengerList implements Serializable
        {
            private List<PassengerType> passengerList = new ArrayList<PassengerType>();

            /** 
             * Get the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @return list
             */
            public List<PassengerType> getPassengerList() {
                return passengerList;
            }

            /** 
             * Set the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @param list
             */
            public void setPassengerList(List<PassengerType> list) {
                passengerList = list;
            }
        }
        /** 
         * Contact data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ContactInformationType" name="ContactInformation" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ContactList implements Serializable
        {
            private List<ContactInformationType> contactInformationList = new ArrayList<ContactInformationType>();

            /** 
             * Get the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @return list
             */
            public List<ContactInformationType> getContactInformationList() {
                return contactInformationList;
            }

            /** 
             * Set the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @param list
             */
            public void setContactInformationList(
                    List<ContactInformationType> list) {
                contactInformationList = list;
            }
        }
        /** 
         * Checked or Carry-On Baggage Allowance detail. Use BaggageCategory to specify which of the two.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageAllowanceList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="BaggageAllowance" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class BaggageAllowance -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class BaggageAllowanceList implements Serializable
        {
            private List<BaggageAllowance> baggageAllowanceList = new ArrayList<BaggageAllowance>();

            /** 
             * Get the list of 'BaggageAllowance' element items.
             * 
             * @return list
             */
            public List<BaggageAllowance> getBaggageAllowanceList() {
                return baggageAllowanceList;
            }

            /** 
             * Set the list of 'BaggageAllowance' element items.
             * 
             * @param list
             */
            public void setBaggageAllowanceList(List<BaggageAllowance> list) {
                baggageAllowanceList = list;
            }
            /** 
             * Checked or Carry-On Baggage Allowance detail. Use BaggageCategory to specify which of the two.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageAllowance" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:BaggageCategoryListType" name="BaggageCategory"/>
             *       &lt;xs:element ref="ns:AllowanceDescription" minOccurs="0"/>
             *       &lt;xs:element ref="ns:DimensionAllowance" minOccurs="0"/>
             *       &lt;xs:element ref="ns:PieceAllowance" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element ref="ns:WeightAllowance" minOccurs="0"/>
             *       &lt;xs:element type="ns:BaggageDeterminingCarrierType" name="BaggageDeterminingCarrier" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="BaggageAllowanceID"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BaggageAllowance implements Serializable
            {
                private BaggageCategoryListType baggageCategory;
                private BagAllowanceDescType allowanceDescription;
                private BagAllowanceDimensionType dimensionAllowance;
                private List<BagAllowancePieceType> pieceAllowanceList = new ArrayList<BagAllowancePieceType>();
                private WeightAllowance weightAllowance;
                private BaggageDeterminingCarrierType baggageDeterminingCarrier;
                private String baggageAllowanceID;

                /** 
                 * Get the 'BaggageCategory' element value. Enumeration:

                CarryOn
                Checked
                 * 
                 * @return value
                 */
                public BaggageCategoryListType getBaggageCategory() {
                    return baggageCategory;
                }

                /** 
                 * Set the 'BaggageCategory' element value. Enumeration:

                CarryOn
                Checked
                 * 
                 * @param baggageCategory
                 */
                public void setBaggageCategory(
                        BaggageCategoryListType baggageCategory) {
                    this.baggageCategory = baggageCategory;
                }

                /** 
                 * Get the 'AllowanceDescription' element value.
                 * 
                 * @return value
                 */
                public BagAllowanceDescType getAllowanceDescription() {
                    return allowanceDescription;
                }

                /** 
                 * Set the 'AllowanceDescription' element value.
                 * 
                 * @param allowanceDescription
                 */
                public void setAllowanceDescription(
                        BagAllowanceDescType allowanceDescription) {
                    this.allowanceDescription = allowanceDescription;
                }

                /** 
                 * Get the 'DimensionAllowance' element value.
                 * 
                 * @return value
                 */
                public BagAllowanceDimensionType getDimensionAllowance() {
                    return dimensionAllowance;
                }

                /** 
                 * Set the 'DimensionAllowance' element value.
                 * 
                 * @param dimensionAllowance
                 */
                public void setDimensionAllowance(
                        BagAllowanceDimensionType dimensionAllowance) {
                    this.dimensionAllowance = dimensionAllowance;
                }

                /** 
                 * Get the list of 'PieceAllowance' element items.
                 * 
                 * @return list
                 */
                public List<BagAllowancePieceType> getPieceAllowanceList() {
                    return pieceAllowanceList;
                }

                /** 
                 * Set the list of 'PieceAllowance' element items.
                 * 
                 * @param list
                 */
                public void setPieceAllowanceList(
                        List<BagAllowancePieceType> list) {
                    pieceAllowanceList = list;
                }

                /** 
                 * Get the 'WeightAllowance' element value.
                 * 
                 * @return value
                 */
                public WeightAllowance getWeightAllowance() {
                    return weightAllowance;
                }

                /** 
                 * Set the 'WeightAllowance' element value.
                 * 
                 * @param weightAllowance
                 */
                public void setWeightAllowance(WeightAllowance weightAllowance) {
                    this.weightAllowance = weightAllowance;
                }

                /** 
                 * Get the 'BaggageDeterminingCarrier' element value. Baggage Determining Carrier as defined in resolution 722 (f), and who’s baggage rules apply.
                 * 
                 * @return value
                 */
                public BaggageDeterminingCarrierType getBaggageDeterminingCarrier() {
                    return baggageDeterminingCarrier;
                }

                /** 
                 * Set the 'BaggageDeterminingCarrier' element value. Baggage Determining Carrier as defined in resolution 722 (f), and who’s baggage rules apply.
                 * 
                 * @param baggageDeterminingCarrier
                 */
                public void setBaggageDeterminingCarrier(
                        BaggageDeterminingCarrierType baggageDeterminingCarrier) {
                    this.baggageDeterminingCarrier = baggageDeterminingCarrier;
                }

                /** 
                 * Get the 'BaggageAllowanceID' attribute value.
                 * 
                 * @return value
                 */
                public String getBaggageAllowanceID() {
                    return baggageAllowanceID;
                }

                /** 
                 * Set the 'BaggageAllowanceID' attribute value.
                 * 
                 * @param baggageAllowanceID
                 */
                public void setBaggageAllowanceID(String baggageAllowanceID) {
                    this.baggageAllowanceID = baggageAllowanceID;
                }
            }
        }
        /** 
         * Description Details
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DescriptionList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element ref="ns:Description" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class DescriptionList implements Serializable
        {
            private List<com.gridnine.xtrip.server.gds.tandc.wsmodel.Description> descriptionList = new ArrayList<com.gridnine.xtrip.server.gds.tandc.wsmodel.Description>();

            /** 
             * Get the list of 'Description' element items.
             * 
             * @return list
             */
            public List<com.gridnine.xtrip.server.gds.tandc.wsmodel.Description> getDescriptionList() {
                return descriptionList;
            }

            /** 
             * Set the list of 'Description' element items.
             * 
             * @param list
             */
            public void setDescriptionList(
                    List<com.gridnine.xtrip.server.gds.tandc.wsmodel.Description> list) {
                descriptionList = list;
            }
        }
        /** 
         * List of Flight Segments
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegmentList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ListOfFlightSegmentType" name="FlightSegment" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FlightSegmentList implements Serializable
        {
            private List<ListOfFlightSegmentType> flightSegmentList = new ArrayList<ListOfFlightSegmentType>();

            /** 
             * Get the list of 'FlightSegment' element items.
             * 
             * @return list
             */
            public List<ListOfFlightSegmentType> getFlightSegmentList() {
                return flightSegmentList;
            }

            /** 
             * Set the list of 'FlightSegment' element items.
             * 
             * @param list
             */
            public void setFlightSegmentList(List<ListOfFlightSegmentType> list) {
                flightSegmentList = list;
            }
        }
        /** 
         * List of Flight elements.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Flight" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Flight -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FlightList implements Serializable
        {
            private List<Flight> flightList = new ArrayList<Flight>();

            /** 
             * Get the list of 'Flight' element items.
             * 
             * @return list
             */
            public List<Flight> getFlightList() {
                return flightList;
            }

            /** 
             * Set the list of 'Flight' element items.
             * 
             * @param list
             */
            public void setFlightList(List<Flight> list) {
                flightList = list;
            }
            /** 
             * Journey information describing the travel between an airport/city where travel commences and an airport/city where travel ultimately terminates. A journey may be comprised of one or more segments. Note: This node will be renamed to journey in future releases.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Flight" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:TotalJourneyType" name="Journey" minOccurs="0"/>
             *       &lt;xs:element ref="ns:SegmentReferences"/>
             *       &lt;xs:element name="Settlement" minOccurs="0">
             *         &lt;!-- Reference to inner class Settlement -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
             *     &lt;xs:attribute type="xs:string" name="FlightKey"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * 
             * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
             *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
             * &lt;/xs:attributeGroup>
             * </pre>
             */
            public static class Flight implements Serializable
            {
                private TotalJourneyType journey;
                private SegmentReferences segmentReferences;
                private Settlement settlement;
                private String refs;
                private String flightKey;

                /** 
                 * Get the 'Journey' element value. Flight journey information.
                 * 
                 * @return value
                 */
                public TotalJourneyType getJourney() {
                    return journey;
                }

                /** 
                 * Set the 'Journey' element value. Flight journey information.
                 * 
                 * @param journey
                 */
                public void setJourney(TotalJourneyType journey) {
                    this.journey = journey;
                }

                /** 
                 * Get the 'SegmentReferences' element value.
                 * 
                 * @return value
                 */
                public SegmentReferences getSegmentReferences() {
                    return segmentReferences;
                }

                /** 
                 * Set the 'SegmentReferences' element value.
                 * 
                 * @param segmentReferences
                 */
                public void setSegmentReferences(
                        SegmentReferences segmentReferences) {
                    this.segmentReferences = segmentReferences;
                }

                /** 
                 * Get the 'Settlement' element value.
                 * 
                 * @return value
                 */
                public Settlement getSettlement() {
                    return settlement;
                }

                /** 
                 * Set the 'Settlement' element value.
                 * 
                 * @param settlement
                 */
                public void setSettlement(Settlement settlement) {
                    this.settlement = settlement;
                }

                /** 
                 * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @return value
                 */
                public String getRefs() {
                    return refs;
                }

                /** 
                 * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @param refs
                 */
                public void setRefs(String refs) {
                    this.refs = refs;
                }

                /** 
                 * Get the 'FlightKey' attribute value. A globally unique identifier for this Flight instance. Example: flight1
                 * 
                 * @return value
                 */
                public String getFlightKey() {
                    return flightKey;
                }

                /** 
                 * Set the 'FlightKey' attribute value. A globally unique identifier for this Flight instance. Example: flight1
                 * 
                 * @param flightKey
                 */
                public void setFlightKey(String flightKey) {
                    this.flightKey = flightKey;
                }
                /** 
                 * Interline Settlement information between airlines, including method of settlement, interline settlement value and currency.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Settlement" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Method"/>
                 *       &lt;xs:element type="ns:CurrencyAmountOptType" name="InterlineSettlementValue" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Settlement implements Serializable
                {
                    private String method;
                    private CurrencyAmountOptType interlineSettlementValue;

                    /** 
                     * Get the 'Method' element value. Service settlement method.
                    Examples:
                    AD (Internal Airline Document)
                    DS (Direct Settlement)
                    EA (EMD Associated or Internal Airline Document)
                    ES (EMD Standalone )
                    FI (Fare Integrated)
                    MA (Flight Associated, Settled via MCO)
                    MS (Standalone, Settled via MCO)

                    Encoding Scheme: IATA PADIS Codeset SST (Service Settlement Type)
                     * 
                     * @return value
                     */
                    public String getMethod() {
                        return method;
                    }

                    /** 
                     * Set the 'Method' element value. Service settlement method.
                    Examples:
                    AD (Internal Airline Document)
                    DS (Direct Settlement)
                    EA (EMD Associated or Internal Airline Document)
                    ES (EMD Standalone )
                    FI (Fare Integrated)
                    MA (Flight Associated, Settled via MCO)
                    MS (Standalone, Settled via MCO)

                    Encoding Scheme: IATA PADIS Codeset SST (Service Settlement Type)
                     * 
                     * @param method
                     */
                    public void setMethod(String method) {
                        this.method = method;
                    }

                    /** 
                     * Get the 'InterlineSettlementValue' element value. Settlement (Price) Value. Example: 300 (USD)

                    Note: This represents a Settlement value that is only used between the POA and ORA.
                     * 
                     * @return value
                     */
                    public CurrencyAmountOptType getInterlineSettlementValue() {
                        return interlineSettlementValue;
                    }

                    /** 
                     * Set the 'InterlineSettlementValue' element value. Settlement (Price) Value. Example: 300 (USD)

                    Note: This represents a Settlement value that is only used between the POA and ORA.
                     * 
                     * @param interlineSettlementValue
                     */
                    public void setInterlineSettlementValue(
                            CurrencyAmountOptType interlineSettlementValue) {
                        this.interlineSettlementValue = interlineSettlementValue;
                    }
                }
            }
        }
        /** 
         * List of Origin/Destination elements.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element ref="ns:OriginDestination" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OriginDestinationList implements Serializable
        {
            private List<OriginDestination> originDestinationList = new ArrayList<OriginDestination>();

            /** 
             * Get the list of 'OriginDestination' element items.
             * 
             * @return list
             */
            public List<OriginDestination> getOriginDestinationList() {
                return originDestinationList;
            }

            /** 
             * Set the list of 'OriginDestination' element items.
             * 
             * @param list
             */
            public void setOriginDestinationList(List<OriginDestination> list) {
                originDestinationList = list;
            }
        }
        /** 
         * Price Class list.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceClassList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:PriceClassType" name="PriceClass" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PriceClassList implements Serializable
        {
            private List<PriceClassType> priceClassList = new ArrayList<PriceClassType>();

            /** 
             * Get the list of 'PriceClass' element items.
             * 
             * @return list
             */
            public List<PriceClassType> getPriceClassList() {
                return priceClassList;
            }

            /** 
             * Set the list of 'PriceClass' element items.
             * 
             * @param list
             */
            public void setPriceClassList(List<PriceClassType> list) {
                priceClassList = list;
            }
        }
        /** 
         * Description and characteristics of a Service
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceDefinitionList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ServiceDefinitionType" name="ServiceDefinition" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ServiceDefinitionList implements Serializable
        {
            private List<ServiceDefinitionType> serviceDefinitionList = new ArrayList<ServiceDefinitionType>();

            /** 
             * Get the list of 'ServiceDefinition' element items.
             * 
             * @return list
             */
            public List<ServiceDefinitionType> getServiceDefinitionList() {
                return serviceDefinitionList;
            }

            /** 
             * Set the list of 'ServiceDefinition' element items.
             * 
             * @param list
             */
            public void setServiceDefinitionList(
                    List<ServiceDefinitionType> list) {
                serviceDefinitionList = list;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatDefinitionList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="SeatDefinition" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class SeatDefinition -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SeatDefinitionList implements Serializable
        {
            private List<SeatDefinition> seatDefinitionList = new ArrayList<SeatDefinition>();

            /** 
             * Get the list of 'SeatDefinition' element items.
             * 
             * @return list
             */
            public List<SeatDefinition> getSeatDefinitionList() {
                return seatDefinitionList;
            }

            /** 
             * Set the list of 'SeatDefinition' element items.
             * 
             * @param list
             */
            public void setSeatDefinitionList(List<SeatDefinition> list) {
                seatDefinitionList = list;
            }
            /** 
             * Seat information by aircraft section.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatDefinition" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Description" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Description -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="ns:SeatMapMessageType" name="Marketing" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="SeatCharacteristicCode" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element type="ns:SizeUnitSimpleType" name="UOM" minOccurs="0"/>
             *       &lt;xs:element type="xs:decimal" name="SeatWidthLow" minOccurs="0"/>
             *       &lt;xs:element type="xs:decimal" name="SeatPitchLow" minOccurs="0"/>
             *       &lt;xs:element name="Keywords" minOccurs="0">
             *         &lt;!-- Reference to inner class Keywords -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="SeatDefinitionID"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class SeatDefinition implements Serializable
            {
                private List<Description> descriptionList = new ArrayList<Description>();
                private SeatMapMessageType marketing;
                private List<String> seatCharacteristicCodeList = new ArrayList<String>();
                private SizeUnitSimpleType UOM;
                private BigDecimal seatWidthLow;
                private BigDecimal seatPitchLow;
                private Keywords keywords;
                private String seatDefinitionID;

                /** 
                 * Get the list of 'Description' element items.
                 * 
                 * @return list
                 */
                public List<Description> getDescriptionList() {
                    return descriptionList;
                }

                /** 
                 * Set the list of 'Description' element items.
                 * 
                 * @param list
                 */
                public void setDescriptionList(List<Description> list) {
                    descriptionList = list;
                }

                /** 
                 * Get the 'Marketing' element value. Images and/or links for the entire section defined by the range of rows.
                 * 
                 * @return value
                 */
                public SeatMapMessageType getMarketing() {
                    return marketing;
                }

                /** 
                 * Set the 'Marketing' element value. Images and/or links for the entire section defined by the range of rows.
                 * 
                 * @param marketing
                 */
                public void setMarketing(SeatMapMessageType marketing) {
                    this.marketing = marketing;
                }

                /** 
                 * Get the list of 'SeatCharacteristicCode' element items. Refers to aircraft seat characteristics; seat option codes.  Examples: E (EXIT ROW), M (Middle Seat), A (Aisle seat), L (Left side of aircraft), Q (Bulk Head).  Refer to PADIS code list 9825.
                 * 
                 * @return list
                 */
                public List<String> getSeatCharacteristicCodeList() {
                    return seatCharacteristicCodeList;
                }

                /** 
                 * Set the list of 'SeatCharacteristicCode' element items. Refers to aircraft seat characteristics; seat option codes.  Examples: E (EXIT ROW), M (Middle Seat), A (Aisle seat), L (Left side of aircraft), Q (Bulk Head).  Refer to PADIS code list 9825.
                 * 
                 * @param list
                 */
                public void setSeatCharacteristicCodeList(List<String> list) {
                    seatCharacteristicCodeList = list;
                }

                /** 
                 * Get the 'UOM' element value. Associated Keyword Unit of Measure, if relevant. Example: INCH
                 * 
                 * @return value
                 */
                public SizeUnitSimpleType getUOM() {
                    return UOM;
                }

                /** 
                 * Set the 'UOM' element value. Associated Keyword Unit of Measure, if relevant. Example: INCH
                 * 
                 * @param UOM
                 */
                public void setUOM(SizeUnitSimpleType UOM) {
                    this.UOM = UOM;
                }

                /** 
                 * Get the 'SeatWidthLow' element value. Lowest Width Measurement value for this section. Example: 20
                 * 
                 * @return value
                 */
                public BigDecimal getSeatWidthLow() {
                    return seatWidthLow;
                }

                /** 
                 * Set the 'SeatWidthLow' element value. Lowest Width Measurement value for this section. Example: 20
                 * 
                 * @param seatWidthLow
                 */
                public void setSeatWidthLow(BigDecimal seatWidthLow) {
                    this.seatWidthLow = seatWidthLow;
                }

                /** 
                 * Get the 'SeatPitchLow' element value. Lowest Pitch Measurement value for this section. Example: 32
                 * 
                 * @return value
                 */
                public BigDecimal getSeatPitchLow() {
                    return seatPitchLow;
                }

                /** 
                 * Set the 'SeatPitchLow' element value. Lowest Pitch Measurement value for this section. Example: 32
                 * 
                 * @param seatPitchLow
                 */
                public void setSeatPitchLow(BigDecimal seatPitchLow) {
                    this.seatPitchLow = seatPitchLow;
                }

                /** 
                 * Get the 'Keywords' element value.
                 * 
                 * @return value
                 */
                public Keywords getKeywords() {
                    return keywords;
                }

                /** 
                 * Set the 'Keywords' element value.
                 * 
                 * @param keywords
                 */
                public void setKeywords(Keywords keywords) {
                    this.keywords = keywords;
                }

                /** 
                 * Get the 'SeatDefinitionID' attribute value.
                 * 
                 * @return value
                 */
                public String getSeatDefinitionID() {
                    return seatDefinitionID;
                }

                /** 
                 * Set the 'SeatDefinitionID' attribute value.
                 * 
                 * @param seatDefinitionID
                 */
                public void setSeatDefinitionID(String seatDefinitionID) {
                    this.seatDefinitionID = seatDefinitionID;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Description" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:sequence>
                 *         &lt;xs:element name="Text" minOccurs="0">
                 *           &lt;!-- Reference to inner class Text -->
                 *         &lt;/xs:element>
                 *         &lt;xs:element type="xs:string" name="MarkupStyle" minOccurs="0"/>
                 *       &lt;/xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Link" minOccurs="0"/>
                 *       &lt;xs:element name="Media" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class Media -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Description implements Serializable
                {
                    private Text text;
                    private String markupStyle;
                    private String link;
                    private List<Media> mediaList = new ArrayList<Media>();

                    /** 
                     * Get the 'Text' element value.
                     * 
                     * @return value
                     */
                    public Text getText() {
                        return text;
                    }

                    /** 
                     * Set the 'Text' element value.
                     * 
                     * @param text
                     */
                    public void setText(Text text) {
                        this.text = text;
                    }

                    /** 
                     * Get the 'MarkupStyle' element value. Mark-up Style. Example: HTML
                     * 
                     * @return value
                     */
                    public String getMarkupStyle() {
                        return markupStyle;
                    }

                    /** 
                     * Set the 'MarkupStyle' element value. Mark-up Style. Example: HTML
                     * 
                     * @param markupStyle
                     */
                    public void setMarkupStyle(String markupStyle) {
                        this.markupStyle = markupStyle;
                    }

                    /** 
                     * Get the 'Link' element value. LINK to Description information source.
                     * 
                     * @return value
                     */
                    public String getLink() {
                        return link;
                    }

                    /** 
                     * Set the 'Link' element value. LINK to Description information source.
                     * 
                     * @param link
                     */
                    public void setLink(String link) {
                        this.link = link;
                    }

                    /** 
                     * Get the list of 'Media' element items.
                     * 
                     * @return list
                     */
                    public List<Media> getMediaList() {
                        return mediaList;
                    }

                    /** 
                     * Set the list of 'Media' element items.
                     * 
                     * @param list
                     */
                    public void setMediaList(List<Media> list) {
                        mediaList = list;
                    }
                    /** 
                     * Description value.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Text" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:string">
                     *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * 
                     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
                     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
                     * &lt;/xs:attributeGroup>
                     * </pre>
                     */
                    public static class Text implements Serializable
                    {
                        private String string;
                        private String refs;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public String getString() {
                            return string;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param string
                         */
                        public void setString(String string) {
                            this.string = string;
                        }

                        /** 
                         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                         * 
                         * @return value
                         */
                        public String getRefs() {
                            return refs;
                        }

                        /** 
                         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                         * 
                         * @param refs
                         */
                        public void setRefs(String refs) {
                            this.refs = refs;
                        }
                    }
                    /** 
                     * Description-associated Media Object(s).
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Media" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:choice>
                     *       &lt;xs:element type="ns:UniqueIDContextType" name="ObjectID"/>
                     *       &lt;xs:element ref="ns:MediaLink"/>
                     *       &lt;xs:element type="ns:UniqueIDContextType" name="AttachmentID"/>
                     *     &lt;/xs:choice>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Media implements Serializable
                    {
                        private int mediaListSelect = -1;
                        private static final int OBJECT_ID_CHOICE = 0;
                        private static final int MEDIA_LINK_CHOICE = 1;
                        private static final int ATTACHMENT_ID_CHOICE = 2;
                        private UniqueIDContextType objectID;
                        private MediaLink mediaLink;
                        private UniqueIDContextType attachmentID;

                        private void setMediaListSelect(int choice) {
                            if (mediaListSelect == -1) {
                                mediaListSelect = choice;
                            } else if (mediaListSelect != choice) {
                                throw new IllegalStateException(
                                        "Need to call clearMediaListSelect() before changing existing choice");
                            }
                        }

                        /** 
                         * Clear the choice selection.
                         */
                        public void clearMediaListSelect() {
                            mediaListSelect = -1;
                        }

                        /** 
                         * Check if ObjectID is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifObjectID() {
                            return mediaListSelect == OBJECT_ID_CHOICE;
                        }

                        /** 
                         * Get the 'ObjectID' element value. Description-associated MEDIA OBJECT ID or Key. Example: IMG1
                         * 
                         * @return value
                         */
                        public UniqueIDContextType getObjectID() {
                            return objectID;
                        }

                        /** 
                         * Set the 'ObjectID' element value. Description-associated MEDIA OBJECT ID or Key. Example: IMG1
                         * 
                         * @param objectID
                         */
                        public void setObjectID(UniqueIDContextType objectID) {
                            setMediaListSelect(OBJECT_ID_CHOICE);
                            this.objectID = objectID;
                        }

                        /** 
                         * Check if MediaLink is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifMediaLink() {
                            return mediaListSelect == MEDIA_LINK_CHOICE;
                        }

                        /** 
                         * Get the 'MediaLink' element value. Description-associated MEDIA LINK.
                         * 
                         * @return value
                         */
                        public MediaLink getMediaLink() {
                            return mediaLink;
                        }

                        /** 
                         * Set the 'MediaLink' element value. Description-associated MEDIA LINK.
                         * 
                         * @param mediaLink
                         */
                        public void setMediaLink(MediaLink mediaLink) {
                            setMediaListSelect(MEDIA_LINK_CHOICE);
                            this.mediaLink = mediaLink;
                        }

                        /** 
                         * Check if AttachmentID is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifAttachmentID() {
                            return mediaListSelect == ATTACHMENT_ID_CHOICE;
                        }

                        /** 
                         * Get the 'AttachmentID' element value. Description-associated Media Attachment ID. Example: ATT1.
                         * 
                         * @return value
                         */
                        public UniqueIDContextType getAttachmentID() {
                            return attachmentID;
                        }

                        /** 
                         * Set the 'AttachmentID' element value. Description-associated Media Attachment ID. Example: ATT1.
                         * 
                         * @param attachmentID
                         */
                        public void setAttachmentID(
                                UniqueIDContextType attachmentID) {
                            setMediaListSelect(ATTACHMENT_ID_CHOICE);
                            this.attachmentID = attachmentID;
                        }
                    }
                }
                /** 
                 * Seat Description Key-Value Word Pairs.
                Examples:
                ReclineDegree - 25
                BedLengthLowEnd - 68
                BedLengthHighEnd - 78
                WidthLowEnd - 20
                WidthHighEnd - 21.5
                PitchLowEnd - 32
                PitchHighEnd - 34.4

                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Keywords" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="ns:KeyWordType" name="KeyWord" maxOccurs="unbounded"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Keywords implements Serializable
                {
                    private List<KeyWordType> keyWordList = new ArrayList<KeyWordType>();

                    /** 
                     * Get the list of 'KeyWord' element items. Key-Value detail.
                     * 
                     * @return list
                     */
                    public List<KeyWordType> getKeyWordList() {
                        return keyWordList;
                    }

                    /** 
                     * Set the list of 'KeyWord' element items. Key-Value detail.
                     * 
                     * @param list
                     */
                    public void setKeyWordList(List<KeyWordType> list) {
                        keyWordList = list;
                    }
                }
            }
        }
    }
}
