
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * The OrderChange/ OrderView transaction set requests modifications to an Order by specifying which order items to change and what to change them to. The updated view of the Order is returned.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderChangeRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:PointOfSale" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element ref="ns:OrderChangeParameters" minOccurs="0"/>
 *       &lt;xs:element name="Query">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element name="Group" minOccurs="0">
 *               &lt;!-- Reference to inner class Group -->
 *             &lt;/xs:element>
 *             &lt;xs:element name="OrderID">
 *               &lt;xs:complexType>
 *                 &lt;xs:simpleContent>
 *                   &lt;xs:extension base="xs:string">
 *                     &lt;xs:attribute type="xs:string" use="optional" name="Owner"/>
 *                     &lt;xs:attribute name="OwnerType">
 *                       &lt;xs:simpleType>
 *                         &lt;!-- Reference to inner class OwnerType -->
 *                       &lt;/xs:simpleType>
 *                     &lt;/xs:attribute>
 *                   &lt;/xs:extension>
 *                 &lt;/xs:simpleContent>
 *               &lt;/xs:complexType>
 *             &lt;/xs:element>
 *             &lt;xs:element type="xs:string" name="ActionContext" minOccurs="0"/>
 *             &lt;xs:choice minOccurs="0">
 *               &lt;!-- Reference to inner class Choice -->
 *             &lt;/xs:choice>
 *             &lt;xs:element name="Payments" minOccurs="0">
 *               &lt;!-- Reference to inner class Payments -->
 *             &lt;/xs:element>
 *             &lt;xs:element ref="ns:BookingReferences" minOccurs="0"/>
 *             &lt;xs:element ref="ns:OrderChangeMetadata" minOccurs="0"/>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:element name="DataLists" minOccurs="0">
 *         &lt;!-- Reference to inner class DataLists -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OrderChangeRQ implements Serializable
{
    private PointOfSaleType pointOfSale;
    private MsgDocumentType document;
    private MsgPartiesType party;
    private OrdChangeParamsType orderChangeParameters;
    private Group group;
    private String queryOrderIDString;
    private String queryOrderIDOwner;
    private OwnerType queryOrderIDOwnerType;
    private String queryActionContext;
    private Choice choice;
    private Payments payments;
    private BookingReferences queryBookingReferences;
    private OrdChangeMetadataType queryOrderChangeMetadata;
    private DataLists dataLists;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'PointOfSale' element value.
     * 
     * @return value
     */
    public PointOfSaleType getPointOfSale() {
        return pointOfSale;
    }

    /** 
     * Set the 'PointOfSale' element value.
     * 
     * @param pointOfSale
     */
    public void setPointOfSale(PointOfSaleType pointOfSale) {
        this.pointOfSale = pointOfSale;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    /** 
     * Get the 'OrderChangeParameters' element value.
     * 
     * @return value
     */
    public OrdChangeParamsType getOrderChangeParameters() {
        return orderChangeParameters;
    }

    /** 
     * Set the 'OrderChangeParameters' element value.
     * 
     * @param orderChangeParameters
     */
    public void setOrderChangeParameters(
            OrdChangeParamsType orderChangeParameters) {
        this.orderChangeParameters = orderChangeParameters;
    }

    /** 
     * Get the 'Group' element value. Order Change Query.
     * 
     * @return value
     */
    public Group getGroup() {
        return group;
    }

    /** 
     * Set the 'Group' element value. Order Change Query.
     * 
     * @param group
     */
    public void setGroup(Group group) {
        this.group = group;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getQueryOrderIDString() {
        return queryOrderIDString;
    }

    /** 
     * Set the extension value.
     * 
     * @param queryOrderIDString
     */
    public void setQueryOrderIDString(String queryOrderIDString) {
        this.queryOrderIDString = queryOrderIDString;
    }

    /** 
     * Get the 'Owner' attribute value. Airline Designator of airline that owns/ assigned this ID. Example: BA

    Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Codes
     * 
     * @return value
     */
    public String getQueryOrderIDOwner() {
        return queryOrderIDOwner;
    }

    /** 
     * Set the 'Owner' attribute value. Airline Designator of airline that owns/ assigned this ID. Example: BA

    Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Codes
     * 
     * @param queryOrderIDOwner
     */
    public void setQueryOrderIDOwner(String queryOrderIDOwner) {
        this.queryOrderIDOwner = queryOrderIDOwner;
    }

    /** 
     * Get the 'OwnerType' attribute value. The POA OrderID should only go to the ORA, not back to the seller.
    1. ORA
    2. POA
     * 
     * @return value
     */
    public OwnerType getQueryOrderIDOwnerType() {
        return queryOrderIDOwnerType;
    }

    /** 
     * Set the 'OwnerType' attribute value. The POA OrderID should only go to the ORA, not back to the seller.
    1. ORA
    2. POA
     * 
     * @param queryOrderIDOwnerType
     */
    public void setQueryOrderIDOwnerType(OwnerType queryOrderIDOwnerType) {
        this.queryOrderIDOwnerType = queryOrderIDOwnerType;
    }

    /** 
     * Get the 'ActionContext' element value. Reference to PADIS codeset REA. When used, provides context for the change being requested.
     * 
     * @return value
     */
    public String getQueryActionContext() {
        return queryActionContext;
    }

    /** 
     * Set the 'ActionContext' element value. Reference to PADIS codeset REA. When used, provides context for the change being requested.
     * 
     * @param queryActionContext
     */
    public void setQueryActionContext(String queryActionContext) {
        this.queryActionContext = queryActionContext;
    }

    /** 
     * Get the choice value. Order Change Query.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value. Order Change Query.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }

    /** 
     * Get the 'Payments' element value. Order Change Query.
     * 
     * @return value
     */
    public Payments getPayments() {
        return payments;
    }

    /** 
     * Set the 'Payments' element value. Order Change Query.
     * 
     * @param payments
     */
    public void setPayments(Payments payments) {
        this.payments = payments;
    }

    /** 
     * Get the 'BookingReferences' element value. Existing Booking Reference (e.g. PNR Record Locator). Example: R1A3SK
     * 
     * @return value
     */
    public BookingReferences getQueryBookingReferences() {
        return queryBookingReferences;
    }

    /** 
     * Set the 'BookingReferences' element value. Existing Booking Reference (e.g. PNR Record Locator). Example: R1A3SK
     * 
     * @param queryBookingReferences
     */
    public void setQueryBookingReferences(
            BookingReferences queryBookingReferences) {
        this.queryBookingReferences = queryBookingReferences;
    }

    /** 
     * Get the 'OrderChangeMetadata' element value.
     * 
     * @return value
     */
    public OrdChangeMetadataType getQueryOrderChangeMetadata() {
        return queryOrderChangeMetadata;
    }

    /** 
     * Set the 'OrderChangeMetadata' element value.
     * 
     * @param queryOrderChangeMetadata
     */
    public void setQueryOrderChangeMetadata(
            OrdChangeMetadataType queryOrderChangeMetadata) {
        this.queryOrderChangeMetadata = queryOrderChangeMetadata;
    }

    /** 
     * Get the 'DataLists' element value.
     * 
     * @return value
     */
    public DataLists getDataLists() {
        return dataLists;
    }

    /** 
     * Set the 'DataLists' element value.
     * 
     * @param dataLists
     */
    public void setDataLists(DataLists dataLists) {
        this.dataLists = dataLists;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Group and Action.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Group" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:GroupType">
     *         &lt;xs:sequence>
     *           &lt;xs:element name="ActionType" minOccurs="0">
     *             &lt;!-- Reference to inner class ActionType -->
     *           &lt;/xs:element>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Group extends GroupType implements Serializable
    {
        private ActionType actionType;

        /** 
         * Get the 'ActionType' element value.
         * 
         * @return value
         */
        public ActionType getActionType() {
            return actionType;
        }

        /** 
         * Set the 'ActionType' element value.
         * 
         * @param actionType
         */
        public void setActionType(ActionType actionType) {
            this.actionType = actionType;
        }
        /** 
         * Order Action. Examples: Cancel, Create, Divide, Delete, Reissue, Reprice, Update
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ActionType" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ActionType implements Serializable
        {
            private String string;
            private String context;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'Context' attribute value. Action Type Context.
             * 
             * @return value
             */
            public String getContext() {
                return context;
            }

            /** 
             * Set the 'Context' attribute value. Action Type Context.
             * 
             * @param context
             */
            public void setContext(String context) {
                this.context = context;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="ORA"/>
     *     &lt;xs:enumeration value="POA"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum OwnerType implements Serializable {
        ORA, POA
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element name="OrderServicing" minOccurs="0">
     *     &lt;!-- Reference to inner class OrderServicing -->
     *   &lt;/xs:element>
     *   &lt;xs:element name="PassengerServicing" minOccurs="0" maxOccurs="unbounded">
     *     &lt;!-- Reference to inner class PassengerServicing -->
     *   &lt;/xs:element>
     *   &lt;xs:element name="AcceptRepricedOrder" minOccurs="0">
     *     &lt;!-- Reference to inner class AcceptRepricedOrder -->
     *   &lt;/xs:element>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int ORDER_SERVICING_CHOICE = 0;
        private static final int PASSENGER_SERVICING_LIST_CHOICE = 1;
        private static final int ACCEPT_REPRICED_ORDER_CHOICE = 2;
        private OrderServicing orderServicing;
        private List<PassengerServicing> passengerServicingList = new ArrayList<PassengerServicing>();
        private AcceptRepricedOrder acceptRepricedOrder;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if OrderServicing is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOrderServicing() {
            return choiceSelect == ORDER_SERVICING_CHOICE;
        }

        /** 
         * Get the 'OrderServicing' element value.
         * 
         * @return value
         */
        public OrderServicing getOrderServicing() {
            return orderServicing;
        }

        /** 
         * Set the 'OrderServicing' element value.
         * 
         * @param orderServicing
         */
        public void setOrderServicing(OrderServicing orderServicing) {
            setChoiceSelect(ORDER_SERVICING_CHOICE);
            this.orderServicing = orderServicing;
        }

        /** 
         * Check if PassengerServicingList is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPassengerServicingList() {
            return choiceSelect == PASSENGER_SERVICING_LIST_CHOICE;
        }

        /** 
         * Get the list of 'PassengerServicing' element items.
         * 
         * @return list
         */
        public List<PassengerServicing> getPassengerServicingList() {
            return passengerServicingList;
        }

        /** 
         * Set the list of 'PassengerServicing' element items.
         * 
         * @param list
         */
        public void setPassengerServicingList(List<PassengerServicing> list) {
            setChoiceSelect(PASSENGER_SERVICING_LIST_CHOICE);
            passengerServicingList = list;
        }

        /** 
         * Check if AcceptRepricedOrder is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAcceptRepricedOrder() {
            return choiceSelect == ACCEPT_REPRICED_ORDER_CHOICE;
        }

        /** 
         * Get the 'AcceptRepricedOrder' element value.
         * 
         * @return value
         */
        public AcceptRepricedOrder getAcceptRepricedOrder() {
            return acceptRepricedOrder;
        }

        /** 
         * Set the 'AcceptRepricedOrder' element value.
         * 
         * @param acceptRepricedOrder
         */
        public void setAcceptRepricedOrder(
                AcceptRepricedOrder acceptRepricedOrder) {
            setChoiceSelect(ACCEPT_REPRICED_ORDER_CHOICE);
            this.acceptRepricedOrder = acceptRepricedOrder;
        }
        /** 
         * Collection of functions used by the seller to request the airline to commit changes to an existing Order. These may be adding, removing or replacing Order Items (with potential refund conditions, in case of cancellations). The actions possible are determined by the airline and communicated to the seller at the time of an OrderReshopRS (which precedes OrderChangeRQ). It is up to the seller to then accept the proposed actions from the OrderReshopRS by echoing these functions in this OrderServicing structure.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderServicing" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:OrderRequestType" name="AcceptOffer" minOccurs="0"/>
         *       &lt;xs:element name="Delete" minOccurs="0">
         *         &lt;!-- Reference to inner class Delete -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OrderServicing implements Serializable
        {
            private OrderRequestType acceptOffer;
            private Delete delete;

            /** 
             * Get the 'AcceptOffer' element value. Function to accept a new OfferItem and adding it to the existing Order.
             * 
             * @return value
             */
            public OrderRequestType getAcceptOffer() {
                return acceptOffer;
            }

            /** 
             * Set the 'AcceptOffer' element value. Function to accept a new OfferItem and adding it to the existing Order.
             * 
             * @param acceptOffer
             */
            public void setAcceptOffer(OrderRequestType acceptOffer) {
                this.acceptOffer = acceptOffer;
            }

            /** 
             * Get the 'Delete' element value.
             * 
             * @return value
             */
            public Delete getDelete() {
                return delete;
            }

            /** 
             * Set the 'Delete' element value.
             * 
             * @param delete
             */
            public void setDelete(Delete delete) {
                this.delete = delete;
            }
            /** 
             * Function to accept the deletion of an OrderItem from the existing Order.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Delete" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="OrderItemID" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Delete implements Serializable
            {
                private List<String> orderItemIDList = new ArrayList<String>();

                /** 
                 * Get the list of 'OrderItemID' element items.
                 * 
                 * @return list
                 */
                public List<String> getOrderItemIDList() {
                    return orderItemIDList;
                }

                /** 
                 * Set the list of 'OrderItemID' element items.
                 * 
                 * @param list
                 */
                public void setOrderItemIDList(List<String> list) {
                    orderItemIDList = list;
                }
            }
        }
        /** 
         * Function to Add, Remove or Update the Passenger Details. Providing the New and Previous values together implies an Update.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerServicing" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="New" minOccurs="0">
         *         &lt;!-- Reference to inner class New -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Previous" minOccurs="0">
         *         &lt;!-- Reference to inner class Previous -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PassengerServicing implements Serializable
        {
            private New _new;
            private Previous previous;

            /** 
             * Get the 'New' element value.
             * 
             * @return value
             */
            public New getNew() {
                return _new;
            }

            /** 
             * Set the 'New' element value.
             * 
             * @param _new
             */
            public void setNew(New _new) {
                this._new = _new;
            }

            /** 
             * Get the 'Previous' element value.
             * 
             * @return value
             */
            public Previous getPrevious() {
                return previous;
            }

            /** 
             * Set the 'Previous' element value.
             * 
             * @param previous
             */
            public void setPrevious(Previous previous) {
                this.previous = previous;
            }
            /** 
             * If used alone, requests the addition of information to the passenger details.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="New" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="PTC" minOccurs="0"/>
             *       &lt;xs:choice minOccurs="0">
             *         &lt;!-- Reference to inner class ChoiceInner -->
             *       &lt;/xs:choice>
             *       &lt;xs:element type="xs:string" name="ResidenceCountryCode" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="CitizenshipCountryCode" minOccurs="0"/>
             *       &lt;xs:element type="ns:IndividualType" name="Individual" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="ProfileID" minOccurs="0"/>
             *       &lt;xs:element type="ns:LoyaltyProgramAccountType" name="LoyaltyProgramAccount" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element type="ns:FOID" name="FOID" minOccurs="0"/>
             *       &lt;xs:element type="ns:IdentityDocumentType" name="IdentityDocument" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element type="xs:string" name="ContactInfoRef" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="InfantRef" minOccurs="0"/>
             *       &lt;xs:element type="ns:LanguageUsageType" name="Language" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element type="ns:RemarkTypeAIDM" name="Remark" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element name="ActionType"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="PassengerID"/>
             *     &lt;xs:attribute type="xs:boolean" name="ProfileConsentIndicator"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class New implements Serializable
            {
                private String PTC;
                private ChoiceInner choice;
                private String residenceCountryCode;
                private String citizenshipCountryCode;
                private IndividualType individual;
                private String profileID;
                private List<LoyaltyProgramAccountType> loyaltyProgramAccountList = new ArrayList<LoyaltyProgramAccountType>();
                private FOID FOID;
                private List<IdentityDocumentType> identityDocumentList = new ArrayList<IdentityDocumentType>();
                private String contactInfoRef;
                private String infantRef;
                private List<LanguageUsageType> languageList = new ArrayList<LanguageUsageType>();
                private List<RemarkTypeAIDM> remarkList = new ArrayList<RemarkTypeAIDM>();
                private String passengerID;
                private Boolean profileConsentIndicator;

                /** 
                 * Get the 'PTC' element value. Type code applying to the Passenger which typically drives pricing (e.g. ADT, CHD, etc).
                 * 
                 * @return value
                 */
                public String getPTC() {
                    return PTC;
                }

                /** 
                 * Set the 'PTC' element value. Type code applying to the Passenger which typically drives pricing (e.g. ADT, CHD, etc).
                 * 
                 * @param PTC
                 */
                public void setPTC(String PTC) {
                    this.PTC = PTC;
                }

                /** 
                 * Get the choice value.
                 * 
                 * @return value
                 */
                public ChoiceInner getChoice() {
                    return choice;
                }

                /** 
                 * Set the choice value.
                 * 
                 * @param choice
                 */
                public void setChoice(ChoiceInner choice) {
                    this.choice = choice;
                }

                /** 
                 * Get the 'ResidenceCountryCode' element value. Residence Country Code. Examples: US, FR.
                 * 
                 * @return value
                 */
                public String getResidenceCountryCode() {
                    return residenceCountryCode;
                }

                /** 
                 * Set the 'ResidenceCountryCode' element value. Residence Country Code. Examples: US, FR.
                 * 
                 * @param residenceCountryCode
                 */
                public void setResidenceCountryCode(String residenceCountryCode) {
                    this.residenceCountryCode = residenceCountryCode;
                }

                /** 
                 * Get the 'CitizenshipCountryCode' element value. Citizenship Country Code. Examples: US, FR.
                 * 
                 * @return value
                 */
                public String getCitizenshipCountryCode() {
                    return citizenshipCountryCode;
                }

                /** 
                 * Set the 'CitizenshipCountryCode' element value. Citizenship Country Code. Examples: US, FR.
                 * 
                 * @param citizenshipCountryCode
                 */
                public void setCitizenshipCountryCode(
                        String citizenshipCountryCode) {
                    this.citizenshipCountryCode = citizenshipCountryCode;
                }

                /** 
                 * Get the 'Individual' element value. A single human being as distinct from a group, class, or family.
                 * 
                 * @return value
                 */
                public IndividualType getIndividual() {
                    return individual;
                }

                /** 
                 * Set the 'Individual' element value. A single human being as distinct from a group, class, or family.
                 * 
                 * @param individual
                 */
                public void setIndividual(IndividualType individual) {
                    this.individual = individual;
                }

                /** 
                 * Get the 'ProfileID' element value. Passenger Profile ID
                 * 
                 * @return value
                 */
                public String getProfileID() {
                    return profileID;
                }

                /** 
                 * Set the 'ProfileID' element value. Passenger Profile ID
                 * 
                 * @param profileID
                 */
                public void setProfileID(String profileID) {
                    this.profileID = profileID;
                }

                /** 
                 * Get the list of 'LoyaltyProgramAccount' element items. An account set up for a customer within a rewards program which holds funds on behalf of that customer.
                 * 
                 * @return list
                 */
                public List<LoyaltyProgramAccountType> getLoyaltyProgramAccountList() {
                    return loyaltyProgramAccountList;
                }

                /** 
                 * Set the list of 'LoyaltyProgramAccount' element items. An account set up for a customer within a rewards program which holds funds on behalf of that customer.
                 * 
                 * @param list
                 */
                public void setLoyaltyProgramAccountList(
                        List<LoyaltyProgramAccountType> list) {
                    loyaltyProgramAccountList = list;
                }

                /** 
                 * Get the 'FOID' element value. Form of identification.  Typically used to identify that the passenger is who he says he is.

                This is the type of FOID as defined in AIRIMP (FF Number, Credit Card Number, etc.).

                 * 
                 * @return value
                 */
                public FOID getFOID() {
                    return FOID;
                }

                /** 
                 * Set the 'FOID' element value. Form of identification.  Typically used to identify that the passenger is who he says he is.

                This is the type of FOID as defined in AIRIMP (FF Number, Credit Card Number, etc.).

                 * 
                 * @param FOID
                 */
                public void setFOID(FOID FOID) {
                    this.FOID = FOID;
                }

                /** 
                 * Get the list of 'IdentityDocument' element items. Any document which may be used to identify a person or verify aspects of a person's personal identity.
                 * 
                 * @return list
                 */
                public List<IdentityDocumentType> getIdentityDocumentList() {
                    return identityDocumentList;
                }

                /** 
                 * Set the list of 'IdentityDocument' element items. Any document which may be used to identify a person or verify aspects of a person's personal identity.
                 * 
                 * @param list
                 */
                public void setIdentityDocumentList(
                        List<IdentityDocumentType> list) {
                    identityDocumentList = list;
                }

                /** 
                 * Get the 'ContactInfoRef' element value. Reference to Contact Information, within the context of one message.
                 * 
                 * @return value
                 */
                public String getContactInfoRef() {
                    return contactInfoRef;
                }

                /** 
                 * Set the 'ContactInfoRef' element value. Reference to Contact Information, within the context of one message.
                 * 
                 * @param contactInfoRef
                 */
                public void setContactInfoRef(String contactInfoRef) {
                    this.contactInfoRef = contactInfoRef;
                }

                /** 
                 * Get the 'InfantRef' element value. Reference to Passenger instance within the context of one message, associating an infant on lap to this adult passenger. 
                 * 
                 * @return value
                 */
                public String getInfantRef() {
                    return infantRef;
                }

                /** 
                 * Set the 'InfantRef' element value. Reference to Passenger instance within the context of one message, associating an infant on lap to this adult passenger. 
                 * 
                 * @param infantRef
                 */
                public void setInfantRef(String infantRef) {
                    this.infantRef = infantRef;
                }

                /** 
                 * Get the list of 'Language' element items. Language Code representation.
                 * 
                 * @return list
                 */
                public List<LanguageUsageType> getLanguageList() {
                    return languageList;
                }

                /** 
                 * Set the list of 'Language' element items. Language Code representation.
                 * 
                 * @param list
                 */
                public void setLanguageList(List<LanguageUsageType> list) {
                    languageList = list;
                }

                /** 
                 * Get the list of 'Remark' element items. Additional, supplementary information about the document or service.
                 * 
                 * @return list
                 */
                public List<RemarkTypeAIDM> getRemarkList() {
                    return remarkList;
                }

                /** 
                 * Set the list of 'Remark' element items. Additional, supplementary information about the document or service.
                 * 
                 * @param list
                 */
                public void setRemarkList(List<RemarkTypeAIDM> list) {
                    remarkList = list;
                }

                /** 
                 * Get the 'PassengerID' attribute value. Uniquely identifies a Passenger within the context of one message.
                 * 
                 * @return value
                 */
                public String getPassengerID() {
                    return passengerID;
                }

                /** 
                 * Set the 'PassengerID' attribute value. Uniquely identifies a Passenger within the context of one message.
                 * 
                 * @param passengerID
                 */
                public void setPassengerID(String passengerID) {
                    this.passengerID = passengerID;
                }

                /** 
                 * Get the 'ProfileConsentIndicator' attribute value. When true, passenger authorizes the airline to share his/her profile information or send promotional emails.
                 * 
                 * @return value
                 */
                public Boolean getProfileConsentIndicator() {
                    return profileConsentIndicator;
                }

                /** 
                 * Set the 'ProfileConsentIndicator' attribute value. When true, passenger authorizes the airline to share his/her profile information or send promotional emails.
                 * 
                 * @param profileConsentIndicator
                 */
                public void setProfileConsentIndicator(
                        Boolean profileConsentIndicator) {
                    this.profileConsentIndicator = profileConsentIndicator;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:choice xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
                 *   &lt;xs:element type="ns:MeasureType" name="Age" minOccurs="0"/>
                 *   &lt;xs:element type="xs:date" name="Birthdate" minOccurs="0"/>
                 * &lt;/xs:choice>
                 * </pre>
                 */
                public static class ChoiceInner implements Serializable
                {
                    private int choiceSelect = -1;
                    private static final int AGE_CHOICE = 0;
                    private static final int BIRTHDATE_CHOICE = 1;
                    private MeasureType age;
                    private Date birthdate;

                    private void setChoiceSelect(int choice) {
                        if (choiceSelect == -1) {
                            choiceSelect = choice;
                        } else if (choiceSelect != choice) {
                            throw new IllegalStateException(
                                    "Need to call clearChoiceSelect() before changing existing choice");
                        }
                    }

                    /** 
                     * Clear the choice selection.
                     */
                    public void clearChoiceSelect() {
                        choiceSelect = -1;
                    }

                    /** 
                     * Check if Age is current selection for choice.
                     * 
                     * @return <code>true</code> if selection, <code>false</code> if not
                     */
                    public boolean ifAge() {
                        return choiceSelect == AGE_CHOICE;
                    }

                    /** 
                     * Get the 'Age' element value. The Age of the Passenger.  To be used in NDC Anonymous Shopping requests or when the birthdate (in Individual) is not known.
                     * 
                     * @return value
                     */
                    public MeasureType getAge() {
                        return age;
                    }

                    /** 
                     * Set the 'Age' element value. The Age of the Passenger.  To be used in NDC Anonymous Shopping requests or when the birthdate (in Individual) is not known.
                     * 
                     * @param age
                     */
                    public void setAge(MeasureType age) {
                        setChoiceSelect(AGE_CHOICE);
                        this.age = age;
                    }

                    /** 
                     * Check if Birthdate is current selection for choice.
                     * 
                     * @return <code>true</code> if selection, <code>false</code> if not
                     */
                    public boolean ifBirthdate() {
                        return choiceSelect == BIRTHDATE_CHOICE;
                    }

                    /** 
                     * Get the 'Birthdate' element value. The Date of Birth of the Passenger.  Anonymous Shopping requests or when the birthdate (in Individual) is not known.
                     * 
                     * @return value
                     */
                    public Date getBirthdate() {
                        return birthdate;
                    }

                    /** 
                     * Set the 'Birthdate' element value. The Date of Birth of the Passenger.  Anonymous Shopping requests or when the birthdate (in Individual) is not known.
                     * 
                     * @param birthdate
                     */
                    public void setBirthdate(Date birthdate) {
                        setChoiceSelect(BIRTHDATE_CHOICE);
                        this.birthdate = birthdate;
                    }
                }
            }
            /** 
             * If used alone, requests the removal of information to the passenger details.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Previous" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="PTC" minOccurs="0"/>
             *       &lt;xs:choice minOccurs="0">
             *         &lt;!-- Reference to inner class ChoiceInner -->
             *       &lt;/xs:choice>
             *       &lt;xs:element type="xs:string" name="ResidenceCountryCode" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="CitizenshipCountryCode" minOccurs="0"/>
             *       &lt;xs:element type="ns:IndividualType" name="Individual" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="ProfileID" minOccurs="0"/>
             *       &lt;xs:element type="ns:LoyaltyProgramAccountType" name="LoyaltyProgramAccount" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element type="ns:FOID" name="FOID" minOccurs="0"/>
             *       &lt;xs:element type="ns:IdentityDocumentType" name="IdentityDocument" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element type="xs:string" name="ContactInfoRef" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="InfantRef" minOccurs="0"/>
             *       &lt;xs:element type="ns:LanguageUsageType" name="Language" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element type="ns:RemarkTypeAIDM" name="Remark" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element name="ActionType"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="PassengerID"/>
             *     &lt;xs:attribute type="xs:boolean" name="ProfileConsentIndicator"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Previous implements Serializable
            {
                private String PTC;
                private ChoiceInner choice;
                private String residenceCountryCode;
                private String citizenshipCountryCode;
                private IndividualType individual;
                private String profileID;
                private List<LoyaltyProgramAccountType> loyaltyProgramAccountList = new ArrayList<LoyaltyProgramAccountType>();
                private FOID FOID;
                private List<IdentityDocumentType> identityDocumentList = new ArrayList<IdentityDocumentType>();
                private String contactInfoRef;
                private String infantRef;
                private List<LanguageUsageType> languageList = new ArrayList<LanguageUsageType>();
                private List<RemarkTypeAIDM> remarkList = new ArrayList<RemarkTypeAIDM>();
                private String passengerID;
                private Boolean profileConsentIndicator;

                /** 
                 * Get the 'PTC' element value. Type code applying to the Passenger which typically drives pricing (e.g. ADT, CHD, etc).
                 * 
                 * @return value
                 */
                public String getPTC() {
                    return PTC;
                }

                /** 
                 * Set the 'PTC' element value. Type code applying to the Passenger which typically drives pricing (e.g. ADT, CHD, etc).
                 * 
                 * @param PTC
                 */
                public void setPTC(String PTC) {
                    this.PTC = PTC;
                }

                /** 
                 * Get the choice value.
                 * 
                 * @return value
                 */
                public ChoiceInner getChoice() {
                    return choice;
                }

                /** 
                 * Set the choice value.
                 * 
                 * @param choice
                 */
                public void setChoice(ChoiceInner choice) {
                    this.choice = choice;
                }

                /** 
                 * Get the 'ResidenceCountryCode' element value. Residence Country Code. Examples: US, FR.
                 * 
                 * @return value
                 */
                public String getResidenceCountryCode() {
                    return residenceCountryCode;
                }

                /** 
                 * Set the 'ResidenceCountryCode' element value. Residence Country Code. Examples: US, FR.
                 * 
                 * @param residenceCountryCode
                 */
                public void setResidenceCountryCode(String residenceCountryCode) {
                    this.residenceCountryCode = residenceCountryCode;
                }

                /** 
                 * Get the 'CitizenshipCountryCode' element value. Citizenship Country Code. Examples: US, FR.
                 * 
                 * @return value
                 */
                public String getCitizenshipCountryCode() {
                    return citizenshipCountryCode;
                }

                /** 
                 * Set the 'CitizenshipCountryCode' element value. Citizenship Country Code. Examples: US, FR.
                 * 
                 * @param citizenshipCountryCode
                 */
                public void setCitizenshipCountryCode(
                        String citizenshipCountryCode) {
                    this.citizenshipCountryCode = citizenshipCountryCode;
                }

                /** 
                 * Get the 'Individual' element value. A single human being as distinct from a group, class, or family.
                 * 
                 * @return value
                 */
                public IndividualType getIndividual() {
                    return individual;
                }

                /** 
                 * Set the 'Individual' element value. A single human being as distinct from a group, class, or family.
                 * 
                 * @param individual
                 */
                public void setIndividual(IndividualType individual) {
                    this.individual = individual;
                }

                /** 
                 * Get the 'ProfileID' element value. Passenger Profile ID
                 * 
                 * @return value
                 */
                public String getProfileID() {
                    return profileID;
                }

                /** 
                 * Set the 'ProfileID' element value. Passenger Profile ID
                 * 
                 * @param profileID
                 */
                public void setProfileID(String profileID) {
                    this.profileID = profileID;
                }

                /** 
                 * Get the list of 'LoyaltyProgramAccount' element items. An account set up for a customer within a rewards program which holds funds on behalf of that customer.
                 * 
                 * @return list
                 */
                public List<LoyaltyProgramAccountType> getLoyaltyProgramAccountList() {
                    return loyaltyProgramAccountList;
                }

                /** 
                 * Set the list of 'LoyaltyProgramAccount' element items. An account set up for a customer within a rewards program which holds funds on behalf of that customer.
                 * 
                 * @param list
                 */
                public void setLoyaltyProgramAccountList(
                        List<LoyaltyProgramAccountType> list) {
                    loyaltyProgramAccountList = list;
                }

                /** 
                 * Get the 'FOID' element value. Form of identification.  Typically used to identify that the passenger is who he says he is.

                This is the type of FOID as defined in AIRIMP (FF Number, Credit Card Number, etc.).

                 * 
                 * @return value
                 */
                public FOID getFOID() {
                    return FOID;
                }

                /** 
                 * Set the 'FOID' element value. Form of identification.  Typically used to identify that the passenger is who he says he is.

                This is the type of FOID as defined in AIRIMP (FF Number, Credit Card Number, etc.).

                 * 
                 * @param FOID
                 */
                public void setFOID(FOID FOID) {
                    this.FOID = FOID;
                }

                /** 
                 * Get the list of 'IdentityDocument' element items. Any document which may be used to identify a person or verify aspects of a person's personal identity.
                 * 
                 * @return list
                 */
                public List<IdentityDocumentType> getIdentityDocumentList() {
                    return identityDocumentList;
                }

                /** 
                 * Set the list of 'IdentityDocument' element items. Any document which may be used to identify a person or verify aspects of a person's personal identity.
                 * 
                 * @param list
                 */
                public void setIdentityDocumentList(
                        List<IdentityDocumentType> list) {
                    identityDocumentList = list;
                }

                /** 
                 * Get the 'ContactInfoRef' element value. Reference to Contact Information, within the context of one message.
                 * 
                 * @return value
                 */
                public String getContactInfoRef() {
                    return contactInfoRef;
                }

                /** 
                 * Set the 'ContactInfoRef' element value. Reference to Contact Information, within the context of one message.
                 * 
                 * @param contactInfoRef
                 */
                public void setContactInfoRef(String contactInfoRef) {
                    this.contactInfoRef = contactInfoRef;
                }

                /** 
                 * Get the 'InfantRef' element value. Reference to Passenger instance within the context of one message, associating an infant on lap to this adult passenger. 
                 * 
                 * @return value
                 */
                public String getInfantRef() {
                    return infantRef;
                }

                /** 
                 * Set the 'InfantRef' element value. Reference to Passenger instance within the context of one message, associating an infant on lap to this adult passenger. 
                 * 
                 * @param infantRef
                 */
                public void setInfantRef(String infantRef) {
                    this.infantRef = infantRef;
                }

                /** 
                 * Get the list of 'Language' element items. Language Code representation.
                 * 
                 * @return list
                 */
                public List<LanguageUsageType> getLanguageList() {
                    return languageList;
                }

                /** 
                 * Set the list of 'Language' element items. Language Code representation.
                 * 
                 * @param list
                 */
                public void setLanguageList(List<LanguageUsageType> list) {
                    languageList = list;
                }

                /** 
                 * Get the list of 'Remark' element items. Additional, supplementary information about the document or service.
                 * 
                 * @return list
                 */
                public List<RemarkTypeAIDM> getRemarkList() {
                    return remarkList;
                }

                /** 
                 * Set the list of 'Remark' element items. Additional, supplementary information about the document or service.
                 * 
                 * @param list
                 */
                public void setRemarkList(List<RemarkTypeAIDM> list) {
                    remarkList = list;
                }

                /** 
                 * Get the 'PassengerID' attribute value. Uniquely identifies a Passenger within the context of one message.
                 * 
                 * @return value
                 */
                public String getPassengerID() {
                    return passengerID;
                }

                /** 
                 * Set the 'PassengerID' attribute value. Uniquely identifies a Passenger within the context of one message.
                 * 
                 * @param passengerID
                 */
                public void setPassengerID(String passengerID) {
                    this.passengerID = passengerID;
                }

                /** 
                 * Get the 'ProfileConsentIndicator' attribute value. When true, passenger authorizes the airline to share his/her profile information or send promotional emails.
                 * 
                 * @return value
                 */
                public Boolean getProfileConsentIndicator() {
                    return profileConsentIndicator;
                }

                /** 
                 * Set the 'ProfileConsentIndicator' attribute value. When true, passenger authorizes the airline to share his/her profile information or send promotional emails.
                 * 
                 * @param profileConsentIndicator
                 */
                public void setProfileConsentIndicator(
                        Boolean profileConsentIndicator) {
                    this.profileConsentIndicator = profileConsentIndicator;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:choice xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
                 *   &lt;xs:element type="ns:MeasureType" name="Age" minOccurs="0"/>
                 *   &lt;xs:element type="xs:date" name="Birthdate" minOccurs="0"/>
                 * &lt;/xs:choice>
                 * </pre>
                 */
                public static class ChoiceInner implements Serializable
                {
                    private int choiceSelect = -1;
                    private static final int AGE_CHOICE = 0;
                    private static final int BIRTHDATE_CHOICE = 1;
                    private MeasureType age;
                    private Date birthdate;

                    private void setChoiceSelect(int choice) {
                        if (choiceSelect == -1) {
                            choiceSelect = choice;
                        } else if (choiceSelect != choice) {
                            throw new IllegalStateException(
                                    "Need to call clearChoiceSelect() before changing existing choice");
                        }
                    }

                    /** 
                     * Clear the choice selection.
                     */
                    public void clearChoiceSelect() {
                        choiceSelect = -1;
                    }

                    /** 
                     * Check if Age is current selection for choice.
                     * 
                     * @return <code>true</code> if selection, <code>false</code> if not
                     */
                    public boolean ifAge() {
                        return choiceSelect == AGE_CHOICE;
                    }

                    /** 
                     * Get the 'Age' element value. The Age of the Passenger.  To be used in NDC Anonymous Shopping requests or when the birthdate (in Individual) is not known.
                     * 
                     * @return value
                     */
                    public MeasureType getAge() {
                        return age;
                    }

                    /** 
                     * Set the 'Age' element value. The Age of the Passenger.  To be used in NDC Anonymous Shopping requests or when the birthdate (in Individual) is not known.
                     * 
                     * @param age
                     */
                    public void setAge(MeasureType age) {
                        setChoiceSelect(AGE_CHOICE);
                        this.age = age;
                    }

                    /** 
                     * Check if Birthdate is current selection for choice.
                     * 
                     * @return <code>true</code> if selection, <code>false</code> if not
                     */
                    public boolean ifBirthdate() {
                        return choiceSelect == BIRTHDATE_CHOICE;
                    }

                    /** 
                     * Get the 'Birthdate' element value. The Date of Birth of the Passenger.  Anonymous Shopping requests or when the birthdate (in Individual) is not known.
                     * 
                     * @return value
                     */
                    public Date getBirthdate() {
                        return birthdate;
                    }

                    /** 
                     * Set the 'Birthdate' element value. The Date of Birth of the Passenger.  Anonymous Shopping requests or when the birthdate (in Individual) is not known.
                     * 
                     * @param birthdate
                     */
                    public void setBirthdate(Date birthdate) {
                        setChoiceSelect(BIRTHDATE_CHOICE);
                        this.birthdate = birthdate;
                    }
                }
            }
        }
        /** 
         * Function used by seller to inform the airline that it is accepting the proposed Order, as it has been repriced and returned in the preceding OrderReshopRS.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AcceptRepricedOrder" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="ResponseID"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AcceptRepricedOrder implements Serializable
        {
            private String responseID;

            /** 
             * Get the 'ResponseID' element value.
             * 
             * @return value
             */
            public String getResponseID() {
                return responseID;
            }

            /** 
             * Set the 'ResponseID' element value.
             * 
             * @param responseID
             */
            public void setResponseID(String responseID) {
                this.responseID = responseID;
            }
        }
    }
    /** 
     * Payment information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payments" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Payment" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Payment -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Payments implements Serializable
    {
        private List<Payment> paymentList = new ArrayList<Payment>();

        /** 
         * Get the list of 'Payment' element items.
         * 
         * @return list
         */
        public List<Payment> getPaymentList() {
            return paymentList;
        }

        /** 
         * Set the list of 'Payment' element items.
         * 
         * @param list
         */
        public void setPaymentList(List<Payment> list) {
            paymentList = list;
        }
        /** 
         * Payment detail, including association(s).
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payment" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:OrderPaymentFormType">
         *         &lt;xs:sequence>
         *           &lt;xs:element name="Offers" minOccurs="0">
         *             &lt;!-- Reference to inner class Offers -->
         *           &lt;/xs:element>
         *           &lt;xs:element type="xs:string" name="OrderItemID" minOccurs="0" maxOccurs="unbounded"/>
         *         &lt;/xs:sequence>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Payment extends OrderPaymentFormType implements
            Serializable
        {
            private Offers offers;
            private List<String> orderItemIDList = new ArrayList<String>();

            /** 
             * Get the 'Offers' element value.
             * 
             * @return value
             */
            public Offers getOffers() {
                return offers;
            }

            /** 
             * Set the 'Offers' element value.
             * 
             * @param offers
             */
            public void setOffers(Offers offers) {
                this.offers = offers;
            }

            /** 
             * Get the list of 'OrderItemID' element items.
             * 
             * @return list
             */
            public List<String> getOrderItemIDList() {
                return orderItemIDList;
            }

            /** 
             * Set the list of 'OrderItemID' element items.
             * 
             * @param list
             */
            public void setOrderItemIDList(List<String> list) {
                orderItemIDList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Offers" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Offer" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Offer -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Offers implements Serializable
            {
                private List<Offer> offerList = new ArrayList<Offer>();

                /** 
                 * Get the list of 'Offer' element items.
                 * 
                 * @return list
                 */
                public List<Offer> getOfferList() {
                    return offerList;
                }

                /** 
                 * Set the list of 'Offer' element items.
                 * 
                 * @param list
                 */
                public void setOfferList(List<Offer> list) {
                    offerList = list;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Offer" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="OfferItemID" minOccurs="0" maxOccurs="unbounded"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="required" name="OfferID"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Owner"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="ResponseID"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Offer implements Serializable
                {
                    private List<String> offerItemIDList = new ArrayList<String>();
                    private String offerID;
                    private String owner;
                    private String responseID;

                    /** 
                     * Get the list of 'OfferItemID' element items. 
                                      Association to one or multiple Offer Items instance(s). Example:OI1 OI2
                                    
                     * 
                     * @return list
                     */
                    public List<String> getOfferItemIDList() {
                        return offerItemIDList;
                    }

                    /** 
                     * Set the list of 'OfferItemID' element items. 
                                      Association to one or multiple Offer Items instance(s). Example:OI1 OI2
                                    
                     * 
                     * @param list
                     */
                    public void setOfferItemIDList(List<String> list) {
                        offerItemIDList = list;
                    }

                    /** 
                     * Get the 'OfferID' attribute value. Reference to the OfferID of the selected Offer (either a standard Offer or an a-la-carte Offer) returned in a previous shopping response.
                     * 
                     * @return value
                     */
                    public String getOfferID() {
                        return offerID;
                    }

                    /** 
                     * Set the 'OfferID' attribute value. Reference to the OfferID of the selected Offer (either a standard Offer or an a-la-carte Offer) returned in a previous shopping response.
                     * 
                     * @param offerID
                     */
                    public void setOfferID(String offerID) {
                        this.offerID = offerID;
                    }

                    /** 
                     * Get the 'Owner' attribute value. Designator of Airline that owns/ assigned these IDs. Examples: BA

                    Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
                     * 
                     * @return value
                     */
                    public String getOwner() {
                        return owner;
                    }

                    /** 
                     * Set the 'Owner' attribute value. Designator of Airline that owns/ assigned these IDs. Examples: BA

                    Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
                     * 
                     * @param owner
                     */
                    public void setOwner(String owner) {
                        this.owner = owner;
                    }

                    /** 
                     * Get the 'ResponseID' attribute value. Reference to unique shopping session response ID, as provided in the airline's previous shopping response.
                     * 
                     * @return value
                     */
                    public String getResponseID() {
                        return responseID;
                    }

                    /** 
                     * Set the 'ResponseID' attribute value. Reference to unique shopping session response ID, as provided in the airline's previous shopping response.
                     * 
                     * @param responseID
                     */
                    public void setResponseID(String responseID) {
                        this.responseID = responseID;
                    }
                }
            }
        }
    }
    /** 
     * Data Lists(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DataLists" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PassengerList" minOccurs="0">
     *         &lt;!-- Reference to inner class PassengerList -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ContactList" minOccurs="0">
     *         &lt;!-- Reference to inner class ContactList -->
     *       &lt;/xs:element>
     *       &lt;xs:element ref="ns:BagDisclosureList" minOccurs="0"/>
     *       &lt;xs:element name="BaggageAllowanceList" minOccurs="0">
     *         &lt;!-- Reference to inner class BaggageAllowanceList -->
     *       &lt;/xs:element>
     *       &lt;xs:element ref="ns:ClassOfServiceList" minOccurs="0"/>
     *       &lt;xs:element ref="ns:ContentSourceList" minOccurs="0"/>
     *       &lt;xs:element name="DescriptionList" minOccurs="0">
     *         &lt;!-- Reference to inner class DescriptionList -->
     *       &lt;/xs:element>
     *       &lt;xs:element ref="ns:DisclosureList" minOccurs="0"/>
     *       &lt;xs:element ref="ns:FareList" minOccurs="0"/>
     *       &lt;xs:element name="FlightSegmentList" minOccurs="0">
     *         &lt;!-- Reference to inner class FlightSegmentList -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FlightList" minOccurs="0">
     *         &lt;!-- Reference to inner class FlightList -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="OriginDestinationList" minOccurs="0">
     *         &lt;!-- Reference to inner class OriginDestinationList -->
     *       &lt;/xs:element>
     *       &lt;xs:element ref="ns:InstructionsList" minOccurs="0"/>
     *       &lt;xs:element ref="ns:MediaList" minOccurs="0"/>
     *       &lt;xs:element ref="ns:PenaltyList" minOccurs="0"/>
     *       &lt;xs:element name="PriceClassList" minOccurs="0">
     *         &lt;!-- Reference to inner class PriceClassList -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ServiceDefinitionList" minOccurs="0">
     *         &lt;!-- Reference to inner class ServiceDefinitionList -->
     *       &lt;/xs:element>
     *       &lt;xs:element ref="ns:TermsList" minOccurs="0"/>
     *       &lt;xs:element name="SeatDefinitionList" minOccurs="0">
     *         &lt;!-- Reference to inner class SeatDefinitionList -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DataLists implements Serializable
    {
        private PassengerList passengerList;
        private ContactList contactList;
        private ListOfBagDisclosureType bagDisclosureList;
        private BaggageAllowanceList baggageAllowanceList;
        private ListOfClassOfServiceType classOfServiceList;
        private ListOfContentSourceType contentSourceList;
        private DescriptionList descriptionList;
        private ListOfDisclosureType disclosureList;
        private FareList fareList;
        private FlightSegmentList flightSegmentList;
        private FlightList flightList;
        private OriginDestinationList originDestinationList;
        private ListOfOfferInstructionsType instructionsList;
        private ListOfMediaType mediaList;
        private ListOfOfferPenaltyType penaltyList;
        private PriceClassList priceClassList;
        private ServiceDefinitionList serviceDefinitionList;
        private ListOfOfferTermsType termsList;
        private SeatDefinitionList seatDefinitionList;

        /** 
         * Get the 'PassengerList' element value.
         * 
         * @return value
         */
        public PassengerList getPassengerList() {
            return passengerList;
        }

        /** 
         * Set the 'PassengerList' element value.
         * 
         * @param passengerList
         */
        public void setPassengerList(PassengerList passengerList) {
            this.passengerList = passengerList;
        }

        /** 
         * Get the 'ContactList' element value.
         * 
         * @return value
         */
        public ContactList getContactList() {
            return contactList;
        }

        /** 
         * Set the 'ContactList' element value.
         * 
         * @param contactList
         */
        public void setContactList(ContactList contactList) {
            this.contactList = contactList;
        }

        /** 
         * Get the 'BagDisclosureList' element value.
         * 
         * @return value
         */
        public ListOfBagDisclosureType getBagDisclosureList() {
            return bagDisclosureList;
        }

        /** 
         * Set the 'BagDisclosureList' element value.
         * 
         * @param bagDisclosureList
         */
        public void setBagDisclosureList(
                ListOfBagDisclosureType bagDisclosureList) {
            this.bagDisclosureList = bagDisclosureList;
        }

        /** 
         * Get the 'BaggageAllowanceList' element value.
         * 
         * @return value
         */
        public BaggageAllowanceList getBaggageAllowanceList() {
            return baggageAllowanceList;
        }

        /** 
         * Set the 'BaggageAllowanceList' element value.
         * 
         * @param baggageAllowanceList
         */
        public void setBaggageAllowanceList(
                BaggageAllowanceList baggageAllowanceList) {
            this.baggageAllowanceList = baggageAllowanceList;
        }

        /** 
         * Get the 'ClassOfServiceList' element value.
         * 
         * @return value
         */
        public ListOfClassOfServiceType getClassOfServiceList() {
            return classOfServiceList;
        }

        /** 
         * Set the 'ClassOfServiceList' element value.
         * 
         * @param classOfServiceList
         */
        public void setClassOfServiceList(
                ListOfClassOfServiceType classOfServiceList) {
            this.classOfServiceList = classOfServiceList;
        }

        /** 
         * Get the 'ContentSourceList' element value.
         * 
         * @return value
         */
        public ListOfContentSourceType getContentSourceList() {
            return contentSourceList;
        }

        /** 
         * Set the 'ContentSourceList' element value.
         * 
         * @param contentSourceList
         */
        public void setContentSourceList(
                ListOfContentSourceType contentSourceList) {
            this.contentSourceList = contentSourceList;
        }

        /** 
         * Get the 'DescriptionList' element value.
         * 
         * @return value
         */
        public DescriptionList getDescriptionList() {
            return descriptionList;
        }

        /** 
         * Set the 'DescriptionList' element value.
         * 
         * @param descriptionList
         */
        public void setDescriptionList(DescriptionList descriptionList) {
            this.descriptionList = descriptionList;
        }

        /** 
         * Get the 'DisclosureList' element value.
         * 
         * @return value
         */
        public ListOfDisclosureType getDisclosureList() {
            return disclosureList;
        }

        /** 
         * Set the 'DisclosureList' element value.
         * 
         * @param disclosureList
         */
        public void setDisclosureList(ListOfDisclosureType disclosureList) {
            this.disclosureList = disclosureList;
        }

        /** 
         * Get the 'FareList' element value.
         * 
         * @return value
         */
        public FareList getFareList() {
            return fareList;
        }

        /** 
         * Set the 'FareList' element value.
         * 
         * @param fareList
         */
        public void setFareList(FareList fareList) {
            this.fareList = fareList;
        }

        /** 
         * Get the 'FlightSegmentList' element value.
         * 
         * @return value
         */
        public FlightSegmentList getFlightSegmentList() {
            return flightSegmentList;
        }

        /** 
         * Set the 'FlightSegmentList' element value.
         * 
         * @param flightSegmentList
         */
        public void setFlightSegmentList(FlightSegmentList flightSegmentList) {
            this.flightSegmentList = flightSegmentList;
        }

        /** 
         * Get the 'FlightList' element value.
         * 
         * @return value
         */
        public FlightList getFlightList() {
            return flightList;
        }

        /** 
         * Set the 'FlightList' element value.
         * 
         * @param flightList
         */
        public void setFlightList(FlightList flightList) {
            this.flightList = flightList;
        }

        /** 
         * Get the 'OriginDestinationList' element value.
         * 
         * @return value
         */
        public OriginDestinationList getOriginDestinationList() {
            return originDestinationList;
        }

        /** 
         * Set the 'OriginDestinationList' element value.
         * 
         * @param originDestinationList
         */
        public void setOriginDestinationList(
                OriginDestinationList originDestinationList) {
            this.originDestinationList = originDestinationList;
        }

        /** 
         * Get the 'InstructionsList' element value.
         * 
         * @return value
         */
        public ListOfOfferInstructionsType getInstructionsList() {
            return instructionsList;
        }

        /** 
         * Set the 'InstructionsList' element value.
         * 
         * @param instructionsList
         */
        public void setInstructionsList(
                ListOfOfferInstructionsType instructionsList) {
            this.instructionsList = instructionsList;
        }

        /** 
         * Get the 'MediaList' element value.
         * 
         * @return value
         */
        public ListOfMediaType getMediaList() {
            return mediaList;
        }

        /** 
         * Set the 'MediaList' element value.
         * 
         * @param mediaList
         */
        public void setMediaList(ListOfMediaType mediaList) {
            this.mediaList = mediaList;
        }

        /** 
         * Get the 'PenaltyList' element value.
         * 
         * @return value
         */
        public ListOfOfferPenaltyType getPenaltyList() {
            return penaltyList;
        }

        /** 
         * Set the 'PenaltyList' element value.
         * 
         * @param penaltyList
         */
        public void setPenaltyList(ListOfOfferPenaltyType penaltyList) {
            this.penaltyList = penaltyList;
        }

        /** 
         * Get the 'PriceClassList' element value.
         * 
         * @return value
         */
        public PriceClassList getPriceClassList() {
            return priceClassList;
        }

        /** 
         * Set the 'PriceClassList' element value.
         * 
         * @param priceClassList
         */
        public void setPriceClassList(PriceClassList priceClassList) {
            this.priceClassList = priceClassList;
        }

        /** 
         * Get the 'ServiceDefinitionList' element value.
         * 
         * @return value
         */
        public ServiceDefinitionList getServiceDefinitionList() {
            return serviceDefinitionList;
        }

        /** 
         * Set the 'ServiceDefinitionList' element value.
         * 
         * @param serviceDefinitionList
         */
        public void setServiceDefinitionList(
                ServiceDefinitionList serviceDefinitionList) {
            this.serviceDefinitionList = serviceDefinitionList;
        }

        /** 
         * Get the 'TermsList' element value.
         * 
         * @return value
         */
        public ListOfOfferTermsType getTermsList() {
            return termsList;
        }

        /** 
         * Set the 'TermsList' element value.
         * 
         * @param termsList
         */
        public void setTermsList(ListOfOfferTermsType termsList) {
            this.termsList = termsList;
        }

        /** 
         * Get the 'SeatDefinitionList' element value.
         * 
         * @return value
         */
        public SeatDefinitionList getSeatDefinitionList() {
            return seatDefinitionList;
        }

        /** 
         * Set the 'SeatDefinitionList' element value.
         * 
         * @param seatDefinitionList
         */
        public void setSeatDefinitionList(SeatDefinitionList seatDefinitionList) {
            this.seatDefinitionList = seatDefinitionList;
        }
        /** 
         * Passenger data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:PassengerType" name="Passenger" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PassengerList implements Serializable
        {
            private List<PassengerType> passengerList = new ArrayList<PassengerType>();

            /** 
             * Get the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @return list
             */
            public List<PassengerType> getPassengerList() {
                return passengerList;
            }

            /** 
             * Set the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @param list
             */
            public void setPassengerList(List<PassengerType> list) {
                passengerList = list;
            }
        }
        /** 
         * Contact data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ContactInformationType" name="ContactInformation" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ContactList implements Serializable
        {
            private List<ContactInformationType> contactInformationList = new ArrayList<ContactInformationType>();

            /** 
             * Get the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @return list
             */
            public List<ContactInformationType> getContactInformationList() {
                return contactInformationList;
            }

            /** 
             * Set the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @param list
             */
            public void setContactInformationList(
                    List<ContactInformationType> list) {
                contactInformationList = list;
            }
        }
        /** 
         * Checked or Carry-On Baggage Allowance detail. Use BaggageCategory to specify which of the two.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageAllowanceList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="BaggageAllowance" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class BaggageAllowance -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class BaggageAllowanceList implements Serializable
        {
            private List<BaggageAllowance> baggageAllowanceList = new ArrayList<BaggageAllowance>();

            /** 
             * Get the list of 'BaggageAllowance' element items.
             * 
             * @return list
             */
            public List<BaggageAllowance> getBaggageAllowanceList() {
                return baggageAllowanceList;
            }

            /** 
             * Set the list of 'BaggageAllowance' element items.
             * 
             * @param list
             */
            public void setBaggageAllowanceList(List<BaggageAllowance> list) {
                baggageAllowanceList = list;
            }
            /** 
             * Checked or Carry-On Baggage Allowance detail. Use BaggageCategory to specify which of the two.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageAllowance" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:BaggageCategoryListType" name="BaggageCategory"/>
             *       &lt;xs:element ref="ns:AllowanceDescription" minOccurs="0"/>
             *       &lt;xs:element ref="ns:DimensionAllowance" minOccurs="0"/>
             *       &lt;xs:element ref="ns:PieceAllowance" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element ref="ns:WeightAllowance" minOccurs="0"/>
             *       &lt;xs:element type="ns:BaggageDeterminingCarrierType" name="BaggageDeterminingCarrier" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="BaggageAllowanceID"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BaggageAllowance implements Serializable
            {
                private BaggageCategoryListType baggageCategory;
                private BagAllowanceDescType allowanceDescription;
                private BagAllowanceDimensionType dimensionAllowance;
                private List<BagAllowancePieceType> pieceAllowanceList = new ArrayList<BagAllowancePieceType>();
                private WeightAllowance weightAllowance;
                private BaggageDeterminingCarrierType baggageDeterminingCarrier;
                private String baggageAllowanceID;

                /** 
                 * Get the 'BaggageCategory' element value. Enumeration:

                CarryOn
                Checked
                 * 
                 * @return value
                 */
                public BaggageCategoryListType getBaggageCategory() {
                    return baggageCategory;
                }

                /** 
                 * Set the 'BaggageCategory' element value. Enumeration:

                CarryOn
                Checked
                 * 
                 * @param baggageCategory
                 */
                public void setBaggageCategory(
                        BaggageCategoryListType baggageCategory) {
                    this.baggageCategory = baggageCategory;
                }

                /** 
                 * Get the 'AllowanceDescription' element value.
                 * 
                 * @return value
                 */
                public BagAllowanceDescType getAllowanceDescription() {
                    return allowanceDescription;
                }

                /** 
                 * Set the 'AllowanceDescription' element value.
                 * 
                 * @param allowanceDescription
                 */
                public void setAllowanceDescription(
                        BagAllowanceDescType allowanceDescription) {
                    this.allowanceDescription = allowanceDescription;
                }

                /** 
                 * Get the 'DimensionAllowance' element value.
                 * 
                 * @return value
                 */
                public BagAllowanceDimensionType getDimensionAllowance() {
                    return dimensionAllowance;
                }

                /** 
                 * Set the 'DimensionAllowance' element value.
                 * 
                 * @param dimensionAllowance
                 */
                public void setDimensionAllowance(
                        BagAllowanceDimensionType dimensionAllowance) {
                    this.dimensionAllowance = dimensionAllowance;
                }

                /** 
                 * Get the list of 'PieceAllowance' element items.
                 * 
                 * @return list
                 */
                public List<BagAllowancePieceType> getPieceAllowanceList() {
                    return pieceAllowanceList;
                }

                /** 
                 * Set the list of 'PieceAllowance' element items.
                 * 
                 * @param list
                 */
                public void setPieceAllowanceList(
                        List<BagAllowancePieceType> list) {
                    pieceAllowanceList = list;
                }

                /** 
                 * Get the 'WeightAllowance' element value.
                 * 
                 * @return value
                 */
                public WeightAllowance getWeightAllowance() {
                    return weightAllowance;
                }

                /** 
                 * Set the 'WeightAllowance' element value.
                 * 
                 * @param weightAllowance
                 */
                public void setWeightAllowance(WeightAllowance weightAllowance) {
                    this.weightAllowance = weightAllowance;
                }

                /** 
                 * Get the 'BaggageDeterminingCarrier' element value. Baggage Determining Carrier as defined in resolution 722 (f), and who’s baggage rules apply.
                 * 
                 * @return value
                 */
                public BaggageDeterminingCarrierType getBaggageDeterminingCarrier() {
                    return baggageDeterminingCarrier;
                }

                /** 
                 * Set the 'BaggageDeterminingCarrier' element value. Baggage Determining Carrier as defined in resolution 722 (f), and who’s baggage rules apply.
                 * 
                 * @param baggageDeterminingCarrier
                 */
                public void setBaggageDeterminingCarrier(
                        BaggageDeterminingCarrierType baggageDeterminingCarrier) {
                    this.baggageDeterminingCarrier = baggageDeterminingCarrier;
                }

                /** 
                 * Get the 'BaggageAllowanceID' attribute value.
                 * 
                 * @return value
                 */
                public String getBaggageAllowanceID() {
                    return baggageAllowanceID;
                }

                /** 
                 * Set the 'BaggageAllowanceID' attribute value.
                 * 
                 * @param baggageAllowanceID
                 */
                public void setBaggageAllowanceID(String baggageAllowanceID) {
                    this.baggageAllowanceID = baggageAllowanceID;
                }
            }
        }
        /** 
         * Description Details
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DescriptionList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element ref="ns:Description" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class DescriptionList implements Serializable
        {
            private List<com.gridnine.xtrip.server.gds.tandc.wsmodel.Description> descriptionList = new ArrayList<com.gridnine.xtrip.server.gds.tandc.wsmodel.Description>();

            /** 
             * Get the list of 'Description' element items.
             * 
             * @return list
             */
            public List<com.gridnine.xtrip.server.gds.tandc.wsmodel.Description> getDescriptionList() {
                return descriptionList;
            }

            /** 
             * Set the list of 'Description' element items.
             * 
             * @param list
             */
            public void setDescriptionList(
                    List<com.gridnine.xtrip.server.gds.tandc.wsmodel.Description> list) {
                descriptionList = list;
            }
        }
        /** 
         * List of Flight Segments
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegmentList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ListOfFlightSegmentType" name="FlightSegment" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FlightSegmentList implements Serializable
        {
            private List<ListOfFlightSegmentType> flightSegmentList = new ArrayList<ListOfFlightSegmentType>();

            /** 
             * Get the list of 'FlightSegment' element items.
             * 
             * @return list
             */
            public List<ListOfFlightSegmentType> getFlightSegmentList() {
                return flightSegmentList;
            }

            /** 
             * Set the list of 'FlightSegment' element items.
             * 
             * @param list
             */
            public void setFlightSegmentList(List<ListOfFlightSegmentType> list) {
                flightSegmentList = list;
            }
        }
        /** 
         * List of Flight elements.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Flight" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Flight -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FlightList implements Serializable
        {
            private List<Flight> flightList = new ArrayList<Flight>();

            /** 
             * Get the list of 'Flight' element items.
             * 
             * @return list
             */
            public List<Flight> getFlightList() {
                return flightList;
            }

            /** 
             * Set the list of 'Flight' element items.
             * 
             * @param list
             */
            public void setFlightList(List<Flight> list) {
                flightList = list;
            }
            /** 
             * Journey information describing the travel between an airport/city where travel commences and an airport/city where travel ultimately terminates. A journey may be comprised of one or more segments. Note: This node will be renamed to journey in future releases.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Flight" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:TotalJourneyType" name="Journey" minOccurs="0"/>
             *       &lt;xs:element ref="ns:SegmentReferences"/>
             *       &lt;xs:element name="Settlement" minOccurs="0">
             *         &lt;!-- Reference to inner class Settlement -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
             *     &lt;xs:attribute type="xs:string" name="FlightKey"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * 
             * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
             *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
             * &lt;/xs:attributeGroup>
             * </pre>
             */
            public static class Flight implements Serializable
            {
                private TotalJourneyType journey;
                private SegmentReferences segmentReferences;
                private Settlement settlement;
                private String refs;
                private String flightKey;

                /** 
                 * Get the 'Journey' element value. Flight journey information.
                 * 
                 * @return value
                 */
                public TotalJourneyType getJourney() {
                    return journey;
                }

                /** 
                 * Set the 'Journey' element value. Flight journey information.
                 * 
                 * @param journey
                 */
                public void setJourney(TotalJourneyType journey) {
                    this.journey = journey;
                }

                /** 
                 * Get the 'SegmentReferences' element value.
                 * 
                 * @return value
                 */
                public SegmentReferences getSegmentReferences() {
                    return segmentReferences;
                }

                /** 
                 * Set the 'SegmentReferences' element value.
                 * 
                 * @param segmentReferences
                 */
                public void setSegmentReferences(
                        SegmentReferences segmentReferences) {
                    this.segmentReferences = segmentReferences;
                }

                /** 
                 * Get the 'Settlement' element value.
                 * 
                 * @return value
                 */
                public Settlement getSettlement() {
                    return settlement;
                }

                /** 
                 * Set the 'Settlement' element value.
                 * 
                 * @param settlement
                 */
                public void setSettlement(Settlement settlement) {
                    this.settlement = settlement;
                }

                /** 
                 * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @return value
                 */
                public String getRefs() {
                    return refs;
                }

                /** 
                 * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @param refs
                 */
                public void setRefs(String refs) {
                    this.refs = refs;
                }

                /** 
                 * Get the 'FlightKey' attribute value. A globally unique identifier for this Flight instance. Example: flight1
                 * 
                 * @return value
                 */
                public String getFlightKey() {
                    return flightKey;
                }

                /** 
                 * Set the 'FlightKey' attribute value. A globally unique identifier for this Flight instance. Example: flight1
                 * 
                 * @param flightKey
                 */
                public void setFlightKey(String flightKey) {
                    this.flightKey = flightKey;
                }
                /** 
                 * Interline Settlement information between airlines, including method of settlement, interline settlement value and currency.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Settlement" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Method"/>
                 *       &lt;xs:element type="ns:CurrencyAmountOptType" name="InterlineSettlementValue" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Settlement implements Serializable
                {
                    private String method;
                    private CurrencyAmountOptType interlineSettlementValue;

                    /** 
                     * Get the 'Method' element value. Service settlement method.
                    Examples:
                    AD (Internal Airline Document)
                    DS (Direct Settlement)
                    EA (EMD Associated or Internal Airline Document)
                    ES (EMD Standalone )
                    FI (Fare Integrated)
                    MA (Flight Associated, Settled via MCO)
                    MS (Standalone, Settled via MCO)

                    Encoding Scheme: IATA PADIS Codeset SST (Service Settlement Type)
                     * 
                     * @return value
                     */
                    public String getMethod() {
                        return method;
                    }

                    /** 
                     * Set the 'Method' element value. Service settlement method.
                    Examples:
                    AD (Internal Airline Document)
                    DS (Direct Settlement)
                    EA (EMD Associated or Internal Airline Document)
                    ES (EMD Standalone )
                    FI (Fare Integrated)
                    MA (Flight Associated, Settled via MCO)
                    MS (Standalone, Settled via MCO)

                    Encoding Scheme: IATA PADIS Codeset SST (Service Settlement Type)
                     * 
                     * @param method
                     */
                    public void setMethod(String method) {
                        this.method = method;
                    }

                    /** 
                     * Get the 'InterlineSettlementValue' element value. Settlement (Price) Value. Example: 300 (USD)

                    Note: This represents a Settlement value that is only used between the POA and ORA.
                     * 
                     * @return value
                     */
                    public CurrencyAmountOptType getInterlineSettlementValue() {
                        return interlineSettlementValue;
                    }

                    /** 
                     * Set the 'InterlineSettlementValue' element value. Settlement (Price) Value. Example: 300 (USD)

                    Note: This represents a Settlement value that is only used between the POA and ORA.
                     * 
                     * @param interlineSettlementValue
                     */
                    public void setInterlineSettlementValue(
                            CurrencyAmountOptType interlineSettlementValue) {
                        this.interlineSettlementValue = interlineSettlementValue;
                    }
                }
            }
        }
        /** 
         * List of Origin/Destination elements.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element ref="ns:OriginDestination" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OriginDestinationList implements Serializable
        {
            private List<OriginDestination> originDestinationList = new ArrayList<OriginDestination>();

            /** 
             * Get the list of 'OriginDestination' element items.
             * 
             * @return list
             */
            public List<OriginDestination> getOriginDestinationList() {
                return originDestinationList;
            }

            /** 
             * Set the list of 'OriginDestination' element items.
             * 
             * @param list
             */
            public void setOriginDestinationList(List<OriginDestination> list) {
                originDestinationList = list;
            }
        }
        /** 
         * Price Class list.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceClassList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:PriceClassType" name="PriceClass" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PriceClassList implements Serializable
        {
            private List<PriceClassType> priceClassList = new ArrayList<PriceClassType>();

            /** 
             * Get the list of 'PriceClass' element items.
             * 
             * @return list
             */
            public List<PriceClassType> getPriceClassList() {
                return priceClassList;
            }

            /** 
             * Set the list of 'PriceClass' element items.
             * 
             * @param list
             */
            public void setPriceClassList(List<PriceClassType> list) {
                priceClassList = list;
            }
        }
        /** 
         * Description and characteristics of a Service
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceDefinitionList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ServiceDefinitionType" name="ServiceDefinition" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ServiceDefinitionList implements Serializable
        {
            private List<ServiceDefinitionType> serviceDefinitionList = new ArrayList<ServiceDefinitionType>();

            /** 
             * Get the list of 'ServiceDefinition' element items.
             * 
             * @return list
             */
            public List<ServiceDefinitionType> getServiceDefinitionList() {
                return serviceDefinitionList;
            }

            /** 
             * Set the list of 'ServiceDefinition' element items.
             * 
             * @param list
             */
            public void setServiceDefinitionList(
                    List<ServiceDefinitionType> list) {
                serviceDefinitionList = list;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatDefinitionList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="SeatDefinition" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class SeatDefinition -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SeatDefinitionList implements Serializable
        {
            private List<SeatDefinition> seatDefinitionList = new ArrayList<SeatDefinition>();

            /** 
             * Get the list of 'SeatDefinition' element items.
             * 
             * @return list
             */
            public List<SeatDefinition> getSeatDefinitionList() {
                return seatDefinitionList;
            }

            /** 
             * Set the list of 'SeatDefinition' element items.
             * 
             * @param list
             */
            public void setSeatDefinitionList(List<SeatDefinition> list) {
                seatDefinitionList = list;
            }
            /** 
             * Seat information by aircraft section.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatDefinition" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Description" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Description -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="ns:SeatMapMessageType" name="Marketing" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="SeatCharacteristicCode" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element type="ns:SizeUnitSimpleType" name="UOM" minOccurs="0"/>
             *       &lt;xs:element type="xs:decimal" name="SeatWidthLow" minOccurs="0"/>
             *       &lt;xs:element type="xs:decimal" name="SeatPitchLow" minOccurs="0"/>
             *       &lt;xs:element name="Keywords" minOccurs="0">
             *         &lt;!-- Reference to inner class Keywords -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="SeatDefinitionID"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class SeatDefinition implements Serializable
            {
                private List<Description> descriptionList = new ArrayList<Description>();
                private SeatMapMessageType marketing;
                private List<String> seatCharacteristicCodeList = new ArrayList<String>();
                private SizeUnitSimpleType UOM;
                private BigDecimal seatWidthLow;
                private BigDecimal seatPitchLow;
                private Keywords keywords;
                private String seatDefinitionID;

                /** 
                 * Get the list of 'Description' element items.
                 * 
                 * @return list
                 */
                public List<Description> getDescriptionList() {
                    return descriptionList;
                }

                /** 
                 * Set the list of 'Description' element items.
                 * 
                 * @param list
                 */
                public void setDescriptionList(List<Description> list) {
                    descriptionList = list;
                }

                /** 
                 * Get the 'Marketing' element value. Images and/or links for the entire section defined by the range of rows.
                 * 
                 * @return value
                 */
                public SeatMapMessageType getMarketing() {
                    return marketing;
                }

                /** 
                 * Set the 'Marketing' element value. Images and/or links for the entire section defined by the range of rows.
                 * 
                 * @param marketing
                 */
                public void setMarketing(SeatMapMessageType marketing) {
                    this.marketing = marketing;
                }

                /** 
                 * Get the list of 'SeatCharacteristicCode' element items. Refers to aircraft seat characteristics; seat option codes.  Examples: E (EXIT ROW), M (Middle Seat), A (Aisle seat), L (Left side of aircraft), Q (Bulk Head).  Refer to PADIS code list 9825.
                 * 
                 * @return list
                 */
                public List<String> getSeatCharacteristicCodeList() {
                    return seatCharacteristicCodeList;
                }

                /** 
                 * Set the list of 'SeatCharacteristicCode' element items. Refers to aircraft seat characteristics; seat option codes.  Examples: E (EXIT ROW), M (Middle Seat), A (Aisle seat), L (Left side of aircraft), Q (Bulk Head).  Refer to PADIS code list 9825.
                 * 
                 * @param list
                 */
                public void setSeatCharacteristicCodeList(List<String> list) {
                    seatCharacteristicCodeList = list;
                }

                /** 
                 * Get the 'UOM' element value. Associated Keyword Unit of Measure, if relevant. Example: INCH
                 * 
                 * @return value
                 */
                public SizeUnitSimpleType getUOM() {
                    return UOM;
                }

                /** 
                 * Set the 'UOM' element value. Associated Keyword Unit of Measure, if relevant. Example: INCH
                 * 
                 * @param UOM
                 */
                public void setUOM(SizeUnitSimpleType UOM) {
                    this.UOM = UOM;
                }

                /** 
                 * Get the 'SeatWidthLow' element value. Lowest Width Measurement value for this section. Example: 20
                 * 
                 * @return value
                 */
                public BigDecimal getSeatWidthLow() {
                    return seatWidthLow;
                }

                /** 
                 * Set the 'SeatWidthLow' element value. Lowest Width Measurement value for this section. Example: 20
                 * 
                 * @param seatWidthLow
                 */
                public void setSeatWidthLow(BigDecimal seatWidthLow) {
                    this.seatWidthLow = seatWidthLow;
                }

                /** 
                 * Get the 'SeatPitchLow' element value. Lowest Pitch Measurement value for this section. Example: 32
                 * 
                 * @return value
                 */
                public BigDecimal getSeatPitchLow() {
                    return seatPitchLow;
                }

                /** 
                 * Set the 'SeatPitchLow' element value. Lowest Pitch Measurement value for this section. Example: 32
                 * 
                 * @param seatPitchLow
                 */
                public void setSeatPitchLow(BigDecimal seatPitchLow) {
                    this.seatPitchLow = seatPitchLow;
                }

                /** 
                 * Get the 'Keywords' element value.
                 * 
                 * @return value
                 */
                public Keywords getKeywords() {
                    return keywords;
                }

                /** 
                 * Set the 'Keywords' element value.
                 * 
                 * @param keywords
                 */
                public void setKeywords(Keywords keywords) {
                    this.keywords = keywords;
                }

                /** 
                 * Get the 'SeatDefinitionID' attribute value.
                 * 
                 * @return value
                 */
                public String getSeatDefinitionID() {
                    return seatDefinitionID;
                }

                /** 
                 * Set the 'SeatDefinitionID' attribute value.
                 * 
                 * @param seatDefinitionID
                 */
                public void setSeatDefinitionID(String seatDefinitionID) {
                    this.seatDefinitionID = seatDefinitionID;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Description" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:sequence>
                 *         &lt;xs:element name="Text" minOccurs="0">
                 *           &lt;!-- Reference to inner class Text -->
                 *         &lt;/xs:element>
                 *         &lt;xs:element type="xs:string" name="MarkupStyle" minOccurs="0"/>
                 *       &lt;/xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Link" minOccurs="0"/>
                 *       &lt;xs:element name="Media" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class Media -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Description implements Serializable
                {
                    private Text text;
                    private String markupStyle;
                    private String link;
                    private List<Media> mediaList = new ArrayList<Media>();

                    /** 
                     * Get the 'Text' element value.
                     * 
                     * @return value
                     */
                    public Text getText() {
                        return text;
                    }

                    /** 
                     * Set the 'Text' element value.
                     * 
                     * @param text
                     */
                    public void setText(Text text) {
                        this.text = text;
                    }

                    /** 
                     * Get the 'MarkupStyle' element value. Mark-up Style. Example: HTML
                     * 
                     * @return value
                     */
                    public String getMarkupStyle() {
                        return markupStyle;
                    }

                    /** 
                     * Set the 'MarkupStyle' element value. Mark-up Style. Example: HTML
                     * 
                     * @param markupStyle
                     */
                    public void setMarkupStyle(String markupStyle) {
                        this.markupStyle = markupStyle;
                    }

                    /** 
                     * Get the 'Link' element value. LINK to Description information source.
                     * 
                     * @return value
                     */
                    public String getLink() {
                        return link;
                    }

                    /** 
                     * Set the 'Link' element value. LINK to Description information source.
                     * 
                     * @param link
                     */
                    public void setLink(String link) {
                        this.link = link;
                    }

                    /** 
                     * Get the list of 'Media' element items.
                     * 
                     * @return list
                     */
                    public List<Media> getMediaList() {
                        return mediaList;
                    }

                    /** 
                     * Set the list of 'Media' element items.
                     * 
                     * @param list
                     */
                    public void setMediaList(List<Media> list) {
                        mediaList = list;
                    }
                    /** 
                     * Description value.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Text" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:string">
                     *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * 
                     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
                     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
                     * &lt;/xs:attributeGroup>
                     * </pre>
                     */
                    public static class Text implements Serializable
                    {
                        private String string;
                        private String refs;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public String getString() {
                            return string;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param string
                         */
                        public void setString(String string) {
                            this.string = string;
                        }

                        /** 
                         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                         * 
                         * @return value
                         */
                        public String getRefs() {
                            return refs;
                        }

                        /** 
                         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                         * 
                         * @param refs
                         */
                        public void setRefs(String refs) {
                            this.refs = refs;
                        }
                    }
                    /** 
                     * Description-associated Media Object(s).
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Media" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:choice>
                     *       &lt;xs:element type="ns:UniqueIDContextType" name="ObjectID"/>
                     *       &lt;xs:element ref="ns:MediaLink"/>
                     *       &lt;xs:element type="ns:UniqueIDContextType" name="AttachmentID"/>
                     *     &lt;/xs:choice>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Media implements Serializable
                    {
                        private int mediaListSelect = -1;
                        private static final int OBJECT_ID_CHOICE = 0;
                        private static final int MEDIA_LINK_CHOICE = 1;
                        private static final int ATTACHMENT_ID_CHOICE = 2;
                        private UniqueIDContextType objectID;
                        private MediaLink mediaLink;
                        private UniqueIDContextType attachmentID;

                        private void setMediaListSelect(int choice) {
                            if (mediaListSelect == -1) {
                                mediaListSelect = choice;
                            } else if (mediaListSelect != choice) {
                                throw new IllegalStateException(
                                        "Need to call clearMediaListSelect() before changing existing choice");
                            }
                        }

                        /** 
                         * Clear the choice selection.
                         */
                        public void clearMediaListSelect() {
                            mediaListSelect = -1;
                        }

                        /** 
                         * Check if ObjectID is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifObjectID() {
                            return mediaListSelect == OBJECT_ID_CHOICE;
                        }

                        /** 
                         * Get the 'ObjectID' element value. Description-associated MEDIA OBJECT ID or Key. Example: IMG1
                         * 
                         * @return value
                         */
                        public UniqueIDContextType getObjectID() {
                            return objectID;
                        }

                        /** 
                         * Set the 'ObjectID' element value. Description-associated MEDIA OBJECT ID or Key. Example: IMG1
                         * 
                         * @param objectID
                         */
                        public void setObjectID(UniqueIDContextType objectID) {
                            setMediaListSelect(OBJECT_ID_CHOICE);
                            this.objectID = objectID;
                        }

                        /** 
                         * Check if MediaLink is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifMediaLink() {
                            return mediaListSelect == MEDIA_LINK_CHOICE;
                        }

                        /** 
                         * Get the 'MediaLink' element value. Description-associated MEDIA LINK.
                         * 
                         * @return value
                         */
                        public MediaLink getMediaLink() {
                            return mediaLink;
                        }

                        /** 
                         * Set the 'MediaLink' element value. Description-associated MEDIA LINK.
                         * 
                         * @param mediaLink
                         */
                        public void setMediaLink(MediaLink mediaLink) {
                            setMediaListSelect(MEDIA_LINK_CHOICE);
                            this.mediaLink = mediaLink;
                        }

                        /** 
                         * Check if AttachmentID is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifAttachmentID() {
                            return mediaListSelect == ATTACHMENT_ID_CHOICE;
                        }

                        /** 
                         * Get the 'AttachmentID' element value. Description-associated Media Attachment ID. Example: ATT1.
                         * 
                         * @return value
                         */
                        public UniqueIDContextType getAttachmentID() {
                            return attachmentID;
                        }

                        /** 
                         * Set the 'AttachmentID' element value. Description-associated Media Attachment ID. Example: ATT1.
                         * 
                         * @param attachmentID
                         */
                        public void setAttachmentID(
                                UniqueIDContextType attachmentID) {
                            setMediaListSelect(ATTACHMENT_ID_CHOICE);
                            this.attachmentID = attachmentID;
                        }
                    }
                }
                /** 
                 * Seat Description Key-Value Word Pairs.
                Examples:
                ReclineDegree - 25
                BedLengthLowEnd - 68
                BedLengthHighEnd - 78
                WidthLowEnd - 20
                WidthHighEnd - 21.5
                PitchLowEnd - 32
                PitchHighEnd - 34.4

                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Keywords" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="ns:KeyWordType" name="KeyWord" maxOccurs="unbounded"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Keywords implements Serializable
                {
                    private List<KeyWordType> keyWordList = new ArrayList<KeyWordType>();

                    /** 
                     * Get the list of 'KeyWord' element items. Key-Value detail.
                     * 
                     * @return list
                     */
                    public List<KeyWordType> getKeyWordList() {
                        return keyWordList;
                    }

                    /** 
                     * Set the list of 'KeyWord' element items. Key-Value detail.
                     * 
                     * @param list
                     */
                    public void setKeyWordList(List<KeyWordType> list) {
                        keyWordList = list;
                    }
                }
            }
        }
    }
}
