
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Order Instructions.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderInstructions">
 *   &lt;xs:complexType>
 *     &lt;xs:complexContent>
 *       &lt;xs:extension base="ns:OrderInstructionType">
 *         &lt;xs:sequence>
 *           &lt;xs:element ref="ns:ClassOfServiceUpgrade" minOccurs="0"/>
 *           &lt;xs:element ref="ns:FreeFormTextInstruction" minOccurs="0"/>
 *           &lt;xs:element type="xs:string" name="SpecialBookingInstruction" minOccurs="0"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:extension>
 *     &lt;/xs:complexContent>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OrderInstructions extends OrderInstructionType implements
    Serializable
{
    private InstrClassUpgradeType classOfServiceUpgrade;
    private FreeFormTextInstruction freeFormTextInstruction;
    private String specialBookingInstruction;

    /** 
     * Get the 'ClassOfServiceUpgrade' element value.
     * 
     * @return value
     */
    public InstrClassUpgradeType getClassOfServiceUpgrade() {
        return classOfServiceUpgrade;
    }

    /** 
     * Set the 'ClassOfServiceUpgrade' element value.
     * 
     * @param classOfServiceUpgrade
     */
    public void setClassOfServiceUpgrade(
            InstrClassUpgradeType classOfServiceUpgrade) {
        this.classOfServiceUpgrade = classOfServiceUpgrade;
    }

    /** 
     * Get the 'FreeFormTextInstruction' element value.
     * 
     * @return value
     */
    public FreeFormTextInstruction getFreeFormTextInstruction() {
        return freeFormTextInstruction;
    }

    /** 
     * Set the 'FreeFormTextInstruction' element value.
     * 
     * @param freeFormTextInstruction
     */
    public void setFreeFormTextInstruction(
            FreeFormTextInstruction freeFormTextInstruction) {
        this.freeFormTextInstruction = freeFormTextInstruction;
    }

    /** 
     * Get the 'SpecialBookingInstruction' element value. Special Need Order booking method.
    Examples:
    AE (by SSR-Special Service Request)

    Encoding scheme: PADIS Code List for data element 9750 - Option
     * 
     * @return value
     */
    public String getSpecialBookingInstruction() {
        return specialBookingInstruction;
    }

    /** 
     * Set the 'SpecialBookingInstruction' element value. Special Need Order booking method.
    Examples:
    AE (by SSR-Special Service Request)

    Encoding scheme: PADIS Code List for data element 9750 - Option
     * 
     * @param specialBookingInstruction
     */
    public void setSpecialBookingInstruction(String specialBookingInstruction) {
        this.specialBookingInstruction = specialBookingInstruction;
    }
}
