
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Order ID and Child Order Item Collection definition.Shopping CR: This fulfills the requirement to allow previously ordered items to be used as a shopping session qualifiers.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderKeysType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="ns:OrderID"/>
 *     &lt;xs:element name="AssociatedIDs" minOccurs="0">
 *       &lt;!-- Reference to inner class AssociatedIDs -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class OrderKeysType implements Serializable
{
    private OrderIDType orderID;
    private AssociatedIDs associatedIDs;
    private String refs;

    /** 
     * Get the 'OrderID' element value.
     * 
     * @return value
     */
    public OrderIDType getOrderID() {
        return orderID;
    }

    /** 
     * Set the 'OrderID' element value.
     * 
     * @param orderID
     */
    public void setOrderID(OrderIDType orderID) {
        this.orderID = orderID;
    }

    /** 
     * Get the 'AssociatedIDs' element value.
     * 
     * @return value
     */
    public AssociatedIDs getAssociatedIDs() {
        return associatedIDs;
    }

    /** 
     * Set the 'AssociatedIDs' element value.
     * 
     * @param associatedIDs
     */
    public void setAssociatedIDs(AssociatedIDs associatedIDs) {
        this.associatedIDs = associatedIDs;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Associated Order Item(s), Offer Item(s) and Optional Service(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AssociatedIDs" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="AssociatedID" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class AssociatedID -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AssociatedIDs implements Serializable
    {
        private List<AssociatedID> associatedIDList = new ArrayList<AssociatedID>();

        /** 
         * Get the list of 'AssociatedID' element items.
         * 
         * @return list
         */
        public List<AssociatedID> getAssociatedIDList() {
            return associatedIDList;
        }

        /** 
         * Set the list of 'AssociatedID' element items.
         * 
         * @param list
         */
        public void setAssociatedIDList(List<AssociatedID> list) {
            associatedIDList = list;
        }
        /** 
         * Associated ID detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AssociatedID" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element ref="ns:OrderItemID" minOccurs="0"/>
         *       &lt;xs:element ref="ns:OfferItemID" minOccurs="0"/>
         *       &lt;xs:element ref="ns:ServiceID" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AssociatedID implements Serializable
        {
            private OrderItemID orderItemID;
            private OfferItemID offerItemID;
            private ServiceIDType serviceID;

            /** 
             * Get the 'OrderItemID' element value.
             * 
             * @return value
             */
            public OrderItemID getOrderItemID() {
                return orderItemID;
            }

            /** 
             * Set the 'OrderItemID' element value.
             * 
             * @param orderItemID
             */
            public void setOrderItemID(OrderItemID orderItemID) {
                this.orderItemID = orderItemID;
            }

            /** 
             * Get the 'OfferItemID' element value.
             * 
             * @return value
             */
            public OfferItemID getOfferItemID() {
                return offerItemID;
            }

            /** 
             * Set the 'OfferItemID' element value.
             * 
             * @param offerItemID
             */
            public void setOfferItemID(OfferItemID offerItemID) {
                this.offerItemID = offerItemID;
            }

            /** 
             * Get the 'ServiceID' element value.
             * 
             * @return value
             */
            public ServiceIDType getServiceID() {
                return serviceID;
            }

            /** 
             * Set the 'ServiceID' element value.
             * 
             * @param serviceID
             */
            public void setServiceID(ServiceIDType serviceID) {
                this.serviceID = serviceID;
            }
        }
    }
}
