
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * The OrderList transaction set retrieves a list of Orders that match one or more search criteria.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderListRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:PointOfSale" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element ref="ns:OrderListParameters" minOccurs="0"/>
 *       &lt;xs:element name="Query">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element name="Filters">
 *               &lt;xs:complexType>
 *                 &lt;xs:sequence>
 *                   &lt;xs:element name="Agency" minOccurs="0">
 *                     &lt;!-- Reference to inner class Agency -->
 *                   &lt;/xs:element>
 *                   &lt;xs:element name="Airline" minOccurs="0">
 *                     &lt;!-- Reference to inner class Airline -->
 *                   &lt;/xs:element>
 *                   &lt;xs:element ref="ns:BookingReferences" minOccurs="0"/>
 *                   &lt;xs:element type="ns:DatePeriodRepType" name="CancelDateRange" minOccurs="0"/>
 *                   &lt;xs:element type="ns:DatePeriodRepType" name="CreateDateRange" minOccurs="0"/>
 *                   &lt;xs:element name="Flight" minOccurs="0">
 *                     &lt;!-- Reference to inner class Flight -->
 *                   &lt;/xs:element>
 *                   &lt;xs:element name="Group" minOccurs="0">
 *                     &lt;!-- Reference to inner class Group -->
 *                   &lt;/xs:element>
 *                   &lt;xs:element name="Passenger" minOccurs="0">
 *                     &lt;!-- Reference to inner class Passenger -->
 *                   &lt;/xs:element>
 *                   &lt;xs:element name="Payments" minOccurs="0">
 *                     &lt;!-- Reference to inner class Payments -->
 *                   &lt;/xs:element>
 *                   &lt;xs:element name="TicketDocument" minOccurs="0">
 *                     &lt;!-- Reference to inner class TicketDocument -->
 *                   &lt;/xs:element>
 *                   &lt;xs:element type="ns:DatePeriodRepType" name="TravelDateRange" minOccurs="0"/>
 *                   &lt;xs:element name="Service" minOccurs="0">
 *                     &lt;!-- Reference to inner class Service -->
 *                   &lt;/xs:element>
 *                 &lt;/xs:sequence>
 *               &lt;/xs:complexType>
 *             &lt;/xs:element>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OrderListRQ implements Serializable
{
    private PointOfSaleType pointOfSale;
    private MsgDocumentType document;
    private MsgPartiesType party;
    private OrderListParamsType orderListParameters;
    private Agency agency;
    private Airline airline;
    private BookingReferences queryBookingReferences;
    private DatePeriodRepType queryCancelDateRange;
    private DatePeriodRepType queryCreateDateRange;
    private Flight flight;
    private Group group;
    private Passenger passenger;
    private Payments payments;
    private TicketDocument ticketDocument;
    private DatePeriodRepType queryTravelDateRange;
    private Service service;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'PointOfSale' element value.
     * 
     * @return value
     */
    public PointOfSaleType getPointOfSale() {
        return pointOfSale;
    }

    /** 
     * Set the 'PointOfSale' element value.
     * 
     * @param pointOfSale
     */
    public void setPointOfSale(PointOfSaleType pointOfSale) {
        this.pointOfSale = pointOfSale;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    /** 
     * Get the 'OrderListParameters' element value.
     * 
     * @return value
     */
    public OrderListParamsType getOrderListParameters() {
        return orderListParameters;
    }

    /** 
     * Set the 'OrderListParameters' element value.
     * 
     * @param orderListParameters
     */
    public void setOrderListParameters(OrderListParamsType orderListParameters) {
        this.orderListParameters = orderListParameters;
    }

    /** 
     * Get the 'Agency' element value. Query Filters.
     * 
     * @return value
     */
    public Agency getAgency() {
        return agency;
    }

    /** 
     * Set the 'Agency' element value. Query Filters.
     * 
     * @param agency
     */
    public void setAgency(Agency agency) {
        this.agency = agency;
    }

    /** 
     * Get the 'Airline' element value. Query Filters.
     * 
     * @return value
     */
    public Airline getAirline() {
        return airline;
    }

    /** 
     * Set the 'Airline' element value. Query Filters.
     * 
     * @param airline
     */
    public void setAirline(Airline airline) {
        this.airline = airline;
    }

    /** 
     * Get the 'BookingReferences' element value. Existing Booking Reference (e.g. PNR Record Locator). Example: R1A3SK
     * 
     * @return value
     */
    public BookingReferences getQueryBookingReferences() {
        return queryBookingReferences;
    }

    /** 
     * Set the 'BookingReferences' element value. Existing Booking Reference (e.g. PNR Record Locator). Example: R1A3SK
     * 
     * @param queryBookingReferences
     */
    public void setQueryBookingReferences(
            BookingReferences queryBookingReferences) {
        this.queryBookingReferences = queryBookingReferences;
    }

    /** 
     * Get the 'CancelDateRange' element value. Order Cancellation Date Range.
     * 
     * @return value
     */
    public DatePeriodRepType getQueryCancelDateRange() {
        return queryCancelDateRange;
    }

    /** 
     * Set the 'CancelDateRange' element value. Order Cancellation Date Range.
     * 
     * @param queryCancelDateRange
     */
    public void setQueryCancelDateRange(DatePeriodRepType queryCancelDateRange) {
        this.queryCancelDateRange = queryCancelDateRange;
    }

    /** 
     * Get the 'CreateDateRange' element value. Order Creation Date Range.
     * 
     * @return value
     */
    public DatePeriodRepType getQueryCreateDateRange() {
        return queryCreateDateRange;
    }

    /** 
     * Set the 'CreateDateRange' element value. Order Creation Date Range.
     * 
     * @param queryCreateDateRange
     */
    public void setQueryCreateDateRange(DatePeriodRepType queryCreateDateRange) {
        this.queryCreateDateRange = queryCreateDateRange;
    }

    /** 
     * Get the 'Flight' element value. Query Filters.
     * 
     * @return value
     */
    public Flight getFlight() {
        return flight;
    }

    /** 
     * Set the 'Flight' element value. Query Filters.
     * 
     * @param flight
     */
    public void setFlight(Flight flight) {
        this.flight = flight;
    }

    /** 
     * Get the 'Group' element value. Query Filters.
     * 
     * @return value
     */
    public Group getGroup() {
        return group;
    }

    /** 
     * Set the 'Group' element value. Query Filters.
     * 
     * @param group
     */
    public void setGroup(Group group) {
        this.group = group;
    }

    /** 
     * Get the 'Passenger' element value. Query Filters.
     * 
     * @return value
     */
    public Passenger getPassenger() {
        return passenger;
    }

    /** 
     * Set the 'Passenger' element value. Query Filters.
     * 
     * @param passenger
     */
    public void setPassenger(Passenger passenger) {
        this.passenger = passenger;
    }

    /** 
     * Get the 'Payments' element value. Query Filters.
     * 
     * @return value
     */
    public Payments getPayments() {
        return payments;
    }

    /** 
     * Set the 'Payments' element value. Query Filters.
     * 
     * @param payments
     */
    public void setPayments(Payments payments) {
        this.payments = payments;
    }

    /** 
     * Get the 'TicketDocument' element value. Query Filters.
     * 
     * @return value
     */
    public TicketDocument getTicketDocument() {
        return ticketDocument;
    }

    /** 
     * Set the 'TicketDocument' element value. Query Filters.
     * 
     * @param ticketDocument
     */
    public void setTicketDocument(TicketDocument ticketDocument) {
        this.ticketDocument = ticketDocument;
    }

    /** 
     * Get the 'TravelDateRange' element value. Travel Date Range.
     * 
     * @return value
     */
    public DatePeriodRepType getQueryTravelDateRange() {
        return queryTravelDateRange;
    }

    /** 
     * Set the 'TravelDateRange' element value. Travel Date Range.
     * 
     * @param queryTravelDateRange
     */
    public void setQueryTravelDateRange(DatePeriodRepType queryTravelDateRange) {
        this.queryTravelDateRange = queryTravelDateRange;
    }

    /** 
     * Get the 'Service' element value. Query Filters.
     * 
     * @return value
     */
    public Service getService() {
        return service;
    }

    /** 
     * Set the 'Service' element value. Query Filters.
     * 
     * @param service
     */
    public void setService(Service service) {
        this.service = service;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Agency.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Agency" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:AgencyID" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="IATA_Number" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Agency implements Serializable
    {
        private AgencyID agencyID;
        private String name;
        private String IATANumber;

        /** 
         * Get the 'AgencyID' element value.
         * 
         * @return value
         */
        public AgencyID getAgencyID() {
            return agencyID;
        }

        /** 
         * Set the 'AgencyID' element value.
         * 
         * @param agencyID
         */
        public void setAgencyID(AgencyID agencyID) {
            this.agencyID = agencyID;
        }

        /** 
         * Get the 'Name' element value. Agency Seller Name.  Example: Carson Travel
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'Name' element value. Agency Seller Name.  Example: Carson Travel
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }

        /** 
         * Get the 'IATA_Number' element value. Agency Seller IATA number. Example: 98417900
         * 
         * @return value
         */
        public String getIATANumber() {
            return IATANumber;
        }

        /** 
         * Set the 'IATA_Number' element value. Agency Seller IATA number. Example: 98417900
         * 
         * @param IATANumber
         */
        public void setIATANumber(String IATANumber) {
            this.IATANumber = IATANumber;
        }
    }
    /** 
     * Airline.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Airline" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:AirlineID" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Airline implements Serializable
    {
        private AirlineIDType airlineID;
        private String name;

        /** 
         * Get the 'AirlineID' element value.
         * 
         * @return value
         */
        public AirlineIDType getAirlineID() {
            return airlineID;
        }

        /** 
         * Set the 'AirlineID' element value.
         * 
         * @param airlineID
         */
        public void setAirlineID(AirlineIDType airlineID) {
            this.airlineID = airlineID;
        }

        /** 
         * Get the 'Name' element value. Airline Name. Example: British Airways
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'Name' element value. Airline Name. Example: British Airways
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }
    }
    /** 
     * Flight Filters.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Flight" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:FlightNumber" minOccurs="0"/>
     *       &lt;xs:element ref="ns:ClassOfService" minOccurs="0"/>
     *       &lt;xs:element ref="ns:FareBasisCode" minOccurs="0"/>
     *       &lt;xs:element name="Arrival" minOccurs="0">
     *         &lt;!-- Reference to inner class Arrival -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Departure" minOccurs="0">
     *         &lt;!-- Reference to inner class Departure -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="OriginDestination" minOccurs="0">
     *         &lt;!-- Reference to inner class OriginDestination -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Segment" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Segment -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Flight implements Serializable
    {
        private FlightNumber flightNumber;
        private FlightCOSCoreType classOfService;
        private FareBasisCodeType fareBasisCode;
        private Arrival arrival;
        private Departure departure;
        private OriginDestination originDestination;
        private List<Segment> segmentList = new ArrayList<Segment>();

        /** 
         * Get the 'FlightNumber' element value.
         * 
         * @return value
         */
        public FlightNumber getFlightNumber() {
            return flightNumber;
        }

        /** 
         * Set the 'FlightNumber' element value.
         * 
         * @param flightNumber
         */
        public void setFlightNumber(FlightNumber flightNumber) {
            this.flightNumber = flightNumber;
        }

        /** 
         * Get the 'ClassOfService' element value.
         * 
         * @return value
         */
        public FlightCOSCoreType getClassOfService() {
            return classOfService;
        }

        /** 
         * Set the 'ClassOfService' element value.
         * 
         * @param classOfService
         */
        public void setClassOfService(FlightCOSCoreType classOfService) {
            this.classOfService = classOfService;
        }

        /** 
         * Get the 'FareBasisCode' element value.
         * 
         * @return value
         */
        public FareBasisCodeType getFareBasisCode() {
            return fareBasisCode;
        }

        /** 
         * Set the 'FareBasisCode' element value.
         * 
         * @param fareBasisCode
         */
        public void setFareBasisCode(FareBasisCodeType fareBasisCode) {
            this.fareBasisCode = fareBasisCode;
        }

        /** 
         * Get the 'Arrival' element value.
         * 
         * @return value
         */
        public Arrival getArrival() {
            return arrival;
        }

        /** 
         * Set the 'Arrival' element value.
         * 
         * @param arrival
         */
        public void setArrival(Arrival arrival) {
            this.arrival = arrival;
        }

        /** 
         * Get the 'Departure' element value.
         * 
         * @return value
         */
        public Departure getDeparture() {
            return departure;
        }

        /** 
         * Set the 'Departure' element value.
         * 
         * @param departure
         */
        public void setDeparture(Departure departure) {
            this.departure = departure;
        }

        /** 
         * Get the 'OriginDestination' element value.
         * 
         * @return value
         */
        public OriginDestination getOriginDestination() {
            return originDestination;
        }

        /** 
         * Set the 'OriginDestination' element value.
         * 
         * @param originDestination
         */
        public void setOriginDestination(OriginDestination originDestination) {
            this.originDestination = originDestination;
        }

        /** 
         * Get the list of 'Segment' element items.
         * 
         * @return list
         */
        public List<Segment> getSegmentList() {
            return segmentList;
        }

        /** 
         * Set the list of 'Segment' element items.
         * 
         * @param list
         */
        public void setSegmentList(List<Segment> list) {
            segmentList = list;
        }
        /** 
         * Arrival Airport.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Arrival" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="AirportCode">
         *         &lt;xs:complexType>
         *           &lt;xs:simpleContent>
         *             &lt;xs:extension base="xs:string">
         *               &lt;xs:attributeGroup ref="ns:RadiusAttrGroup"/>
         *             &lt;/xs:extension>
         *           &lt;/xs:simpleContent>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:date" name="Date"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Arrival implements Serializable
        {
            private String airportCodeString;
            private RadiusAttrGroup airportCodeRadiusAttrGroup;
            private Date date;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getAirportCodeString() {
                return airportCodeString;
            }

            /** 
             * Set the extension value.
             * 
             * @param airportCodeString
             */
            public void setAirportCodeString(String airportCodeString) {
                this.airportCodeString = airportCodeString;
            }

            /** 
             * Get the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
             * 
             * @return value
             */
            public RadiusAttrGroup getAirportCodeRadiusAttrGroup() {
                return airportCodeRadiusAttrGroup;
            }

            /** 
             * Set the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
             * 
             * @param airportCodeRadiusAttrGroup
             */
            public void setAirportCodeRadiusAttrGroup(
                    RadiusAttrGroup airportCodeRadiusAttrGroup) {
                this.airportCodeRadiusAttrGroup = airportCodeRadiusAttrGroup;
            }

            /** 
             * Get the 'Date' element value. Arrival date. Example: 2017-01-14

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @return value
             */
            public Date getDate() {
                return date;
            }

            /** 
             * Set the 'Date' element value. Arrival date. Example: 2017-01-14

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @param date
             */
            public void setDate(Date date) {
                this.date = date;
            }
        }
        /** 
         * Departure Airport.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Departure" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="AirportCode">
         *         &lt;xs:complexType>
         *           &lt;xs:simpleContent>
         *             &lt;xs:extension base="xs:string">
         *               &lt;xs:attributeGroup ref="ns:RadiusAttrGroup"/>
         *             &lt;/xs:extension>
         *           &lt;/xs:simpleContent>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:date" name="Date"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Departure implements Serializable
        {
            private String airportCodeString;
            private RadiusAttrGroup airportCodeRadiusAttrGroup;
            private Date date;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getAirportCodeString() {
                return airportCodeString;
            }

            /** 
             * Set the extension value.
             * 
             * @param airportCodeString
             */
            public void setAirportCodeString(String airportCodeString) {
                this.airportCodeString = airportCodeString;
            }

            /** 
             * Get the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
             * 
             * @return value
             */
            public RadiusAttrGroup getAirportCodeRadiusAttrGroup() {
                return airportCodeRadiusAttrGroup;
            }

            /** 
             * Set the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
             * 
             * @param airportCodeRadiusAttrGroup
             */
            public void setAirportCodeRadiusAttrGroup(
                    RadiusAttrGroup airportCodeRadiusAttrGroup) {
                this.airportCodeRadiusAttrGroup = airportCodeRadiusAttrGroup;
            }

            /** 
             * Get the 'Date' element value. Departure date. Example: 2017-01-13

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @return value
             */
            public Date getDate() {
                return date;
            }

            /** 
             * Set the 'Date' element value. Departure date. Example: 2017-01-13

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @param date
             */
            public void setDate(Date date) {
                this.date = date;
            }
        }
        /** 
         * Flight origin/ destination information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestination" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Departure">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element name="AirportCode">
         *               &lt;xs:complexType>
         *                 &lt;xs:simpleContent>
         *                   &lt;xs:extension base="xs:string">
         *                     &lt;xs:attributeGroup ref="ns:RadiusAttrGroup"/>
         *                   &lt;/xs:extension>
         *                 &lt;/xs:simpleContent>
         *               &lt;/xs:complexType>
         *             &lt;/xs:element>
         *             &lt;xs:element type="xs:date" name="Date"/>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="Arrival">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element name="AirportCode">
         *               &lt;xs:complexType>
         *                 &lt;xs:simpleContent>
         *                   &lt;xs:extension base="xs:string">
         *                     &lt;xs:attributeGroup ref="ns:RadiusAttrGroup"/>
         *                   &lt;/xs:extension>
         *                 &lt;/xs:simpleContent>
         *               &lt;/xs:complexType>
         *             &lt;/xs:element>
         *             &lt;xs:element type="xs:date" name="Date"/>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class OriginDestination implements Serializable
        {
            private String departureAirportCodeString;
            private RadiusAttrGroup departureAirportCodeRadiusAttrGroup;
            private Date departureDate;
            private String arrivalAirportCodeString;
            private RadiusAttrGroup arrivalAirportCodeRadiusAttrGroup;
            private Date arrivalDate;
            private String refs;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getDepartureAirportCodeString() {
                return departureAirportCodeString;
            }

            /** 
             * Set the extension value.
             * 
             * @param departureAirportCodeString
             */
            public void setDepartureAirportCodeString(
                    String departureAirportCodeString) {
                this.departureAirportCodeString = departureAirportCodeString;
            }

            /** 
             * Get the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
             * 
             * @return value
             */
            public RadiusAttrGroup getDepartureAirportCodeRadiusAttrGroup() {
                return departureAirportCodeRadiusAttrGroup;
            }

            /** 
             * Set the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
             * 
             * @param departureAirportCodeRadiusAttrGroup
             */
            public void setDepartureAirportCodeRadiusAttrGroup(
                    RadiusAttrGroup departureAirportCodeRadiusAttrGroup) {
                this.departureAirportCodeRadiusAttrGroup = departureAirportCodeRadiusAttrGroup;
            }

            /** 
             * Get the 'Date' element value. Departure date. Example: 2017-01-13

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @return value
             */
            public Date getDepartureDate() {
                return departureDate;
            }

            /** 
             * Set the 'Date' element value. Departure date. Example: 2017-01-13

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @param departureDate
             */
            public void setDepartureDate(Date departureDate) {
                this.departureDate = departureDate;
            }

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getArrivalAirportCodeString() {
                return arrivalAirportCodeString;
            }

            /** 
             * Set the extension value.
             * 
             * @param arrivalAirportCodeString
             */
            public void setArrivalAirportCodeString(
                    String arrivalAirportCodeString) {
                this.arrivalAirportCodeString = arrivalAirportCodeString;
            }

            /** 
             * Get the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
             * 
             * @return value
             */
            public RadiusAttrGroup getArrivalAirportCodeRadiusAttrGroup() {
                return arrivalAirportCodeRadiusAttrGroup;
            }

            /** 
             * Set the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
             * 
             * @param arrivalAirportCodeRadiusAttrGroup
             */
            public void setArrivalAirportCodeRadiusAttrGroup(
                    RadiusAttrGroup arrivalAirportCodeRadiusAttrGroup) {
                this.arrivalAirportCodeRadiusAttrGroup = arrivalAirportCodeRadiusAttrGroup;
            }

            /** 
             * Get the 'Date' element value. Arrival date. Example: 2017-01-14

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @return value
             */
            public Date getArrivalDate() {
                return arrivalDate;
            }

            /** 
             * Set the 'Date' element value. Arrival date. Example: 2017-01-14

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @param arrivalDate
             */
            public void setArrivalDate(Date arrivalDate) {
                this.arrivalDate = arrivalDate;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }
        }
        /** 
         * Flight segment information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Segment" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Departure">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element name="AirportCode">
         *               &lt;xs:complexType>
         *                 &lt;xs:simpleContent>
         *                   &lt;xs:extension base="xs:string">
         *                     &lt;xs:attributeGroup ref="ns:RadiusAttrGroup"/>
         *                   &lt;/xs:extension>
         *                 &lt;/xs:simpleContent>
         *               &lt;/xs:complexType>
         *             &lt;/xs:element>
         *             &lt;xs:element type="xs:date" name="Date"/>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="Arrival">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element name="AirportCode">
         *               &lt;xs:complexType>
         *                 &lt;xs:simpleContent>
         *                   &lt;xs:extension base="xs:string">
         *                     &lt;xs:attributeGroup ref="ns:RadiusAttrGroup"/>
         *                   &lt;/xs:extension>
         *                 &lt;/xs:simpleContent>
         *               &lt;/xs:complexType>
         *             &lt;/xs:element>
         *             &lt;xs:element type="xs:date" name="Date"/>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class Segment implements Serializable
        {
            private String departureAirportCodeString;
            private RadiusAttrGroup departureAirportCodeRadiusAttrGroup;
            private Date departureDate;
            private String arrivalAirportCodeString;
            private RadiusAttrGroup arrivalAirportCodeRadiusAttrGroup;
            private Date arrivalDate;
            private String refs;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getDepartureAirportCodeString() {
                return departureAirportCodeString;
            }

            /** 
             * Set the extension value.
             * 
             * @param departureAirportCodeString
             */
            public void setDepartureAirportCodeString(
                    String departureAirportCodeString) {
                this.departureAirportCodeString = departureAirportCodeString;
            }

            /** 
             * Get the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
             * 
             * @return value
             */
            public RadiusAttrGroup getDepartureAirportCodeRadiusAttrGroup() {
                return departureAirportCodeRadiusAttrGroup;
            }

            /** 
             * Set the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
             * 
             * @param departureAirportCodeRadiusAttrGroup
             */
            public void setDepartureAirportCodeRadiusAttrGroup(
                    RadiusAttrGroup departureAirportCodeRadiusAttrGroup) {
                this.departureAirportCodeRadiusAttrGroup = departureAirportCodeRadiusAttrGroup;
            }

            /** 
             * Get the 'Date' element value. Departure date. Example: 2017-01-13

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @return value
             */
            public Date getDepartureDate() {
                return departureDate;
            }

            /** 
             * Set the 'Date' element value. Departure date. Example: 2017-01-13

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @param departureDate
             */
            public void setDepartureDate(Date departureDate) {
                this.departureDate = departureDate;
            }

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getArrivalAirportCodeString() {
                return arrivalAirportCodeString;
            }

            /** 
             * Set the extension value.
             * 
             * @param arrivalAirportCodeString
             */
            public void setArrivalAirportCodeString(
                    String arrivalAirportCodeString) {
                this.arrivalAirportCodeString = arrivalAirportCodeString;
            }

            /** 
             * Get the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
             * 
             * @return value
             */
            public RadiusAttrGroup getArrivalAirportCodeRadiusAttrGroup() {
                return arrivalAirportCodeRadiusAttrGroup;
            }

            /** 
             * Set the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
             * 
             * @param arrivalAirportCodeRadiusAttrGroup
             */
            public void setArrivalAirportCodeRadiusAttrGroup(
                    RadiusAttrGroup arrivalAirportCodeRadiusAttrGroup) {
                this.arrivalAirportCodeRadiusAttrGroup = arrivalAirportCodeRadiusAttrGroup;
            }

            /** 
             * Get the 'Date' element value. Arrival date. Example: 2017-01-14

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @return value
             */
            public Date getArrivalDate() {
                return arrivalDate;
            }

            /** 
             * Set the 'Date' element value. Arrival date. Example: 2017-01-14

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @param arrivalDate
             */
            public void setArrivalDate(Date arrivalDate) {
                this.arrivalDate = arrivalDate;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }
        }
    }
    /** 
     * Group Information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Group" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="TotalPartySize" minOccurs="0"/>
     *       &lt;xs:element ref="ns:Contacts" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Group implements Serializable
    {
        private String name;
        private String totalPartySize;
        private Contacts contacts;

        /** 
         * Get the 'Name' element value. Group Name. Example: ABC Tour Club
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'Name' element value. Group Name. Example: ABC Tour Club
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }

        /** 
         * Get the 'TotalPartySize' element value. The Complete Party (TCP) indicating total party size. Example: 12
         * 
         * @return value
         */
        public String getTotalPartySize() {
            return totalPartySize;
        }

        /** 
         * Set the 'TotalPartySize' element value. The Complete Party (TCP) indicating total party size. Example: 12
         * 
         * @param totalPartySize
         */
        public void setTotalPartySize(String totalPartySize) {
            this.totalPartySize = totalPartySize;
        }

        /** 
         * Get the 'Contacts' element value.
         * 
         * @return value
         */
        public Contacts getContacts() {
            return contacts;
        }

        /** 
         * Set the 'Contacts' element value.
         * 
         * @param contacts
         */
        public void setContacts(Contacts contacts) {
            this.contacts = contacts;
        }
    }
    /** 
     * Passenger information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passenger" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Individual" minOccurs="0">
     *         &lt;!-- Reference to inner class Individual -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="ProfileID" minOccurs="0"/>
     *       &lt;xs:element name="LoyaltyProgramAccount" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class LoyaltyProgramAccount -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:FOID" name="FOID" minOccurs="0"/>
     *       &lt;xs:element type="ns:IdentityDocumentType" name="IdentityDocument" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element name="ContactInformation" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class ContactInformation -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Passenger implements Serializable
    {
        private Individual individual;
        private String profileID;
        private List<LoyaltyProgramAccount> loyaltyProgramAccountList = new ArrayList<LoyaltyProgramAccount>();
        private FOID FOID;
        private List<IdentityDocumentType> identityDocumentList = new ArrayList<IdentityDocumentType>();
        private List<ContactInformation> contactInformationList = new ArrayList<ContactInformation>();

        /** 
         * Get the 'Individual' element value.
         * 
         * @return value
         */
        public Individual getIndividual() {
            return individual;
        }

        /** 
         * Set the 'Individual' element value.
         * 
         * @param individual
         */
        public void setIndividual(Individual individual) {
            this.individual = individual;
        }

        /** 
         * Get the 'ProfileID' element value. Passenger Profile ID
         * 
         * @return value
         */
        public String getProfileID() {
            return profileID;
        }

        /** 
         * Set the 'ProfileID' element value. Passenger Profile ID
         * 
         * @param profileID
         */
        public void setProfileID(String profileID) {
            this.profileID = profileID;
        }

        /** 
         * Get the list of 'LoyaltyProgramAccount' element items.
         * 
         * @return list
         */
        public List<LoyaltyProgramAccount> getLoyaltyProgramAccountList() {
            return loyaltyProgramAccountList;
        }

        /** 
         * Set the list of 'LoyaltyProgramAccount' element items.
         * 
         * @param list
         */
        public void setLoyaltyProgramAccountList(
                List<LoyaltyProgramAccount> list) {
            loyaltyProgramAccountList = list;
        }

        /** 
         * Get the 'FOID' element value. Form of identification.  Typically used to identify that the passenger is who he says he is.

        This is the type of FOID as defined in AIRIMP (FF Number, Credit Card Number, etc.).

         * 
         * @return value
         */
        public FOID getFOID() {
            return FOID;
        }

        /** 
         * Set the 'FOID' element value. Form of identification.  Typically used to identify that the passenger is who he says he is.

        This is the type of FOID as defined in AIRIMP (FF Number, Credit Card Number, etc.).

         * 
         * @param FOID
         */
        public void setFOID(FOID FOID) {
            this.FOID = FOID;
        }

        /** 
         * Get the list of 'IdentityDocument' element items. Any document which may be used to identify a person or verify aspects of a person's personal identity.
         * 
         * @return list
         */
        public List<IdentityDocumentType> getIdentityDocumentList() {
            return identityDocumentList;
        }

        /** 
         * Set the list of 'IdentityDocument' element items. Any document which may be used to identify a person or verify aspects of a person's personal identity.
         * 
         * @param list
         */
        public void setIdentityDocumentList(List<IdentityDocumentType> list) {
            identityDocumentList = list;
        }

        /** 
         * Get the list of 'ContactInformation' element items.
         * 
         * @return list
         */
        public List<ContactInformation> getContactInformationList() {
            return contactInformationList;
        }

        /** 
         * Set the list of 'ContactInformation' element items.
         * 
         * @param list
         */
        public void setContactInformationList(List<ContactInformation> list) {
            contactInformationList = list;
        }
        /** 
         * A single human being as distinct from a group, class, or family.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Individual" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="GivenName" minOccurs="0" maxOccurs="5"/>
         *       &lt;xs:element type="xs:string" name="MiddleName" minOccurs="0" maxOccurs="3"/>
         *       &lt;xs:element type="xs:string" name="Surname"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Individual implements Serializable
        {
            private List<String> givenNameList = new ArrayList<String>();
            private List<String> middleNameList = new ArrayList<String>();
            private String surname;

            /** 
             * Get the list of 'GivenName' element items. Individual's first or given name. Example: JOHN.
             * 
             * @return list
             */
            public List<String> getGivenNameList() {
                return givenNameList;
            }

            /** 
             * Set the list of 'GivenName' element items. Individual's first or given name. Example: JOHN.
             * 
             * @param list
             */
            public void setGivenNameList(List<String> list) {
                givenNameList = list;
            }

            /** 
             * Get the list of 'MiddleName' element items. Individual's middle name or initial.  Examples: G, GEORGE
             * 
             * @return list
             */
            public List<String> getMiddleNameList() {
                return middleNameList;
            }

            /** 
             * Set the list of 'MiddleName' element items. Individual's middle name or initial.  Examples: G, GEORGE
             * 
             * @param list
             */
            public void setMiddleNameList(List<String> list) {
                middleNameList = list;
            }

            /** 
             * Get the 'Surname' element value. Individual's family name, last name. Example: SMITH.
             * 
             * @return value
             */
            public String getSurname() {
                return surname;
            }

            /** 
             * Set the 'Surname' element value. Individual's family name, last name. Example: SMITH.
             * 
             * @param surname
             */
            public void setSurname(String surname) {
                this.surname = surname;
            }
        }
        /** 
         * The account set up for a customer within a rewards program which holds funds on behalf of that customer.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LoyaltyProgramAccount" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:AirlineTypeAIDM" name="Airline" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="ProgramName" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="ProgramCode" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="AccountNumber" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="SignInID" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class LoyaltyProgramAccount implements Serializable
        {
            private AirlineTypeAIDM airline;
            private String programName;
            private String programCode;
            private String accountNumber;
            private String signInID;

            /** 
             * Get the 'Airline' element value. An enterprise operating aircraft for commercial purposes
             * 
             * @return value
             */
            public AirlineTypeAIDM getAirline() {
                return airline;
            }

            /** 
             * Set the 'Airline' element value. An enterprise operating aircraft for commercial purposes
             * 
             * @param airline
             */
            public void setAirline(AirlineTypeAIDM airline) {
                this.airline = airline;
            }

            /** 
             * Get the 'ProgramName' element value. Loyalty Program Name. Example: Miles and More
             * 
             * @return value
             */
            public String getProgramName() {
                return programName;
            }

            /** 
             * Set the 'ProgramName' element value. Loyalty Program Name. Example: Miles and More
             * 
             * @param programName
             */
            public void setProgramName(String programName) {
                this.programName = programName;
            }

            /** 
             * Get the 'ProgramCode' element value. Loyalty Program ID: Example: MAM
             * 
             * @return value
             */
            public String getProgramCode() {
                return programCode;
            }

            /** 
             * Set the 'ProgramCode' element value. Loyalty Program ID: Example: MAM
             * 
             * @param programCode
             */
            public void setProgramCode(String programCode) {
                this.programCode = programCode;
            }

            /** 
             * Get the 'AccountNumber' element value. Loyalty Program account number. Example: ABC123456
             * 
             * @return value
             */
            public String getAccountNumber() {
                return accountNumber;
            }

            /** 
             * Set the 'AccountNumber' element value. Loyalty Program account number. Example: ABC123456
             * 
             * @param accountNumber
             */
            public void setAccountNumber(String accountNumber) {
                this.accountNumber = accountNumber;
            }

            /** 
             * Get the 'SignInID' element value. Loyalty Program sign-in ID (or username).
             * 
             * @return value
             */
            public String getSignInID() {
                return signInID;
            }

            /** 
             * Set the 'SignInID' element value. Loyalty Program sign-in ID (or username).
             * 
             * @param signInID
             */
            public void setSignInID(String signInID) {
                this.signInID = signInID;
            }
        }
        /** 
         * Contact Information, within the context of one message.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactInformation" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="ContactType" minOccurs="0"/>
         *       &lt;xs:element type="ns:PostalAddressType" name="PostalAddress" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="ns:EmailAddressType" name="EmailAddress" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="ns:PhoneTypeAIDM" name="Phone" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="ns:OtherAddressType" name="OtherAddress" minOccurs="0" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ContactInformation implements Serializable
        {
            private String contactType;
            private List<PostalAddressType> postalAddressList = new ArrayList<PostalAddressType>();
            private List<EmailAddressType> emailAddressList = new ArrayList<EmailAddressType>();
            private List<PhoneTypeAIDM> phoneList = new ArrayList<PhoneTypeAIDM>();
            private List<OtherAddressType> otherAddressList = new ArrayList<OtherAddressType>();

            /** 
             * Get the 'ContactType' element value. Classification for a particular set of contact information (e.g. Primary, Payment, etc.)
             * 
             * @return value
             */
            public String getContactType() {
                return contactType;
            }

            /** 
             * Set the 'ContactType' element value. Classification for a particular set of contact information (e.g. Primary, Payment, etc.)
             * 
             * @param contactType
             */
            public void setContactType(String contactType) {
                this.contactType = contactType;
            }

            /** 
             * Get the list of 'PostalAddress' element items. The address used for postal service. Examples are post office boxes address, postal physical address, postal code
             * 
             * @return list
             */
            public List<PostalAddressType> getPostalAddressList() {
                return postalAddressList;
            }

            /** 
             * Set the list of 'PostalAddress' element items. The address used for postal service. Examples are post office boxes address, postal physical address, postal code
             * 
             * @param list
             */
            public void setPostalAddressList(List<PostalAddressType> list) {
                postalAddressList = list;
            }

            /** 
             * Get the list of 'EmailAddress' element items. The email address which should be used for contact purposes.
             * 
             * @return list
             */
            public List<EmailAddressType> getEmailAddressList() {
                return emailAddressList;
            }

            /** 
             * Set the list of 'EmailAddress' element items. The email address which should be used for contact purposes.
             * 
             * @param list
             */
            public void setEmailAddressList(List<EmailAddressType> list) {
                emailAddressList = list;
            }

            /** 
             * Get the list of 'Phone' element items. A telephone number is a sequence of digits assigned to a fixed-line telephone subscriber station connected to a telephone line or to a wireless electronic telephony device, such as a radio telephone or a mobile telephone, or to other devices for data transmission via the public switched telephone network (PSTN) or other private networks.

             * 
             * @return list
             */
            public List<PhoneTypeAIDM> getPhoneList() {
                return phoneList;
            }

            /** 
             * Set the list of 'Phone' element items. A telephone number is a sequence of digits assigned to a fixed-line telephone subscriber station connected to a telephone line or to a wireless electronic telephony device, such as a radio telephone or a mobile telephone, or to other devices for data transmission via the public switched telephone network (PSTN) or other private networks.

             * 
             * @param list
             */
            public void setPhoneList(List<PhoneTypeAIDM> list) {
                phoneList = list;
            }

            /** 
             * Get the list of 'OtherAddress' element items. Other Contact Method information.   (i.e. social media handle, website, etc.)
             * 
             * @return list
             */
            public List<OtherAddressType> getOtherAddressList() {
                return otherAddressList;
            }

            /** 
             * Set the list of 'OtherAddress' element items. Other Contact Method information.   (i.e. social media handle, website, etc.)
             * 
             * @param list
             */
            public void setOtherAddressList(List<OtherAddressType> list) {
                otherAddressList = list;
            }
        }
    }
    /** 
     * Payment information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payments" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:CurrencyAmountOptType" name="Amount" minOccurs="0"/>
     *       &lt;xs:element name="Method" minOccurs="0">
     *         &lt;!-- Reference to inner class Method -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Status" minOccurs="0">
     *         &lt;!-- Reference to inner class Status -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Payments implements Serializable
    {
        private CurrencyAmountOptType amount;
        private Method method;
        private Status status;

        /** 
         * Get the 'Amount' element value. The amount for this form of payment. Example: 300 USD
         * 
         * @return value
         */
        public CurrencyAmountOptType getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' element value. The amount for this form of payment. Example: 300 USD
         * 
         * @param amount
         */
        public void setAmount(CurrencyAmountOptType amount) {
            this.amount = amount;
        }

        /** 
         * Get the 'Method' element value.
         * 
         * @return value
         */
        public Method getMethod() {
            return method;
        }

        /** 
         * Set the 'Method' element value.
         * 
         * @param method
         */
        public void setMethod(Method method) {
            this.method = method;
        }

        /** 
         * Get the 'Status' element value.
         * 
         * @return value
         */
        public Status getStatus() {
            return status;
        }

        /** 
         * Set the 'Status' element value.
         * 
         * @param status
         */
        public void setStatus(Status status) {
            this.status = status;
        }
        /** 
         * Payment Method detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Method" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="CardCode" minOccurs="0"/>
         *       &lt;xs:element name="MaskedCardNumber" minOccurs="0">
         *         &lt;!-- Reference to inner class MaskedCardNumber -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="TokenizedCardNumber" minOccurs="0"/>
         *       &lt;xs:element name="EffectiveExpireDate" minOccurs="0">
         *         &lt;!-- Reference to inner class EffectiveExpireDate -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="CardHolderName" minOccurs="0">
         *         &lt;!-- Reference to inner class CardHolderName -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class Method implements Serializable
        {
            private String cardCode;
            private MaskedCardNumber maskedCardNumber;
            private String tokenizedCardNumber;
            private EffectiveExpireDate effectiveExpireDate;
            private CardHolderName cardHolderName;
            private String refs;

            /** 
             * Get the 'CardCode' element value. Credit card issuer code. Example: MC

            Note: This is the 2 character code of the credit card issuer.
             * 
             * @return value
             */
            public String getCardCode() {
                return cardCode;
            }

            /** 
             * Set the 'CardCode' element value. Credit card issuer code. Example: MC

            Note: This is the 2 character code of the credit card issuer.
             * 
             * @param cardCode
             */
            public void setCardCode(String cardCode) {
                this.cardCode = cardCode;
            }

            /** 
             * Get the 'MaskedCardNumber' element value.
             * 
             * @return value
             */
            public MaskedCardNumber getMaskedCardNumber() {
                return maskedCardNumber;
            }

            /** 
             * Set the 'MaskedCardNumber' element value.
             * 
             * @param maskedCardNumber
             */
            public void setMaskedCardNumber(MaskedCardNumber maskedCardNumber) {
                this.maskedCardNumber = maskedCardNumber;
            }

            /** 
             * Get the 'TokenizedCardNumber' element value. Tokenized card number.

            Note: This capability may not be supported by all EDIST-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of this capability is not dictated by this specification.
             * 
             * @return value
             */
            public String getTokenizedCardNumber() {
                return tokenizedCardNumber;
            }

            /** 
             * Set the 'TokenizedCardNumber' element value. Tokenized card number.

            Note: This capability may not be supported by all EDIST-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of this capability is not dictated by this specification.
             * 
             * @param tokenizedCardNumber
             */
            public void setTokenizedCardNumber(String tokenizedCardNumber) {
                this.tokenizedCardNumber = tokenizedCardNumber;
            }

            /** 
             * Get the 'EffectiveExpireDate' element value.
             * 
             * @return value
             */
            public EffectiveExpireDate getEffectiveExpireDate() {
                return effectiveExpireDate;
            }

            /** 
             * Set the 'EffectiveExpireDate' element value.
             * 
             * @param effectiveExpireDate
             */
            public void setEffectiveExpireDate(
                    EffectiveExpireDate effectiveExpireDate) {
                this.effectiveExpireDate = effectiveExpireDate;
            }

            /** 
             * Get the 'CardHolderName' element value.
             * 
             * @return value
             */
            public CardHolderName getCardHolderName() {
                return cardHolderName;
            }

            /** 
             * Set the 'CardHolderName' element value.
             * 
             * @param cardHolderName
             */
            public void setCardHolderName(CardHolderName cardHolderName) {
                this.cardHolderName = cardHolderName;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }
            /** 
             * Concealed credit card number, Example: xxxxxxxxxxxx9922
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MaskedCardNumber" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * 
             * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
             *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
             * &lt;/xs:attributeGroup>
             * </pre>
             */
            public static class MaskedCardNumber implements Serializable
            {
                private String string;
                private String refs;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @return value
                 */
                public String getRefs() {
                    return refs;
                }

                /** 
                 * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @param refs
                 */
                public void setRefs(String refs) {
                    this.refs = refs;
                }
            }
            /** 
             * Payment Card Effective and/ or Expiration date(s).
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EffectiveExpireDate" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Effective" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="Expiration" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * 
             * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
             *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
             * &lt;/xs:attributeGroup>
             * </pre>
             */
            public static class EffectiveExpireDate implements Serializable
            {
                private String effective;
                private String expiration;
                private String refs;

                /** 
                 * Get the 'Effective' element value. Payment Card Effective Date. Example: 0116
                 * 
                 * @return value
                 */
                public String getEffective() {
                    return effective;
                }

                /** 
                 * Set the 'Effective' element value. Payment Card Effective Date. Example: 0116
                 * 
                 * @param effective
                 */
                public void setEffective(String effective) {
                    this.effective = effective;
                }

                /** 
                 * Get the 'Expiration' element value. Payment Card Expiration Date. Example: 0119
                 * 
                 * @return value
                 */
                public String getExpiration() {
                    return expiration;
                }

                /** 
                 * Set the 'Expiration' element value. Payment Card Expiration Date. Example: 0119
                 * 
                 * @param expiration
                 */
                public void setExpiration(String expiration) {
                    this.expiration = expiration;
                }

                /** 
                 * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @return value
                 */
                public String getRefs() {
                    return refs;
                }

                /** 
                 * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @param refs
                 */
                public void setRefs(String refs) {
                    this.refs = refs;
                }
            }
            /** 
             * Name of credit card holder. Example: JOHN SMITH
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CardHolderName" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * 
             * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
             *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
             * &lt;/xs:attributeGroup>
             * </pre>
             */
            public static class CardHolderName implements Serializable
            {
                private String string;
                private String refs;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @return value
                 */
                public String getRefs() {
                    return refs;
                }

                /** 
                 * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @param refs
                 */
                public void setRefs(String refs) {
                    this.refs = refs;
                }
            }
        }
        /** 
         * Payment Status. Examples: Canceled, Complete, Failed
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Status" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="ns:PaymentStatusListType">
         *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Status implements Serializable
        {
            private PaymentStatusListType paymentStatusListType;
            private String context;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public PaymentStatusListType getPaymentStatusListType() {
                return paymentStatusListType;
            }

            /** 
             * Set the extension value.
             * 
             * @param paymentStatusListType
             */
            public void setPaymentStatusListType(
                    PaymentStatusListType paymentStatusListType) {
                this.paymentStatusListType = paymentStatusListType;
            }

            /** 
             * Get the 'Context' attribute value. Payment Status Context.
             * 
             * @return value
             */
            public String getContext() {
                return context;
            }

            /** 
             * Set the 'Context' attribute value. Payment Status Context.
             * 
             * @param context
             */
            public void setContext(String context) {
                this.context = context;
            }
        }
    }
    /** 
     * Ticket document numbers.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketDocument" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:DatePeriodRepType" name="IssueDateRange" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="TicketDocNbr" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="TicketingLocation" minOccurs="0"/>
     *       &lt;xs:element type="xs:integer" name="CouponNumber" minOccurs="0"/>
     *       &lt;xs:element name="Status" minOccurs="0">
     *         &lt;!-- Reference to inner class Status -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TicketDocument implements Serializable
    {
        private DatePeriodRepType issueDateRange;
        private String ticketDocNbr;
        private String ticketingLocation;
        private BigInteger couponNumber;
        private Status status;

        /** 
         * Get the 'IssueDateRange' element value. Issue Date Range.
         * 
         * @return value
         */
        public DatePeriodRepType getIssueDateRange() {
            return issueDateRange;
        }

        /** 
         * Set the 'IssueDateRange' element value. Issue Date Range.
         * 
         * @param issueDateRange
         */
        public void setIssueDateRange(DatePeriodRepType issueDateRange) {
            this.issueDateRange = issueDateRange;
        }

        /** 
         * Get the 'TicketDocNbr' element value. Coupon Document Number.

        Note: This is the document number comprised of the airline code, form code, and serial number.
         * 
         * @return value
         */
        public String getTicketDocNbr() {
            return ticketDocNbr;
        }

        /** 
         * Set the 'TicketDocNbr' element value. Coupon Document Number.

        Note: This is the document number comprised of the airline code, form code, and serial number.
         * 
         * @param ticketDocNbr
         */
        public void setTicketDocNbr(String ticketDocNbr) {
            this.ticketDocNbr = ticketDocNbr;
        }

        /** 
         * Get the 'TicketingLocation' element value. Airport or City Code. Example: JFK

        Encoding Scheme: IATA/ A4A (three character) Airport or City Code
         * 
         * @return value
         */
        public String getTicketingLocation() {
            return ticketingLocation;
        }

        /** 
         * Set the 'TicketingLocation' element value. Airport or City Code. Example: JFK

        Encoding Scheme: IATA/ A4A (three character) Airport or City Code
         * 
         * @param ticketingLocation
         */
        public void setTicketingLocation(String ticketingLocation) {
            this.ticketingLocation = ticketingLocation;
        }

        /** 
         * Get the 'CouponNumber' element value. Applicable coupon number. Example: 1234
         * 
         * @return value
         */
        public BigInteger getCouponNumber() {
            return couponNumber;
        }

        /** 
         * Set the 'CouponNumber' element value. Applicable coupon number. Example: 1234
         * 
         * @param couponNumber
         */
        public void setCouponNumber(BigInteger couponNumber) {
            this.couponNumber = couponNumber;
        }

        /** 
         * Get the 'Status' element value.
         * 
         * @return value
         */
        public Status getStatus() {
            return status;
        }

        /** 
         * Set the 'Status' element value.
         * 
         * @param status
         */
        public void setStatus(Status status) {
            this.status = status;
        }
        /** 
         * Ticketing Status. Examples: Requested, Ticketed, Other
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Status" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="ns:TicketDesigAppListType">
         *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Status implements Serializable
        {
            private TicketDesigAppListType ticketDesigAppListType;
            private String context;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public TicketDesigAppListType getTicketDesigAppListType() {
                return ticketDesigAppListType;
            }

            /** 
             * Set the extension value.
             * 
             * @param ticketDesigAppListType
             */
            public void setTicketDesigAppListType(
                    TicketDesigAppListType ticketDesigAppListType) {
                this.ticketDesigAppListType = ticketDesigAppListType;
            }

            /** 
             * Get the 'Context' attribute value. Context.
             * 
             * @return value
             */
            public String getContext() {
                return context;
            }

            /** 
             * Set the 'Context' attribute value. Context.
             * 
             * @param context
             */
            public void setContext(String context) {
                this.context = context;
            }
        }
    }
    /** 
     * Service information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Service" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:ServiceID" minOccurs="0"/>
     *       &lt;xs:element ref="ns:Description" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Service implements Serializable
    {
        private ServiceIDType serviceID;
        private Description description;

        /** 
         * Get the 'ServiceID' element value.
         * 
         * @return value
         */
        public ServiceIDType getServiceID() {
            return serviceID;
        }

        /** 
         * Set the 'ServiceID' element value.
         * 
         * @param serviceID
         */
        public void setServiceID(ServiceIDType serviceID) {
            this.serviceID = serviceID;
        }

        /** 
         * Get the 'Description' element value.
         * 
         * @return value
         */
        public Description getDescription() {
            return description;
        }

        /** 
         * Set the 'Description' element value.
         * 
         * @param description
         */
        public void setDescription(Description description) {
            this.description = description;
        }
    }
}
