
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * The OrderList transaction set retrieves a list of Orders that match one or more search criteria.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderListRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:choice>
 *         &lt;xs:sequence>
 *           &lt;xs:element type="ns:SuccessType" name="Success"/>
 *           &lt;xs:element type="ns:WarningsType" name="Warnings" minOccurs="0"/>
 *           &lt;xs:element name="Response">
 *             &lt;xs:complexType>
 *               &lt;xs:sequence>
 *                 &lt;xs:element ref="ns:OrderListProcessing" minOccurs="0"/>
 *                 &lt;xs:element name="Orders" minOccurs="0">
 *                   &lt;!-- Reference to inner class Orders -->
 *                 &lt;/xs:element>
 *               &lt;/xs:sequence>
 *             &lt;/xs:complexType>
 *           &lt;/xs:element>
 *         &lt;/xs:sequence>
 *         &lt;xs:element ref="ns:Errors"/>
 *       &lt;/xs:choice>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OrderListRS implements Serializable
{
    private MsgDocumentType document;
    private int choiceSelect = -1;
    private static final int SUCCESS_CHOICE = 0;
    private static final int ERRORS_CHOICE = 1;
    private SuccessType success;
    private WarningsType warnings;
    private OrderListProcessType responseOrderListProcessing;
    private Orders orders;
    private ErrorsType errors;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Success is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSuccess() {
        return choiceSelect == SUCCESS_CHOICE;
    }

    /** 
     * Get the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @return value
     */
    public SuccessType getSuccess() {
        return success;
    }

    /** 
     * Set the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @param success
     */
    public void setSuccess(SuccessType success) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.success = success;
    }

    /** 
     * Get the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @return value
     */
    public WarningsType getWarnings() {
        return warnings;
    }

    /** 
     * Set the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @param warnings
     */
    public void setWarnings(WarningsType warnings) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.warnings = warnings;
    }

    /** 
     * Get the 'OrderListProcessing' element value. Transaction Processing Results, including processing status, alerts, notices, business warnings, supplemental marketing messages and policy.
     * 
     * @return value
     */
    public OrderListProcessType getResponseOrderListProcessing() {
        return responseOrderListProcessing;
    }

    /** 
     * Set the 'OrderListProcessing' element value. Transaction Processing Results, including processing status, alerts, notices, business warnings, supplemental marketing messages and policy.
     * 
     * @param responseOrderListProcessing
     */
    public void setResponseOrderListProcessing(
            OrderListProcessType responseOrderListProcessing) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responseOrderListProcessing = responseOrderListProcessing;
    }

    /** 
     * Get the 'Orders' element value. Query Results.
     * 
     * @return value
     */
    public Orders getOrders() {
        return orders;
    }

    /** 
     * Set the 'Orders' element value. Query Results.
     * 
     * @param orders
     */
    public void setOrders(Orders orders) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.orders = orders;
    }

    /** 
     * Check if Errors is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifErrors() {
        return choiceSelect == ERRORS_CHOICE;
    }

    /** 
     * Get the 'Errors' element value.
     * 
     * @return value
     */
    public ErrorsType getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value.
     * 
     * @param errors
     */
    public void setErrors(ErrorsType errors) {
        setChoiceSelect(ERRORS_CHOICE);
        this.errors = errors;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Matched Order(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Orders" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Order" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Order -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Orders implements Serializable
    {
        private List<Order> orderList = new ArrayList<Order>();

        /** 
         * Get the list of 'Order' element items.
         * 
         * @return list
         */
        public List<Order> getOrderList() {
            return orderList;
        }

        /** 
         * Set the list of 'Order' element items.
         * 
         * @param list
         */
        public void setOrderList(List<Order> list) {
            orderList = list;
        }
        /** 
         * Matched Order.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Order" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Agency" minOccurs="0">
         *         &lt;!-- Reference to inner class Agency -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:date" name="CreationDate" minOccurs="0"/>
         *       &lt;xs:element name="Departure" minOccurs="0">
         *         &lt;!-- Reference to inner class Departure -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Arrival" minOccurs="0">
         *         &lt;!-- Reference to inner class Arrival -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="NbrInParty" minOccurs="0">
         *         &lt;!-- Reference to inner class NbrInParty -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Passengers" minOccurs="0">
         *         &lt;!-- Reference to inner class Passengers -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="TicketingStatus" minOccurs="0">
         *         &lt;!-- Reference to inner class TicketingStatus -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="OrderID"/>
         *       &lt;xs:element name="Status" minOccurs="0">
         *         &lt;!-- Reference to inner class Status -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Order implements Serializable
        {
            private Agency agency;
            private Date creationDate;
            private Departure departure;
            private Arrival arrival;
            private NbrInParty nbrInParty;
            private Passengers passengers;
            private TicketingStatus ticketingStatus;
            private String orderID;
            private Status status;

            /** 
             * Get the 'Agency' element value.
             * 
             * @return value
             */
            public Agency getAgency() {
                return agency;
            }

            /** 
             * Set the 'Agency' element value.
             * 
             * @param agency
             */
            public void setAgency(Agency agency) {
                this.agency = agency;
            }

            /** 
             * Get the 'CreationDate' element value. Order Creation Date.
             * 
             * @return value
             */
            public Date getCreationDate() {
                return creationDate;
            }

            /** 
             * Set the 'CreationDate' element value. Order Creation Date.
             * 
             * @param creationDate
             */
            public void setCreationDate(Date creationDate) {
                this.creationDate = creationDate;
            }

            /** 
             * Get the 'Departure' element value.
             * 
             * @return value
             */
            public Departure getDeparture() {
                return departure;
            }

            /** 
             * Set the 'Departure' element value.
             * 
             * @param departure
             */
            public void setDeparture(Departure departure) {
                this.departure = departure;
            }

            /** 
             * Get the 'Arrival' element value.
             * 
             * @return value
             */
            public Arrival getArrival() {
                return arrival;
            }

            /** 
             * Set the 'Arrival' element value.
             * 
             * @param arrival
             */
            public void setArrival(Arrival arrival) {
                this.arrival = arrival;
            }

            /** 
             * Get the 'NbrInParty' element value.
             * 
             * @return value
             */
            public NbrInParty getNbrInParty() {
                return nbrInParty;
            }

            /** 
             * Set the 'NbrInParty' element value.
             * 
             * @param nbrInParty
             */
            public void setNbrInParty(NbrInParty nbrInParty) {
                this.nbrInParty = nbrInParty;
            }

            /** 
             * Get the 'Passengers' element value.
             * 
             * @return value
             */
            public Passengers getPassengers() {
                return passengers;
            }

            /** 
             * Set the 'Passengers' element value.
             * 
             * @param passengers
             */
            public void setPassengers(Passengers passengers) {
                this.passengers = passengers;
            }

            /** 
             * Get the 'TicketingStatus' element value.
             * 
             * @return value
             */
            public TicketingStatus getTicketingStatus() {
                return ticketingStatus;
            }

            /** 
             * Set the 'TicketingStatus' element value.
             * 
             * @param ticketingStatus
             */
            public void setTicketingStatus(TicketingStatus ticketingStatus) {
                this.ticketingStatus = ticketingStatus;
            }

            /** 
             * Get the 'OrderID' element value. Order Identificatio
             * 
             * @return value
             */
            public String getOrderID() {
                return orderID;
            }

            /** 
             * Set the 'OrderID' element value. Order Identificatio
             * 
             * @param orderID
             */
            public void setOrderID(String orderID) {
                this.orderID = orderID;
            }

            /** 
             * Get the 'Status' element value.
             * 
             * @return value
             */
            public Status getStatus() {
                return status;
            }

            /** 
             * Set the 'Status' element value.
             * 
             * @param status
             */
            public void setStatus(Status status) {
                this.status = status;
            }
            /** 
             * Agency.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Agency" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element ref="ns:AgencyID" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="IATA_Number" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Agency implements Serializable
            {
                private AgencyID agencyID;
                private String name;
                private String IATANumber;

                /** 
                 * Get the 'AgencyID' element value.
                 * 
                 * @return value
                 */
                public AgencyID getAgencyID() {
                    return agencyID;
                }

                /** 
                 * Set the 'AgencyID' element value.
                 * 
                 * @param agencyID
                 */
                public void setAgencyID(AgencyID agencyID) {
                    this.agencyID = agencyID;
                }

                /** 
                 * Get the 'Name' element value. Agency Seller Name.  Example: Carson Travel
                 * 
                 * @return value
                 */
                public String getName() {
                    return name;
                }

                /** 
                 * Set the 'Name' element value. Agency Seller Name.  Example: Carson Travel
                 * 
                 * @param name
                 */
                public void setName(String name) {
                    this.name = name;
                }

                /** 
                 * Get the 'IATA_Number' element value. Agency Seller IATA number. Example: 98417900
                 * 
                 * @return value
                 */
                public String getIATANumber() {
                    return IATANumber;
                }

                /** 
                 * Set the 'IATA_Number' element value. Agency Seller IATA number. Example: 98417900
                 * 
                 * @param IATANumber
                 */
                public void setIATANumber(String IATANumber) {
                    this.IATANumber = IATANumber;
                }
            }
            /** 
             * Departure Airport.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Departure" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="AirportCode">
             *         &lt;xs:complexType>
             *           &lt;xs:simpleContent>
             *             &lt;xs:extension base="xs:string">
             *               &lt;xs:attributeGroup ref="ns:RadiusAttrGroup"/>
             *             &lt;/xs:extension>
             *           &lt;/xs:simpleContent>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:date" name="Date"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Departure implements Serializable
            {
                private String airportCodeString;
                private RadiusAttrGroup airportCodeRadiusAttrGroup;
                private Date date;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getAirportCodeString() {
                    return airportCodeString;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param airportCodeString
                 */
                public void setAirportCodeString(String airportCodeString) {
                    this.airportCodeString = airportCodeString;
                }

                /** 
                 * Get the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
                 * 
                 * @return value
                 */
                public RadiusAttrGroup getAirportCodeRadiusAttrGroup() {
                    return airportCodeRadiusAttrGroup;
                }

                /** 
                 * Set the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
                 * 
                 * @param airportCodeRadiusAttrGroup
                 */
                public void setAirportCodeRadiusAttrGroup(
                        RadiusAttrGroup airportCodeRadiusAttrGroup) {
                    this.airportCodeRadiusAttrGroup = airportCodeRadiusAttrGroup;
                }

                /** 
                 * Get the 'Date' element value. Departure date. Example: 2017-01-13

                Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
                 * 
                 * @return value
                 */
                public Date getDate() {
                    return date;
                }

                /** 
                 * Set the 'Date' element value. Departure date. Example: 2017-01-13

                Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
                 * 
                 * @param date
                 */
                public void setDate(Date date) {
                    this.date = date;
                }
            }
            /** 
             * Arrival Airport.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Arrival" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="AirportCode">
             *         &lt;xs:complexType>
             *           &lt;xs:simpleContent>
             *             &lt;xs:extension base="xs:string">
             *               &lt;xs:attributeGroup ref="ns:RadiusAttrGroup"/>
             *             &lt;/xs:extension>
             *           &lt;/xs:simpleContent>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:date" name="Date"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Arrival implements Serializable
            {
                private String airportCodeString;
                private RadiusAttrGroup airportCodeRadiusAttrGroup;
                private Date date;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getAirportCodeString() {
                    return airportCodeString;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param airportCodeString
                 */
                public void setAirportCodeString(String airportCodeString) {
                    this.airportCodeString = airportCodeString;
                }

                /** 
                 * Get the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
                 * 
                 * @return value
                 */
                public RadiusAttrGroup getAirportCodeRadiusAttrGroup() {
                    return airportCodeRadiusAttrGroup;
                }

                /** 
                 * Set the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
                 * 
                 * @param airportCodeRadiusAttrGroup
                 */
                public void setAirportCodeRadiusAttrGroup(
                        RadiusAttrGroup airportCodeRadiusAttrGroup) {
                    this.airportCodeRadiusAttrGroup = airportCodeRadiusAttrGroup;
                }

                /** 
                 * Get the 'Date' element value. Arrival date. Example: 2017-01-13

                Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
                 * 
                 * @return value
                 */
                public Date getDate() {
                    return date;
                }

                /** 
                 * Set the 'Date' element value. Arrival date. Example: 2017-01-13

                Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
                 * 
                 * @param date
                 */
                public void setDate(Date date) {
                    this.date = date;
                }
            }
            /** 
             * Number in Party. Example: 2
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NbrInParty" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * 
             * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
             *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
             * &lt;/xs:attributeGroup>
             * </pre>
             */
            public static class NbrInParty implements Serializable
            {
                private String string;
                private String refs;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @return value
                 */
                public String getRefs() {
                    return refs;
                }

                /** 
                 * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @param refs
                 */
                public void setRefs(String refs) {
                    this.refs = refs;
                }
            }
            /** 
             * Passenger and Group information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:choice>
             *       &lt;xs:element type="ns:GroupType" name="Group"/>
             *       &lt;xs:element name="FullName" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class FullName -->
             *       &lt;/xs:element>
             *     &lt;/xs:choice>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Passengers implements Serializable
            {
                private int passengersSelect = -1;
                private static final int GROUP_CHOICE = 0;
                private static final int FULL_NAME_LIST_CHOICE = 1;
                private GroupType group;
                private List<FullName> fullNameList = new ArrayList<FullName>();

                private void setPassengersSelect(int choice) {
                    if (passengersSelect == -1) {
                        passengersSelect = choice;
                    } else if (passengersSelect != choice) {
                        throw new IllegalStateException(
                                "Need to call clearPassengersSelect() before changing existing choice");
                    }
                }

                /** 
                 * Clear the choice selection.
                 */
                public void clearPassengersSelect() {
                    passengersSelect = -1;
                }

                /** 
                 * Check if Group is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifGroup() {
                    return passengersSelect == GROUP_CHOICE;
                }

                /** 
                 * Get the 'Group' element value. Group Information.
                 * 
                 * @return value
                 */
                public GroupType getGroup() {
                    return group;
                }

                /** 
                 * Set the 'Group' element value. Group Information.
                 * 
                 * @param group
                 */
                public void setGroup(GroupType group) {
                    setPassengersSelect(GROUP_CHOICE);
                    this.group = group;
                }

                /** 
                 * Check if FullNameList is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifFullNameList() {
                    return passengersSelect == FULL_NAME_LIST_CHOICE;
                }

                /** 
                 * Get the list of 'FullName' element items.
                 * 
                 * @return list
                 */
                public List<FullName> getFullNameList() {
                    return fullNameList;
                }

                /** 
                 * Set the list of 'FullName' element items.
                 * 
                 * @param list
                 */
                public void setFullNameList(List<FullName> list) {
                    setPassengersSelect(FULL_NAME_LIST_CHOICE);
                    fullNameList = list;
                }
                /** 
                 * Passenger Full Name. Example: JOHN SMITH
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FullName" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:string">
                 *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * 
                 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
                 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
                 * &lt;/xs:attributeGroup>
                 * </pre>
                 */
                public static class FullName implements Serializable
                {
                    private String string;
                    private String refs;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getString() {
                        return string;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param string
                     */
                    public void setString(String string) {
                        this.string = string;
                    }

                    /** 
                     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                     * 
                     * @return value
                     */
                    public String getRefs() {
                        return refs;
                    }

                    /** 
                     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                     * 
                     * @param refs
                     */
                    public void setRefs(String refs) {
                        this.refs = refs;
                    }
                }
            }
            /** 
             * Ticketing Status. Examples: Requested, Ticketed, Other
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketingStatus" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="ns:TicketDesigAppListType">
             *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TicketingStatus implements Serializable
            {
                private TicketDesigAppListType ticketDesigAppListType;
                private String context;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public TicketDesigAppListType getTicketDesigAppListType() {
                    return ticketDesigAppListType;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param ticketDesigAppListType
                 */
                public void setTicketDesigAppListType(
                        TicketDesigAppListType ticketDesigAppListType) {
                    this.ticketDesigAppListType = ticketDesigAppListType;
                }

                /** 
                 * Get the 'Context' attribute value. Context.
                 * 
                 * @return value
                 */
                public String getContext() {
                    return context;
                }

                /** 
                 * Set the 'Context' attribute value. Context.
                 * 
                 * @param context
                 */
                public void setContext(String context) {
                    this.context = context;
                }
            }
            /** 
             * Current status of the Order Item and related indicators. 
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Status" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="StatusCode"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="ChangeOfGaugeInd"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="ScheduleChangeInd"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Status implements Serializable
            {
                private String statusCode;
                private Boolean changeOfGaugeInd;
                private Boolean scheduleChangeInd;

                /** 
                 * Get the 'StatusCode' element value. 
                                    Current Order Item status. Example: OK (Confirmed) Encoding Scheme: IATA Padis Codeset - List for data element 4405 (Status, coded)
                                  
                 * 
                 * @return value
                 */
                public String getStatusCode() {
                    return statusCode;
                }

                /** 
                 * Set the 'StatusCode' element value. 
                                    Current Order Item status. Example: OK (Confirmed) Encoding Scheme: IATA Padis Codeset - List for data element 4405 (Status, coded)
                                  
                 * 
                 * @param statusCode
                 */
                public void setStatusCode(String statusCode) {
                    this.statusCode = statusCode;
                }

                /** 
                 * Get the 'ChangeOfGaugeInd' attribute value. 
                                  When true, the order item cannot be fulfilled due to an aircraft change.
                                
                 * 
                 * @return value
                 */
                public Boolean getChangeOfGaugeInd() {
                    return changeOfGaugeInd;
                }

                /** 
                 * Set the 'ChangeOfGaugeInd' attribute value. 
                                  When true, the order item cannot be fulfilled due to an aircraft change.
                                
                 * 
                 * @param changeOfGaugeInd
                 */
                public void setChangeOfGaugeInd(Boolean changeOfGaugeInd) {
                    this.changeOfGaugeInd = changeOfGaugeInd;
                }

                /** 
                 * Get the 'ScheduleChangeInd' attribute value. 
                                  When true, the order item cannot be fulfilled due to a flight schedule change.
                                
                 * 
                 * @return value
                 */
                public Boolean getScheduleChangeInd() {
                    return scheduleChangeInd;
                }

                /** 
                 * Set the 'ScheduleChangeInd' attribute value. 
                                  When true, the order item cannot be fulfilled due to a flight schedule change.
                                
                 * 
                 * @param scheduleChangeInd
                 */
                public void setScheduleChangeInd(Boolean scheduleChangeInd) {
                    this.scheduleChangeInd = scheduleChangeInd;
                }
            }
        }
    }
}
