
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * ORDER PAYMENT FORM definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderPaymentFormType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Type"/>
 *     &lt;xs:element name="Method">
 *       &lt;xs:complexType>
 *         &lt;xs:choice>
 *           &lt;xs:element ref="ns:Voucher"/>
 *           &lt;xs:element ref="ns:PaymentCard"/>
 *           &lt;xs:element ref="ns:Other"/>
 *           &lt;xs:element ref="ns:MiscChargeOrder"/>
 *           &lt;xs:element ref="ns:LoyaltyRedemption"/>
 *           &lt;xs:element ref="ns:DirectBill"/>
 *           &lt;xs:element ref="ns:Cash"/>
 *           &lt;xs:element ref="ns:BankAccount"/>
 *           &lt;xs:element ref="ns:Check"/>
 *         &lt;/xs:choice>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:CurrencyAmountOptType" name="Amount"/>
 *     &lt;xs:element name="Payer" minOccurs="0">
 *       &lt;!-- Reference to inner class Payer -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OrderPaymentFormType implements Serializable
{
    private String type;
    private int methodSelect = -1;
    private static final int METHOD_VOUCHER_CHOICE = 0;
    private static final int METHOD_PAYMENT_CARD_CHOICE = 1;
    private static final int METHOD_OTHER_CHOICE = 2;
    private static final int METHOD_MISC_CHARGE_ORDER_CHOICE = 3;
    private static final int METHOD_LOYALTY_REDEMPTION_CHOICE = 4;
    private static final int METHOD_DIRECT_BILL_CHOICE = 5;
    private static final int METHOD_CASH_CHOICE = 6;
    private static final int METHOD_BANK_ACCOUNT_CHOICE = 7;
    private static final int METHOD_CHECK_CHOICE = 8;
    private Voucher methodVoucher;
    private PaymentCardType methodPaymentCard;
    private Other methodOther;
    private MiscChargeOrder methodMiscChargeOrder;
    private LoyaltyRedemption methodLoyaltyRedemption;
    private DirectBillType methodDirectBill;
    private Cash methodCash;
    private BankAccountType methodBankAccount;
    private Check methodCheck;
    private CurrencyAmountOptType amount;
    private Payer payer;

    /** 
     * Get the 'Type' element value. The form of payment type. Examples: Credit Card, Cash.

    Encoding Scheme: IATA PADIS code list data element [9888] Form of Payment Identification
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value. The form of payment type. Examples: Credit Card, Cash.

    Encoding Scheme: IATA PADIS code list data element [9888] Form of Payment Identification
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    private void setMethodSelect(int choice) {
        if (methodSelect == -1) {
            methodSelect = choice;
        } else if (methodSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearMethodSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearMethodSelect() {
        methodSelect = -1;
    }

    /** 
     * Check if MethodVoucher is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMethodVoucher() {
        return methodSelect == METHOD_VOUCHER_CHOICE;
    }

    /** 
     * Get the 'Voucher' element value. Information relating to prepayment vouchers.
     * 
     * @return value
     */
    public Voucher getMethodVoucher() {
        return methodVoucher;
    }

    /** 
     * Set the 'Voucher' element value. Information relating to prepayment vouchers.
     * 
     * @param methodVoucher
     */
    public void setMethodVoucher(Voucher methodVoucher) {
        setMethodSelect(METHOD_VOUCHER_CHOICE);
        this.methodVoucher = methodVoucher;
    }

    /** 
     * Check if MethodPaymentCard is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMethodPaymentCard() {
        return methodSelect == METHOD_PAYMENT_CARD_CHOICE;
    }

    /** 
     * Get the 'PaymentCard' element value.
     * 
     * @return value
     */
    public PaymentCardType getMethodPaymentCard() {
        return methodPaymentCard;
    }

    /** 
     * Set the 'PaymentCard' element value.
     * 
     * @param methodPaymentCard
     */
    public void setMethodPaymentCard(PaymentCardType methodPaymentCard) {
        setMethodSelect(METHOD_PAYMENT_CARD_CHOICE);
        this.methodPaymentCard = methodPaymentCard;
    }

    /** 
     * Check if MethodOther is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMethodOther() {
        return methodSelect == METHOD_OTHER_CHOICE;
    }

    /** 
     * Get the 'Other' element value.
     * 
     * @return value
     */
    public Other getMethodOther() {
        return methodOther;
    }

    /** 
     * Set the 'Other' element value.
     * 
     * @param methodOther
     */
    public void setMethodOther(Other methodOther) {
        setMethodSelect(METHOD_OTHER_CHOICE);
        this.methodOther = methodOther;
    }

    /** 
     * Check if MethodMiscChargeOrder is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMethodMiscChargeOrder() {
        return methodSelect == METHOD_MISC_CHARGE_ORDER_CHOICE;
    }

    /** 
     * Get the 'MiscChargeOrder' element value.
     * 
     * @return value
     */
    public MiscChargeOrder getMethodMiscChargeOrder() {
        return methodMiscChargeOrder;
    }

    /** 
     * Set the 'MiscChargeOrder' element value.
     * 
     * @param methodMiscChargeOrder
     */
    public void setMethodMiscChargeOrder(MiscChargeOrder methodMiscChargeOrder) {
        setMethodSelect(METHOD_MISC_CHARGE_ORDER_CHOICE);
        this.methodMiscChargeOrder = methodMiscChargeOrder;
    }

    /** 
     * Check if MethodLoyaltyRedemption is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMethodLoyaltyRedemption() {
        return methodSelect == METHOD_LOYALTY_REDEMPTION_CHOICE;
    }

    /** 
     * Get the 'LoyaltyRedemption' element value.
     * 
     * @return value
     */
    public LoyaltyRedemption getMethodLoyaltyRedemption() {
        return methodLoyaltyRedemption;
    }

    /** 
     * Set the 'LoyaltyRedemption' element value.
     * 
     * @param methodLoyaltyRedemption
     */
    public void setMethodLoyaltyRedemption(
            LoyaltyRedemption methodLoyaltyRedemption) {
        setMethodSelect(METHOD_LOYALTY_REDEMPTION_CHOICE);
        this.methodLoyaltyRedemption = methodLoyaltyRedemption;
    }

    /** 
     * Check if MethodDirectBill is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMethodDirectBill() {
        return methodSelect == METHOD_DIRECT_BILL_CHOICE;
    }

    /** 
     * Get the 'DirectBill' element value.
     * 
     * @return value
     */
    public DirectBillType getMethodDirectBill() {
        return methodDirectBill;
    }

    /** 
     * Set the 'DirectBill' element value.
     * 
     * @param methodDirectBill
     */
    public void setMethodDirectBill(DirectBillType methodDirectBill) {
        setMethodSelect(METHOD_DIRECT_BILL_CHOICE);
        this.methodDirectBill = methodDirectBill;
    }

    /** 
     * Check if MethodCash is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMethodCash() {
        return methodSelect == METHOD_CASH_CHOICE;
    }

    /** 
     * Get the 'Cash' element value.
     * 
     * @return value
     */
    public Cash getMethodCash() {
        return methodCash;
    }

    /** 
     * Set the 'Cash' element value.
     * 
     * @param methodCash
     */
    public void setMethodCash(Cash methodCash) {
        setMethodSelect(METHOD_CASH_CHOICE);
        this.methodCash = methodCash;
    }

    /** 
     * Check if MethodBankAccount is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMethodBankAccount() {
        return methodSelect == METHOD_BANK_ACCOUNT_CHOICE;
    }

    /** 
     * Get the 'BankAccount' element value.
     * 
     * @return value
     */
    public BankAccountType getMethodBankAccount() {
        return methodBankAccount;
    }

    /** 
     * Set the 'BankAccount' element value.
     * 
     * @param methodBankAccount
     */
    public void setMethodBankAccount(BankAccountType methodBankAccount) {
        setMethodSelect(METHOD_BANK_ACCOUNT_CHOICE);
        this.methodBankAccount = methodBankAccount;
    }

    /** 
     * Check if MethodCheck is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMethodCheck() {
        return methodSelect == METHOD_CHECK_CHOICE;
    }

    /** 
     * Get the 'Check' element value. Check (Cheque) Payment
     * 
     * @return value
     */
    public Check getMethodCheck() {
        return methodCheck;
    }

    /** 
     * Set the 'Check' element value. Check (Cheque) Payment
     * 
     * @param methodCheck
     */
    public void setMethodCheck(Check methodCheck) {
        setMethodSelect(METHOD_CHECK_CHOICE);
        this.methodCheck = methodCheck;
    }

    /** 
     * Get the 'Amount' element value. The amount for this form of payment. Example: 300 USD
                
     * 
     * @return value
     */
    public CurrencyAmountOptType getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. The amount for this form of payment. Example: 300 USD
                
     * 
     * @param amount
     */
    public void setAmount(CurrencyAmountOptType amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'Payer' element value.
     * 
     * @return value
     */
    public Payer getPayer() {
        return payer;
    }

    /** 
     * Set the 'Payer' element value.
     * 
     * @param payer
     */
    public void setPayer(Payer payer) {
        this.payer = payer;
    }
    /** 
     * The person who is paying for an Order is not a passenger
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payer" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="ContactInfoRefs" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Payer implements Serializable
    {
        private String contactInfoRefs;

        /** 
         * Get the 'ContactInfoRefs' element value. Ref to Contact Information of the Order's Payer. The information can be a company, or include the name details of the individual paying.
         * 
         * @return value
         */
        public String getContactInfoRefs() {
            return contactInfoRefs;
        }

        /** 
         * Set the 'ContactInfoRefs' element value. Ref to Contact Information of the Order's Payer. The information can be a company, or include the name details of the individual paying.
         * 
         * @param contactInfoRefs
         */
        public void setContactInfoRefs(String contactInfoRefs) {
            this.contactInfoRefs = contactInfoRefs;
        }
    }
}
