
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** 
 * The OrderReshop transaction set passes new shopping requests to an airline to replace existing specified order or order items in an Order or for new shopping requests to add to an existing Order. Airline responds with product offers within the context of the existing Order.

 There is no change to the Order or Order Items, in response to a Reshop request - typically, the Reshop response will be followed by an OrderChangeRQ or OrderCancelRQ transaction, to commit the re-shop offer.

 In the response, the Airline can provide exact instructions as to what actions can finally be executed, as a solution to the initially requested action.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderReshopRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:choice>
 *         &lt;xs:sequence>
 *           &lt;xs:element type="ns:SuccessType" name="Success"/>
 *           &lt;xs:element type="ns:WarningsType" name="Warnings" minOccurs="0"/>
 *           &lt;xs:element name="Response">
 *             &lt;xs:complexType>
 *               &lt;xs:sequence>
 *                 &lt;xs:element ref="ns:OrderReshopProcessing" minOccurs="0"/>
 *                 &lt;xs:element type="ns:ShoppingResponseID_Type" name="ReShoppingResponseID" minOccurs="0"/>
 *                 &lt;xs:element name="Group" minOccurs="0">
 *                   &lt;!-- Reference to inner class Group -->
 *                 &lt;/xs:element>
 *                 &lt;xs:choice>
 *                   &lt;xs:element name="ReshopOffers">
 *                     &lt;!-- Reference to inner class ReshopOffers -->
 *                   &lt;/xs:element>
 *                   &lt;xs:element name="RepricedOffer">
 *                     &lt;xs:complexType>
 *                       &lt;xs:sequence>
 *                         &lt;xs:element name="RepricedOfferItem" maxOccurs="unbounded">
 *                           &lt;!-- Reference to inner class RepricedOfferItem -->
 *                         &lt;/xs:element>
 *                       &lt;/xs:sequence>
 *                       &lt;xs:attribute type="xs:string" use="required" name="OfferID"/>
 *                       &lt;xs:attribute type="xs:string" use="required" name="Owner"/>
 *                       &lt;xs:attribute type="xs:string" name="OwnerType"/>
 *                       &lt;xs:attribute type="xs:boolean" name="RequestedDateInd"/>
 *                     &lt;/xs:complexType>
 *                   &lt;/xs:element>
 *                   &lt;xs:element type="xs:boolean" name="NoPriceChangeInd"/>
 *                 &lt;/xs:choice>
 *                 &lt;xs:element type="ns:PenaltyType" name="ChangeFees" minOccurs="0"/>
 *                 &lt;xs:element name="Payments" minOccurs="0">
 *                   &lt;!-- Reference to inner class Payments -->
 *                 &lt;/xs:element>
 *                 &lt;xs:element name="Commission" minOccurs="0">
 *                   &lt;!-- Reference to inner class Commission -->
 *                 &lt;/xs:element>
 *                 &lt;xs:element name="DataLists" minOccurs="0">
 *                   &lt;!-- Reference to inner class DataLists -->
 *                 &lt;/xs:element>
 *                 &lt;xs:element type="ns:ItinReshopMetadataType" name="Metadata" minOccurs="0"/>
 *               &lt;/xs:sequence>
 *             &lt;/xs:complexType>
 *           &lt;/xs:element>
 *         &lt;/xs:sequence>
 *         &lt;xs:element ref="ns:Errors"/>
 *       &lt;/xs:choice>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OrderReshopRS implements Serializable
{
    private MsgDocumentType document;
    private int choiceSelect = -1;
    private static final int SUCCESS_CHOICE = 0;
    private static final int ERRORS_CHOICE = 1;
    private SuccessType success;
    private WarningsType warnings;
    private ItinReshopProcessType responseOrderReshopProcessing;
    private ShoppingResponseIDType responseReShoppingResponseID;
    private Group group;
    private int responseChoiceSelect = -1;
    private static final int RESHOP_OFFERS_CHOICE = 0;
    private static final int RESPONSE_REPRICED_OFFER_CHOICE = 1;
    private static final int RESPONSE_NO_PRICE_CHANGE_IND_CHOICE = 2;
    private ReshopOffers reshopOffers;
    private List<RepricedOfferItem> repricedOfferItemList = new ArrayList<RepricedOfferItem>();
    private String responseRepricedOfferOfferID;
    private String responseRepricedOfferOwner;
    private String responseRepricedOfferOwnerType;
    private Boolean responseRepricedOfferRequestedDateInd;
    private boolean responseNoPriceChangeInd;
    private PenaltyType responseChangeFees;
    private Payments payments;
    private Commission commission;
    private DataLists dataLists;
    private ItinReshopMetadataType responseMetadata;
    private ErrorsType errors;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Success is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSuccess() {
        return choiceSelect == SUCCESS_CHOICE;
    }

    /** 
     * Get the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @return value
     */
    public SuccessType getSuccess() {
        return success;
    }

    /** 
     * Set the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @param success
     */
    public void setSuccess(SuccessType success) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.success = success;
    }

    /** 
     * Get the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @return value
     */
    public WarningsType getWarnings() {
        return warnings;
    }

    /** 
     * Set the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @param warnings
     */
    public void setWarnings(WarningsType warnings) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.warnings = warnings;
    }

    /** 
     * Get the 'OrderReshopProcessing' element value. Transaction Processing Results, including processing status, alerts, notices, business warnings, supplemental marketing messages and policy.
     * 
     * @return value
     */
    public ItinReshopProcessType getResponseOrderReshopProcessing() {
        return responseOrderReshopProcessing;
    }

    /** 
     * Set the 'OrderReshopProcessing' element value. Transaction Processing Results, including processing status, alerts, notices, business warnings, supplemental marketing messages and policy.
     * 
     * @param responseOrderReshopProcessing
     */
    public void setResponseOrderReshopProcessing(
            ItinReshopProcessType responseOrderReshopProcessing) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responseOrderReshopProcessing = responseOrderReshopProcessing;
    }

    /** 
     * Get the 'ReShoppingResponseID' element value. A collection of shopping session (message response) IDs, including the unique (master) Shopping Response ID, Offer IDs, Offer Item IDs and Service IDs.

    Notes: This capability may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by this specification. Notes:
    1. This capability supports reduced message payload sizes by providing a mechanism that supports references to cached Shopping Transactions and/ or Offer information so only object identifiers (e.g. Offer, Service) need to be exchanged in a subsequent Shopping request message, versus specifying the full object details.

    2. This capability may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only.  The technical implementation of this capability is not dictated by this specification.
     * 
     * @return value
     */
    public ShoppingResponseIDType getResponseReShoppingResponseID() {
        return responseReShoppingResponseID;
    }

    /** 
     * Set the 'ReShoppingResponseID' element value. A collection of shopping session (message response) IDs, including the unique (master) Shopping Response ID, Offer IDs, Offer Item IDs and Service IDs.

    Notes: This capability may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by this specification. Notes:
    1. This capability supports reduced message payload sizes by providing a mechanism that supports references to cached Shopping Transactions and/ or Offer information so only object identifiers (e.g. Offer, Service) need to be exchanged in a subsequent Shopping request message, versus specifying the full object details.

    2. This capability may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only.  The technical implementation of this capability is not dictated by this specification.
     * 
     * @param responseReShoppingResponseID
     */
    public void setResponseReShoppingResponseID(
            ShoppingResponseIDType responseReShoppingResponseID) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responseReShoppingResponseID = responseReShoppingResponseID;
    }

    /** 
     * Get the 'Group' element value. Query Results.
     * 
     * @return value
     */
    public Group getGroup() {
        return group;
    }

    /** 
     * Set the 'Group' element value. Query Results.
     * 
     * @param group
     */
    public void setGroup(Group group) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.group = group;
    }

    private void setResponseChoiceSelect(int choice) {
        setChoiceSelect(SUCCESS_CHOICE);
        if (responseChoiceSelect == -1) {
            responseChoiceSelect = choice;
        } else if (responseChoiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearResponseChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearResponseChoiceSelect() {
        responseChoiceSelect = -1;
    }

    /** 
     * Check if ReshopOffers is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifReshopOffers() {
        return responseChoiceSelect == RESHOP_OFFERS_CHOICE;
    }

    /** 
     * Get the 'ReshopOffers' element value.
     * 
     * @return value
     */
    public ReshopOffers getReshopOffers() {
        return reshopOffers;
    }

    /** 
     * Set the 'ReshopOffers' element value.
     * 
     * @param reshopOffers
     */
    public void setReshopOffers(ReshopOffers reshopOffers) {
        setResponseChoiceSelect(RESHOP_OFFERS_CHOICE);
        this.reshopOffers = reshopOffers;
    }

    /** 
     * Check if ResponseRepricedOffer is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifResponseRepricedOffer() {
        return responseChoiceSelect == RESPONSE_REPRICED_OFFER_CHOICE;
    }

    /** 
     * Get the list of 'RepricedOfferItem' element items. Function used to request the repricing of an existing Order, possibly as a consequence of expired TimeLimits. Airline returns Offers/OfferItems that describe the changes incurred from the reprice request.
     * 
     * @return list
     */
    public List<RepricedOfferItem> getRepricedOfferItemList() {
        return repricedOfferItemList;
    }

    /** 
     * Set the list of 'RepricedOfferItem' element items. Function used to request the repricing of an existing Order, possibly as a consequence of expired TimeLimits. Airline returns Offers/OfferItems that describe the changes incurred from the reprice request.
     * 
     * @param list
     */
    public void setRepricedOfferItemList(List<RepricedOfferItem> list) {
        setResponseChoiceSelect(RESPONSE_REPRICED_OFFER_CHOICE);
        repricedOfferItemList = list;
    }

    /** 
     * Get the 'OfferID' attribute value. Airline-assigned unique Offer identifier.
     * 
     * @return value
     */
    public String getResponseRepricedOfferOfferID() {
        return responseRepricedOfferOfferID;
    }

    /** 
     * Set the 'OfferID' attribute value. Airline-assigned unique Offer identifier.
     * 
     * @param responseRepricedOfferOfferID
     */
    public void setResponseRepricedOfferOfferID(
            String responseRepricedOfferOfferID) {
        setResponseChoiceSelect(RESPONSE_REPRICED_OFFER_CHOICE);
        this.responseRepricedOfferOfferID = responseRepricedOfferOfferID;
    }

    /** 
     * Get the 'Owner' attribute value. Airline designator of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA

    Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
     * 
     * @return value
     */
    public String getResponseRepricedOfferOwner() {
        return responseRepricedOfferOwner;
    }

    /** 
     * Set the 'Owner' attribute value. Airline designator of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA

    Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
     * 
     * @param responseRepricedOfferOwner
     */
    public void setResponseRepricedOfferOwner(String responseRepricedOfferOwner) {
        setResponseChoiceSelect(RESPONSE_REPRICED_OFFER_CHOICE);
        this.responseRepricedOfferOwner = responseRepricedOfferOwner;
    }

    /** 
     * Get the 'OwnerType' attribute value. The POA OrderID should only go to the ORA, not back to the seller.
    1. ORA
    2. POA
     * 
     * @return value
     */
    public String getResponseRepricedOfferOwnerType() {
        return responseRepricedOfferOwnerType;
    }

    /** 
     * Set the 'OwnerType' attribute value. The POA OrderID should only go to the ORA, not back to the seller.
    1. ORA
    2. POA
     * 
     * @param responseRepricedOfferOwnerType
     */
    public void setResponseRepricedOfferOwnerType(
            String responseRepricedOfferOwnerType) {
        setResponseChoiceSelect(RESPONSE_REPRICED_OFFER_CHOICE);
        this.responseRepricedOfferOwnerType = responseRepricedOfferOwnerType;
    }

    /** 
     * Get the 'RequestedDateInd' attribute value. Indicator to specify if the offer relates to requested date. For example in calendar search, this indicator will be set to 'true' if this airline offer is for a requested date and will not be present (or will be set to 'false' if airline offer is for another date than requested one.
     * 
     * @return value
     */
    public Boolean getResponseRepricedOfferRequestedDateInd() {
        return responseRepricedOfferRequestedDateInd;
    }

    /** 
     * Set the 'RequestedDateInd' attribute value. Indicator to specify if the offer relates to requested date. For example in calendar search, this indicator will be set to 'true' if this airline offer is for a requested date and will not be present (or will be set to 'false' if airline offer is for another date than requested one.
     * 
     * @param responseRepricedOfferRequestedDateInd
     */
    public void setResponseRepricedOfferRequestedDateInd(
            Boolean responseRepricedOfferRequestedDateInd) {
        setResponseChoiceSelect(RESPONSE_REPRICED_OFFER_CHOICE);
        this.responseRepricedOfferRequestedDateInd = responseRepricedOfferRequestedDateInd;
    }

    /** 
     * Check if ResponseNoPriceChangeInd is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifResponseNoPriceChangeInd() {
        return responseChoiceSelect == RESPONSE_NO_PRICE_CHANGE_IND_CHOICE;
    }

    /** 
     * Get the 'NoPriceChangeInd' element value. When "true", the Reprice had no effect on the price(s) of the original Order/OrderItems.
     * 
     * @return value
     */
    public boolean isResponseNoPriceChangeInd() {
        return responseNoPriceChangeInd;
    }

    /** 
     * Set the 'NoPriceChangeInd' element value. When "true", the Reprice had no effect on the price(s) of the original Order/OrderItems.
     * 
     * @param responseNoPriceChangeInd
     */
    public void setResponseNoPriceChangeInd(boolean responseNoPriceChangeInd) {
        setResponseChoiceSelect(RESPONSE_NO_PRICE_CHANGE_IND_CHOICE);
        this.responseNoPriceChangeInd = responseNoPriceChangeInd;
    }

    /** 
     * Get the 'ChangeFees' element value. Reshop Fees(s) and Penalty(s).
     * 
     * @return value
     */
    public PenaltyType getResponseChangeFees() {
        return responseChangeFees;
    }

    /** 
     * Set the 'ChangeFees' element value. Reshop Fees(s) and Penalty(s).
     * 
     * @param responseChangeFees
     */
    public void setResponseChangeFees(PenaltyType responseChangeFees) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responseChangeFees = responseChangeFees;
    }

    /** 
     * Get the 'Payments' element value. Query Results.
     * 
     * @return value
     */
    public Payments getPayments() {
        return payments;
    }

    /** 
     * Set the 'Payments' element value. Query Results.
     * 
     * @param payments
     */
    public void setPayments(Payments payments) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.payments = payments;
    }

    /** 
     * Get the 'Commission' element value. Query Results.
     * 
     * @return value
     */
    public Commission getCommission() {
        return commission;
    }

    /** 
     * Set the 'Commission' element value. Query Results.
     * 
     * @param commission
     */
    public void setCommission(Commission commission) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.commission = commission;
    }

    /** 
     * Get the 'DataLists' element value. Query Results.
     * 
     * @return value
     */
    public DataLists getDataLists() {
        return dataLists;
    }

    /** 
     * Set the 'DataLists' element value. Query Results.
     * 
     * @param dataLists
     */
    public void setDataLists(DataLists dataLists) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.dataLists = dataLists;
    }

    /** 
     * Get the 'Metadata' element value. Metadata List(s).
     * 
     * @return value
     */
    public ItinReshopMetadataType getResponseMetadata() {
        return responseMetadata;
    }

    /** 
     * Set the 'Metadata' element value. Metadata List(s).
     * 
     * @param responseMetadata
     */
    public void setResponseMetadata(ItinReshopMetadataType responseMetadata) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responseMetadata = responseMetadata;
    }

    /** 
     * Check if Errors is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifErrors() {
        return choiceSelect == ERRORS_CHOICE;
    }

    /** 
     * Get the 'Errors' element value.
     * 
     * @return value
     */
    public ErrorsType getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value.
     * 
     * @param errors
     */
    public void setErrors(ErrorsType errors) {
        setChoiceSelect(ERRORS_CHOICE);
        this.errors = errors;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Group Information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Group" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:GroupType">
     *         &lt;xs:sequence>
     *           &lt;xs:element name="ActionType" minOccurs="0">
     *             &lt;!-- Reference to inner class ActionType -->
     *           &lt;/xs:element>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Group extends GroupType implements Serializable
    {
        private ActionType actionType;

        /** 
         * Get the 'ActionType' element value.
         * 
         * @return value
         */
        public ActionType getActionType() {
            return actionType;
        }

        /** 
         * Set the 'ActionType' element value.
         * 
         * @param actionType
         */
        public void setActionType(ActionType actionType) {
            this.actionType = actionType;
        }
        /** 
         * Order Action. Examples: Cancel, Create, Update, Delete, Reissue, Reprice
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ActionType" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ActionType implements Serializable
        {
            private String string;
            private String context;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'Context' attribute value. Action Type Context.
             * 
             * @return value
             */
            public String getContext() {
                return context;
            }

            /** 
             * Set the 'Context' attribute value. Action Type Context.
             * 
             * @param context
             */
            public void setContext(String context) {
                this.context = context;
            }
        }
    }
    /** 
     * Reshopped airline offer(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReshopOffers">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="ReshopOffer" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class ReshopOffer -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ALaCarteOffer" minOccurs="0">
     *         &lt;!-- Reference to inner class ALaCarteOffer -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ReshopOffers implements Serializable
    {
        private List<ReshopOffer> reshopOfferList = new ArrayList<ReshopOffer>();
        private ALaCarteOffer ALaCarteOffer1;

        /** 
         * Get the list of 'ReshopOffer' element items.
         * 
         * @return list
         */
        public List<ReshopOffer> getReshopOfferList() {
            return reshopOfferList;
        }

        /** 
         * Set the list of 'ReshopOffer' element items.
         * 
         * @param list
         */
        public void setReshopOfferList(List<ReshopOffer> list) {
            reshopOfferList = list;
        }

        /** 
         * Get the 'ALaCarteOffer' element value.
         * 
         * @return value
         */
        public ALaCarteOffer getALaCarteOffer1() {
            return ALaCarteOffer1;
        }

        /** 
         * Set the 'ALaCarteOffer' element value.
         * 
         * @param ALaCarteOffer1
         */
        public void setALaCarteOffer1(ALaCarteOffer ALaCarteOffer1) {
            this.ALaCarteOffer1 = ALaCarteOffer1;
        }
        /** 
         * Reshopped airline offer
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReshopOffer" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:OfferType">
         *         &lt;xs:sequence>
         *           &lt;xs:element name="FlightsOverview" minOccurs="0">
         *             &lt;!-- Reference to inner class FlightsOverview -->
         *           &lt;/xs:element>
         *           &lt;xs:element name="DeleteOfferItem" minOccurs="0" maxOccurs="unbounded">
         *             &lt;!-- Reference to inner class DeleteOfferItem -->
         *           &lt;/xs:element>
         *           &lt;xs:element name="AddOfferItem" minOccurs="0" maxOccurs="unbounded">
         *             &lt;!-- Reference to inner class AddOfferItem -->
         *           &lt;/xs:element>
         *           &lt;xs:element name="NameChangeOfferItem" minOccurs="0">
         *             &lt;!-- Reference to inner class NameChangeOfferItem -->
         *           &lt;/xs:element>
         *           &lt;xs:element name="BaggageAllowance" minOccurs="0" maxOccurs="unbounded">
         *             &lt;!-- Reference to inner class BaggageAllowance -->
         *           &lt;/xs:element>
         *         &lt;/xs:sequence>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ReshopOffer extends OfferType implements
            Serializable
        {
            private FlightsOverview flightsOverview;
            private List<DeleteOfferItem> deleteOfferItemList = new ArrayList<DeleteOfferItem>();
            private List<AddOfferItem> addOfferItemList = new ArrayList<AddOfferItem>();
            private NameChangeOfferItem nameChangeOfferItem;
            private List<BaggageAllowance> baggageAllowanceList = new ArrayList<BaggageAllowance>();

            /** 
             * Get the 'FlightsOverview' element value.
             * 
             * @return value
             */
            public FlightsOverview getFlightsOverview() {
                return flightsOverview;
            }

            /** 
             * Set the 'FlightsOverview' element value.
             * 
             * @param flightsOverview
             */
            public void setFlightsOverview(FlightsOverview flightsOverview) {
                this.flightsOverview = flightsOverview;
            }

            /** 
             * Get the list of 'DeleteOfferItem' element items.
             * 
             * @return list
             */
            public List<DeleteOfferItem> getDeleteOfferItemList() {
                return deleteOfferItemList;
            }

            /** 
             * Set the list of 'DeleteOfferItem' element items.
             * 
             * @param list
             */
            public void setDeleteOfferItemList(List<DeleteOfferItem> list) {
                deleteOfferItemList = list;
            }

            /** 
             * Get the list of 'AddOfferItem' element items.
             * 
             * @return list
             */
            public List<AddOfferItem> getAddOfferItemList() {
                return addOfferItemList;
            }

            /** 
             * Set the list of 'AddOfferItem' element items.
             * 
             * @param list
             */
            public void setAddOfferItemList(List<AddOfferItem> list) {
                addOfferItemList = list;
            }

            /** 
             * Get the 'NameChangeOfferItem' element value.
             * 
             * @return value
             */
            public NameChangeOfferItem getNameChangeOfferItem() {
                return nameChangeOfferItem;
            }

            /** 
             * Set the 'NameChangeOfferItem' element value.
             * 
             * @param nameChangeOfferItem
             */
            public void setNameChangeOfferItem(
                    NameChangeOfferItem nameChangeOfferItem) {
                this.nameChangeOfferItem = nameChangeOfferItem;
            }

            /** 
             * Get the list of 'BaggageAllowance' element items.
             * 
             * @return list
             */
            public List<BaggageAllowance> getBaggageAllowanceList() {
                return baggageAllowanceList;
            }

            /** 
             * Set the list of 'BaggageAllowance' element items.
             * 
             * @param list
             */
            public void setBaggageAllowanceList(List<BaggageAllowance> list) {
                baggageAllowanceList = list;
            }
            /** 
             * Summary of proposed flight information in the context of this specific Offer.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightsOverview" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="FlightRef" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class FlightRef -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="ItineraryPriceClassRef" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FlightsOverview implements Serializable
            {
                private List<FlightRef> flightRefList = new ArrayList<FlightRef>();
                private String itineraryPriceClassRef;

                /** 
                 * Get the list of 'FlightRef' element items.
                 * 
                 * @return list
                 */
                public List<FlightRef> getFlightRefList() {
                    return flightRefList;
                }

                /** 
                 * Set the list of 'FlightRef' element items.
                 * 
                 * @param list
                 */
                public void setFlightRefList(List<FlightRef> list) {
                    flightRefList = list;
                }

                /** 
                 * Get the 'ItineraryPriceClassRef' element value. Itinerary-level price class (eg. most restrictive applies)
                 * 
                 * @return value
                 */
                public String getItineraryPriceClassRef() {
                    return itineraryPriceClassRef;
                }

                /** 
                 * Set the 'ItineraryPriceClassRef' element value. Itinerary-level price class (eg. most restrictive applies)
                 * 
                 * @param itineraryPriceClassRef
                 */
                public void setItineraryPriceClassRef(
                        String itineraryPriceClassRef) {
                    this.itineraryPriceClassRef = itineraryPriceClassRef;
                }
                /** 
                 * Reference to the Flight ID specified within this Offer. Should be repeated for all Flights included.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightRef" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:string">
                 *         &lt;xs:attribute type="xs:string" name="ODRef"/>
                 *         &lt;xs:attribute type="xs:string" name="PriceClassRef"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FlightRef implements Serializable
                {
                    private String string;
                    private String ODRef;
                    private String priceClassRef;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getString() {
                        return string;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param string
                     */
                    public void setString(String string) {
                        this.string = string;
                    }

                    /** 
                     * Get the 'ODRef' attribute value. Reference to the Origin/Destination ID specified within this Offer.
                     * 
                     * @return value
                     */
                    public String getODRef() {
                        return ODRef;
                    }

                    /** 
                     * Set the 'ODRef' attribute value. Reference to the Origin/Destination ID specified within this Offer.
                     * 
                     * @param ODRef
                     */
                    public void setODRef(String ODRef) {
                        this.ODRef = ODRef;
                    }

                    /** 
                     * Get the 'PriceClassRef' attribute value. Flight-level price class
                     * 
                     * @return value
                     */
                    public String getPriceClassRef() {
                        return priceClassRef;
                    }

                    /** 
                     * Set the 'PriceClassRef' attribute value. Flight-level price class
                     * 
                     * @param priceClassRef
                     */
                    public void setPriceClassRef(String priceClassRef) {
                        this.priceClassRef = priceClassRef;
                    }
                }
            }
            /** 
             * OrderItems which the Airline confirms can be deleted in a subsequent OrderChangeRQ. Optionally, a price differential (e.g. refund amounts) can be added to each OrderItem occurrence being deleted.

            Should not be used for "replace" type functions. In the case the Seller is attempting to replace an OrderItem, this item should only be referenced from the AddOfferItem's attribute "OrderItemIDs".
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DeleteOfferItem" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="ReshopDifferential" minOccurs="0">
             *         &lt;!-- Reference to inner class ReshopDifferential -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="OfferItemID"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="OrderItemID"/>
             *     &lt;xs:attribute type="xs:boolean" name="MandatoryInd"/>
             *     &lt;xs:attribute type="xs:boolean" name="ModificationProhibitedInd"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class DeleteOfferItem implements Serializable
            {
                private ReshopDifferential reshopDifferential;
                private String offerItemID;
                private String orderItemID;
                private Boolean mandatoryInd;
                private Boolean modificationProhibitedInd;

                /** 
                 * Get the 'ReshopDifferential' element value.
                 * 
                 * @return value
                 */
                public ReshopDifferential getReshopDifferential() {
                    return reshopDifferential;
                }

                /** 
                 * Set the 'ReshopDifferential' element value.
                 * 
                 * @param reshopDifferential
                 */
                public void setReshopDifferential(
                        ReshopDifferential reshopDifferential) {
                    this.reshopDifferential = reshopDifferential;
                }

                /** 
                 * Get the 'OfferItemID' attribute value. Unique identifier for this OfferItem instance. Must be unique within XML message. Exceeding 64 characters or use of dashes is not recommended.
                 * 
                 * @return value
                 */
                public String getOfferItemID() {
                    return offerItemID;
                }

                /** 
                 * Set the 'OfferItemID' attribute value. Unique identifier for this OfferItem instance. Must be unique within XML message. Exceeding 64 characters or use of dashes is not recommended.
                 * 
                 * @param offerItemID
                 */
                public void setOfferItemID(String offerItemID) {
                    this.offerItemID = offerItemID;
                }

                /** 
                 * Get the 'OrderItemID' attribute value.
                 * 
                 * @return value
                 */
                public String getOrderItemID() {
                    return orderItemID;
                }

                /** 
                 * Set the 'OrderItemID' attribute value.
                 * 
                 * @param orderItemID
                 */
                public void setOrderItemID(String orderItemID) {
                    this.orderItemID = orderItemID;
                }

                /** 
                 * Get the 'MandatoryInd' attribute value. If set to 'true', indicates mandatory Offer Items which cannot be removed from the Offer. Mandatory Offer Items transition into Order Items. If not present or 'false', the Offer item is optional. The aggregate price at the Offer level initially reflects the sum of the prices for all Mandatory Offer Items within it.
                 * 
                 * @return value
                 */
                public Boolean getMandatoryInd() {
                    return mandatoryInd;
                }

                /** 
                 * Set the 'MandatoryInd' attribute value. If set to 'true', indicates mandatory Offer Items which cannot be removed from the Offer. Mandatory Offer Items transition into Order Items. If not present or 'false', the Offer item is optional. The aggregate price at the Offer level initially reflects the sum of the prices for all Mandatory Offer Items within it.
                 * 
                 * @param mandatoryInd
                 */
                public void setMandatoryInd(Boolean mandatoryInd) {
                    this.mandatoryInd = mandatoryInd;
                }

                /** 
                 * Get the 'ModificationProhibitedInd' attribute value. POA to ORA only: to indicate that the offer is non-modifiable. This indicates to ORA that its offer is non-modifiable (eg. Regulatory or brand protection reasons). If indicator is set to true, nodifications to the POA’s offer ARE NOT allowed.
                 * 
                 * @return value
                 */
                public Boolean getModificationProhibitedInd() {
                    return modificationProhibitedInd;
                }

                /** 
                 * Set the 'ModificationProhibitedInd' attribute value. POA to ORA only: to indicate that the offer is non-modifiable. This indicates to ORA that its offer is non-modifiable (eg. Regulatory or brand protection reasons). If indicator is set to true, nodifications to the POA’s offer ARE NOT allowed.
                 * 
                 * @param modificationProhibitedInd
                 */
                public void setModificationProhibitedInd(
                        Boolean modificationProhibitedInd) {
                    this.modificationProhibitedInd = modificationProhibitedInd;
                }
                /** 
                 * It contains the Original order amount, new offer amount, penalty details, fees and due by details. It also contains the taxes information.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReshopDifferential" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="OriginalOrderItem" minOccurs="0">
                 *         &lt;!-- Reference to inner class OriginalOrderItem -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="NewOfferItem" minOccurs="0">
                 *         &lt;!-- Reference to inner class NewOfferItem -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="PenaltyAmount" minOccurs="0">
                 *         &lt;!-- Reference to inner class PenaltyAmount -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FeesAmount" minOccurs="0">
                 *         &lt;!-- Reference to inner class FeesAmount -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="ReshopDue">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:choice>
                 *               &lt;xs:element name="ByPassenger">
                 *                 &lt;xs:complexType>
                 *                   &lt;xs:sequence>
                 *                     &lt;xs:element ref="ns:Total"/>
                 *                   &lt;/xs:sequence>
                 *                 &lt;/xs:complexType>
                 *               &lt;/xs:element>
                 *               &lt;xs:element name="ByAirline">
                 *                 &lt;xs:complexType>
                 *                   &lt;xs:sequence>
                 *                     &lt;xs:element ref="ns:Total"/>
                 *                   &lt;/xs:sequence>
                 *                 &lt;/xs:complexType>
                 *               &lt;/xs:element>
                 *             &lt;/xs:choice>
                 *             &lt;xs:element type="ns:TaxDetailType" name="Taxes" minOccurs="0"/>
                 *           &lt;/xs:sequence>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ReshopDifferential implements Serializable
                {
                    private OriginalOrderItem originalOrderItem;
                    private NewOfferItem newOfferItem;
                    private PenaltyAmount penaltyAmount;
                    private FeesAmount feesAmount;
                    private int reshopDueChoiceSelect = -1;
                    private static final int RESHOP_DUE_BY_PASSENGER_CHOICE = 0;
                    private static final int RESHOP_DUE_BY_AIRLINE_CHOICE = 1;
                    private TotalFareTransactionType reshopDueByPassenger;
                    private TotalFareTransactionType reshopDueByAirline;
                    private TaxDetailType reshopDueTaxes;

                    /** 
                     * Get the 'OriginalOrderItem' element value.
                     * 
                     * @return value
                     */
                    public OriginalOrderItem getOriginalOrderItem() {
                        return originalOrderItem;
                    }

                    /** 
                     * Set the 'OriginalOrderItem' element value.
                     * 
                     * @param originalOrderItem
                     */
                    public void setOriginalOrderItem(
                            OriginalOrderItem originalOrderItem) {
                        this.originalOrderItem = originalOrderItem;
                    }

                    /** 
                     * Get the 'NewOfferItem' element value.
                     * 
                     * @return value
                     */
                    public NewOfferItem getNewOfferItem() {
                        return newOfferItem;
                    }

                    /** 
                     * Set the 'NewOfferItem' element value.
                     * 
                     * @param newOfferItem
                     */
                    public void setNewOfferItem(NewOfferItem newOfferItem) {
                        this.newOfferItem = newOfferItem;
                    }

                    /** 
                     * Get the 'PenaltyAmount' element value.
                     * 
                     * @return value
                     */
                    public PenaltyAmount getPenaltyAmount() {
                        return penaltyAmount;
                    }

                    /** 
                     * Set the 'PenaltyAmount' element value.
                     * 
                     * @param penaltyAmount
                     */
                    public void setPenaltyAmount(PenaltyAmount penaltyAmount) {
                        this.penaltyAmount = penaltyAmount;
                    }

                    /** 
                     * Get the 'FeesAmount' element value.
                     * 
                     * @return value
                     */
                    public FeesAmount getFeesAmount() {
                        return feesAmount;
                    }

                    /** 
                     * Set the 'FeesAmount' element value.
                     * 
                     * @param feesAmount
                     */
                    public void setFeesAmount(FeesAmount feesAmount) {
                        this.feesAmount = feesAmount;
                    }

                    private void setReshopDueChoiceSelect(int choice) {
                        if (reshopDueChoiceSelect == -1) {
                            reshopDueChoiceSelect = choice;
                        } else if (reshopDueChoiceSelect != choice) {
                            throw new IllegalStateException(
                                    "Need to call clearReshopDueChoiceSelect() before changing existing choice");
                        }
                    }

                    /** 
                     * Clear the choice selection.
                     */
                    public void clearReshopDueChoiceSelect() {
                        reshopDueChoiceSelect = -1;
                    }

                    /** 
                     * Check if ReshopDueByPassenger is current selection for choice.
                     * 
                     * @return <code>true</code> if selection, <code>false</code> if not
                     */
                    public boolean ifReshopDueByPassenger() {
                        return reshopDueChoiceSelect == RESHOP_DUE_BY_PASSENGER_CHOICE;
                    }

                    /** 
                     * Get the 'Total' element value. Use when reshop is due by Passenger.
                     * 
                     * @return value
                     */
                    public TotalFareTransactionType getReshopDueByPassenger() {
                        return reshopDueByPassenger;
                    }

                    /** 
                     * Set the 'Total' element value. Use when reshop is due by Passenger.
                     * 
                     * @param reshopDueByPassenger
                     */
                    public void setReshopDueByPassenger(
                            TotalFareTransactionType reshopDueByPassenger) {
                        setReshopDueChoiceSelect(RESHOP_DUE_BY_PASSENGER_CHOICE);
                        this.reshopDueByPassenger = reshopDueByPassenger;
                    }

                    /** 
                     * Check if ReshopDueByAirline is current selection for choice.
                     * 
                     * @return <code>true</code> if selection, <code>false</code> if not
                     */
                    public boolean ifReshopDueByAirline() {
                        return reshopDueChoiceSelect == RESHOP_DUE_BY_AIRLINE_CHOICE;
                    }

                    /** 
                     * Get the 'Total' element value. Use when reshop is due by Airline.
                     * 
                     * @return value
                     */
                    public TotalFareTransactionType getReshopDueByAirline() {
                        return reshopDueByAirline;
                    }

                    /** 
                     * Set the 'Total' element value. Use when reshop is due by Airline.
                     * 
                     * @param reshopDueByAirline
                     */
                    public void setReshopDueByAirline(
                            TotalFareTransactionType reshopDueByAirline) {
                        setReshopDueChoiceSelect(RESHOP_DUE_BY_AIRLINE_CHOICE);
                        this.reshopDueByAirline = reshopDueByAirline;
                    }

                    /** 
                     * Get the 'Taxes' element value. Tax Information.
                     * 
                     * @return value
                     */
                    public TaxDetailType getReshopDueTaxes() {
                        return reshopDueTaxes;
                    }

                    /** 
                     * Set the 'Taxes' element value. Tax Information.
                     * 
                     * @param reshopDueTaxes
                     */
                    public void setReshopDueTaxes(TaxDetailType reshopDueTaxes) {
                        this.reshopDueTaxes = reshopDueTaxes;
                    }
                    /** 
                     * Original order fare details.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginalOrderItem" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element ref="ns:Total"/>
                     *       &lt;xs:element type="ns:TaxDetailType" name="Taxes" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class OriginalOrderItem implements
                        Serializable
                    {
                        private TotalFareTransactionType total;
                        private TaxDetailType taxes;

                        /** 
                         * Get the 'Total' element value.
                         * 
                         * @return value
                         */
                        public TotalFareTransactionType getTotal() {
                            return total;
                        }

                        /** 
                         * Set the 'Total' element value.
                         * 
                         * @param total
                         */
                        public void setTotal(TotalFareTransactionType total) {
                            this.total = total;
                        }

                        /** 
                         * Get the 'Taxes' element value. Tax Information.
                         * 
                         * @return value
                         */
                        public TaxDetailType getTaxes() {
                            return taxes;
                        }

                        /** 
                         * Set the 'Taxes' element value. Tax Information.
                         * 
                         * @param taxes
                         */
                        public void setTaxes(TaxDetailType taxes) {
                            this.taxes = taxes;
                        }
                    }
                    /** 
                     * New order offer fare details.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NewOfferItem" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element ref="ns:Total"/>
                     *       &lt;xs:element type="ns:TaxDetailType" name="Taxes" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class NewOfferItem implements Serializable
                    {
                        private TotalFareTransactionType total;
                        private TaxDetailType taxes;

                        /** 
                         * Get the 'Total' element value.
                         * 
                         * @return value
                         */
                        public TotalFareTransactionType getTotal() {
                            return total;
                        }

                        /** 
                         * Set the 'Total' element value.
                         * 
                         * @param total
                         */
                        public void setTotal(TotalFareTransactionType total) {
                            this.total = total;
                        }

                        /** 
                         * Get the 'Taxes' element value. Tax Information.
                         * 
                         * @return value
                         */
                        public TaxDetailType getTaxes() {
                            return taxes;
                        }

                        /** 
                         * Set the 'Taxes' element value. Tax Information.
                         * 
                         * @param taxes
                         */
                        public void setTaxes(TaxDetailType taxes) {
                            this.taxes = taxes;
                        }
                    }
                    /** 
                     * Penalty fare details.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PenaltyAmount" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element ref="ns:Total"/>
                     *       &lt;xs:element type="ns:TaxDetailType" name="Taxes" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class PenaltyAmount implements Serializable
                    {
                        private TotalFareTransactionType total;
                        private TaxDetailType taxes;

                        /** 
                         * Get the 'Total' element value.
                         * 
                         * @return value
                         */
                        public TotalFareTransactionType getTotal() {
                            return total;
                        }

                        /** 
                         * Set the 'Total' element value.
                         * 
                         * @param total
                         */
                        public void setTotal(TotalFareTransactionType total) {
                            this.total = total;
                        }

                        /** 
                         * Get the 'Taxes' element value. Tax Information.
                         * 
                         * @return value
                         */
                        public TaxDetailType getTaxes() {
                            return taxes;
                        }

                        /** 
                         * Set the 'Taxes' element value. Tax Information.
                         * 
                         * @param taxes
                         */
                        public void setTaxes(TaxDetailType taxes) {
                            this.taxes = taxes;
                        }
                    }
                    /** 
                     * Fees information.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FeesAmount" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element ref="ns:Total"/>
                     *       &lt;xs:element type="ns:TaxDetailType" name="Taxes" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class FeesAmount implements Serializable
                    {
                        private TotalFareTransactionType total;
                        private TaxDetailType taxes;

                        /** 
                         * Get the 'Total' element value.
                         * 
                         * @return value
                         */
                        public TotalFareTransactionType getTotal() {
                            return total;
                        }

                        /** 
                         * Set the 'Total' element value.
                         * 
                         * @param total
                         */
                        public void setTotal(TotalFareTransactionType total) {
                            this.total = total;
                        }

                        /** 
                         * Get the 'Taxes' element value. Tax Information.
                         * 
                         * @return value
                         */
                        public TaxDetailType getTaxes() {
                            return taxes;
                        }

                        /** 
                         * Set the 'Taxes' element value. Tax Information.
                         * 
                         * @param taxes
                         */
                        public void setTaxes(TaxDetailType taxes) {
                            this.taxes = taxes;
                        }
                    }
                }
            }
            /** 
             * Offers presented in response to a shopping query from the “Add” function in OrderReshopRQ. If original query also specified items for deletion, the suggested Offers/OfferItems here could be meant to replace the OrderItems specified in the request's Delete function – the differential in price would then be presented in the “ReshopDifferential” structure.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AddOfferItem" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:complexContent>
             *       &lt;xs:extension base="ns:OfferItemType">
             *         &lt;xs:sequence>
             *           &lt;xs:element name="ReshopDifferential" minOccurs="0">
             *             &lt;!-- Reference to inner class ReshopDifferential -->
             *           &lt;/xs:element>
             *         &lt;/xs:sequence>
             *         &lt;xs:attribute type="xs:string" name="OrderItemIDs"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:complexContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AddOfferItem extends OfferItemType implements
                Serializable
            {
                private ReshopDifferential reshopDifferential;
                private String orderItemIDs;

                /** 
                 * Get the 'ReshopDifferential' element value.
                 * 
                 * @return value
                 */
                public ReshopDifferential getReshopDifferential() {
                    return reshopDifferential;
                }

                /** 
                 * Set the 'ReshopDifferential' element value.
                 * 
                 * @param reshopDifferential
                 */
                public void setReshopDifferential(
                        ReshopDifferential reshopDifferential) {
                    this.reshopDifferential = reshopDifferential;
                }

                /** 
                 * Get the 'OrderItemIDs' attribute value. Reference to one or more OrderItems that are going to be replaced by this OfferItem.
                 * 
                 * @return value
                 */
                public String getOrderItemIDs() {
                    return orderItemIDs;
                }

                /** 
                 * Set the 'OrderItemIDs' attribute value. Reference to one or more OrderItems that are going to be replaced by this OfferItem.
                 * 
                 * @param orderItemIDs
                 */
                public void setOrderItemIDs(String orderItemIDs) {
                    this.orderItemIDs = orderItemIDs;
                }
                /** 
                 * It contains the Original order amount, new offer amount, penalty details, fees and due by details. It also contains the taxes information.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReshopDifferential" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="OriginalOrderItem" minOccurs="0">
                 *         &lt;!-- Reference to inner class OriginalOrderItem -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="NewOfferItem" minOccurs="0">
                 *         &lt;!-- Reference to inner class NewOfferItem -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="PenaltyAmount" minOccurs="0">
                 *         &lt;!-- Reference to inner class PenaltyAmount -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FeesAmount" minOccurs="0">
                 *         &lt;!-- Reference to inner class FeesAmount -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="ReshopDue">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:choice>
                 *               &lt;xs:element name="ByPassenger">
                 *                 &lt;xs:complexType>
                 *                   &lt;xs:sequence>
                 *                     &lt;xs:element ref="ns:Total"/>
                 *                   &lt;/xs:sequence>
                 *                 &lt;/xs:complexType>
                 *               &lt;/xs:element>
                 *               &lt;xs:element name="ByAirline">
                 *                 &lt;xs:complexType>
                 *                   &lt;xs:sequence>
                 *                     &lt;xs:element ref="ns:Total"/>
                 *                   &lt;/xs:sequence>
                 *                 &lt;/xs:complexType>
                 *               &lt;/xs:element>
                 *             &lt;/xs:choice>
                 *             &lt;xs:element type="ns:TaxDetailType" name="Taxes" minOccurs="0"/>
                 *           &lt;/xs:sequence>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ReshopDifferential implements Serializable
                {
                    private OriginalOrderItem originalOrderItem;
                    private NewOfferItem newOfferItem;
                    private PenaltyAmount penaltyAmount;
                    private FeesAmount feesAmount;
                    private int reshopDueChoiceSelect = -1;
                    private static final int RESHOP_DUE_BY_PASSENGER_CHOICE = 0;
                    private static final int RESHOP_DUE_BY_AIRLINE_CHOICE = 1;
                    private TotalFareTransactionType reshopDueByPassenger;
                    private TotalFareTransactionType reshopDueByAirline;
                    private TaxDetailType reshopDueTaxes;

                    /** 
                     * Get the 'OriginalOrderItem' element value.
                     * 
                     * @return value
                     */
                    public OriginalOrderItem getOriginalOrderItem() {
                        return originalOrderItem;
                    }

                    /** 
                     * Set the 'OriginalOrderItem' element value.
                     * 
                     * @param originalOrderItem
                     */
                    public void setOriginalOrderItem(
                            OriginalOrderItem originalOrderItem) {
                        this.originalOrderItem = originalOrderItem;
                    }

                    /** 
                     * Get the 'NewOfferItem' element value.
                     * 
                     * @return value
                     */
                    public NewOfferItem getNewOfferItem() {
                        return newOfferItem;
                    }

                    /** 
                     * Set the 'NewOfferItem' element value.
                     * 
                     * @param newOfferItem
                     */
                    public void setNewOfferItem(NewOfferItem newOfferItem) {
                        this.newOfferItem = newOfferItem;
                    }

                    /** 
                     * Get the 'PenaltyAmount' element value.
                     * 
                     * @return value
                     */
                    public PenaltyAmount getPenaltyAmount() {
                        return penaltyAmount;
                    }

                    /** 
                     * Set the 'PenaltyAmount' element value.
                     * 
                     * @param penaltyAmount
                     */
                    public void setPenaltyAmount(PenaltyAmount penaltyAmount) {
                        this.penaltyAmount = penaltyAmount;
                    }

                    /** 
                     * Get the 'FeesAmount' element value.
                     * 
                     * @return value
                     */
                    public FeesAmount getFeesAmount() {
                        return feesAmount;
                    }

                    /** 
                     * Set the 'FeesAmount' element value.
                     * 
                     * @param feesAmount
                     */
                    public void setFeesAmount(FeesAmount feesAmount) {
                        this.feesAmount = feesAmount;
                    }

                    private void setReshopDueChoiceSelect(int choice) {
                        if (reshopDueChoiceSelect == -1) {
                            reshopDueChoiceSelect = choice;
                        } else if (reshopDueChoiceSelect != choice) {
                            throw new IllegalStateException(
                                    "Need to call clearReshopDueChoiceSelect() before changing existing choice");
                        }
                    }

                    /** 
                     * Clear the choice selection.
                     */
                    public void clearReshopDueChoiceSelect() {
                        reshopDueChoiceSelect = -1;
                    }

                    /** 
                     * Check if ReshopDueByPassenger is current selection for choice.
                     * 
                     * @return <code>true</code> if selection, <code>false</code> if not
                     */
                    public boolean ifReshopDueByPassenger() {
                        return reshopDueChoiceSelect == RESHOP_DUE_BY_PASSENGER_CHOICE;
                    }

                    /** 
                     * Get the 'Total' element value. Use when reshop is due by Passenger.
                     * 
                     * @return value
                     */
                    public TotalFareTransactionType getReshopDueByPassenger() {
                        return reshopDueByPassenger;
                    }

                    /** 
                     * Set the 'Total' element value. Use when reshop is due by Passenger.
                     * 
                     * @param reshopDueByPassenger
                     */
                    public void setReshopDueByPassenger(
                            TotalFareTransactionType reshopDueByPassenger) {
                        setReshopDueChoiceSelect(RESHOP_DUE_BY_PASSENGER_CHOICE);
                        this.reshopDueByPassenger = reshopDueByPassenger;
                    }

                    /** 
                     * Check if ReshopDueByAirline is current selection for choice.
                     * 
                     * @return <code>true</code> if selection, <code>false</code> if not
                     */
                    public boolean ifReshopDueByAirline() {
                        return reshopDueChoiceSelect == RESHOP_DUE_BY_AIRLINE_CHOICE;
                    }

                    /** 
                     * Get the 'Total' element value. Use when reshop is due by Airline.
                     * 
                     * @return value
                     */
                    public TotalFareTransactionType getReshopDueByAirline() {
                        return reshopDueByAirline;
                    }

                    /** 
                     * Set the 'Total' element value. Use when reshop is due by Airline.
                     * 
                     * @param reshopDueByAirline
                     */
                    public void setReshopDueByAirline(
                            TotalFareTransactionType reshopDueByAirline) {
                        setReshopDueChoiceSelect(RESHOP_DUE_BY_AIRLINE_CHOICE);
                        this.reshopDueByAirline = reshopDueByAirline;
                    }

                    /** 
                     * Get the 'Taxes' element value. Tax Information.
                     * 
                     * @return value
                     */
                    public TaxDetailType getReshopDueTaxes() {
                        return reshopDueTaxes;
                    }

                    /** 
                     * Set the 'Taxes' element value. Tax Information.
                     * 
                     * @param reshopDueTaxes
                     */
                    public void setReshopDueTaxes(TaxDetailType reshopDueTaxes) {
                        this.reshopDueTaxes = reshopDueTaxes;
                    }
                    /** 
                     * Original order fare details.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginalOrderItem" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element ref="ns:Total"/>
                     *       &lt;xs:element type="ns:TaxDetailType" name="Taxes" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class OriginalOrderItem implements
                        Serializable
                    {
                        private TotalFareTransactionType total;
                        private TaxDetailType taxes;

                        /** 
                         * Get the 'Total' element value.
                         * 
                         * @return value
                         */
                        public TotalFareTransactionType getTotal() {
                            return total;
                        }

                        /** 
                         * Set the 'Total' element value.
                         * 
                         * @param total
                         */
                        public void setTotal(TotalFareTransactionType total) {
                            this.total = total;
                        }

                        /** 
                         * Get the 'Taxes' element value. Tax Information.
                         * 
                         * @return value
                         */
                        public TaxDetailType getTaxes() {
                            return taxes;
                        }

                        /** 
                         * Set the 'Taxes' element value. Tax Information.
                         * 
                         * @param taxes
                         */
                        public void setTaxes(TaxDetailType taxes) {
                            this.taxes = taxes;
                        }
                    }
                    /** 
                     * New order offer fare details.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NewOfferItem" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element ref="ns:Total"/>
                     *       &lt;xs:element type="ns:TaxDetailType" name="Taxes" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class NewOfferItem implements Serializable
                    {
                        private TotalFareTransactionType total;
                        private TaxDetailType taxes;

                        /** 
                         * Get the 'Total' element value.
                         * 
                         * @return value
                         */
                        public TotalFareTransactionType getTotal() {
                            return total;
                        }

                        /** 
                         * Set the 'Total' element value.
                         * 
                         * @param total
                         */
                        public void setTotal(TotalFareTransactionType total) {
                            this.total = total;
                        }

                        /** 
                         * Get the 'Taxes' element value. Tax Information.
                         * 
                         * @return value
                         */
                        public TaxDetailType getTaxes() {
                            return taxes;
                        }

                        /** 
                         * Set the 'Taxes' element value. Tax Information.
                         * 
                         * @param taxes
                         */
                        public void setTaxes(TaxDetailType taxes) {
                            this.taxes = taxes;
                        }
                    }
                    /** 
                     * Penalty fare details.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PenaltyAmount" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element ref="ns:Total"/>
                     *       &lt;xs:element type="ns:TaxDetailType" name="Taxes" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class PenaltyAmount implements Serializable
                    {
                        private TotalFareTransactionType total;
                        private TaxDetailType taxes;

                        /** 
                         * Get the 'Total' element value.
                         * 
                         * @return value
                         */
                        public TotalFareTransactionType getTotal() {
                            return total;
                        }

                        /** 
                         * Set the 'Total' element value.
                         * 
                         * @param total
                         */
                        public void setTotal(TotalFareTransactionType total) {
                            this.total = total;
                        }

                        /** 
                         * Get the 'Taxes' element value. Tax Information.
                         * 
                         * @return value
                         */
                        public TaxDetailType getTaxes() {
                            return taxes;
                        }

                        /** 
                         * Set the 'Taxes' element value. Tax Information.
                         * 
                         * @param taxes
                         */
                        public void setTaxes(TaxDetailType taxes) {
                            this.taxes = taxes;
                        }
                    }
                    /** 
                     * Fees information.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FeesAmount" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element ref="ns:Total"/>
                     *       &lt;xs:element type="ns:TaxDetailType" name="Taxes" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class FeesAmount implements Serializable
                    {
                        private TotalFareTransactionType total;
                        private TaxDetailType taxes;

                        /** 
                         * Get the 'Total' element value.
                         * 
                         * @return value
                         */
                        public TotalFareTransactionType getTotal() {
                            return total;
                        }

                        /** 
                         * Set the 'Total' element value.
                         * 
                         * @param total
                         */
                        public void setTotal(TotalFareTransactionType total) {
                            this.total = total;
                        }

                        /** 
                         * Get the 'Taxes' element value. Tax Information.
                         * 
                         * @return value
                         */
                        public TaxDetailType getTaxes() {
                            return taxes;
                        }

                        /** 
                         * Set the 'Taxes' element value. Tax Information.
                         * 
                         * @param taxes
                         */
                        public void setTaxes(TaxDetailType taxes) {
                            this.taxes = taxes;
                        }
                    }
                }
            }
            /** 
             * Function to request a change and/or correction to a passenger name for the specified Order.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NameChangeOfferItem" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:complexContent>
             *       &lt;xs:extension base="ns:NameChangeOfferItemType">
             *         &lt;xs:sequence>
             *           &lt;xs:element name="NameChange" minOccurs="0">
             *             &lt;!-- Reference to inner class NameChange -->
             *           &lt;/xs:element>
             *         &lt;/xs:sequence>
             *       &lt;/xs:extension>
             *     &lt;/xs:complexContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class NameChangeOfferItem
                    extends
                        NameChangeOfferItemType implements Serializable
            {
                private NameChange nameChange;

                /** 
                 * Get the 'NameChange' element value.
                 * 
                 * @return value
                 */
                public NameChange getNameChange() {
                    return nameChange;
                }

                /** 
                 * Set the 'NameChange' element value.
                 * 
                 * @param nameChange
                 */
                public void setNameChange(NameChange nameChange) {
                    this.nameChange = nameChange;
                }
                /** 
                 * Structure to echo back the name changes allowed by the Airline, packaged within an OfferItem
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NameChange" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="PassengerID"/>
                 *       &lt;xs:element type="xs:string" name="NameTitle" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="GivenName" minOccurs="0" maxOccurs="5"/>
                 *       &lt;xs:element type="xs:string" name="MiddleName" minOccurs="0" maxOccurs="3"/>
                 *       &lt;xs:element type="xs:string" name="Surname" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="SurnameSuffix" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class NameChange implements Serializable
                {
                    private String passengerID;
                    private String nameTitle;
                    private List<String> givenNameList = new ArrayList<String>();
                    private List<String> middleNameList = new ArrayList<String>();
                    private String surname;
                    private String surnameSuffix;

                    /** 
                     * Get the 'PassengerID' element value. Identifier of the Passenger within the Order in the Order Management System. This is the PassengerID that is assigned at the time of Order creation by the Airline.
                     * 
                     * @return value
                     */
                    public String getPassengerID() {
                        return passengerID;
                    }

                    /** 
                     * Set the 'PassengerID' element value. Identifier of the Passenger within the Order in the Order Management System. This is the PassengerID that is assigned at the time of Order creation by the Airline.
                     * 
                     * @param passengerID
                     */
                    public void setPassengerID(String passengerID) {
                        this.passengerID = passengerID;
                    }

                    /** 
                     * Get the 'NameTitle' element value. Individual's name title. Examples: MR, MRS, DRn.
                     * 
                     * @return value
                     */
                    public String getNameTitle() {
                        return nameTitle;
                    }

                    /** 
                     * Set the 'NameTitle' element value. Individual's name title. Examples: MR, MRS, DRn.
                     * 
                     * @param nameTitle
                     */
                    public void setNameTitle(String nameTitle) {
                        this.nameTitle = nameTitle;
                    }

                    /** 
                     * Get the list of 'GivenName' element items. Individual's first or given name. Example: JOHN.
                     * 
                     * @return list
                     */
                    public List<String> getGivenNameList() {
                        return givenNameList;
                    }

                    /** 
                     * Set the list of 'GivenName' element items. Individual's first or given name. Example: JOHN.
                     * 
                     * @param list
                     */
                    public void setGivenNameList(List<String> list) {
                        givenNameList = list;
                    }

                    /** 
                     * Get the list of 'MiddleName' element items. Individual's middle name or initial.  Examples: G, GEORGE
                     * 
                     * @return list
                     */
                    public List<String> getMiddleNameList() {
                        return middleNameList;
                    }

                    /** 
                     * Set the list of 'MiddleName' element items. Individual's middle name or initial.  Examples: G, GEORGE
                     * 
                     * @param list
                     */
                    public void setMiddleNameList(List<String> list) {
                        middleNameList = list;
                    }

                    /** 
                     * Get the 'Surname' element value. Individual's family name, last name. Example: SMITH.
                     * 
                     * @return value
                     */
                    public String getSurname() {
                        return surname;
                    }

                    /** 
                     * Set the 'Surname' element value. Individual's family name, last name. Example: SMITH.
                     * 
                     * @param surname
                     */
                    public void setSurname(String surname) {
                        this.surname = surname;
                    }

                    /** 
                     * Get the 'SurnameSuffix' element value. Individual's surname suffixes and letters. Examples: Jr., Sr., III, Ret., Esq.
                     * 
                     * @return value
                     */
                    public String getSurnameSuffix() {
                        return surnameSuffix;
                    }

                    /** 
                     * Set the 'SurnameSuffix' element value. Individual's surname suffixes and letters. Examples: Jr., Sr., III, Ret., Esq.
                     * 
                     * @param surnameSuffix
                     */
                    public void setSurnameSuffix(String surnameSuffix) {
                        this.surnameSuffix = surnameSuffix;
                    }
                }
            }
            /** 
             * This block contains references to the Baggage Allowance characteristics (no. of pieces / weight / dimensions, etc) included in the Flight services for one or more Passengers.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageAllowance" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="FlightRefs"/>
             *       &lt;xs:element type="xs:string" name="PassengerRefs"/>
             *       &lt;xs:element type="xs:string" name="BaggageAllowanceRef"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BaggageAllowance implements Serializable
            {
                private String flightRefs;
                private String passengerRefs;
                private String baggageAllowanceRef;

                /** 
                 * Get the 'FlightRefs' element value. Reference to FlightIDs in DataLists
                 * 
                 * @return value
                 */
                public String getFlightRefs() {
                    return flightRefs;
                }

                /** 
                 * Set the 'FlightRefs' element value. Reference to FlightIDs in DataLists
                 * 
                 * @param flightRefs
                 */
                public void setFlightRefs(String flightRefs) {
                    this.flightRefs = flightRefs;
                }

                /** 
                 * Get the 'PassengerRefs' element value. Reference to PassengerIDs in DataLists
                 * 
                 * @return value
                 */
                public String getPassengerRefs() {
                    return passengerRefs;
                }

                /** 
                 * Set the 'PassengerRefs' element value. Reference to PassengerIDs in DataLists
                 * 
                 * @param passengerRefs
                 */
                public void setPassengerRefs(String passengerRefs) {
                    this.passengerRefs = passengerRefs;
                }

                /** 
                 * Get the 'BaggageAllowanceRef' element value. Reference to BaggageAllowanceIDs in DataLists
                 * 
                 * @return value
                 */
                public String getBaggageAllowanceRef() {
                    return baggageAllowanceRef;
                }

                /** 
                 * Set the 'BaggageAllowanceRef' element value. Reference to BaggageAllowanceIDs in DataLists
                 * 
                 * @param baggageAllowanceRef
                 */
                public void setBaggageAllowanceRef(String baggageAllowanceRef) {
                    this.baggageAllowanceRef = baggageAllowanceRef;
                }
            }
        }
        /** 
         * Container for standalone optional OfferItems. This supports the shopping basket concept. The main purpose of this structure is to reduce the size of the message by inserting Offer Items which are applicable to multiple flight-related Offers defined above.

        NB. For the OfferID of the ALaCarteOffer: Default OfferID identifier for A La Carte Offer Items in a scenario where items here are not selected for a flight-related Offer above.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ALaCarteOffer" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:OfferType">
         *         &lt;xs:sequence>
         *           &lt;xs:element type="ns:ALaCarteOfferItemType" name="ALaCarteOfferItem" maxOccurs="unbounded"/>
         *         &lt;/xs:sequence>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ALaCarteOffer extends OfferType implements
            Serializable
        {
            private List<ALaCarteOfferItemType> ALaCarteOfferItemList = new ArrayList<ALaCarteOfferItemType>();

            /** 
             * Get the list of 'ALaCarteOfferItem' element items. One Service or Service  Bundle which is priced per unit. A La Carte Offer Items are optional and variable quantities of these can be selected by any of the eligible passengers for the applicable segments and/or price classes.
             * 
             * @return list
             */
            public List<ALaCarteOfferItemType> getALaCarteOfferItemList() {
                return ALaCarteOfferItemList;
            }

            /** 
             * Set the list of 'ALaCarteOfferItem' element items. One Service or Service  Bundle which is priced per unit. A La Carte Offer Items are optional and variable quantities of these can be selected by any of the eligible passengers for the applicable segments and/or price classes.
             * 
             * @param list
             */
            public void setALaCarteOfferItemList(
                    List<ALaCarteOfferItemType> list) {
                ALaCarteOfferItemList = list;
            }
        }
    }
    /** 
     * Offers presented in response to a reprice request in the OrderReshopRQ. If there is a change in the price of the Order, these Offers may be subsequently accepted in the OrderChangeRQ and the repriced OrderItems (returned as OfferItems) will then replace the old OrderItems.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RepricedOfferItem" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="TotalPriceDetail">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element name="TotalAmount">
     *               &lt;xs:complexType>
     *                 &lt;xs:choice>
     *                   &lt;xs:element ref="ns:AwardPricing"/>
     *                   &lt;xs:element ref="ns:CombinationPricing"/>
     *                   &lt;xs:element ref="ns:DetailCurrencyPrice"/>
     *                   &lt;xs:element ref="ns:EncodedCurrencyPrice"/>
     *                   &lt;xs:element ref="ns:SimpleCurrencyPrice"/>
     *                 &lt;/xs:choice>
     *               &lt;/xs:complexType>
     *             &lt;/xs:element>
     *             &lt;xs:element type="ns:CurrencyAmountOptType" name="BaseAmount" minOccurs="0"/>
     *             &lt;xs:element ref="ns:FareFiledIn" minOccurs="0"/>
     *             &lt;xs:element type="ns:DiscountType" name="Discount" minOccurs="0"/>
     *             &lt;xs:element name="Surcharges" minOccurs="0">
     *               &lt;!-- Reference to inner class Surcharges -->
     *             &lt;/xs:element>
     *             &lt;xs:element type="ns:TaxDetailType" name="Taxes" minOccurs="0"/>
     *             &lt;xs:element ref="ns:TaxExemption" minOccurs="0"/>
     *             &lt;xs:choice minOccurs="0">
     *               &lt;!-- Reference to inner class Choice -->
     *             &lt;/xs:choice>
     *             &lt;xs:element type="ns:FeeSurchargeType" name="Fees" minOccurs="0"/>
     *           &lt;/xs:sequence>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:FareDetailType" name="FareDetail" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element name="OriginalOrderItem">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element name="TotalPriceDetail">
     *               &lt;xs:complexType>
     *                 &lt;xs:sequence>
     *                   &lt;xs:element name="TotalAmount">
     *                     &lt;xs:complexType>
     *                       &lt;xs:choice>
     *                         &lt;xs:element ref="ns:AwardPricing"/>
     *                         &lt;xs:element ref="ns:CombinationPricing"/>
     *                         &lt;xs:element ref="ns:DetailCurrencyPrice"/>
     *                         &lt;xs:element ref="ns:EncodedCurrencyPrice"/>
     *                         &lt;xs:element ref="ns:SimpleCurrencyPrice"/>
     *                       &lt;/xs:choice>
     *                     &lt;/xs:complexType>
     *                   &lt;/xs:element>
     *                   &lt;xs:element type="ns:CurrencyAmountOptType" name="BaseAmount" minOccurs="0"/>
     *                   &lt;xs:element ref="ns:FareFiledIn" minOccurs="0"/>
     *                   &lt;xs:element type="ns:DiscountType" name="Discount" minOccurs="0"/>
     *                   &lt;xs:element name="Surcharges" minOccurs="0">
     *                     &lt;!-- Reference to inner class Surcharges1 -->
     *                   &lt;/xs:element>
     *                   &lt;xs:element type="ns:TaxDetailType" name="Taxes" minOccurs="0"/>
     *                   &lt;xs:element ref="ns:TaxExemption" minOccurs="0"/>
     *                   &lt;xs:choice minOccurs="0">
     *                     &lt;!-- Reference to inner class Choice1 -->
     *                   &lt;/xs:choice>
     *                   &lt;xs:element type="ns:FeeSurchargeType" name="Fees" minOccurs="0"/>
     *                 &lt;/xs:sequence>
     *               &lt;/xs:complexType>
     *             &lt;/xs:element>
     *             &lt;xs:element type="ns:FareDetailType" name="FareDetail" minOccurs="0" maxOccurs="unbounded"/>
     *           &lt;/xs:sequence>
     *           &lt;xs:attribute type="xs:string" use="required" name="OrderItemID"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="required" name="OfferItemID"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class RepricedOfferItem implements Serializable
    {
        private int totalPriceDetailTotalAmountSelect = -1;
        private static final int TOTAL_PRICE_DETAIL_AWARD_PRICING_CHOICE = 0;
        private static final int TOTAL_PRICE_DETAIL_COMBINATION_PRICING_CHOICE = 1;
        private static final int TOTAL_PRICE_DETAIL_DETAIL_CURRENCY_PRICE_CHOICE = 2;
        private static final int TOTAL_PRICE_DETAIL_ENCODED_CURRENCY_PRICE_CHOICE = 3;
        private static final int TOTAL_PRICE_DETAIL_SIMPLE_CURRENCY_PRICE_CHOICE = 4;
        private AwardPriceUnitType totalPriceDetailAwardPricing;
        private CombinationPriceType totalPriceDetailCombinationPricing;
        private DetailCurrencyPriceType totalPriceDetailDetailCurrencyPrice;
        private EncodedCurrencyPrice totalPriceDetailEncodedCurrencyPrice;
        private SimpleCurrencyPrice totalPriceDetailSimpleCurrencyPrice;
        private CurrencyAmountOptType totalPriceDetailBaseAmount;
        private FareFilingType totalPriceDetailFareFiledIn;
        private DiscountType totalPriceDetailDiscount;
        private Surcharges surcharges;
        private TaxDetailType totalPriceDetailTaxes;
        private TaxExemptionType totalPriceDetailTaxExemption;
        private Choice choice;
        private FeeSurchargeType totalPriceDetailFees;
        private List<FareDetailType> fareDetailList = new ArrayList<FareDetailType>();
        private int originalOrderItemTotalAmountSelect = -1;
        private static final int ORIGINAL_ORDER_ITEM_AWARD_PRICING_CHOICE = 0;
        private static final int ORIGINAL_ORDER_ITEM_COMBINATION_PRICING_CHOICE = 1;
        private static final int ORIGINAL_ORDER_ITEM_DETAIL_CURRENCY_PRICE_CHOICE = 2;
        private static final int ORIGINAL_ORDER_ITEM_ENCODED_CURRENCY_PRICE_CHOICE = 3;
        private static final int ORIGINAL_ORDER_ITEM_SIMPLE_CURRENCY_PRICE_CHOICE = 4;
        private AwardPriceUnitType originalOrderItemAwardPricing;
        private CombinationPriceType originalOrderItemCombinationPricing;
        private DetailCurrencyPriceType originalOrderItemDetailCurrencyPrice;
        private EncodedCurrencyPrice originalOrderItemEncodedCurrencyPrice;
        private SimpleCurrencyPrice originalOrderItemSimpleCurrencyPrice;
        private CurrencyAmountOptType originalOrderItemBaseAmount;
        private FareFilingType originalOrderItemFareFiledIn;
        private DiscountType originalOrderItemDiscount;
        private Surcharges1 surcharges1;
        private TaxDetailType originalOrderItemTaxes;
        private TaxExemptionType originalOrderItemTaxExemption;
        private Choice1 choice1;
        private FeeSurchargeType originalOrderItemFees;
        private List<FareDetailType> originalOrderItemFareDetailList = new ArrayList<FareDetailType>();
        private String originalOrderItemOrderItemID;
        private String offerItemID;

        private void setTotalPriceDetailTotalAmountSelect(int choice) {
            if (totalPriceDetailTotalAmountSelect == -1) {
                totalPriceDetailTotalAmountSelect = choice;
            } else if (totalPriceDetailTotalAmountSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearTotalPriceDetailTotalAmountSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearTotalPriceDetailTotalAmountSelect() {
            totalPriceDetailTotalAmountSelect = -1;
        }

        /** 
         * Check if TotalPriceDetailAwardPricing is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTotalPriceDetailAwardPricing() {
            return totalPriceDetailTotalAmountSelect == TOTAL_PRICE_DETAIL_AWARD_PRICING_CHOICE;
        }

        /** 
         * Get the 'AwardPricing' element value.
         * 
         * @return value
         */
        public AwardPriceUnitType getTotalPriceDetailAwardPricing() {
            return totalPriceDetailAwardPricing;
        }

        /** 
         * Set the 'AwardPricing' element value.
         * 
         * @param totalPriceDetailAwardPricing
         */
        public void setTotalPriceDetailAwardPricing(
                AwardPriceUnitType totalPriceDetailAwardPricing) {
            setTotalPriceDetailTotalAmountSelect(TOTAL_PRICE_DETAIL_AWARD_PRICING_CHOICE);
            this.totalPriceDetailAwardPricing = totalPriceDetailAwardPricing;
        }

        /** 
         * Check if TotalPriceDetailCombinationPricing is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTotalPriceDetailCombinationPricing() {
            return totalPriceDetailTotalAmountSelect == TOTAL_PRICE_DETAIL_COMBINATION_PRICING_CHOICE;
        }

        /** 
         * Get the 'CombinationPricing' element value.
         * 
         * @return value
         */
        public CombinationPriceType getTotalPriceDetailCombinationPricing() {
            return totalPriceDetailCombinationPricing;
        }

        /** 
         * Set the 'CombinationPricing' element value.
         * 
         * @param totalPriceDetailCombinationPricing
         */
        public void setTotalPriceDetailCombinationPricing(
                CombinationPriceType totalPriceDetailCombinationPricing) {
            setTotalPriceDetailTotalAmountSelect(TOTAL_PRICE_DETAIL_COMBINATION_PRICING_CHOICE);
            this.totalPriceDetailCombinationPricing = totalPriceDetailCombinationPricing;
        }

        /** 
         * Check if TotalPriceDetailDetailCurrencyPrice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTotalPriceDetailDetailCurrencyPrice() {
            return totalPriceDetailTotalAmountSelect == TOTAL_PRICE_DETAIL_DETAIL_CURRENCY_PRICE_CHOICE;
        }

        /** 
         * Get the 'DetailCurrencyPrice' element value.
         * 
         * @return value
         */
        public DetailCurrencyPriceType getTotalPriceDetailDetailCurrencyPrice() {
            return totalPriceDetailDetailCurrencyPrice;
        }

        /** 
         * Set the 'DetailCurrencyPrice' element value.
         * 
         * @param totalPriceDetailDetailCurrencyPrice
         */
        public void setTotalPriceDetailDetailCurrencyPrice(
                DetailCurrencyPriceType totalPriceDetailDetailCurrencyPrice) {
            setTotalPriceDetailTotalAmountSelect(TOTAL_PRICE_DETAIL_DETAIL_CURRENCY_PRICE_CHOICE);
            this.totalPriceDetailDetailCurrencyPrice = totalPriceDetailDetailCurrencyPrice;
        }

        /** 
         * Check if TotalPriceDetailEncodedCurrencyPrice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTotalPriceDetailEncodedCurrencyPrice() {
            return totalPriceDetailTotalAmountSelect == TOTAL_PRICE_DETAIL_ENCODED_CURRENCY_PRICE_CHOICE;
        }

        /** 
         * Get the 'EncodedCurrencyPrice' element value.
         * 
         * @return value
         */
        public EncodedCurrencyPrice getTotalPriceDetailEncodedCurrencyPrice() {
            return totalPriceDetailEncodedCurrencyPrice;
        }

        /** 
         * Set the 'EncodedCurrencyPrice' element value.
         * 
         * @param totalPriceDetailEncodedCurrencyPrice
         */
        public void setTotalPriceDetailEncodedCurrencyPrice(
                EncodedCurrencyPrice totalPriceDetailEncodedCurrencyPrice) {
            setTotalPriceDetailTotalAmountSelect(TOTAL_PRICE_DETAIL_ENCODED_CURRENCY_PRICE_CHOICE);
            this.totalPriceDetailEncodedCurrencyPrice = totalPriceDetailEncodedCurrencyPrice;
        }

        /** 
         * Check if TotalPriceDetailSimpleCurrencyPrice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTotalPriceDetailSimpleCurrencyPrice() {
            return totalPriceDetailTotalAmountSelect == TOTAL_PRICE_DETAIL_SIMPLE_CURRENCY_PRICE_CHOICE;
        }

        /** 
         * Get the 'SimpleCurrencyPrice' element value.
         * 
         * @return value
         */
        public SimpleCurrencyPrice getTotalPriceDetailSimpleCurrencyPrice() {
            return totalPriceDetailSimpleCurrencyPrice;
        }

        /** 
         * Set the 'SimpleCurrencyPrice' element value.
         * 
         * @param totalPriceDetailSimpleCurrencyPrice
         */
        public void setTotalPriceDetailSimpleCurrencyPrice(
                SimpleCurrencyPrice totalPriceDetailSimpleCurrencyPrice) {
            setTotalPriceDetailTotalAmountSelect(TOTAL_PRICE_DETAIL_SIMPLE_CURRENCY_PRICE_CHOICE);
            this.totalPriceDetailSimpleCurrencyPrice = totalPriceDetailSimpleCurrencyPrice;
        }

        /** 
         * Get the 'BaseAmount' element value. Total Base Fare Amount.  Example: 200000

        Note: This includes  surcharges (if applicable).
         * 
         * @return value
         */
        public CurrencyAmountOptType getTotalPriceDetailBaseAmount() {
            return totalPriceDetailBaseAmount;
        }

        /** 
         * Set the 'BaseAmount' element value. Total Base Fare Amount.  Example: 200000

        Note: This includes  surcharges (if applicable).
         * 
         * @param totalPriceDetailBaseAmount
         */
        public void setTotalPriceDetailBaseAmount(
                CurrencyAmountOptType totalPriceDetailBaseAmount) {
            this.totalPriceDetailBaseAmount = totalPriceDetailBaseAmount;
        }

        /** 
         * Get the 'FareFiledIn' element value.
         * 
         * @return value
         */
        public FareFilingType getTotalPriceDetailFareFiledIn() {
            return totalPriceDetailFareFiledIn;
        }

        /** 
         * Set the 'FareFiledIn' element value.
         * 
         * @param totalPriceDetailFareFiledIn
         */
        public void setTotalPriceDetailFareFiledIn(
                FareFilingType totalPriceDetailFareFiledIn) {
            this.totalPriceDetailFareFiledIn = totalPriceDetailFareFiledIn;
        }

        /** 
         * Get the 'Discount' element value. Discount Information
         * 
         * @return value
         */
        public DiscountType getTotalPriceDetailDiscount() {
            return totalPriceDetailDiscount;
        }

        /** 
         * Set the 'Discount' element value. Discount Information
         * 
         * @param totalPriceDetailDiscount
         */
        public void setTotalPriceDetailDiscount(
                DiscountType totalPriceDetailDiscount) {
            this.totalPriceDetailDiscount = totalPriceDetailDiscount;
        }

        /** 
         * Get the 'Surcharges' element value. Total price reflecting all services for all passengers across all segments referenced within this Offer Item.
         * 
         * @return value
         */
        public Surcharges getSurcharges() {
            return surcharges;
        }

        /** 
         * Set the 'Surcharges' element value. Total price reflecting all services for all passengers across all segments referenced within this Offer Item.
         * 
         * @param surcharges
         */
        public void setSurcharges(Surcharges surcharges) {
            this.surcharges = surcharges;
        }

        /** 
         * Get the 'Taxes' element value. Ticket Tax/fee/charge details to indicate taxes that apply to country of commencement of travel and routing.
         * 
         * @return value
         */
        public TaxDetailType getTotalPriceDetailTaxes() {
            return totalPriceDetailTaxes;
        }

        /** 
         * Set the 'Taxes' element value. Ticket Tax/fee/charge details to indicate taxes that apply to country of commencement of travel and routing.
         * 
         * @param totalPriceDetailTaxes
         */
        public void setTotalPriceDetailTaxes(TaxDetailType totalPriceDetailTaxes) {
            this.totalPriceDetailTaxes = totalPriceDetailTaxes;
        }

        /** 
         * Get the 'TaxExemption' element value.
         * 
         * @return value
         */
        public TaxExemptionType getTotalPriceDetailTaxExemption() {
            return totalPriceDetailTaxExemption;
        }

        /** 
         * Set the 'TaxExemption' element value.
         * 
         * @param totalPriceDetailTaxExemption
         */
        public void setTotalPriceDetailTaxExemption(
                TaxExemptionType totalPriceDetailTaxExemption) {
            this.totalPriceDetailTaxExemption = totalPriceDetailTaxExemption;
        }

        /** 
         * Get the choice value. Total price reflecting all services for all passengers across all segments referenced within this Offer Item.
         * 
         * @return value
         */
        public Choice getChoice() {
            return choice;
        }

        /** 
         * Set the choice value. Total price reflecting all services for all passengers across all segments referenced within this Offer Item.
         * 
         * @param choice
         */
        public void setChoice(Choice choice) {
            this.choice = choice;
        }

        /** 
         * Get the 'Fees' element value. Individual fee/ surcharge information would appear on the accountable document.
         * 
         * @return value
         */
        public FeeSurchargeType getTotalPriceDetailFees() {
            return totalPriceDetailFees;
        }

        /** 
         * Set the 'Fees' element value. Individual fee/ surcharge information would appear on the accountable document.
         * 
         * @param totalPriceDetailFees
         */
        public void setTotalPriceDetailFees(
                FeeSurchargeType totalPriceDetailFees) {
            this.totalPriceDetailFees = totalPriceDetailFees;
        }

        /** 
         * Get the list of 'FareDetail' element items. Fare Detail, including Fare Component and Fare Rules.
         * 
         * @return list
         */
        public List<FareDetailType> getFareDetailList() {
            return fareDetailList;
        }

        /** 
         * Set the list of 'FareDetail' element items. Fare Detail, including Fare Component and Fare Rules.
         * 
         * @param list
         */
        public void setFareDetailList(List<FareDetailType> list) {
            fareDetailList = list;
        }

        private void setOriginalOrderItemTotalAmountSelect(int choice) {
            if (originalOrderItemTotalAmountSelect == -1) {
                originalOrderItemTotalAmountSelect = choice;
            } else if (originalOrderItemTotalAmountSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearOriginalOrderItemTotalAmountSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearOriginalOrderItemTotalAmountSelect() {
            originalOrderItemTotalAmountSelect = -1;
        }

        /** 
         * Check if OriginalOrderItemAwardPricing is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOriginalOrderItemAwardPricing() {
            return originalOrderItemTotalAmountSelect == ORIGINAL_ORDER_ITEM_AWARD_PRICING_CHOICE;
        }

        /** 
         * Get the 'AwardPricing' element value.
         * 
         * @return value
         */
        public AwardPriceUnitType getOriginalOrderItemAwardPricing() {
            return originalOrderItemAwardPricing;
        }

        /** 
         * Set the 'AwardPricing' element value.
         * 
         * @param originalOrderItemAwardPricing
         */
        public void setOriginalOrderItemAwardPricing(
                AwardPriceUnitType originalOrderItemAwardPricing) {
            setOriginalOrderItemTotalAmountSelect(ORIGINAL_ORDER_ITEM_AWARD_PRICING_CHOICE);
            this.originalOrderItemAwardPricing = originalOrderItemAwardPricing;
        }

        /** 
         * Check if OriginalOrderItemCombinationPricing is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOriginalOrderItemCombinationPricing() {
            return originalOrderItemTotalAmountSelect == ORIGINAL_ORDER_ITEM_COMBINATION_PRICING_CHOICE;
        }

        /** 
         * Get the 'CombinationPricing' element value.
         * 
         * @return value
         */
        public CombinationPriceType getOriginalOrderItemCombinationPricing() {
            return originalOrderItemCombinationPricing;
        }

        /** 
         * Set the 'CombinationPricing' element value.
         * 
         * @param originalOrderItemCombinationPricing
         */
        public void setOriginalOrderItemCombinationPricing(
                CombinationPriceType originalOrderItemCombinationPricing) {
            setOriginalOrderItemTotalAmountSelect(ORIGINAL_ORDER_ITEM_COMBINATION_PRICING_CHOICE);
            this.originalOrderItemCombinationPricing = originalOrderItemCombinationPricing;
        }

        /** 
         * Check if OriginalOrderItemDetailCurrencyPrice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOriginalOrderItemDetailCurrencyPrice() {
            return originalOrderItemTotalAmountSelect == ORIGINAL_ORDER_ITEM_DETAIL_CURRENCY_PRICE_CHOICE;
        }

        /** 
         * Get the 'DetailCurrencyPrice' element value.
         * 
         * @return value
         */
        public DetailCurrencyPriceType getOriginalOrderItemDetailCurrencyPrice() {
            return originalOrderItemDetailCurrencyPrice;
        }

        /** 
         * Set the 'DetailCurrencyPrice' element value.
         * 
         * @param originalOrderItemDetailCurrencyPrice
         */
        public void setOriginalOrderItemDetailCurrencyPrice(
                DetailCurrencyPriceType originalOrderItemDetailCurrencyPrice) {
            setOriginalOrderItemTotalAmountSelect(ORIGINAL_ORDER_ITEM_DETAIL_CURRENCY_PRICE_CHOICE);
            this.originalOrderItemDetailCurrencyPrice = originalOrderItemDetailCurrencyPrice;
        }

        /** 
         * Check if OriginalOrderItemEncodedCurrencyPrice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOriginalOrderItemEncodedCurrencyPrice() {
            return originalOrderItemTotalAmountSelect == ORIGINAL_ORDER_ITEM_ENCODED_CURRENCY_PRICE_CHOICE;
        }

        /** 
         * Get the 'EncodedCurrencyPrice' element value.
         * 
         * @return value
         */
        public EncodedCurrencyPrice getOriginalOrderItemEncodedCurrencyPrice() {
            return originalOrderItemEncodedCurrencyPrice;
        }

        /** 
         * Set the 'EncodedCurrencyPrice' element value.
         * 
         * @param originalOrderItemEncodedCurrencyPrice
         */
        public void setOriginalOrderItemEncodedCurrencyPrice(
                EncodedCurrencyPrice originalOrderItemEncodedCurrencyPrice) {
            setOriginalOrderItemTotalAmountSelect(ORIGINAL_ORDER_ITEM_ENCODED_CURRENCY_PRICE_CHOICE);
            this.originalOrderItemEncodedCurrencyPrice = originalOrderItemEncodedCurrencyPrice;
        }

        /** 
         * Check if OriginalOrderItemSimpleCurrencyPrice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOriginalOrderItemSimpleCurrencyPrice() {
            return originalOrderItemTotalAmountSelect == ORIGINAL_ORDER_ITEM_SIMPLE_CURRENCY_PRICE_CHOICE;
        }

        /** 
         * Get the 'SimpleCurrencyPrice' element value.
         * 
         * @return value
         */
        public SimpleCurrencyPrice getOriginalOrderItemSimpleCurrencyPrice() {
            return originalOrderItemSimpleCurrencyPrice;
        }

        /** 
         * Set the 'SimpleCurrencyPrice' element value.
         * 
         * @param originalOrderItemSimpleCurrencyPrice
         */
        public void setOriginalOrderItemSimpleCurrencyPrice(
                SimpleCurrencyPrice originalOrderItemSimpleCurrencyPrice) {
            setOriginalOrderItemTotalAmountSelect(ORIGINAL_ORDER_ITEM_SIMPLE_CURRENCY_PRICE_CHOICE);
            this.originalOrderItemSimpleCurrencyPrice = originalOrderItemSimpleCurrencyPrice;
        }

        /** 
         * Get the 'BaseAmount' element value. Total Base Fare Amount.  Example: 200000

        Note: This includes  surcharges (if applicable).
         * 
         * @return value
         */
        public CurrencyAmountOptType getOriginalOrderItemBaseAmount() {
            return originalOrderItemBaseAmount;
        }

        /** 
         * Set the 'BaseAmount' element value. Total Base Fare Amount.  Example: 200000

        Note: This includes  surcharges (if applicable).
         * 
         * @param originalOrderItemBaseAmount
         */
        public void setOriginalOrderItemBaseAmount(
                CurrencyAmountOptType originalOrderItemBaseAmount) {
            this.originalOrderItemBaseAmount = originalOrderItemBaseAmount;
        }

        /** 
         * Get the 'FareFiledIn' element value.
         * 
         * @return value
         */
        public FareFilingType getOriginalOrderItemFareFiledIn() {
            return originalOrderItemFareFiledIn;
        }

        /** 
         * Set the 'FareFiledIn' element value.
         * 
         * @param originalOrderItemFareFiledIn
         */
        public void setOriginalOrderItemFareFiledIn(
                FareFilingType originalOrderItemFareFiledIn) {
            this.originalOrderItemFareFiledIn = originalOrderItemFareFiledIn;
        }

        /** 
         * Get the 'Discount' element value. Discount Information
         * 
         * @return value
         */
        public DiscountType getOriginalOrderItemDiscount() {
            return originalOrderItemDiscount;
        }

        /** 
         * Set the 'Discount' element value. Discount Information
         * 
         * @param originalOrderItemDiscount
         */
        public void setOriginalOrderItemDiscount(
                DiscountType originalOrderItemDiscount) {
            this.originalOrderItemDiscount = originalOrderItemDiscount;
        }

        /** 
         * Get the 'Surcharges' element value. Total price reflecting all services for all passengers across all segments referenced within this Offer Item.
         * 
         * @return value
         */
        public Surcharges1 getSurcharges1() {
            return surcharges1;
        }

        /** 
         * Set the 'Surcharges' element value. Total price reflecting all services for all passengers across all segments referenced within this Offer Item.
         * 
         * @param surcharges1
         */
        public void setSurcharges1(Surcharges1 surcharges1) {
            this.surcharges1 = surcharges1;
        }

        /** 
         * Get the 'Taxes' element value. Ticket Tax/fee/charge details to indicate taxes that apply to country of commencement of travel and routing.
         * 
         * @return value
         */
        public TaxDetailType getOriginalOrderItemTaxes() {
            return originalOrderItemTaxes;
        }

        /** 
         * Set the 'Taxes' element value. Ticket Tax/fee/charge details to indicate taxes that apply to country of commencement of travel and routing.
         * 
         * @param originalOrderItemTaxes
         */
        public void setOriginalOrderItemTaxes(
                TaxDetailType originalOrderItemTaxes) {
            this.originalOrderItemTaxes = originalOrderItemTaxes;
        }

        /** 
         * Get the 'TaxExemption' element value.
         * 
         * @return value
         */
        public TaxExemptionType getOriginalOrderItemTaxExemption() {
            return originalOrderItemTaxExemption;
        }

        /** 
         * Set the 'TaxExemption' element value.
         * 
         * @param originalOrderItemTaxExemption
         */
        public void setOriginalOrderItemTaxExemption(
                TaxExemptionType originalOrderItemTaxExemption) {
            this.originalOrderItemTaxExemption = originalOrderItemTaxExemption;
        }

        /** 
         * Get the choice value. Total price reflecting all services for all passengers across all segments referenced within this Offer Item.
         * 
         * @return value
         */
        public Choice1 getChoice1() {
            return choice1;
        }

        /** 
         * Set the choice value. Total price reflecting all services for all passengers across all segments referenced within this Offer Item.
         * 
         * @param choice1
         */
        public void setChoice1(Choice1 choice1) {
            this.choice1 = choice1;
        }

        /** 
         * Get the 'Fees' element value. Individual fee/ surcharge information would appear on the accountable document.
         * 
         * @return value
         */
        public FeeSurchargeType getOriginalOrderItemFees() {
            return originalOrderItemFees;
        }

        /** 
         * Set the 'Fees' element value. Individual fee/ surcharge information would appear on the accountable document.
         * 
         * @param originalOrderItemFees
         */
        public void setOriginalOrderItemFees(
                FeeSurchargeType originalOrderItemFees) {
            this.originalOrderItemFees = originalOrderItemFees;
        }

        /** 
         * Get the list of 'FareDetail' element items. Fare Detail, including Fare Component and Fare Rules.
         * 
         * @return list
         */
        public List<FareDetailType> getOriginalOrderItemFareDetailList() {
            return originalOrderItemFareDetailList;
        }

        /** 
         * Set the list of 'FareDetail' element items. Fare Detail, including Fare Component and Fare Rules.
         * 
         * @param list
         */
        public void setOriginalOrderItemFareDetailList(List<FareDetailType> list) {
            originalOrderItemFareDetailList = list;
        }

        /** 
         * Get the 'OrderItemID' attribute value.
         * 
         * @return value
         */
        public String getOriginalOrderItemOrderItemID() {
            return originalOrderItemOrderItemID;
        }

        /** 
         * Set the 'OrderItemID' attribute value.
         * 
         * @param originalOrderItemOrderItemID
         */
        public void setOriginalOrderItemOrderItemID(
                String originalOrderItemOrderItemID) {
            this.originalOrderItemOrderItemID = originalOrderItemOrderItemID;
        }

        /** 
         * Get the 'OfferItemID' attribute value. Unique identifier for this OfferItem instance. Must be unique within XML message. Exceeding 64 characters or use of dashes is not recommended.
         * 
         * @return value
         */
        public String getOfferItemID() {
            return offerItemID;
        }

        /** 
         * Set the 'OfferItemID' attribute value. Unique identifier for this OfferItem instance. Must be unique within XML message. Exceeding 64 characters or use of dashes is not recommended.
         * 
         * @param offerItemID
         */
        public void setOfferItemID(String offerItemID) {
            this.offerItemID = offerItemID;
        }
        /** 
         * Applicable Surcharge(s).
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Surcharges" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:FeeSurchargeType" name="Surcharge" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Surcharges implements Serializable
        {
            private List<FeeSurchargeType> surchargeList = new ArrayList<FeeSurchargeType>();

            /** 
             * Get the list of 'Surcharge' element items. Surcharge detail.
             * 
             * @return list
             */
            public List<FeeSurchargeType> getSurchargeList() {
                return surchargeList;
            }

            /** 
             * Set the list of 'Surcharge' element items. Surcharge detail.
             * 
             * @param list
             */
            public void setSurchargeList(List<FeeSurchargeType> list) {
                surchargeList = list;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:choice xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
         *   &lt;xs:element type="ns:AwardPriceUnitType" name="AwardPricing" minOccurs="0"/>
         *   &lt;xs:element type="ns:CombinationPriceType" name="CombinationPricing" minOccurs="0"/>
         * &lt;/xs:choice>
         * </pre>
         */
        public static class Choice implements Serializable
        {
            private int choiceSelect = -1;
            private static final int AWARD_PRICING_CHOICE = 0;
            private static final int COMBINATION_PRICING_CHOICE = 1;
            private AwardPriceUnitType awardPricing;
            private CombinationPriceType combinationPricing;

            private void setChoiceSelect(int choice) {
                if (choiceSelect == -1) {
                    choiceSelect = choice;
                } else if (choiceSelect != choice) {
                    throw new IllegalStateException(
                            "Need to call clearChoiceSelect() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearChoiceSelect() {
                choiceSelect = -1;
            }

            /** 
             * Check if AwardPricing is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifAwardPricing() {
                return choiceSelect == AWARD_PRICING_CHOICE;
            }

            /** 
             * Get the 'AwardPricing' element value. AWARD (Redemption Unit-based) Pricing information.
             * 
             * @return value
             */
            public AwardPriceUnitType getAwardPricing() {
                return awardPricing;
            }

            /** 
             * Set the 'AwardPricing' element value. AWARD (Redemption Unit-based) Pricing information.
             * 
             * @param awardPricing
             */
            public void setAwardPricing(AwardPriceUnitType awardPricing) {
                setChoiceSelect(AWARD_PRICING_CHOICE);
                this.awardPricing = awardPricing;
            }

            /** 
             * Check if CombinationPricing is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifCombinationPricing() {
                return choiceSelect == COMBINATION_PRICING_CHOICE;
            }

            /** 
             * Get the 'CombinationPricing' element value. PARTIAL CURRENCY and AWARD Pricing Combination information.
             * 
             * @return value
             */
            public CombinationPriceType getCombinationPricing() {
                return combinationPricing;
            }

            /** 
             * Set the 'CombinationPricing' element value. PARTIAL CURRENCY and AWARD Pricing Combination information.
             * 
             * @param combinationPricing
             */
            public void setCombinationPricing(
                    CombinationPriceType combinationPricing) {
                setChoiceSelect(COMBINATION_PRICING_CHOICE);
                this.combinationPricing = combinationPricing;
            }
        }
        /** 
         * Applicable Surcharge(s).
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Surcharges" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:FeeSurchargeType" name="Surcharge" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Surcharges1 implements Serializable
        {
            private List<FeeSurchargeType> surchargeList = new ArrayList<FeeSurchargeType>();

            /** 
             * Get the list of 'Surcharge' element items. Surcharge detail.
             * 
             * @return list
             */
            public List<FeeSurchargeType> getSurchargeList() {
                return surchargeList;
            }

            /** 
             * Set the list of 'Surcharge' element items. Surcharge detail.
             * 
             * @param list
             */
            public void setSurchargeList(List<FeeSurchargeType> list) {
                surchargeList = list;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:choice xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
         *   &lt;xs:element type="ns:AwardPriceUnitType" name="AwardPricing" minOccurs="0"/>
         *   &lt;xs:element type="ns:CombinationPriceType" name="CombinationPricing" minOccurs="0"/>
         * &lt;/xs:choice>
         * </pre>
         */
        public static class Choice1 implements Serializable
        {
            private int choice1Select = -1;
            private static final int AWARD_PRICING_CHOICE = 0;
            private static final int COMBINATION_PRICING_CHOICE = 1;
            private AwardPriceUnitType awardPricing;
            private CombinationPriceType combinationPricing;

            private void setChoice1Select(int choice) {
                if (choice1Select == -1) {
                    choice1Select = choice;
                } else if (choice1Select != choice) {
                    throw new IllegalStateException(
                            "Need to call clearChoice1Select() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearChoice1Select() {
                choice1Select = -1;
            }

            /** 
             * Check if AwardPricing is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifAwardPricing() {
                return choice1Select == AWARD_PRICING_CHOICE;
            }

            /** 
             * Get the 'AwardPricing' element value. AWARD (Redemption Unit-based) Pricing information.
             * 
             * @return value
             */
            public AwardPriceUnitType getAwardPricing() {
                return awardPricing;
            }

            /** 
             * Set the 'AwardPricing' element value. AWARD (Redemption Unit-based) Pricing information.
             * 
             * @param awardPricing
             */
            public void setAwardPricing(AwardPriceUnitType awardPricing) {
                setChoice1Select(AWARD_PRICING_CHOICE);
                this.awardPricing = awardPricing;
            }

            /** 
             * Check if CombinationPricing is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifCombinationPricing() {
                return choice1Select == COMBINATION_PRICING_CHOICE;
            }

            /** 
             * Get the 'CombinationPricing' element value. PARTIAL CURRENCY and AWARD Pricing Combination information.
             * 
             * @return value
             */
            public CombinationPriceType getCombinationPricing() {
                return combinationPricing;
            }

            /** 
             * Set the 'CombinationPricing' element value. PARTIAL CURRENCY and AWARD Pricing Combination information.
             * 
             * @param combinationPricing
             */
            public void setCombinationPricing(
                    CombinationPriceType combinationPricing) {
                setChoice1Select(COMBINATION_PRICING_CHOICE);
                this.combinationPricing = combinationPricing;
            }
        }
    }
    /** 
     * Payment information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payments" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:PaymentMethodType" name="Payment" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Payments implements Serializable
    {
        private List<PaymentMethodType> paymentList = new ArrayList<PaymentMethodType>();

        /** 
         * Get the list of 'Payment' element items. Payment detail, including association(s).
         * 
         * @return list
         */
        public List<PaymentMethodType> getPaymentList() {
            return paymentList;
        }

        /** 
         * Set the list of 'Payment' element items. Payment detail, including association(s).
         * 
         * @param list
         */
        public void setPaymentList(List<PaymentMethodType> list) {
            paymentList = list;
        }
    }
    /** 
     * Commission information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:CommissionType">
     *         &lt;xs:sequence>
     *           &lt;xs:element name="ActionType" minOccurs="0">
     *             &lt;!-- Reference to inner class ActionType -->
     *           &lt;/xs:element>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Commission extends CommissionType implements
        Serializable
    {
        private ActionType actionType;

        /** 
         * Get the 'ActionType' element value.
         * 
         * @return value
         */
        public ActionType getActionType() {
            return actionType;
        }

        /** 
         * Set the 'ActionType' element value.
         * 
         * @param actionType
         */
        public void setActionType(ActionType actionType) {
            this.actionType = actionType;
        }
        /** 
         * Order Action. Examples: Cancel, Create, Update, Delete, Reissue, Reprice
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ActionType" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ActionType implements Serializable
        {
            private String string;
            private String context;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'Context' attribute value. Action Type Context.
             * 
             * @return value
             */
            public String getContext() {
                return context;
            }

            /** 
             * Set the 'Context' attribute value. Action Type Context.
             * 
             * @param context
             */
            public void setContext(String context) {
                this.context = context;
            }
        }
    }
    /** 
     * Data Lists(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DataLists" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PassengerList" minOccurs="0">
     *         &lt;!-- Reference to inner class PassengerList -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ContactList" minOccurs="0">
     *         &lt;!-- Reference to inner class ContactList -->
     *       &lt;/xs:element>
     *       &lt;xs:element ref="ns:BagDisclosureList" minOccurs="0"/>
     *       &lt;xs:element name="BaggageAllowanceList" minOccurs="0">
     *         &lt;!-- Reference to inner class BaggageAllowanceList -->
     *       &lt;/xs:element>
     *       &lt;xs:element ref="ns:ClassOfServiceList" minOccurs="0"/>
     *       &lt;xs:element ref="ns:ContentSourceList" minOccurs="0"/>
     *       &lt;xs:element name="DescriptionList" minOccurs="0">
     *         &lt;!-- Reference to inner class DescriptionList -->
     *       &lt;/xs:element>
     *       &lt;xs:element ref="ns:DisclosureList" minOccurs="0"/>
     *       &lt;xs:element ref="ns:FareList" minOccurs="0"/>
     *       &lt;xs:element name="FlightSegmentList" minOccurs="0">
     *         &lt;!-- Reference to inner class FlightSegmentList -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FlightList" minOccurs="0">
     *         &lt;!-- Reference to inner class FlightList -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="OriginDestinationList" minOccurs="0">
     *         &lt;!-- Reference to inner class OriginDestinationList -->
     *       &lt;/xs:element>
     *       &lt;xs:element ref="ns:InstructionsList" minOccurs="0"/>
     *       &lt;xs:element ref="ns:MediaList" minOccurs="0"/>
     *       &lt;xs:element ref="ns:PenaltyList" minOccurs="0"/>
     *       &lt;xs:element name="PriceClassList" minOccurs="0">
     *         &lt;!-- Reference to inner class PriceClassList -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ServiceDefinitionList" minOccurs="0">
     *         &lt;!-- Reference to inner class ServiceDefinitionList -->
     *       &lt;/xs:element>
     *       &lt;xs:element ref="ns:TermsList" minOccurs="0"/>
     *       &lt;xs:element name="SeatDefinitionList" minOccurs="0">
     *         &lt;!-- Reference to inner class SeatDefinitionList -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DataLists implements Serializable
    {
        private PassengerList passengerList;
        private ContactList contactList;
        private ListOfBagDisclosureType bagDisclosureList;
        private BaggageAllowanceList baggageAllowanceList;
        private ListOfClassOfServiceType classOfServiceList;
        private ListOfContentSourceType contentSourceList;
        private DescriptionList descriptionList;
        private ListOfDisclosureType disclosureList;
        private FareList fareList;
        private FlightSegmentList flightSegmentList;
        private FlightList flightList;
        private OriginDestinationList originDestinationList;
        private ListOfOfferInstructionsType instructionsList;
        private ListOfMediaType mediaList;
        private ListOfOfferPenaltyType penaltyList;
        private PriceClassList priceClassList;
        private ServiceDefinitionList serviceDefinitionList;
        private ListOfOfferTermsType termsList;
        private SeatDefinitionList seatDefinitionList;

        /** 
         * Get the 'PassengerList' element value.
         * 
         * @return value
         */
        public PassengerList getPassengerList() {
            return passengerList;
        }

        /** 
         * Set the 'PassengerList' element value.
         * 
         * @param passengerList
         */
        public void setPassengerList(PassengerList passengerList) {
            this.passengerList = passengerList;
        }

        /** 
         * Get the 'ContactList' element value.
         * 
         * @return value
         */
        public ContactList getContactList() {
            return contactList;
        }

        /** 
         * Set the 'ContactList' element value.
         * 
         * @param contactList
         */
        public void setContactList(ContactList contactList) {
            this.contactList = contactList;
        }

        /** 
         * Get the 'BagDisclosureList' element value.
         * 
         * @return value
         */
        public ListOfBagDisclosureType getBagDisclosureList() {
            return bagDisclosureList;
        }

        /** 
         * Set the 'BagDisclosureList' element value.
         * 
         * @param bagDisclosureList
         */
        public void setBagDisclosureList(
                ListOfBagDisclosureType bagDisclosureList) {
            this.bagDisclosureList = bagDisclosureList;
        }

        /** 
         * Get the 'BaggageAllowanceList' element value.
         * 
         * @return value
         */
        public BaggageAllowanceList getBaggageAllowanceList() {
            return baggageAllowanceList;
        }

        /** 
         * Set the 'BaggageAllowanceList' element value.
         * 
         * @param baggageAllowanceList
         */
        public void setBaggageAllowanceList(
                BaggageAllowanceList baggageAllowanceList) {
            this.baggageAllowanceList = baggageAllowanceList;
        }

        /** 
         * Get the 'ClassOfServiceList' element value.
         * 
         * @return value
         */
        public ListOfClassOfServiceType getClassOfServiceList() {
            return classOfServiceList;
        }

        /** 
         * Set the 'ClassOfServiceList' element value.
         * 
         * @param classOfServiceList
         */
        public void setClassOfServiceList(
                ListOfClassOfServiceType classOfServiceList) {
            this.classOfServiceList = classOfServiceList;
        }

        /** 
         * Get the 'ContentSourceList' element value.
         * 
         * @return value
         */
        public ListOfContentSourceType getContentSourceList() {
            return contentSourceList;
        }

        /** 
         * Set the 'ContentSourceList' element value.
         * 
         * @param contentSourceList
         */
        public void setContentSourceList(
                ListOfContentSourceType contentSourceList) {
            this.contentSourceList = contentSourceList;
        }

        /** 
         * Get the 'DescriptionList' element value.
         * 
         * @return value
         */
        public DescriptionList getDescriptionList() {
            return descriptionList;
        }

        /** 
         * Set the 'DescriptionList' element value.
         * 
         * @param descriptionList
         */
        public void setDescriptionList(DescriptionList descriptionList) {
            this.descriptionList = descriptionList;
        }

        /** 
         * Get the 'DisclosureList' element value.
         * 
         * @return value
         */
        public ListOfDisclosureType getDisclosureList() {
            return disclosureList;
        }

        /** 
         * Set the 'DisclosureList' element value.
         * 
         * @param disclosureList
         */
        public void setDisclosureList(ListOfDisclosureType disclosureList) {
            this.disclosureList = disclosureList;
        }

        /** 
         * Get the 'FareList' element value.
         * 
         * @return value
         */
        public FareList getFareList() {
            return fareList;
        }

        /** 
         * Set the 'FareList' element value.
         * 
         * @param fareList
         */
        public void setFareList(FareList fareList) {
            this.fareList = fareList;
        }

        /** 
         * Get the 'FlightSegmentList' element value.
         * 
         * @return value
         */
        public FlightSegmentList getFlightSegmentList() {
            return flightSegmentList;
        }

        /** 
         * Set the 'FlightSegmentList' element value.
         * 
         * @param flightSegmentList
         */
        public void setFlightSegmentList(FlightSegmentList flightSegmentList) {
            this.flightSegmentList = flightSegmentList;
        }

        /** 
         * Get the 'FlightList' element value.
         * 
         * @return value
         */
        public FlightList getFlightList() {
            return flightList;
        }

        /** 
         * Set the 'FlightList' element value.
         * 
         * @param flightList
         */
        public void setFlightList(FlightList flightList) {
            this.flightList = flightList;
        }

        /** 
         * Get the 'OriginDestinationList' element value.
         * 
         * @return value
         */
        public OriginDestinationList getOriginDestinationList() {
            return originDestinationList;
        }

        /** 
         * Set the 'OriginDestinationList' element value.
         * 
         * @param originDestinationList
         */
        public void setOriginDestinationList(
                OriginDestinationList originDestinationList) {
            this.originDestinationList = originDestinationList;
        }

        /** 
         * Get the 'InstructionsList' element value.
         * 
         * @return value
         */
        public ListOfOfferInstructionsType getInstructionsList() {
            return instructionsList;
        }

        /** 
         * Set the 'InstructionsList' element value.
         * 
         * @param instructionsList
         */
        public void setInstructionsList(
                ListOfOfferInstructionsType instructionsList) {
            this.instructionsList = instructionsList;
        }

        /** 
         * Get the 'MediaList' element value.
         * 
         * @return value
         */
        public ListOfMediaType getMediaList() {
            return mediaList;
        }

        /** 
         * Set the 'MediaList' element value.
         * 
         * @param mediaList
         */
        public void setMediaList(ListOfMediaType mediaList) {
            this.mediaList = mediaList;
        }

        /** 
         * Get the 'PenaltyList' element value.
         * 
         * @return value
         */
        public ListOfOfferPenaltyType getPenaltyList() {
            return penaltyList;
        }

        /** 
         * Set the 'PenaltyList' element value.
         * 
         * @param penaltyList
         */
        public void setPenaltyList(ListOfOfferPenaltyType penaltyList) {
            this.penaltyList = penaltyList;
        }

        /** 
         * Get the 'PriceClassList' element value.
         * 
         * @return value
         */
        public PriceClassList getPriceClassList() {
            return priceClassList;
        }

        /** 
         * Set the 'PriceClassList' element value.
         * 
         * @param priceClassList
         */
        public void setPriceClassList(PriceClassList priceClassList) {
            this.priceClassList = priceClassList;
        }

        /** 
         * Get the 'ServiceDefinitionList' element value.
         * 
         * @return value
         */
        public ServiceDefinitionList getServiceDefinitionList() {
            return serviceDefinitionList;
        }

        /** 
         * Set the 'ServiceDefinitionList' element value.
         * 
         * @param serviceDefinitionList
         */
        public void setServiceDefinitionList(
                ServiceDefinitionList serviceDefinitionList) {
            this.serviceDefinitionList = serviceDefinitionList;
        }

        /** 
         * Get the 'TermsList' element value.
         * 
         * @return value
         */
        public ListOfOfferTermsType getTermsList() {
            return termsList;
        }

        /** 
         * Set the 'TermsList' element value.
         * 
         * @param termsList
         */
        public void setTermsList(ListOfOfferTermsType termsList) {
            this.termsList = termsList;
        }

        /** 
         * Get the 'SeatDefinitionList' element value.
         * 
         * @return value
         */
        public SeatDefinitionList getSeatDefinitionList() {
            return seatDefinitionList;
        }

        /** 
         * Set the 'SeatDefinitionList' element value.
         * 
         * @param seatDefinitionList
         */
        public void setSeatDefinitionList(SeatDefinitionList seatDefinitionList) {
            this.seatDefinitionList = seatDefinitionList;
        }
        /** 
         * Passenger data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:PassengerType" name="Passenger" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PassengerList implements Serializable
        {
            private List<PassengerType> passengerList = new ArrayList<PassengerType>();

            /** 
             * Get the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @return list
             */
            public List<PassengerType> getPassengerList() {
                return passengerList;
            }

            /** 
             * Set the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @param list
             */
            public void setPassengerList(List<PassengerType> list) {
                passengerList = list;
            }
        }
        /** 
         * Contact data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ContactInformationType" name="ContactInformation" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ContactList implements Serializable
        {
            private List<ContactInformationType> contactInformationList = new ArrayList<ContactInformationType>();

            /** 
             * Get the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @return list
             */
            public List<ContactInformationType> getContactInformationList() {
                return contactInformationList;
            }

            /** 
             * Set the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @param list
             */
            public void setContactInformationList(
                    List<ContactInformationType> list) {
                contactInformationList = list;
            }
        }
        /** 
         * Checked or Carry-On Baggage Allowance detail. Use BaggageCategory to specify which of the two.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageAllowanceList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="BaggageAllowance" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class BaggageAllowance -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class BaggageAllowanceList implements Serializable
        {
            private List<BaggageAllowance> baggageAllowanceList = new ArrayList<BaggageAllowance>();

            /** 
             * Get the list of 'BaggageAllowance' element items.
             * 
             * @return list
             */
            public List<BaggageAllowance> getBaggageAllowanceList() {
                return baggageAllowanceList;
            }

            /** 
             * Set the list of 'BaggageAllowance' element items.
             * 
             * @param list
             */
            public void setBaggageAllowanceList(List<BaggageAllowance> list) {
                baggageAllowanceList = list;
            }
            /** 
             * Checked or Carry-On Baggage Allowance detail. Use BaggageCategory to specify which of the two.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageAllowance" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:BaggageCategoryListType" name="BaggageCategory"/>
             *       &lt;xs:element ref="ns:AllowanceDescription" minOccurs="0"/>
             *       &lt;xs:element ref="ns:DimensionAllowance" minOccurs="0"/>
             *       &lt;xs:element ref="ns:PieceAllowance" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element ref="ns:WeightAllowance" minOccurs="0"/>
             *       &lt;xs:element type="ns:BaggageDeterminingCarrierType" name="BaggageDeterminingCarrier" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="BaggageAllowanceID"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BaggageAllowance implements Serializable
            {
                private BaggageCategoryListType baggageCategory;
                private BagAllowanceDescType allowanceDescription;
                private BagAllowanceDimensionType dimensionAllowance;
                private List<BagAllowancePieceType> pieceAllowanceList = new ArrayList<BagAllowancePieceType>();
                private WeightAllowance weightAllowance;
                private BaggageDeterminingCarrierType baggageDeterminingCarrier;
                private String baggageAllowanceID;

                /** 
                 * Get the 'BaggageCategory' element value. Enumeration:

                CarryOn
                Checked
                 * 
                 * @return value
                 */
                public BaggageCategoryListType getBaggageCategory() {
                    return baggageCategory;
                }

                /** 
                 * Set the 'BaggageCategory' element value. Enumeration:

                CarryOn
                Checked
                 * 
                 * @param baggageCategory
                 */
                public void setBaggageCategory(
                        BaggageCategoryListType baggageCategory) {
                    this.baggageCategory = baggageCategory;
                }

                /** 
                 * Get the 'AllowanceDescription' element value.
                 * 
                 * @return value
                 */
                public BagAllowanceDescType getAllowanceDescription() {
                    return allowanceDescription;
                }

                /** 
                 * Set the 'AllowanceDescription' element value.
                 * 
                 * @param allowanceDescription
                 */
                public void setAllowanceDescription(
                        BagAllowanceDescType allowanceDescription) {
                    this.allowanceDescription = allowanceDescription;
                }

                /** 
                 * Get the 'DimensionAllowance' element value.
                 * 
                 * @return value
                 */
                public BagAllowanceDimensionType getDimensionAllowance() {
                    return dimensionAllowance;
                }

                /** 
                 * Set the 'DimensionAllowance' element value.
                 * 
                 * @param dimensionAllowance
                 */
                public void setDimensionAllowance(
                        BagAllowanceDimensionType dimensionAllowance) {
                    this.dimensionAllowance = dimensionAllowance;
                }

                /** 
                 * Get the list of 'PieceAllowance' element items.
                 * 
                 * @return list
                 */
                public List<BagAllowancePieceType> getPieceAllowanceList() {
                    return pieceAllowanceList;
                }

                /** 
                 * Set the list of 'PieceAllowance' element items.
                 * 
                 * @param list
                 */
                public void setPieceAllowanceList(
                        List<BagAllowancePieceType> list) {
                    pieceAllowanceList = list;
                }

                /** 
                 * Get the 'WeightAllowance' element value.
                 * 
                 * @return value
                 */
                public WeightAllowance getWeightAllowance() {
                    return weightAllowance;
                }

                /** 
                 * Set the 'WeightAllowance' element value.
                 * 
                 * @param weightAllowance
                 */
                public void setWeightAllowance(WeightAllowance weightAllowance) {
                    this.weightAllowance = weightAllowance;
                }

                /** 
                 * Get the 'BaggageDeterminingCarrier' element value. Baggage Determining Carrier as defined in resolution 722 (f), and who’s baggage rules apply.
                 * 
                 * @return value
                 */
                public BaggageDeterminingCarrierType getBaggageDeterminingCarrier() {
                    return baggageDeterminingCarrier;
                }

                /** 
                 * Set the 'BaggageDeterminingCarrier' element value. Baggage Determining Carrier as defined in resolution 722 (f), and who’s baggage rules apply.
                 * 
                 * @param baggageDeterminingCarrier
                 */
                public void setBaggageDeterminingCarrier(
                        BaggageDeterminingCarrierType baggageDeterminingCarrier) {
                    this.baggageDeterminingCarrier = baggageDeterminingCarrier;
                }

                /** 
                 * Get the 'BaggageAllowanceID' attribute value.
                 * 
                 * @return value
                 */
                public String getBaggageAllowanceID() {
                    return baggageAllowanceID;
                }

                /** 
                 * Set the 'BaggageAllowanceID' attribute value.
                 * 
                 * @param baggageAllowanceID
                 */
                public void setBaggageAllowanceID(String baggageAllowanceID) {
                    this.baggageAllowanceID = baggageAllowanceID;
                }
            }
        }
        /** 
         * Description Details
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DescriptionList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element ref="ns:Description" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class DescriptionList implements Serializable
        {
            private List<com.gridnine.xtrip.server.gds.tandc.wsmodel.Description> descriptionList = new ArrayList<com.gridnine.xtrip.server.gds.tandc.wsmodel.Description>();

            /** 
             * Get the list of 'Description' element items.
             * 
             * @return list
             */
            public List<com.gridnine.xtrip.server.gds.tandc.wsmodel.Description> getDescriptionList() {
                return descriptionList;
            }

            /** 
             * Set the list of 'Description' element items.
             * 
             * @param list
             */
            public void setDescriptionList(
                    List<com.gridnine.xtrip.server.gds.tandc.wsmodel.Description> list) {
                descriptionList = list;
            }
        }
        /** 
         * List of Flight Segments
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegmentList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ListOfFlightSegmentType" name="FlightSegment" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FlightSegmentList implements Serializable
        {
            private List<ListOfFlightSegmentType> flightSegmentList = new ArrayList<ListOfFlightSegmentType>();

            /** 
             * Get the list of 'FlightSegment' element items.
             * 
             * @return list
             */
            public List<ListOfFlightSegmentType> getFlightSegmentList() {
                return flightSegmentList;
            }

            /** 
             * Set the list of 'FlightSegment' element items.
             * 
             * @param list
             */
            public void setFlightSegmentList(List<ListOfFlightSegmentType> list) {
                flightSegmentList = list;
            }
        }
        /** 
         * List of Flight elements.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Flight" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Flight -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FlightList implements Serializable
        {
            private List<Flight> flightList = new ArrayList<Flight>();

            /** 
             * Get the list of 'Flight' element items.
             * 
             * @return list
             */
            public List<Flight> getFlightList() {
                return flightList;
            }

            /** 
             * Set the list of 'Flight' element items.
             * 
             * @param list
             */
            public void setFlightList(List<Flight> list) {
                flightList = list;
            }
            /** 
             * Journey information describing the travel between an airport/city where travel commences and an airport/city where travel ultimately terminates. A journey may be comprised of one or more segments. Note: This node will be renamed to journey in future releases.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Flight" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:TotalJourneyType" name="Journey" minOccurs="0"/>
             *       &lt;xs:element ref="ns:SegmentReferences"/>
             *       &lt;xs:element name="Settlement" minOccurs="0">
             *         &lt;!-- Reference to inner class Settlement -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
             *     &lt;xs:attribute type="xs:string" name="FlightKey"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * 
             * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
             *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
             * &lt;/xs:attributeGroup>
             * </pre>
             */
            public static class Flight implements Serializable
            {
                private TotalJourneyType journey;
                private SegmentReferences segmentReferences;
                private Settlement settlement;
                private String refs;
                private String flightKey;

                /** 
                 * Get the 'Journey' element value. Flight journey information.
                 * 
                 * @return value
                 */
                public TotalJourneyType getJourney() {
                    return journey;
                }

                /** 
                 * Set the 'Journey' element value. Flight journey information.
                 * 
                 * @param journey
                 */
                public void setJourney(TotalJourneyType journey) {
                    this.journey = journey;
                }

                /** 
                 * Get the 'SegmentReferences' element value.
                 * 
                 * @return value
                 */
                public SegmentReferences getSegmentReferences() {
                    return segmentReferences;
                }

                /** 
                 * Set the 'SegmentReferences' element value.
                 * 
                 * @param segmentReferences
                 */
                public void setSegmentReferences(
                        SegmentReferences segmentReferences) {
                    this.segmentReferences = segmentReferences;
                }

                /** 
                 * Get the 'Settlement' element value.
                 * 
                 * @return value
                 */
                public Settlement getSettlement() {
                    return settlement;
                }

                /** 
                 * Set the 'Settlement' element value.
                 * 
                 * @param settlement
                 */
                public void setSettlement(Settlement settlement) {
                    this.settlement = settlement;
                }

                /** 
                 * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @return value
                 */
                public String getRefs() {
                    return refs;
                }

                /** 
                 * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @param refs
                 */
                public void setRefs(String refs) {
                    this.refs = refs;
                }

                /** 
                 * Get the 'FlightKey' attribute value. A globally unique identifier for this Flight instance. Example: flight1
                 * 
                 * @return value
                 */
                public String getFlightKey() {
                    return flightKey;
                }

                /** 
                 * Set the 'FlightKey' attribute value. A globally unique identifier for this Flight instance. Example: flight1
                 * 
                 * @param flightKey
                 */
                public void setFlightKey(String flightKey) {
                    this.flightKey = flightKey;
                }
                /** 
                 * Interline Settlement information between airlines, including method of settlement, interline settlement value and currency.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Settlement" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Method"/>
                 *       &lt;xs:element type="ns:CurrencyAmountOptType" name="InterlineSettlementValue" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Settlement implements Serializable
                {
                    private String method;
                    private CurrencyAmountOptType interlineSettlementValue;

                    /** 
                     * Get the 'Method' element value. Service settlement method.
                    Examples:
                    AD (Internal Airline Document)
                    DS (Direct Settlement)
                    EA (EMD Associated or Internal Airline Document)
                    ES (EMD Standalone )
                    FI (Fare Integrated)
                    MA (Flight Associated, Settled via MCO)
                    MS (Standalone, Settled via MCO)

                    Encoding Scheme: IATA PADIS Codeset SST (Service Settlement Type)
                     * 
                     * @return value
                     */
                    public String getMethod() {
                        return method;
                    }

                    /** 
                     * Set the 'Method' element value. Service settlement method.
                    Examples:
                    AD (Internal Airline Document)
                    DS (Direct Settlement)
                    EA (EMD Associated or Internal Airline Document)
                    ES (EMD Standalone )
                    FI (Fare Integrated)
                    MA (Flight Associated, Settled via MCO)
                    MS (Standalone, Settled via MCO)

                    Encoding Scheme: IATA PADIS Codeset SST (Service Settlement Type)
                     * 
                     * @param method
                     */
                    public void setMethod(String method) {
                        this.method = method;
                    }

                    /** 
                     * Get the 'InterlineSettlementValue' element value. Settlement (Price) Value. Example: 300 (USD)

                    Note: This represents a Settlement value that is only used between the POA and ORA.
                     * 
                     * @return value
                     */
                    public CurrencyAmountOptType getInterlineSettlementValue() {
                        return interlineSettlementValue;
                    }

                    /** 
                     * Set the 'InterlineSettlementValue' element value. Settlement (Price) Value. Example: 300 (USD)

                    Note: This represents a Settlement value that is only used between the POA and ORA.
                     * 
                     * @param interlineSettlementValue
                     */
                    public void setInterlineSettlementValue(
                            CurrencyAmountOptType interlineSettlementValue) {
                        this.interlineSettlementValue = interlineSettlementValue;
                    }
                }
            }
        }
        /** 
         * List of Origin/Destination elements.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element ref="ns:OriginDestination" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OriginDestinationList implements Serializable
        {
            private List<OriginDestination> originDestinationList = new ArrayList<OriginDestination>();

            /** 
             * Get the list of 'OriginDestination' element items.
             * 
             * @return list
             */
            public List<OriginDestination> getOriginDestinationList() {
                return originDestinationList;
            }

            /** 
             * Set the list of 'OriginDestination' element items.
             * 
             * @param list
             */
            public void setOriginDestinationList(List<OriginDestination> list) {
                originDestinationList = list;
            }
        }
        /** 
         * Price Class list.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceClassList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:PriceClassType" name="PriceClass" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PriceClassList implements Serializable
        {
            private List<PriceClassType> priceClassList = new ArrayList<PriceClassType>();

            /** 
             * Get the list of 'PriceClass' element items.
             * 
             * @return list
             */
            public List<PriceClassType> getPriceClassList() {
                return priceClassList;
            }

            /** 
             * Set the list of 'PriceClass' element items.
             * 
             * @param list
             */
            public void setPriceClassList(List<PriceClassType> list) {
                priceClassList = list;
            }
        }
        /** 
         * Description and characteristics of a Service
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceDefinitionList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ServiceDefinitionType" name="ServiceDefinition" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ServiceDefinitionList implements Serializable
        {
            private List<ServiceDefinitionType> serviceDefinitionList = new ArrayList<ServiceDefinitionType>();

            /** 
             * Get the list of 'ServiceDefinition' element items.
             * 
             * @return list
             */
            public List<ServiceDefinitionType> getServiceDefinitionList() {
                return serviceDefinitionList;
            }

            /** 
             * Set the list of 'ServiceDefinition' element items.
             * 
             * @param list
             */
            public void setServiceDefinitionList(
                    List<ServiceDefinitionType> list) {
                serviceDefinitionList = list;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatDefinitionList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="SeatDefinition" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class SeatDefinition -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SeatDefinitionList implements Serializable
        {
            private List<SeatDefinition> seatDefinitionList = new ArrayList<SeatDefinition>();

            /** 
             * Get the list of 'SeatDefinition' element items.
             * 
             * @return list
             */
            public List<SeatDefinition> getSeatDefinitionList() {
                return seatDefinitionList;
            }

            /** 
             * Set the list of 'SeatDefinition' element items.
             * 
             * @param list
             */
            public void setSeatDefinitionList(List<SeatDefinition> list) {
                seatDefinitionList = list;
            }
            /** 
             * Seat information by aircraft section.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatDefinition" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Description" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Description -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="ns:SeatMapMessageType" name="Marketing" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="SeatCharacteristicCode" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element type="ns:SizeUnitSimpleType" name="UOM" minOccurs="0"/>
             *       &lt;xs:element type="xs:decimal" name="SeatWidthLow" minOccurs="0"/>
             *       &lt;xs:element type="xs:decimal" name="SeatPitchLow" minOccurs="0"/>
             *       &lt;xs:element name="Keywords" minOccurs="0">
             *         &lt;!-- Reference to inner class Keywords -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="SeatDefinitionID"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class SeatDefinition implements Serializable
            {
                private List<Description> descriptionList = new ArrayList<Description>();
                private SeatMapMessageType marketing;
                private List<String> seatCharacteristicCodeList = new ArrayList<String>();
                private SizeUnitSimpleType UOM;
                private BigDecimal seatWidthLow;
                private BigDecimal seatPitchLow;
                private Keywords keywords;
                private String seatDefinitionID;

                /** 
                 * Get the list of 'Description' element items.
                 * 
                 * @return list
                 */
                public List<Description> getDescriptionList() {
                    return descriptionList;
                }

                /** 
                 * Set the list of 'Description' element items.
                 * 
                 * @param list
                 */
                public void setDescriptionList(List<Description> list) {
                    descriptionList = list;
                }

                /** 
                 * Get the 'Marketing' element value. Images and/or links for the entire section defined by the range of rows.
                 * 
                 * @return value
                 */
                public SeatMapMessageType getMarketing() {
                    return marketing;
                }

                /** 
                 * Set the 'Marketing' element value. Images and/or links for the entire section defined by the range of rows.
                 * 
                 * @param marketing
                 */
                public void setMarketing(SeatMapMessageType marketing) {
                    this.marketing = marketing;
                }

                /** 
                 * Get the list of 'SeatCharacteristicCode' element items. Refers to aircraft seat characteristics; seat option codes.  Examples: E (EXIT ROW), M (Middle Seat), A (Aisle seat), L (Left side of aircraft), Q (Bulk Head).  Refer to PADIS code list 9825.
                 * 
                 * @return list
                 */
                public List<String> getSeatCharacteristicCodeList() {
                    return seatCharacteristicCodeList;
                }

                /** 
                 * Set the list of 'SeatCharacteristicCode' element items. Refers to aircraft seat characteristics; seat option codes.  Examples: E (EXIT ROW), M (Middle Seat), A (Aisle seat), L (Left side of aircraft), Q (Bulk Head).  Refer to PADIS code list 9825.
                 * 
                 * @param list
                 */
                public void setSeatCharacteristicCodeList(List<String> list) {
                    seatCharacteristicCodeList = list;
                }

                /** 
                 * Get the 'UOM' element value. Associated Keyword Unit of Measure, if relevant. Example: INCH
                 * 
                 * @return value
                 */
                public SizeUnitSimpleType getUOM() {
                    return UOM;
                }

                /** 
                 * Set the 'UOM' element value. Associated Keyword Unit of Measure, if relevant. Example: INCH
                 * 
                 * @param UOM
                 */
                public void setUOM(SizeUnitSimpleType UOM) {
                    this.UOM = UOM;
                }

                /** 
                 * Get the 'SeatWidthLow' element value. Lowest Width Measurement value for this section. Example: 20
                 * 
                 * @return value
                 */
                public BigDecimal getSeatWidthLow() {
                    return seatWidthLow;
                }

                /** 
                 * Set the 'SeatWidthLow' element value. Lowest Width Measurement value for this section. Example: 20
                 * 
                 * @param seatWidthLow
                 */
                public void setSeatWidthLow(BigDecimal seatWidthLow) {
                    this.seatWidthLow = seatWidthLow;
                }

                /** 
                 * Get the 'SeatPitchLow' element value. Lowest Pitch Measurement value for this section. Example: 32
                 * 
                 * @return value
                 */
                public BigDecimal getSeatPitchLow() {
                    return seatPitchLow;
                }

                /** 
                 * Set the 'SeatPitchLow' element value. Lowest Pitch Measurement value for this section. Example: 32
                 * 
                 * @param seatPitchLow
                 */
                public void setSeatPitchLow(BigDecimal seatPitchLow) {
                    this.seatPitchLow = seatPitchLow;
                }

                /** 
                 * Get the 'Keywords' element value.
                 * 
                 * @return value
                 */
                public Keywords getKeywords() {
                    return keywords;
                }

                /** 
                 * Set the 'Keywords' element value.
                 * 
                 * @param keywords
                 */
                public void setKeywords(Keywords keywords) {
                    this.keywords = keywords;
                }

                /** 
                 * Get the 'SeatDefinitionID' attribute value.
                 * 
                 * @return value
                 */
                public String getSeatDefinitionID() {
                    return seatDefinitionID;
                }

                /** 
                 * Set the 'SeatDefinitionID' attribute value.
                 * 
                 * @param seatDefinitionID
                 */
                public void setSeatDefinitionID(String seatDefinitionID) {
                    this.seatDefinitionID = seatDefinitionID;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Description" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:sequence>
                 *         &lt;xs:element name="Text" minOccurs="0">
                 *           &lt;!-- Reference to inner class Text -->
                 *         &lt;/xs:element>
                 *         &lt;xs:element type="xs:string" name="MarkupStyle" minOccurs="0"/>
                 *       &lt;/xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Link" minOccurs="0"/>
                 *       &lt;xs:element name="Media" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class Media -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Description implements Serializable
                {
                    private Text text;
                    private String markupStyle;
                    private String link;
                    private List<Media> mediaList = new ArrayList<Media>();

                    /** 
                     * Get the 'Text' element value.
                     * 
                     * @return value
                     */
                    public Text getText() {
                        return text;
                    }

                    /** 
                     * Set the 'Text' element value.
                     * 
                     * @param text
                     */
                    public void setText(Text text) {
                        this.text = text;
                    }

                    /** 
                     * Get the 'MarkupStyle' element value. Mark-up Style. Example: HTML
                     * 
                     * @return value
                     */
                    public String getMarkupStyle() {
                        return markupStyle;
                    }

                    /** 
                     * Set the 'MarkupStyle' element value. Mark-up Style. Example: HTML
                     * 
                     * @param markupStyle
                     */
                    public void setMarkupStyle(String markupStyle) {
                        this.markupStyle = markupStyle;
                    }

                    /** 
                     * Get the 'Link' element value. LINK to Description information source.
                     * 
                     * @return value
                     */
                    public String getLink() {
                        return link;
                    }

                    /** 
                     * Set the 'Link' element value. LINK to Description information source.
                     * 
                     * @param link
                     */
                    public void setLink(String link) {
                        this.link = link;
                    }

                    /** 
                     * Get the list of 'Media' element items.
                     * 
                     * @return list
                     */
                    public List<Media> getMediaList() {
                        return mediaList;
                    }

                    /** 
                     * Set the list of 'Media' element items.
                     * 
                     * @param list
                     */
                    public void setMediaList(List<Media> list) {
                        mediaList = list;
                    }
                    /** 
                     * Description value.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Text" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:string">
                     *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * 
                     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
                     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
                     * &lt;/xs:attributeGroup>
                     * </pre>
                     */
                    public static class Text implements Serializable
                    {
                        private String string;
                        private String refs;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public String getString() {
                            return string;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param string
                         */
                        public void setString(String string) {
                            this.string = string;
                        }

                        /** 
                         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                         * 
                         * @return value
                         */
                        public String getRefs() {
                            return refs;
                        }

                        /** 
                         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                         * 
                         * @param refs
                         */
                        public void setRefs(String refs) {
                            this.refs = refs;
                        }
                    }
                    /** 
                     * Description-associated Media Object(s).
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Media" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:choice>
                     *       &lt;xs:element type="ns:UniqueIDContextType" name="ObjectID"/>
                     *       &lt;xs:element ref="ns:MediaLink"/>
                     *       &lt;xs:element type="ns:UniqueIDContextType" name="AttachmentID"/>
                     *     &lt;/xs:choice>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Media implements Serializable
                    {
                        private int mediaListSelect = -1;
                        private static final int OBJECT_ID_CHOICE = 0;
                        private static final int MEDIA_LINK_CHOICE = 1;
                        private static final int ATTACHMENT_ID_CHOICE = 2;
                        private UniqueIDContextType objectID;
                        private MediaLink mediaLink;
                        private UniqueIDContextType attachmentID;

                        private void setMediaListSelect(int choice) {
                            if (mediaListSelect == -1) {
                                mediaListSelect = choice;
                            } else if (mediaListSelect != choice) {
                                throw new IllegalStateException(
                                        "Need to call clearMediaListSelect() before changing existing choice");
                            }
                        }

                        /** 
                         * Clear the choice selection.
                         */
                        public void clearMediaListSelect() {
                            mediaListSelect = -1;
                        }

                        /** 
                         * Check if ObjectID is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifObjectID() {
                            return mediaListSelect == OBJECT_ID_CHOICE;
                        }

                        /** 
                         * Get the 'ObjectID' element value. Description-associated MEDIA OBJECT ID or Key. Example: IMG1
                         * 
                         * @return value
                         */
                        public UniqueIDContextType getObjectID() {
                            return objectID;
                        }

                        /** 
                         * Set the 'ObjectID' element value. Description-associated MEDIA OBJECT ID or Key. Example: IMG1
                         * 
                         * @param objectID
                         */
                        public void setObjectID(UniqueIDContextType objectID) {
                            setMediaListSelect(OBJECT_ID_CHOICE);
                            this.objectID = objectID;
                        }

                        /** 
                         * Check if MediaLink is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifMediaLink() {
                            return mediaListSelect == MEDIA_LINK_CHOICE;
                        }

                        /** 
                         * Get the 'MediaLink' element value. Description-associated MEDIA LINK.
                         * 
                         * @return value
                         */
                        public MediaLink getMediaLink() {
                            return mediaLink;
                        }

                        /** 
                         * Set the 'MediaLink' element value. Description-associated MEDIA LINK.
                         * 
                         * @param mediaLink
                         */
                        public void setMediaLink(MediaLink mediaLink) {
                            setMediaListSelect(MEDIA_LINK_CHOICE);
                            this.mediaLink = mediaLink;
                        }

                        /** 
                         * Check if AttachmentID is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifAttachmentID() {
                            return mediaListSelect == ATTACHMENT_ID_CHOICE;
                        }

                        /** 
                         * Get the 'AttachmentID' element value. Description-associated Media Attachment ID. Example: ATT1.
                         * 
                         * @return value
                         */
                        public UniqueIDContextType getAttachmentID() {
                            return attachmentID;
                        }

                        /** 
                         * Set the 'AttachmentID' element value. Description-associated Media Attachment ID. Example: ATT1.
                         * 
                         * @param attachmentID
                         */
                        public void setAttachmentID(
                                UniqueIDContextType attachmentID) {
                            setMediaListSelect(ATTACHMENT_ID_CHOICE);
                            this.attachmentID = attachmentID;
                        }
                    }
                }
                /** 
                 * Seat Description Key-Value Word Pairs.
                Examples:
                ReclineDegree - 25
                BedLengthLowEnd - 68
                BedLengthHighEnd - 78
                WidthLowEnd - 20
                WidthHighEnd - 21.5
                PitchLowEnd - 32
                PitchHighEnd - 34.4

                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Keywords" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="ns:KeyWordType" name="KeyWord" maxOccurs="unbounded"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Keywords implements Serializable
                {
                    private List<KeyWordType> keyWordList = new ArrayList<KeyWordType>();

                    /** 
                     * Get the list of 'KeyWord' element items. Key-Value detail.
                     * 
                     * @return list
                     */
                    public List<KeyWordType> getKeyWordList() {
                        return keyWordList;
                    }

                    /** 
                     * Set the list of 'KeyWord' element items. Key-Value detail.
                     * 
                     * @param list
                     */
                    public void setKeyWordList(List<KeyWordType> list) {
                        keyWordList = list;
                    }
                }
            }
        }
    }
}
