
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * The OrderRetrieve/ OrderView transaction set retrieves a specified order that matches one or more search criteria.

 Search criteria may include any supported Order Reference information, which may be the Order ID, a PNR reference, a ticket or coupon/ document number, or other Airline supported order reference and a Traveler Surname and Given Name.

 Note that if the order retrieval request is initiated from the party that originally requested the order creation, then an Order Reference is sufficient with the identity of the requesting party.

 If the order retrieval request is initiated from a party that did not originally request the order creation, then an extended security mechanism may be used to extend order view access to the party (e.g. using a CustomerInputRQ/RS for an additional security challenge (e.g. custom security question and answers.)

 The requestor may additionally specify filters to constrain the response information sets, including: Trip itinerary, Flight segment, Passenger, Payment and Accountable document information. If no filters are specified, all order information is returned.

 If a matching order is found, the OrderView response will contain all order information or filtered information (if filters were requested in the order retrieval request.) If no matching Order is located, the OrderView response will include processing condition information and no order information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderRetrieveRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:PointOfSale" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element ref="ns:OrderRetrieveParameters" minOccurs="0"/>
 *       &lt;xs:element name="Query">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element name="Filters">
 *               &lt;xs:complexType>
 *                 &lt;xs:sequence>
 *                   &lt;xs:element ref="ns:OrderID" minOccurs="0"/>
 *                   &lt;xs:element name="Flight" minOccurs="0">
 *                     &lt;!-- Reference to inner class Flight -->
 *                   &lt;/xs:element>
 *                   &lt;xs:element name="Passengers" minOccurs="0">
 *                     &lt;!-- Reference to inner class Passengers -->
 *                   &lt;/xs:element>
 *                   &lt;xs:element name="TicketDocument" minOccurs="0">
 *                     &lt;!-- Reference to inner class TicketDocument -->
 *                   &lt;/xs:element>
 *                   &lt;xs:element name="Group" minOccurs="0">
 *                     &lt;!-- Reference to inner class Group -->
 *                   &lt;/xs:element>
 *                   &lt;xs:element name="Payments" minOccurs="0">
 *                     &lt;!-- Reference to inner class Payments -->
 *                   &lt;/xs:element>
 *                   &lt;xs:element ref="ns:BookingReferences" minOccurs="0"/>
 *                 &lt;/xs:sequence>
 *               &lt;/xs:complexType>
 *             &lt;/xs:element>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OrderRetrieveRQ implements Serializable
{
    private PointOfSaleType pointOfSale;
    private MsgDocumentType document;
    private MsgPartiesType party;
    private OrdRetrieveParamsType orderRetrieveParameters;
    private OrderIDType queryOrderID;
    private Flight flight;
    private Passengers passengers;
    private TicketDocument ticketDocument;
    private Group group;
    private Payments payments;
    private BookingReferences queryBookingReferences;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'PointOfSale' element value.
     * 
     * @return value
     */
    public PointOfSaleType getPointOfSale() {
        return pointOfSale;
    }

    /** 
     * Set the 'PointOfSale' element value.
     * 
     * @param pointOfSale
     */
    public void setPointOfSale(PointOfSaleType pointOfSale) {
        this.pointOfSale = pointOfSale;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    /** 
     * Get the 'OrderRetrieveParameters' element value.
     * 
     * @return value
     */
    public OrdRetrieveParamsType getOrderRetrieveParameters() {
        return orderRetrieveParameters;
    }

    /** 
     * Set the 'OrderRetrieveParameters' element value.
     * 
     * @param orderRetrieveParameters
     */
    public void setOrderRetrieveParameters(
            OrdRetrieveParamsType orderRetrieveParameters) {
        this.orderRetrieveParameters = orderRetrieveParameters;
    }

    /** 
     * Get the 'OrderID' element value.
     * 
     * @return value
     */
    public OrderIDType getQueryOrderID() {
        return queryOrderID;
    }

    /** 
     * Set the 'OrderID' element value.
     * 
     * @param queryOrderID
     */
    public void setQueryOrderID(OrderIDType queryOrderID) {
        this.queryOrderID = queryOrderID;
    }

    /** 
     * Get the 'Flight' element value. Query Filters.
     * 
     * @return value
     */
    public Flight getFlight() {
        return flight;
    }

    /** 
     * Set the 'Flight' element value. Query Filters.
     * 
     * @param flight
     */
    public void setFlight(Flight flight) {
        this.flight = flight;
    }

    /** 
     * Get the 'Passengers' element value. Query Filters.
     * 
     * @return value
     */
    public Passengers getPassengers() {
        return passengers;
    }

    /** 
     * Set the 'Passengers' element value. Query Filters.
     * 
     * @param passengers
     */
    public void setPassengers(Passengers passengers) {
        this.passengers = passengers;
    }

    /** 
     * Get the 'TicketDocument' element value. Query Filters.
     * 
     * @return value
     */
    public TicketDocument getTicketDocument() {
        return ticketDocument;
    }

    /** 
     * Set the 'TicketDocument' element value. Query Filters.
     * 
     * @param ticketDocument
     */
    public void setTicketDocument(TicketDocument ticketDocument) {
        this.ticketDocument = ticketDocument;
    }

    /** 
     * Get the 'Group' element value. Query Filters.
     * 
     * @return value
     */
    public Group getGroup() {
        return group;
    }

    /** 
     * Set the 'Group' element value. Query Filters.
     * 
     * @param group
     */
    public void setGroup(Group group) {
        this.group = group;
    }

    /** 
     * Get the 'Payments' element value. Query Filters.
     * 
     * @return value
     */
    public Payments getPayments() {
        return payments;
    }

    /** 
     * Set the 'Payments' element value. Query Filters.
     * 
     * @param payments
     */
    public void setPayments(Payments payments) {
        this.payments = payments;
    }

    /** 
     * Get the 'BookingReferences' element value. Existing Booking Reference (e.g. PNR Record Locator). Example: R1A3SK
     * 
     * @return value
     */
    public BookingReferences getQueryBookingReferences() {
        return queryBookingReferences;
    }

    /** 
     * Set the 'BookingReferences' element value. Existing Booking Reference (e.g. PNR Record Locator). Example: R1A3SK
     * 
     * @param queryBookingReferences
     */
    public void setQueryBookingReferences(
            BookingReferences queryBookingReferences) {
        this.queryBookingReferences = queryBookingReferences;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Flight Filters.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Flight" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:ClassOfService" minOccurs="0"/>
     *       &lt;xs:element ref="ns:FareBasisCode" minOccurs="0"/>
     *       &lt;xs:element name="OriginDestination" minOccurs="0">
     *         &lt;!-- Reference to inner class OriginDestination -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Segment" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Segment -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Flight implements Serializable
    {
        private FlightCOSCoreType classOfService;
        private FareBasisCodeType fareBasisCode;
        private OriginDestination originDestination;
        private List<Segment> segmentList = new ArrayList<Segment>();

        /** 
         * Get the 'ClassOfService' element value.
         * 
         * @return value
         */
        public FlightCOSCoreType getClassOfService() {
            return classOfService;
        }

        /** 
         * Set the 'ClassOfService' element value.
         * 
         * @param classOfService
         */
        public void setClassOfService(FlightCOSCoreType classOfService) {
            this.classOfService = classOfService;
        }

        /** 
         * Get the 'FareBasisCode' element value.
         * 
         * @return value
         */
        public FareBasisCodeType getFareBasisCode() {
            return fareBasisCode;
        }

        /** 
         * Set the 'FareBasisCode' element value.
         * 
         * @param fareBasisCode
         */
        public void setFareBasisCode(FareBasisCodeType fareBasisCode) {
            this.fareBasisCode = fareBasisCode;
        }

        /** 
         * Get the 'OriginDestination' element value.
         * 
         * @return value
         */
        public OriginDestination getOriginDestination() {
            return originDestination;
        }

        /** 
         * Set the 'OriginDestination' element value.
         * 
         * @param originDestination
         */
        public void setOriginDestination(OriginDestination originDestination) {
            this.originDestination = originDestination;
        }

        /** 
         * Get the list of 'Segment' element items.
         * 
         * @return list
         */
        public List<Segment> getSegmentList() {
            return segmentList;
        }

        /** 
         * Set the list of 'Segment' element items.
         * 
         * @param list
         */
        public void setSegmentList(List<Segment> list) {
            segmentList = list;
        }
        /** 
         * Flight origin/ destination information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestination" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Departure">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element name="AirportCode">
         *               &lt;xs:complexType>
         *                 &lt;xs:simpleContent>
         *                   &lt;xs:extension base="xs:string">
         *                     &lt;xs:attributeGroup ref="ns:RadiusAttrGroup"/>
         *                   &lt;/xs:extension>
         *                 &lt;/xs:simpleContent>
         *               &lt;/xs:complexType>
         *             &lt;/xs:element>
         *             &lt;xs:element type="xs:date" name="Date"/>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="Arrival">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element name="AirportCode">
         *               &lt;xs:complexType>
         *                 &lt;xs:simpleContent>
         *                   &lt;xs:extension base="xs:string">
         *                     &lt;xs:attributeGroup ref="ns:RadiusAttrGroup"/>
         *                   &lt;/xs:extension>
         *                 &lt;/xs:simpleContent>
         *               &lt;/xs:complexType>
         *             &lt;/xs:element>
         *             &lt;xs:element type="xs:date" name="Date"/>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class OriginDestination implements Serializable
        {
            private String departureAirportCodeString;
            private RadiusAttrGroup departureAirportCodeRadiusAttrGroup;
            private Date departureDate;
            private String arrivalAirportCodeString;
            private RadiusAttrGroup arrivalAirportCodeRadiusAttrGroup;
            private Date arrivalDate;
            private String refs;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getDepartureAirportCodeString() {
                return departureAirportCodeString;
            }

            /** 
             * Set the extension value.
             * 
             * @param departureAirportCodeString
             */
            public void setDepartureAirportCodeString(
                    String departureAirportCodeString) {
                this.departureAirportCodeString = departureAirportCodeString;
            }

            /** 
             * Get the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
             * 
             * @return value
             */
            public RadiusAttrGroup getDepartureAirportCodeRadiusAttrGroup() {
                return departureAirportCodeRadiusAttrGroup;
            }

            /** 
             * Set the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
             * 
             * @param departureAirportCodeRadiusAttrGroup
             */
            public void setDepartureAirportCodeRadiusAttrGroup(
                    RadiusAttrGroup departureAirportCodeRadiusAttrGroup) {
                this.departureAirportCodeRadiusAttrGroup = departureAirportCodeRadiusAttrGroup;
            }

            /** 
             * Get the 'Date' element value. Departure date. Example: 2017-01-13

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @return value
             */
            public Date getDepartureDate() {
                return departureDate;
            }

            /** 
             * Set the 'Date' element value. Departure date. Example: 2017-01-13

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @param departureDate
             */
            public void setDepartureDate(Date departureDate) {
                this.departureDate = departureDate;
            }

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getArrivalAirportCodeString() {
                return arrivalAirportCodeString;
            }

            /** 
             * Set the extension value.
             * 
             * @param arrivalAirportCodeString
             */
            public void setArrivalAirportCodeString(
                    String arrivalAirportCodeString) {
                this.arrivalAirportCodeString = arrivalAirportCodeString;
            }

            /** 
             * Get the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
             * 
             * @return value
             */
            public RadiusAttrGroup getArrivalAirportCodeRadiusAttrGroup() {
                return arrivalAirportCodeRadiusAttrGroup;
            }

            /** 
             * Set the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
             * 
             * @param arrivalAirportCodeRadiusAttrGroup
             */
            public void setArrivalAirportCodeRadiusAttrGroup(
                    RadiusAttrGroup arrivalAirportCodeRadiusAttrGroup) {
                this.arrivalAirportCodeRadiusAttrGroup = arrivalAirportCodeRadiusAttrGroup;
            }

            /** 
             * Get the 'Date' element value. Arrival date. Example: 2017-01-14

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @return value
             */
            public Date getArrivalDate() {
                return arrivalDate;
            }

            /** 
             * Set the 'Date' element value. Arrival date. Example: 2017-01-14

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @param arrivalDate
             */
            public void setArrivalDate(Date arrivalDate) {
                this.arrivalDate = arrivalDate;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }
        }
        /** 
         * Flight segment information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Segment" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Departure">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element name="AirportCode">
         *               &lt;xs:complexType>
         *                 &lt;xs:simpleContent>
         *                   &lt;xs:extension base="xs:string">
         *                     &lt;xs:attributeGroup ref="ns:RadiusAttrGroup"/>
         *                   &lt;/xs:extension>
         *                 &lt;/xs:simpleContent>
         *               &lt;/xs:complexType>
         *             &lt;/xs:element>
         *             &lt;xs:element type="xs:date" name="Date"/>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="Arrival">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element name="AirportCode">
         *               &lt;xs:complexType>
         *                 &lt;xs:simpleContent>
         *                   &lt;xs:extension base="xs:string">
         *                     &lt;xs:attributeGroup ref="ns:RadiusAttrGroup"/>
         *                   &lt;/xs:extension>
         *                 &lt;/xs:simpleContent>
         *               &lt;/xs:complexType>
         *             &lt;/xs:element>
         *             &lt;xs:element type="xs:date" name="Date"/>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class Segment implements Serializable
        {
            private String departureAirportCodeString;
            private RadiusAttrGroup departureAirportCodeRadiusAttrGroup;
            private Date departureDate;
            private String arrivalAirportCodeString;
            private RadiusAttrGroup arrivalAirportCodeRadiusAttrGroup;
            private Date arrivalDate;
            private String refs;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getDepartureAirportCodeString() {
                return departureAirportCodeString;
            }

            /** 
             * Set the extension value.
             * 
             * @param departureAirportCodeString
             */
            public void setDepartureAirportCodeString(
                    String departureAirportCodeString) {
                this.departureAirportCodeString = departureAirportCodeString;
            }

            /** 
             * Get the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
             * 
             * @return value
             */
            public RadiusAttrGroup getDepartureAirportCodeRadiusAttrGroup() {
                return departureAirportCodeRadiusAttrGroup;
            }

            /** 
             * Set the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
             * 
             * @param departureAirportCodeRadiusAttrGroup
             */
            public void setDepartureAirportCodeRadiusAttrGroup(
                    RadiusAttrGroup departureAirportCodeRadiusAttrGroup) {
                this.departureAirportCodeRadiusAttrGroup = departureAirportCodeRadiusAttrGroup;
            }

            /** 
             * Get the 'Date' element value. Departure date. Example: 2017-01-13

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @return value
             */
            public Date getDepartureDate() {
                return departureDate;
            }

            /** 
             * Set the 'Date' element value. Departure date. Example: 2017-01-13

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @param departureDate
             */
            public void setDepartureDate(Date departureDate) {
                this.departureDate = departureDate;
            }

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getArrivalAirportCodeString() {
                return arrivalAirportCodeString;
            }

            /** 
             * Set the extension value.
             * 
             * @param arrivalAirportCodeString
             */
            public void setArrivalAirportCodeString(
                    String arrivalAirportCodeString) {
                this.arrivalAirportCodeString = arrivalAirportCodeString;
            }

            /** 
             * Get the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
             * 
             * @return value
             */
            public RadiusAttrGroup getArrivalAirportCodeRadiusAttrGroup() {
                return arrivalAirportCodeRadiusAttrGroup;
            }

            /** 
             * Set the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
             * 
             * @param arrivalAirportCodeRadiusAttrGroup
             */
            public void setArrivalAirportCodeRadiusAttrGroup(
                    RadiusAttrGroup arrivalAirportCodeRadiusAttrGroup) {
                this.arrivalAirportCodeRadiusAttrGroup = arrivalAirportCodeRadiusAttrGroup;
            }

            /** 
             * Get the 'Date' element value. Arrival date. Example: 2017-01-14

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @return value
             */
            public Date getArrivalDate() {
                return arrivalDate;
            }

            /** 
             * Set the 'Date' element value. Arrival date. Example: 2017-01-14

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @param arrivalDate
             */
            public void setArrivalDate(Date arrivalDate) {
                this.arrivalDate = arrivalDate;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }
        }
    }
    /** 
     * Passenger and Group information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Individual" minOccurs="0">
     *         &lt;!-- Reference to inner class Individual -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="ProfileID" minOccurs="0"/>
     *       &lt;xs:element name="LoyaltyProgramAccount" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class LoyaltyProgramAccount -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:FOID" name="FOID" minOccurs="0"/>
     *       &lt;xs:element type="ns:IdentityDocumentType" name="IdentityDocument" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element name="ContactInformation" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class ContactInformation -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Passengers implements Serializable
    {
        private Individual individual;
        private String profileID;
        private List<LoyaltyProgramAccount> loyaltyProgramAccountList = new ArrayList<LoyaltyProgramAccount>();
        private FOID FOID;
        private List<IdentityDocumentType> identityDocumentList = new ArrayList<IdentityDocumentType>();
        private List<ContactInformation> contactInformationList = new ArrayList<ContactInformation>();

        /** 
         * Get the 'Individual' element value.
         * 
         * @return value
         */
        public Individual getIndividual() {
            return individual;
        }

        /** 
         * Set the 'Individual' element value.
         * 
         * @param individual
         */
        public void setIndividual(Individual individual) {
            this.individual = individual;
        }

        /** 
         * Get the 'ProfileID' element value. Passenger Profile ID
         * 
         * @return value
         */
        public String getProfileID() {
            return profileID;
        }

        /** 
         * Set the 'ProfileID' element value. Passenger Profile ID
         * 
         * @param profileID
         */
        public void setProfileID(String profileID) {
            this.profileID = profileID;
        }

        /** 
         * Get the list of 'LoyaltyProgramAccount' element items.
         * 
         * @return list
         */
        public List<LoyaltyProgramAccount> getLoyaltyProgramAccountList() {
            return loyaltyProgramAccountList;
        }

        /** 
         * Set the list of 'LoyaltyProgramAccount' element items.
         * 
         * @param list
         */
        public void setLoyaltyProgramAccountList(
                List<LoyaltyProgramAccount> list) {
            loyaltyProgramAccountList = list;
        }

        /** 
         * Get the 'FOID' element value. Form of identification.  Typically used to identify that the passenger is who he says he is.

        This is the type of FOID as defined in AIRIMP (FF Number, Credit Card Number, etc.).

         * 
         * @return value
         */
        public FOID getFOID() {
            return FOID;
        }

        /** 
         * Set the 'FOID' element value. Form of identification.  Typically used to identify that the passenger is who he says he is.

        This is the type of FOID as defined in AIRIMP (FF Number, Credit Card Number, etc.).

         * 
         * @param FOID
         */
        public void setFOID(FOID FOID) {
            this.FOID = FOID;
        }

        /** 
         * Get the list of 'IdentityDocument' element items. Any document which may be used to identify a person or verify aspects of a person's personal identity.
         * 
         * @return list
         */
        public List<IdentityDocumentType> getIdentityDocumentList() {
            return identityDocumentList;
        }

        /** 
         * Set the list of 'IdentityDocument' element items. Any document which may be used to identify a person or verify aspects of a person's personal identity.
         * 
         * @param list
         */
        public void setIdentityDocumentList(List<IdentityDocumentType> list) {
            identityDocumentList = list;
        }

        /** 
         * Get the list of 'ContactInformation' element items.
         * 
         * @return list
         */
        public List<ContactInformation> getContactInformationList() {
            return contactInformationList;
        }

        /** 
         * Set the list of 'ContactInformation' element items.
         * 
         * @param list
         */
        public void setContactInformationList(List<ContactInformation> list) {
            contactInformationList = list;
        }
        /** 
         * A single human being as distinct from a group, class, or family.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Individual" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="GivenName" minOccurs="0" maxOccurs="5"/>
         *       &lt;xs:element type="xs:string" name="MiddleName" minOccurs="0" maxOccurs="3"/>
         *       &lt;xs:element type="xs:string" name="Surname"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Individual implements Serializable
        {
            private List<String> givenNameList = new ArrayList<String>();
            private List<String> middleNameList = new ArrayList<String>();
            private String surname;

            /** 
             * Get the list of 'GivenName' element items. Individual's first or given name. Example: JOHN.
             * 
             * @return list
             */
            public List<String> getGivenNameList() {
                return givenNameList;
            }

            /** 
             * Set the list of 'GivenName' element items. Individual's first or given name. Example: JOHN.
             * 
             * @param list
             */
            public void setGivenNameList(List<String> list) {
                givenNameList = list;
            }

            /** 
             * Get the list of 'MiddleName' element items. Individual's middle name or initial.  Examples: G, GEORGE
             * 
             * @return list
             */
            public List<String> getMiddleNameList() {
                return middleNameList;
            }

            /** 
             * Set the list of 'MiddleName' element items. Individual's middle name or initial.  Examples: G, GEORGE
             * 
             * @param list
             */
            public void setMiddleNameList(List<String> list) {
                middleNameList = list;
            }

            /** 
             * Get the 'Surname' element value. Individual's family name, last name. Example: SMITH.
             * 
             * @return value
             */
            public String getSurname() {
                return surname;
            }

            /** 
             * Set the 'Surname' element value. Individual's family name, last name. Example: SMITH.
             * 
             * @param surname
             */
            public void setSurname(String surname) {
                this.surname = surname;
            }
        }
        /** 
         * The account set up for a customer within a rewards program which holds funds on behalf of that customer.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LoyaltyProgramAccount" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:AirlineTypeAIDM" name="Airline" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="ProgramName" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="ProgramCode" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="AccountNumber" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="SignInID" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class LoyaltyProgramAccount implements Serializable
        {
            private AirlineTypeAIDM airline;
            private String programName;
            private String programCode;
            private String accountNumber;
            private String signInID;

            /** 
             * Get the 'Airline' element value. An enterprise operating aircraft for commercial purposes
             * 
             * @return value
             */
            public AirlineTypeAIDM getAirline() {
                return airline;
            }

            /** 
             * Set the 'Airline' element value. An enterprise operating aircraft for commercial purposes
             * 
             * @param airline
             */
            public void setAirline(AirlineTypeAIDM airline) {
                this.airline = airline;
            }

            /** 
             * Get the 'ProgramName' element value. Loyalty Program Name. Example: Miles and More
             * 
             * @return value
             */
            public String getProgramName() {
                return programName;
            }

            /** 
             * Set the 'ProgramName' element value. Loyalty Program Name. Example: Miles and More
             * 
             * @param programName
             */
            public void setProgramName(String programName) {
                this.programName = programName;
            }

            /** 
             * Get the 'ProgramCode' element value. Loyalty Program ID: Example: MAM
             * 
             * @return value
             */
            public String getProgramCode() {
                return programCode;
            }

            /** 
             * Set the 'ProgramCode' element value. Loyalty Program ID: Example: MAM
             * 
             * @param programCode
             */
            public void setProgramCode(String programCode) {
                this.programCode = programCode;
            }

            /** 
             * Get the 'AccountNumber' element value. Loyalty Program account number. Example: ABC123456
             * 
             * @return value
             */
            public String getAccountNumber() {
                return accountNumber;
            }

            /** 
             * Set the 'AccountNumber' element value. Loyalty Program account number. Example: ABC123456
             * 
             * @param accountNumber
             */
            public void setAccountNumber(String accountNumber) {
                this.accountNumber = accountNumber;
            }

            /** 
             * Get the 'SignInID' element value. Loyalty Program sign-in ID (or username).
             * 
             * @return value
             */
            public String getSignInID() {
                return signInID;
            }

            /** 
             * Set the 'SignInID' element value. Loyalty Program sign-in ID (or username).
             * 
             * @param signInID
             */
            public void setSignInID(String signInID) {
                this.signInID = signInID;
            }
        }
        /** 
         * Contact Information, within the context of one message.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactInformation" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="ContactType" minOccurs="0"/>
         *       &lt;xs:element type="ns:PostalAddressType" name="PostalAddress" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="ns:EmailAddressType" name="EmailAddress" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="ns:PhoneTypeAIDM" name="Phone" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="ns:OtherAddressType" name="OtherAddress" minOccurs="0" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ContactInformation implements Serializable
        {
            private String contactType;
            private List<PostalAddressType> postalAddressList = new ArrayList<PostalAddressType>();
            private List<EmailAddressType> emailAddressList = new ArrayList<EmailAddressType>();
            private List<PhoneTypeAIDM> phoneList = new ArrayList<PhoneTypeAIDM>();
            private List<OtherAddressType> otherAddressList = new ArrayList<OtherAddressType>();

            /** 
             * Get the 'ContactType' element value. Classification for a particular set of contact information (e.g. Primary, Payment, etc.)
             * 
             * @return value
             */
            public String getContactType() {
                return contactType;
            }

            /** 
             * Set the 'ContactType' element value. Classification for a particular set of contact information (e.g. Primary, Payment, etc.)
             * 
             * @param contactType
             */
            public void setContactType(String contactType) {
                this.contactType = contactType;
            }

            /** 
             * Get the list of 'PostalAddress' element items. The address used for postal service. Examples are post office boxes address, postal physical address, postal code
             * 
             * @return list
             */
            public List<PostalAddressType> getPostalAddressList() {
                return postalAddressList;
            }

            /** 
             * Set the list of 'PostalAddress' element items. The address used for postal service. Examples are post office boxes address, postal physical address, postal code
             * 
             * @param list
             */
            public void setPostalAddressList(List<PostalAddressType> list) {
                postalAddressList = list;
            }

            /** 
             * Get the list of 'EmailAddress' element items. The email address which should be used for contact purposes.
             * 
             * @return list
             */
            public List<EmailAddressType> getEmailAddressList() {
                return emailAddressList;
            }

            /** 
             * Set the list of 'EmailAddress' element items. The email address which should be used for contact purposes.
             * 
             * @param list
             */
            public void setEmailAddressList(List<EmailAddressType> list) {
                emailAddressList = list;
            }

            /** 
             * Get the list of 'Phone' element items. A telephone number is a sequence of digits assigned to a fixed-line telephone subscriber station connected to a telephone line or to a wireless electronic telephony device, such as a radio telephone or a mobile telephone, or to other devices for data transmission via the public switched telephone network (PSTN) or other private networks.

             * 
             * @return list
             */
            public List<PhoneTypeAIDM> getPhoneList() {
                return phoneList;
            }

            /** 
             * Set the list of 'Phone' element items. A telephone number is a sequence of digits assigned to a fixed-line telephone subscriber station connected to a telephone line or to a wireless electronic telephony device, such as a radio telephone or a mobile telephone, or to other devices for data transmission via the public switched telephone network (PSTN) or other private networks.

             * 
             * @param list
             */
            public void setPhoneList(List<PhoneTypeAIDM> list) {
                phoneList = list;
            }

            /** 
             * Get the list of 'OtherAddress' element items. Other Contact Method information.   (i.e. social media handle, website, etc.)
             * 
             * @return list
             */
            public List<OtherAddressType> getOtherAddressList() {
                return otherAddressList;
            }

            /** 
             * Set the list of 'OtherAddress' element items. Other Contact Method information.   (i.e. social media handle, website, etc.)
             * 
             * @param list
             */
            public void setOtherAddressList(List<OtherAddressType> list) {
                otherAddressList = list;
            }
        }
    }
    /** 
     * Ticket document numbers.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketDocument" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="TicketDocNbr"/>
     *       &lt;xs:element type="xs:date" name="DateOfIssue" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="TicketingLocation" minOccurs="0"/>
     *       &lt;xs:element type="xs:integer" name="CouponNumber" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TicketDocument implements Serializable
    {
        private String ticketDocNbr;
        private Date dateOfIssue;
        private String ticketingLocation;
        private BigInteger couponNumber;

        /** 
         * Get the 'TicketDocNbr' element value. Coupon Document Number.

        Note: This is the document number comprised of the airline code, form code, and serial number.
         * 
         * @return value
         */
        public String getTicketDocNbr() {
            return ticketDocNbr;
        }

        /** 
         * Set the 'TicketDocNbr' element value. Coupon Document Number.

        Note: This is the document number comprised of the airline code, form code, and serial number.
         * 
         * @param ticketDocNbr
         */
        public void setTicketDocNbr(String ticketDocNbr) {
            this.ticketDocNbr = ticketDocNbr;
        }

        /** 
         * Get the 'DateOfIssue' element value. Date of Issue. Example: 2017-01-13
         * 
         * @return value
         */
        public Date getDateOfIssue() {
            return dateOfIssue;
        }

        /** 
         * Set the 'DateOfIssue' element value. Date of Issue. Example: 2017-01-13
         * 
         * @param dateOfIssue
         */
        public void setDateOfIssue(Date dateOfIssue) {
            this.dateOfIssue = dateOfIssue;
        }

        /** 
         * Get the 'TicketingLocation' element value. Airport or City Code. Example: JFK

        Encoding Scheme: IATA/ A4A (three character) Airport or City Code
         * 
         * @return value
         */
        public String getTicketingLocation() {
            return ticketingLocation;
        }

        /** 
         * Set the 'TicketingLocation' element value. Airport or City Code. Example: JFK

        Encoding Scheme: IATA/ A4A (three character) Airport or City Code
         * 
         * @param ticketingLocation
         */
        public void setTicketingLocation(String ticketingLocation) {
            this.ticketingLocation = ticketingLocation;
        }

        /** 
         * Get the 'CouponNumber' element value. Applicable coupon number. Example: 1234
         * 
         * @return value
         */
        public BigInteger getCouponNumber() {
            return couponNumber;
        }

        /** 
         * Set the 'CouponNumber' element value. Applicable coupon number. Example: 1234
         * 
         * @param couponNumber
         */
        public void setCouponNumber(BigInteger couponNumber) {
            this.couponNumber = couponNumber;
        }
    }
    /** 
     * Group Information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Group" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="TotalPartySize" minOccurs="0"/>
     *       &lt;xs:element ref="ns:Contacts" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Group implements Serializable
    {
        private String name;
        private String totalPartySize;
        private Contacts contacts;

        /** 
         * Get the 'Name' element value. Group Name. Example: ABC Tour Club
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'Name' element value. Group Name. Example: ABC Tour Club
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }

        /** 
         * Get the 'TotalPartySize' element value. The Complete Party (TCP) indicating total party size. Example: 12
         * 
         * @return value
         */
        public String getTotalPartySize() {
            return totalPartySize;
        }

        /** 
         * Set the 'TotalPartySize' element value. The Complete Party (TCP) indicating total party size. Example: 12
         * 
         * @param totalPartySize
         */
        public void setTotalPartySize(String totalPartySize) {
            this.totalPartySize = totalPartySize;
        }

        /** 
         * Get the 'Contacts' element value.
         * 
         * @return value
         */
        public Contacts getContacts() {
            return contacts;
        }

        /** 
         * Set the 'Contacts' element value.
         * 
         * @param contacts
         */
        public void setContacts(Contacts contacts) {
            this.contacts = contacts;
        }
    }
    /** 
     * Payment information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payments" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Method" minOccurs="0">
     *         &lt;!-- Reference to inner class Method -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Payments implements Serializable
    {
        private Method method;

        /** 
         * Get the 'Method' element value.
         * 
         * @return value
         */
        public Method getMethod() {
            return method;
        }

        /** 
         * Set the 'Method' element value.
         * 
         * @param method
         */
        public void setMethod(Method method) {
            this.method = method;
        }
        /** 
         * Payment Method detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Method" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="CardCode" minOccurs="0"/>
         *       &lt;xs:element name="MaskedCardNumber" minOccurs="0">
         *         &lt;!-- Reference to inner class MaskedCardNumber -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="TokenizedCardNumber" minOccurs="0"/>
         *       &lt;xs:element name="EffectiveExpireDate" minOccurs="0">
         *         &lt;!-- Reference to inner class EffectiveExpireDate -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="CardHolderName" minOccurs="0">
         *         &lt;!-- Reference to inner class CardHolderName -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class Method implements Serializable
        {
            private String cardCode;
            private MaskedCardNumber maskedCardNumber;
            private String tokenizedCardNumber;
            private EffectiveExpireDate effectiveExpireDate;
            private CardHolderName cardHolderName;
            private String refs;

            /** 
             * Get the 'CardCode' element value. Credit card issuer code. Example: MC

            Note: This is the 2 character code of the credit card issuer.
             * 
             * @return value
             */
            public String getCardCode() {
                return cardCode;
            }

            /** 
             * Set the 'CardCode' element value. Credit card issuer code. Example: MC

            Note: This is the 2 character code of the credit card issuer.
             * 
             * @param cardCode
             */
            public void setCardCode(String cardCode) {
                this.cardCode = cardCode;
            }

            /** 
             * Get the 'MaskedCardNumber' element value.
             * 
             * @return value
             */
            public MaskedCardNumber getMaskedCardNumber() {
                return maskedCardNumber;
            }

            /** 
             * Set the 'MaskedCardNumber' element value.
             * 
             * @param maskedCardNumber
             */
            public void setMaskedCardNumber(MaskedCardNumber maskedCardNumber) {
                this.maskedCardNumber = maskedCardNumber;
            }

            /** 
             * Get the 'TokenizedCardNumber' element value. Tokenized card number.

            Note: This capability may not be supported by all EDIST-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of this capability is not dictated by this specification.
             * 
             * @return value
             */
            public String getTokenizedCardNumber() {
                return tokenizedCardNumber;
            }

            /** 
             * Set the 'TokenizedCardNumber' element value. Tokenized card number.

            Note: This capability may not be supported by all EDIST-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of this capability is not dictated by this specification.
             * 
             * @param tokenizedCardNumber
             */
            public void setTokenizedCardNumber(String tokenizedCardNumber) {
                this.tokenizedCardNumber = tokenizedCardNumber;
            }

            /** 
             * Get the 'EffectiveExpireDate' element value.
             * 
             * @return value
             */
            public EffectiveExpireDate getEffectiveExpireDate() {
                return effectiveExpireDate;
            }

            /** 
             * Set the 'EffectiveExpireDate' element value.
             * 
             * @param effectiveExpireDate
             */
            public void setEffectiveExpireDate(
                    EffectiveExpireDate effectiveExpireDate) {
                this.effectiveExpireDate = effectiveExpireDate;
            }

            /** 
             * Get the 'CardHolderName' element value.
             * 
             * @return value
             */
            public CardHolderName getCardHolderName() {
                return cardHolderName;
            }

            /** 
             * Set the 'CardHolderName' element value.
             * 
             * @param cardHolderName
             */
            public void setCardHolderName(CardHolderName cardHolderName) {
                this.cardHolderName = cardHolderName;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }
            /** 
             * Concealed credit card number, Example: xxxxxxxxxxxx9922
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MaskedCardNumber" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * 
             * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
             *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
             * &lt;/xs:attributeGroup>
             * </pre>
             */
            public static class MaskedCardNumber implements Serializable
            {
                private String string;
                private String refs;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @return value
                 */
                public String getRefs() {
                    return refs;
                }

                /** 
                 * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @param refs
                 */
                public void setRefs(String refs) {
                    this.refs = refs;
                }
            }
            /** 
             * Payment Card Effective and/ or Expiration date(s).
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EffectiveExpireDate" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Effective" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="Expiration" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * 
             * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
             *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
             * &lt;/xs:attributeGroup>
             * </pre>
             */
            public static class EffectiveExpireDate implements Serializable
            {
                private String effective;
                private String expiration;
                private String refs;

                /** 
                 * Get the 'Effective' element value. Payment Card Effective Date. Example: 0116
                 * 
                 * @return value
                 */
                public String getEffective() {
                    return effective;
                }

                /** 
                 * Set the 'Effective' element value. Payment Card Effective Date. Example: 0116
                 * 
                 * @param effective
                 */
                public void setEffective(String effective) {
                    this.effective = effective;
                }

                /** 
                 * Get the 'Expiration' element value. Payment Card Expiration Date. Example: 0119
                 * 
                 * @return value
                 */
                public String getExpiration() {
                    return expiration;
                }

                /** 
                 * Set the 'Expiration' element value. Payment Card Expiration Date. Example: 0119
                 * 
                 * @param expiration
                 */
                public void setExpiration(String expiration) {
                    this.expiration = expiration;
                }

                /** 
                 * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @return value
                 */
                public String getRefs() {
                    return refs;
                }

                /** 
                 * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @param refs
                 */
                public void setRefs(String refs) {
                    this.refs = refs;
                }
            }
            /** 
             * Name of credit card holder. Example: JOHN SMITH
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CardHolderName" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * 
             * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
             *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
             * &lt;/xs:attributeGroup>
             * </pre>
             */
            public static class CardHolderName implements Serializable
            {
                private String string;
                private String refs;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @return value
                 */
                public String getRefs() {
                    return refs;
                }

                /** 
                 * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @param refs
                 */
                public void setRefs(String refs) {
                    this.refs = refs;
                }
            }
        }
    }
}
