
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * The OrderRules transaction set requests the rules, change and penalty fees applicable to a specified order.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderRulesRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:choice>
 *         &lt;xs:sequence>
 *           &lt;xs:element type="ns:SuccessType" name="Success"/>
 *           &lt;xs:element type="ns:WarningsType" name="Warnings" minOccurs="0"/>
 *           &lt;xs:element name="Response">
 *             &lt;xs:complexType>
 *               &lt;xs:sequence>
 *                 &lt;xs:element ref="ns:OrderRulesProcessing" minOccurs="0"/>
 *                 &lt;xs:element type="ns:PenaltyType" name="OrderRules"/>
 *                 &lt;xs:element name="OrderID"/>
 *               &lt;/xs:sequence>
 *             &lt;/xs:complexType>
 *           &lt;/xs:element>
 *         &lt;/xs:sequence>
 *         &lt;xs:element ref="ns:Errors"/>
 *       &lt;/xs:choice>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OrderRulesRS implements Serializable
{
    private MsgDocumentType document;
    private int choiceSelect = -1;
    private static final int SUCCESS_CHOICE = 0;
    private static final int ERRORS_CHOICE = 1;
    private SuccessType success;
    private WarningsType warnings;
    private OrdRulesProcessType responseOrderRulesProcessing;
    private PenaltyType responseOrderRules;
    private ErrorsType errors;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Success is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSuccess() {
        return choiceSelect == SUCCESS_CHOICE;
    }

    /** 
     * Get the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @return value
     */
    public SuccessType getSuccess() {
        return success;
    }

    /** 
     * Set the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @param success
     */
    public void setSuccess(SuccessType success) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.success = success;
    }

    /** 
     * Get the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @return value
     */
    public WarningsType getWarnings() {
        return warnings;
    }

    /** 
     * Set the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @param warnings
     */
    public void setWarnings(WarningsType warnings) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.warnings = warnings;
    }

    /** 
     * Get the 'OrderRulesProcessing' element value. Transaction Processing Results, including processing status, alerts, notices, business warnings, supplemental marketing messages and policy.
     * 
     * @return value
     */
    public OrdRulesProcessType getResponseOrderRulesProcessing() {
        return responseOrderRulesProcessing;
    }

    /** 
     * Set the 'OrderRulesProcessing' element value. Transaction Processing Results, including processing status, alerts, notices, business warnings, supplemental marketing messages and policy.
     * 
     * @param responseOrderRulesProcessing
     */
    public void setResponseOrderRulesProcessing(
            OrdRulesProcessType responseOrderRulesProcessing) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responseOrderRulesProcessing = responseOrderRulesProcessing;
    }

    /** 
     * Get the 'OrderRules' element value. Order Rules.
     * 
     * @return value
     */
    public PenaltyType getResponseOrderRules() {
        return responseOrderRules;
    }

    /** 
     * Set the 'OrderRules' element value. Order Rules.
     * 
     * @param responseOrderRules
     */
    public void setResponseOrderRules(PenaltyType responseOrderRules) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responseOrderRules = responseOrderRules;
    }

    /** 
     * Check if Errors is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifErrors() {
        return choiceSelect == ERRORS_CHOICE;
    }

    /** 
     * Get the 'Errors' element value.
     * 
     * @return value
     */
    public ErrorsType getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value.
     * 
     * @param errors
     */
    public void setErrors(ErrorsType errors) {
        setChoiceSelect(ERRORS_CHOICE);
        this.errors = errors;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
}
