
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.sql.Date;

/** 
 * COUPON-RELATED ORIGINAL TICKET/ DOC ISSUE definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginalIssueType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="IssuingAgentID" minOccurs="0"/>
 *     &lt;xs:element type="xs:date" name="DateOfIssue" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="LocationCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TicketDocumentNbr" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OriginalIssueType implements Serializable
{
    private String issuingAgentID;
    private Date dateOfIssue;
    private String locationCode;
    private String ticketDocumentNbr;

    /** 
     * Get the 'IssuingAgentID' element value. Original Issuer ID. Example: 12345

    Note: This is the ID of the original issuer of the document.
     * 
     * @return value
     */
    public String getIssuingAgentID() {
        return issuingAgentID;
    }

    /** 
     * Set the 'IssuingAgentID' element value. Original Issuer ID. Example: 12345

    Note: This is the ID of the original issuer of the document.
     * 
     * @param issuingAgentID
     */
    public void setIssuingAgentID(String issuingAgentID) {
        this.issuingAgentID = issuingAgentID;
    }

    /** 
     * Get the 'DateOfIssue' element value. Issue Date. Example: 2017-01-13

    Note: This is the date the document was originally issued.
     * 
     * @return value
     */
    public Date getDateOfIssue() {
        return dateOfIssue;
    }

    /** 
     * Set the 'DateOfIssue' element value. Issue Date. Example: 2017-01-13

    Note: This is the date the document was originally issued.
     * 
     * @param dateOfIssue
     */
    public void setDateOfIssue(Date dateOfIssue) {
        this.dateOfIssue = dateOfIssue;
    }

    /** 
     * Get the 'LocationCode' element value. Original Issue Location. Example: JFK

    Encoding Scheme: IATA/ A4A (three character) Airport or City Code
     * 
     * @return value
     */
    public String getLocationCode() {
        return locationCode;
    }

    /** 
     * Set the 'LocationCode' element value. Original Issue Location. Example: JFK

    Encoding Scheme: IATA/ A4A (three character) Airport or City Code
     * 
     * @param locationCode
     */
    public void setLocationCode(String locationCode) {
        this.locationCode = locationCode;
    }

    /** 
     * Get the 'TicketDocumentNbr' element value. Original Ticket/ Document Number. Example: ???

    Note: This is the document number comprised of the airline code, form code, and serial number.
     * 
     * @return value
     */
    public String getTicketDocumentNbr() {
        return ticketDocumentNbr;
    }

    /** 
     * Set the 'TicketDocumentNbr' element value. Original Ticket/ Document Number. Example: ???

    Note: This is the document number comprised of the airline code, form code, and serial number.
     * 
     * @param ticketDocumentNbr
     */
    public void setTicketDocumentNbr(String ticketDocumentNbr) {
        this.ticketDocumentNbr = ticketDocumentNbr;
    }
}
