
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Other Contact Method information.   (i.e. social media handle, website, etc.)
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherAddressType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Label" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OtherAddressValue" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OtherAddressType implements Serializable
{
    private String label;
    private String otherAddressValue;

    /** 
     * Get the 'Label' element value. Used to differentiate multiple Other Addresses of one contact.  (i.e. social media handle, website, etc.)
     * 
     * @return value
     */
    public String getLabel() {
        return label;
    }

    /** 
     * Set the 'Label' element value. Used to differentiate multiple Other Addresses of one contact.  (i.e. social media handle, website, etc.)
     * 
     * @param label
     */
    public void setLabel(String label) {
        this.label = label;
    }

    /** 
     * Get the 'OtherAddressValue' element value. Other Contact Method Value. Example: www.marketingsite.com
     * 
     * @return value
     */
    public String getOtherAddressValue() {
        return otherAddressValue;
    }

    /** 
     * Set the 'OtherAddressValue' element value. Other Contact Method Value. Example: www.marketingsite.com
     * 
     * @param otherAddressValue
     */
    public void setOtherAddressValue(String otherAddressValue) {
        this.otherAddressValue = otherAddressValue;
    }
}
