
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * A data type for Other Offer Optional Associations.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherOfferAssocSimpleType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="AircraftEquipment"/>
 *     &lt;xs:enumeration value="BaggageDisclosure"/>
 *     &lt;xs:enumeration value="CarryOnAllowance"/>
 *     &lt;xs:enumeration value="CheckedBagAllowance"/>
 *     &lt;xs:enumeration value="MediaGroup"/>
 *     &lt;xs:enumeration value="MediaItem"/>
 *     &lt;xs:enumeration value="OfferDisclosure"/>
 *     &lt;xs:enumeration value="OfferInstructions"/>
 *     &lt;xs:enumeration value="OfferTerms"/>
 *     &lt;xs:enumeration value="Penalty"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum OtherOfferAssocSimpleType implements Serializable {
    AIRCRAFT_EQUIPMENT("AircraftEquipment"), BAGGAGE_DISCLOSURE(
            "BaggageDisclosure"), CARRY_ON_ALLOWANCE("CarryOnAllowance"), CHECKED_BAG_ALLOWANCE(
            "CheckedBagAllowance"), MEDIA_GROUP("MediaGroup"), MEDIA_ITEM(
            "MediaItem"), OFFER_DISCLOSURE("OfferDisclosure"), OFFER_INSTRUCTIONS(
            "OfferInstructions"), OFFER_TERMS("OfferTerms"), PENALTY("Penalty");
    private final String value;

    private OtherOfferAssocSimpleType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static OtherOfferAssocSimpleType convert(String value) {
        for (OtherOfferAssocSimpleType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
