
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PGPDataType">
 *   &lt;xs:choice>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="xs:base64Binary" name="PGPKeyID"/>
 *       &lt;xs:element type="xs:base64Binary" name="PGPKeyPacket" minOccurs="0"/>
 *       &lt;xs:any minOccurs="0" maxOccurs="unbounded" processContents="lax" namespace="##other"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="xs:base64Binary" name="PGPKeyPacket"/>
 *       &lt;xs:any minOccurs="0" maxOccurs="unbounded" processContents="lax" namespace="##other"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PGPDataType implements Serializable
{
    private int choiceSelect = -1;
    private static final int PGP_KEY_ID_CHOICE = 0;
    private static final int PGP_KEY_PACKET_CHOICE = 1;
    private byte[] PGPKeyID;
    private byte[] PGPKeyPacket;
    private List<Element> anyList = new ArrayList<Element>();
    private byte[] PGPKeyPacket1;
    private List<Element> anyList1s = new ArrayList<Element>();

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if PGPKeyID is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPGPKeyID() {
        return choiceSelect == PGP_KEY_ID_CHOICE;
    }

    /** 
     * Get the 'PGPKeyID' element value.
     * 
     * @return value
     */
    public byte[] getPGPKeyID() {
        return PGPKeyID;
    }

    /** 
     * Set the 'PGPKeyID' element value.
     * 
     * @param PGPKeyID
     */
    public void setPGPKeyID(byte[] PGPKeyID) {
        setChoiceSelect(PGP_KEY_ID_CHOICE);
        this.PGPKeyID = PGPKeyID;
    }

    /** 
     * Get the 'PGPKeyPacket' element value.
     * 
     * @return value
     */
    public byte[] getPGPKeyPacket() {
        return PGPKeyPacket;
    }

    /** 
     * Set the 'PGPKeyPacket' element value.
     * 
     * @param PGPKeyPacket
     */
    public void setPGPKeyPacket(byte[] PGPKeyPacket) {
        setChoiceSelect(PGP_KEY_ID_CHOICE);
        this.PGPKeyPacket = PGPKeyPacket;
    }

    /** 
     * Get the list of any items.
     * 
     * @return list
     */
    public List<Element> getAnyList() {
        return anyList;
    }

    /** 
     * Set the list of any items.
     * 
     * @param list
     */
    public void setAnyList(List<Element> list) {
        setChoiceSelect(PGP_KEY_ID_CHOICE);
        anyList = list;
    }

    /** 
     * Check if PGPKeyPacket is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPGPKeyPacket() {
        return choiceSelect == PGP_KEY_PACKET_CHOICE;
    }

    /** 
     * Get the 'PGPKeyPacket' element value.
     * 
     * @return value
     */
    public byte[] getPGPKeyPacket1() {
        return PGPKeyPacket1;
    }

    /** 
     * Set the 'PGPKeyPacket' element value.
     * 
     * @param PGPKeyPacket1
     */
    public void setPGPKeyPacket1(byte[] PGPKeyPacket1) {
        setChoiceSelect(PGP_KEY_PACKET_CHOICE);
        this.PGPKeyPacket1 = PGPKeyPacket1;
    }

    /** 
     * Get the list of any items.
     * 
     * @return list
     */
    public List<Element> getAnyList1s() {
        return anyList1s;
    }

    /** 
     * Set the list of any items.
     * 
     * @param list
     */
    public void setAnyList1s(List<Element> list) {
        setChoiceSelect(PGP_KEY_PACKET_CHOICE);
        anyList1s = list;
    }
}
