
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * PARTNER ACTOR, common properties.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PartnerCoreRepType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:ActorObjectType">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:PartnerID"/>
 *         &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Type" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PartnerCoreRepType extends ActorObjectType implements Serializable
{
    private PartnerCompanyIDType partnerID;
    private String name;
    private String type;

    /** 
     * Get the 'PartnerID' element value.
     * 
     * @return value
     */
    public PartnerCompanyIDType getPartnerID() {
        return partnerID;
    }

    /** 
     * Set the 'PartnerID' element value.
     * 
     * @param partnerID
     */
    public void setPartnerID(PartnerCompanyIDType partnerID) {
        this.partnerID = partnerID;
    }

    /** 
     * Get the 'Name' element value. Partner Company Name. Example: Flight Stuff. Inc.
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Partner Company Name. Example: Flight Stuff. Inc.
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'Type' element value. Partner Company Type.  Examples: ServiceProvider, ServiceFulfillment, Merchandise
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value. Partner Company Type.  Examples: ServiceProvider, ServiceFulfillment, Merchandise
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }
}
