
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * A data type for PAYMENT FORM Metadata.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentFormMetadataType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:MetadataObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="CustomerFileReference" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="ExtendedPaymentCode" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="CorporateContractCode" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaymentFormMetadataType extends MetadataObjectBaseType implements
    Serializable
{
    private String customerFileReference;
    private String extendedPaymentCode;
    private String text;
    private String corporateContractCode;

    /** 
     * Get the 'CustomerFileReference' element value. Customer Commercial Account.

    Note: This is a reference number to a commercial account used to further identify the holder of the credit card.
     * 
     * @return value
     */
    public String getCustomerFileReference() {
        return customerFileReference;
    }

    /** 
     * Set the 'CustomerFileReference' element value. Customer Commercial Account.

    Note: This is a reference number to a commercial account used to further identify the holder of the credit card.
     * 
     * @param customerFileReference
     */
    public void setCustomerFileReference(String customerFileReference) {
        this.customerFileReference = customerFileReference;
    }

    /** 
     * Get the 'ExtendedPaymentCode' element value. Extended Payment Month Quantity. Example: 3

    Notes:

    1. This is a code to indicate the number of months over which the customer wishes to pay where the credit card issuer permits.
    2. This capability may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of this capability is not dictated by this specification.
     * 
     * @return value
     */
    public String getExtendedPaymentCode() {
        return extendedPaymentCode;
    }

    /** 
     * Set the 'ExtendedPaymentCode' element value. Extended Payment Month Quantity. Example: 3

    Notes:

    1. This is a code to indicate the number of months over which the customer wishes to pay where the credit card issuer permits.
    2. This capability may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of this capability is not dictated by this specification.
     * 
     * @param extendedPaymentCode
     */
    public void setExtendedPaymentCode(String extendedPaymentCode) {
        this.extendedPaymentCode = extendedPaymentCode;
    }

    /** 
     * Get the 'Text' element value. Unique Transaction Information.

    Note: This may contain unique transaction information supplied to the airline/system provider by the credit card company.
     * 
     * @return value
     */
    public String getText() {
        return text;
    }

    /** 
     * Set the 'Text' element value. Unique Transaction Information.

    Note: This may contain unique transaction information supplied to the airline/system provider by the credit card company.
     * 
     * @param text
     */
    public void setText(String text) {
        this.text = text;
    }

    /** 
     * Get the 'CorporateContractCode' element value. Corporate Contract Code. Example: IBM1234

    Note: This is used to indicate whether the purchase is on behalf of a corporate client that has a contract ith the ticketing agency for the purchase of transportation and related services.
     * 
     * @return value
     */
    public String getCorporateContractCode() {
        return corporateContractCode;
    }

    /** 
     * Set the 'CorporateContractCode' element value. Corporate Contract Code. Example: IBM1234

    Note: This is used to indicate whether the purchase is on behalf of a corporate client that has a contract ith the ticketing agency for the purchase of transportation and related services.
     * 
     * @param corporateContractCode
     */
    public void setCorporateContractCode(String corporateContractCode) {
        this.corporateContractCode = corporateContractCode;
    }
}
