
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * PAYMENT PROCESSING  Information definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentProcessType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Type"/>
 *     &lt;xs:element name="Status" minOccurs="0">
 *       &lt;!-- Reference to inner class Status -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Amount">
 *       &lt;xs:complexType>
 *         &lt;xs:choice>
 *           &lt;xs:element ref="ns:AwardPricing"/>
 *           &lt;xs:element ref="ns:CombinationPricing"/>
 *           &lt;xs:element ref="ns:SimpleCurrencyPrice"/>
 *           &lt;xs:element ref="ns:DetailCurrencyPrice"/>
 *           &lt;xs:element ref="ns:EncodedCurrencyPrice"/>
 *         &lt;/xs:choice>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element name="Method">
 *       &lt;xs:complexType>
 *         &lt;xs:choice>
 *           &lt;xs:element ref="ns:VoucherMethod"/>
 *           &lt;xs:element ref="ns:RedemptionMethod"/>
 *           &lt;xs:element ref="ns:PaymentCardMethod"/>
 *           &lt;xs:element ref="ns:OtherMethod"/>
 *           &lt;xs:element ref="ns:MiscChargeMethod"/>
 *           &lt;xs:element ref="ns:DirectBillMethod"/>
 *           &lt;xs:element ref="ns:CashMethod"/>
 *           &lt;xs:element ref="ns:BankAccountMethod"/>
 *           &lt;xs:element ref="ns:Check"/>
 *         &lt;/xs:choice>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element name="Variance" minOccurs="0">
 *       &lt;!-- Reference to inner class Variance -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Promotions" minOccurs="0">
 *       &lt;!-- Reference to inner class Promotions -->
 *     &lt;/xs:element>
 *     &lt;xs:element ref="ns:Description" minOccurs="0"/>
 *     &lt;xs:element name="Payer" minOccurs="0">
 *       &lt;!-- Reference to inner class Payer -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="OrderItemID" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="SplitFormInd"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class PaymentProcessType implements Serializable
{
    private String type;
    private Status status;
    private int amountSelect = -1;
    private static final int AMOUNT_AWARD_PRICING_CHOICE = 0;
    private static final int AMOUNT_COMBINATION_PRICING_CHOICE = 1;
    private static final int AMOUNT_SIMPLE_CURRENCY_PRICE_CHOICE = 2;
    private static final int AMOUNT_DETAIL_CURRENCY_PRICE_CHOICE = 3;
    private static final int AMOUNT_ENCODED_CURRENCY_PRICE_CHOICE = 4;
    private AwardPriceUnitType amountAwardPricing;
    private CombinationPriceType amountCombinationPricing;
    private SimpleCurrencyPrice amountSimpleCurrencyPrice;
    private DetailCurrencyPriceType amountDetailCurrencyPrice;
    private EncodedCurrencyPrice amountEncodedCurrencyPrice;
    private int methodSelect = -1;
    private static final int METHOD_VOUCHER_METHOD_CHOICE = 0;
    private static final int METHOD_REDEMPTION_METHOD_CHOICE = 1;
    private static final int METHOD_PAYMENT_CARD_METHOD_CHOICE = 2;
    private static final int METHOD_OTHER_METHOD_CHOICE = 3;
    private static final int METHOD_MISC_CHARGE_METHOD_CHOICE = 4;
    private static final int METHOD_DIRECT_BILL_METHOD_CHOICE = 5;
    private static final int METHOD_CASH_METHOD_CHOICE = 6;
    private static final int METHOD_BANK_ACCOUNT_METHOD_CHOICE = 7;
    private static final int METHOD_CHECK_CHOICE = 8;
    private VoucherMethodType methodVoucherMethod;
    private RedemptionMethodType methodRedemptionMethod;
    private PaymentCardMethodType methodPaymentCardMethod;
    private OtherMethodType methodOtherMethod;
    private MiscChargeMethodType methodMiscChargeMethod;
    private DirectBillMethodType methodDirectBillMethod;
    private CashMethodType methodCashMethod;
    private BankAccountMethodType methodBankAccountMethod;
    private Check methodCheck;
    private Variance variance;
    private Promotions promotions;
    private Description description;
    private Payer payer;
    private List<String> orderItemIDList = new ArrayList<String>();
    private String refs;
    private Boolean splitFormInd;

    /** 
     * Get the 'Type' element value. 
              The form of payment type. Examples: Credit Card, Cash. Encoding Scheme: IATA PADIS code list data element [9888] Form of Payment Identification
            
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value. 
              The form of payment type. Examples: Credit Card, Cash. Encoding Scheme: IATA PADIS code list data element [9888] Form of Payment Identification
            
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'Status' element value.
     * 
     * @return value
     */
    public Status getStatus() {
        return status;
    }

    /** 
     * Set the 'Status' element value.
     * 
     * @param status
     */
    public void setStatus(Status status) {
        this.status = status;
    }

    private void setAmountSelect(int choice) {
        if (amountSelect == -1) {
            amountSelect = choice;
        } else if (amountSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearAmountSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearAmountSelect() {
        amountSelect = -1;
    }

    /** 
     * Check if AmountAwardPricing is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAmountAwardPricing() {
        return amountSelect == AMOUNT_AWARD_PRICING_CHOICE;
    }

    /** 
     * Get the 'AwardPricing' element value.
     * 
     * @return value
     */
    public AwardPriceUnitType getAmountAwardPricing() {
        return amountAwardPricing;
    }

    /** 
     * Set the 'AwardPricing' element value.
     * 
     * @param amountAwardPricing
     */
    public void setAmountAwardPricing(AwardPriceUnitType amountAwardPricing) {
        setAmountSelect(AMOUNT_AWARD_PRICING_CHOICE);
        this.amountAwardPricing = amountAwardPricing;
    }

    /** 
     * Check if AmountCombinationPricing is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAmountCombinationPricing() {
        return amountSelect == AMOUNT_COMBINATION_PRICING_CHOICE;
    }

    /** 
     * Get the 'CombinationPricing' element value.
     * 
     * @return value
     */
    public CombinationPriceType getAmountCombinationPricing() {
        return amountCombinationPricing;
    }

    /** 
     * Set the 'CombinationPricing' element value.
     * 
     * @param amountCombinationPricing
     */
    public void setAmountCombinationPricing(
            CombinationPriceType amountCombinationPricing) {
        setAmountSelect(AMOUNT_COMBINATION_PRICING_CHOICE);
        this.amountCombinationPricing = amountCombinationPricing;
    }

    /** 
     * Check if AmountSimpleCurrencyPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAmountSimpleCurrencyPrice() {
        return amountSelect == AMOUNT_SIMPLE_CURRENCY_PRICE_CHOICE;
    }

    /** 
     * Get the 'SimpleCurrencyPrice' element value.
     * 
     * @return value
     */
    public SimpleCurrencyPrice getAmountSimpleCurrencyPrice() {
        return amountSimpleCurrencyPrice;
    }

    /** 
     * Set the 'SimpleCurrencyPrice' element value.
     * 
     * @param amountSimpleCurrencyPrice
     */
    public void setAmountSimpleCurrencyPrice(
            SimpleCurrencyPrice amountSimpleCurrencyPrice) {
        setAmountSelect(AMOUNT_SIMPLE_CURRENCY_PRICE_CHOICE);
        this.amountSimpleCurrencyPrice = amountSimpleCurrencyPrice;
    }

    /** 
     * Check if AmountDetailCurrencyPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAmountDetailCurrencyPrice() {
        return amountSelect == AMOUNT_DETAIL_CURRENCY_PRICE_CHOICE;
    }

    /** 
     * Get the 'DetailCurrencyPrice' element value.
     * 
     * @return value
     */
    public DetailCurrencyPriceType getAmountDetailCurrencyPrice() {
        return amountDetailCurrencyPrice;
    }

    /** 
     * Set the 'DetailCurrencyPrice' element value.
     * 
     * @param amountDetailCurrencyPrice
     */
    public void setAmountDetailCurrencyPrice(
            DetailCurrencyPriceType amountDetailCurrencyPrice) {
        setAmountSelect(AMOUNT_DETAIL_CURRENCY_PRICE_CHOICE);
        this.amountDetailCurrencyPrice = amountDetailCurrencyPrice;
    }

    /** 
     * Check if AmountEncodedCurrencyPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAmountEncodedCurrencyPrice() {
        return amountSelect == AMOUNT_ENCODED_CURRENCY_PRICE_CHOICE;
    }

    /** 
     * Get the 'EncodedCurrencyPrice' element value.
     * 
     * @return value
     */
    public EncodedCurrencyPrice getAmountEncodedCurrencyPrice() {
        return amountEncodedCurrencyPrice;
    }

    /** 
     * Set the 'EncodedCurrencyPrice' element value.
     * 
     * @param amountEncodedCurrencyPrice
     */
    public void setAmountEncodedCurrencyPrice(
            EncodedCurrencyPrice amountEncodedCurrencyPrice) {
        setAmountSelect(AMOUNT_ENCODED_CURRENCY_PRICE_CHOICE);
        this.amountEncodedCurrencyPrice = amountEncodedCurrencyPrice;
    }

    private void setMethodSelect(int choice) {
        if (methodSelect == -1) {
            methodSelect = choice;
        } else if (methodSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearMethodSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearMethodSelect() {
        methodSelect = -1;
    }

    /** 
     * Check if MethodVoucherMethod is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMethodVoucherMethod() {
        return methodSelect == METHOD_VOUCHER_METHOD_CHOICE;
    }

    /** 
     * Get the 'VoucherMethod' element value.
     * 
     * @return value
     */
    public VoucherMethodType getMethodVoucherMethod() {
        return methodVoucherMethod;
    }

    /** 
     * Set the 'VoucherMethod' element value.
     * 
     * @param methodVoucherMethod
     */
    public void setMethodVoucherMethod(VoucherMethodType methodVoucherMethod) {
        setMethodSelect(METHOD_VOUCHER_METHOD_CHOICE);
        this.methodVoucherMethod = methodVoucherMethod;
    }

    /** 
     * Check if MethodRedemptionMethod is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMethodRedemptionMethod() {
        return methodSelect == METHOD_REDEMPTION_METHOD_CHOICE;
    }

    /** 
     * Get the 'RedemptionMethod' element value.
     * 
     * @return value
     */
    public RedemptionMethodType getMethodRedemptionMethod() {
        return methodRedemptionMethod;
    }

    /** 
     * Set the 'RedemptionMethod' element value.
     * 
     * @param methodRedemptionMethod
     */
    public void setMethodRedemptionMethod(
            RedemptionMethodType methodRedemptionMethod) {
        setMethodSelect(METHOD_REDEMPTION_METHOD_CHOICE);
        this.methodRedemptionMethod = methodRedemptionMethod;
    }

    /** 
     * Check if MethodPaymentCardMethod is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMethodPaymentCardMethod() {
        return methodSelect == METHOD_PAYMENT_CARD_METHOD_CHOICE;
    }

    /** 
     * Get the 'PaymentCardMethod' element value.
     * 
     * @return value
     */
    public PaymentCardMethodType getMethodPaymentCardMethod() {
        return methodPaymentCardMethod;
    }

    /** 
     * Set the 'PaymentCardMethod' element value.
     * 
     * @param methodPaymentCardMethod
     */
    public void setMethodPaymentCardMethod(
            PaymentCardMethodType methodPaymentCardMethod) {
        setMethodSelect(METHOD_PAYMENT_CARD_METHOD_CHOICE);
        this.methodPaymentCardMethod = methodPaymentCardMethod;
    }

    /** 
     * Check if MethodOtherMethod is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMethodOtherMethod() {
        return methodSelect == METHOD_OTHER_METHOD_CHOICE;
    }

    /** 
     * Get the 'OtherMethod' element value.
     * 
     * @return value
     */
    public OtherMethodType getMethodOtherMethod() {
        return methodOtherMethod;
    }

    /** 
     * Set the 'OtherMethod' element value.
     * 
     * @param methodOtherMethod
     */
    public void setMethodOtherMethod(OtherMethodType methodOtherMethod) {
        setMethodSelect(METHOD_OTHER_METHOD_CHOICE);
        this.methodOtherMethod = methodOtherMethod;
    }

    /** 
     * Check if MethodMiscChargeMethod is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMethodMiscChargeMethod() {
        return methodSelect == METHOD_MISC_CHARGE_METHOD_CHOICE;
    }

    /** 
     * Get the 'MiscChargeMethod' element value.
     * 
     * @return value
     */
    public MiscChargeMethodType getMethodMiscChargeMethod() {
        return methodMiscChargeMethod;
    }

    /** 
     * Set the 'MiscChargeMethod' element value.
     * 
     * @param methodMiscChargeMethod
     */
    public void setMethodMiscChargeMethod(
            MiscChargeMethodType methodMiscChargeMethod) {
        setMethodSelect(METHOD_MISC_CHARGE_METHOD_CHOICE);
        this.methodMiscChargeMethod = methodMiscChargeMethod;
    }

    /** 
     * Check if MethodDirectBillMethod is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMethodDirectBillMethod() {
        return methodSelect == METHOD_DIRECT_BILL_METHOD_CHOICE;
    }

    /** 
     * Get the 'DirectBillMethod' element value.
     * 
     * @return value
     */
    public DirectBillMethodType getMethodDirectBillMethod() {
        return methodDirectBillMethod;
    }

    /** 
     * Set the 'DirectBillMethod' element value.
     * 
     * @param methodDirectBillMethod
     */
    public void setMethodDirectBillMethod(
            DirectBillMethodType methodDirectBillMethod) {
        setMethodSelect(METHOD_DIRECT_BILL_METHOD_CHOICE);
        this.methodDirectBillMethod = methodDirectBillMethod;
    }

    /** 
     * Check if MethodCashMethod is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMethodCashMethod() {
        return methodSelect == METHOD_CASH_METHOD_CHOICE;
    }

    /** 
     * Get the 'CashMethod' element value.
     * 
     * @return value
     */
    public CashMethodType getMethodCashMethod() {
        return methodCashMethod;
    }

    /** 
     * Set the 'CashMethod' element value.
     * 
     * @param methodCashMethod
     */
    public void setMethodCashMethod(CashMethodType methodCashMethod) {
        setMethodSelect(METHOD_CASH_METHOD_CHOICE);
        this.methodCashMethod = methodCashMethod;
    }

    /** 
     * Check if MethodBankAccountMethod is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMethodBankAccountMethod() {
        return methodSelect == METHOD_BANK_ACCOUNT_METHOD_CHOICE;
    }

    /** 
     * Get the 'BankAccountMethod' element value.
     * 
     * @return value
     */
    public BankAccountMethodType getMethodBankAccountMethod() {
        return methodBankAccountMethod;
    }

    /** 
     * Set the 'BankAccountMethod' element value.
     * 
     * @param methodBankAccountMethod
     */
    public void setMethodBankAccountMethod(
            BankAccountMethodType methodBankAccountMethod) {
        setMethodSelect(METHOD_BANK_ACCOUNT_METHOD_CHOICE);
        this.methodBankAccountMethod = methodBankAccountMethod;
    }

    /** 
     * Check if MethodCheck is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMethodCheck() {
        return methodSelect == METHOD_CHECK_CHOICE;
    }

    /** 
     * Get the 'Check' element value. Check (Cheque) Payment
     * 
     * @return value
     */
    public Check getMethodCheck() {
        return methodCheck;
    }

    /** 
     * Set the 'Check' element value. Check (Cheque) Payment
     * 
     * @param methodCheck
     */
    public void setMethodCheck(Check methodCheck) {
        setMethodSelect(METHOD_CHECK_CHOICE);
        this.methodCheck = methodCheck;
    }

    /** 
     * Get the 'Variance' element value.
     * 
     * @return value
     */
    public Variance getVariance() {
        return variance;
    }

    /** 
     * Set the 'Variance' element value.
     * 
     * @param variance
     */
    public void setVariance(Variance variance) {
        this.variance = variance;
    }

    /** 
     * Get the 'Promotions' element value.
     * 
     * @return value
     */
    public Promotions getPromotions() {
        return promotions;
    }

    /** 
     * Set the 'Promotions' element value.
     * 
     * @param promotions
     */
    public void setPromotions(Promotions promotions) {
        this.promotions = promotions;
    }

    /** 
     * Get the 'Description' element value.
     * 
     * @return value
     */
    public Description getDescription() {
        return description;
    }

    /** 
     * Set the 'Description' element value.
     * 
     * @param description
     */
    public void setDescription(Description description) {
        this.description = description;
    }

    /** 
     * Get the 'Payer' element value.
     * 
     * @return value
     */
    public Payer getPayer() {
        return payer;
    }

    /** 
     * Set the 'Payer' element value.
     * 
     * @param payer
     */
    public void setPayer(Payer payer) {
        this.payer = payer;
    }

    /** 
     * Get the list of 'OrderItemID' element items.
     * 
     * @return list
     */
    public List<String> getOrderItemIDList() {
        return orderItemIDList;
    }

    /** 
     * Set the list of 'OrderItemID' element items.
     * 
     * @param list
     */
    public void setOrderItemIDList(List<String> list) {
        orderItemIDList = list;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }

    /** 
     * Get the 'SplitFormInd' attribute value. When true, this is a split form of payment.
     * 
     * @return value
     */
    public Boolean getSplitFormInd() {
        return splitFormInd;
    }

    /** 
     * Set the 'SplitFormInd' attribute value. When true, this is a split form of payment.
     * 
     * @param splitFormInd
     */
    public void setSplitFormInd(Boolean splitFormInd) {
        this.splitFormInd = splitFormInd;
    }
    /** 
     * Payment Status information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Status" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:PaymentStatusType">
     *         &lt;xs:attribute type="xs:boolean" use="optional" name="FailedPaymentInd"/>
     *         &lt;xs:attribute type="xs:boolean" use="optional" name="PartialPaymentInd"/>
     *         &lt;xs:attribute type="xs:boolean" use="optional" name="VerificationInd"/>
     *         &lt;xs:attribute type="xs:boolean" use="optional" name="PriceVarianceInd"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Status extends PaymentStatusType implements
        Serializable
    {
        private Boolean failedPaymentInd;
        private Boolean partialPaymentInd;
        private Boolean verificationInd;
        private Boolean priceVarianceInd;

        /** 
         * Get the 'FailedPaymentInd' attribute value. When true, payment for this Order has failed.

        Note: Payment Failure status is specified in the PaymentStatus node.
         * 
         * @return value
         */
        public Boolean getFailedPaymentInd() {
            return failedPaymentInd;
        }

        /** 
         * Set the 'FailedPaymentInd' attribute value. When true, payment for this Order has failed.

        Note: Payment Failure status is specified in the PaymentStatus node.
         * 
         * @param failedPaymentInd
         */
        public void setFailedPaymentInd(Boolean failedPaymentInd) {
            this.failedPaymentInd = failedPaymentInd;
        }

        /** 
         * Get the 'PartialPaymentInd' attribute value. When true, this Order has been partially paid.

        Note: Partial Payment status and information is specified in the PaymentStatus node.
         * 
         * @return value
         */
        public Boolean getPartialPaymentInd() {
            return partialPaymentInd;
        }

        /** 
         * Set the 'PartialPaymentInd' attribute value. When true, this Order has been partially paid.

        Note: Partial Payment status and information is specified in the PaymentStatus node.
         * 
         * @param partialPaymentInd
         */
        public void setPartialPaymentInd(Boolean partialPaymentInd) {
            this.partialPaymentInd = partialPaymentInd;
        }

        /** 
         * Get the 'VerificationInd' attribute value. When true, payment for this Order requires additional authentication.

        Note: Payment Verification status and information is specified in the PaymentStatus node.
         * 
         * @return value
         */
        public Boolean getVerificationInd() {
            return verificationInd;
        }

        /** 
         * Set the 'VerificationInd' attribute value. When true, payment for this Order requires additional authentication.

        Note: Payment Verification status and information is specified in the PaymentStatus node.
         * 
         * @param verificationInd
         */
        public void setVerificationInd(Boolean verificationInd) {
            this.verificationInd = verificationInd;
        }

        /** 
         * Get the 'PriceVarianceInd' attribute value. When true, a price variance was applied.
         * 
         * @return value
         */
        public Boolean getPriceVarianceInd() {
            return priceVarianceInd;
        }

        /** 
         * Set the 'PriceVarianceInd' attribute value. When true, a price variance was applied.
         * 
         * @param priceVarianceInd
         */
        public void setPriceVarianceInd(Boolean priceVarianceInd) {
            this.priceVarianceInd = priceVarianceInd;
        }
    }
    /** 
     * Price variance actually applied during payment processing.

     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Variance" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:CurrencyAmountOptType" name="Amount"/>
     *       &lt;xs:element ref="ns:Associations"/>
     *       &lt;xs:element type="ns:PriceVarianceRuleType" name="Rule" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Variance implements Serializable
    {
        private CurrencyAmountOptType amount;
        private Associations associations;
        private PriceVarianceRuleType rule;

        /** 
         * Get the 'Amount' element value. Price Variance Amount. Example: .67 USD
         * 
         * @return value
         */
        public CurrencyAmountOptType getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' element value. Price Variance Amount. Example: .67 USD
         * 
         * @param amount
         */
        public void setAmount(CurrencyAmountOptType amount) {
            this.amount = amount;
        }

        /** 
         * Get the 'Associations' element value. Association(s), including Passenger and Group.
         * 
         * @return value
         */
        public Associations getAssociations() {
            return associations;
        }

        /** 
         * Set the 'Associations' element value. Association(s), including Passenger and Group.
         * 
         * @param associations
         */
        public void setAssociations(Associations associations) {
            this.associations = associations;
        }

        /** 
         * Get the 'Rule' element value. Price Variance Rule Applied.
         * 
         * @return value
         */
        public PriceVarianceRuleType getRule() {
            return rule;
        }

        /** 
         * Set the 'Rule' element value. Price Variance Rule Applied.
         * 
         * @param rule
         */
        public void setRule(PriceVarianceRuleType rule) {
            this.rule = rule;
        }
    }
    /** 
     * Applied Promotion(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Promotions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Promotion" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Promotion -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Promotions implements Serializable
    {
        private List<Promotion> promotionList = new ArrayList<Promotion>();

        /** 
         * Get the list of 'Promotion' element items.
         * 
         * @return list
         */
        public List<Promotion> getPromotionList() {
            return promotionList;
        }

        /** 
         * Set the list of 'Promotion' element items.
         * 
         * @param list
         */
        public void setPromotionList(List<Promotion> list) {
            promotionList = list;
        }
        /** 
         * Promotion Detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Promotion" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:PromotionType">
         *         &lt;xs:sequence>
         *           &lt;xs:element ref="ns:Associations"/>
         *         &lt;/xs:sequence>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Promotion extends PromotionType implements
            Serializable
        {
            private Associations associations;

            /** 
             * Get the 'Associations' element value. Association(s), including Passenger and Group.
             * 
             * @return value
             */
            public Associations getAssociations() {
                return associations;
            }

            /** 
             * Set the 'Associations' element value. Association(s), including Passenger and Group.
             * 
             * @param associations
             */
            public void setAssociations(Associations associations) {
                this.associations = associations;
            }
        }
    }
    /** 
     * The person who is paying for an Order is not a passenger
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payer" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="ContactInfoRefs" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Payer implements Serializable
    {
        private String contactInfoRefs;

        /** 
         * Get the 'ContactInfoRefs' element value. Ref to Contact Information of the Order's Payer. The information can be a company, or include the name details of the individual paying.
         * 
         * @return value
         */
        public String getContactInfoRefs() {
            return contactInfoRefs;
        }

        /** 
         * Set the 'ContactInfoRefs' element value. Ref to Contact Information of the Order's Payer. The information can be a company, or include the name details of the individual paying.
         * 
         * @param contactInfoRefs
         */
        public void setContactInfoRefs(String contactInfoRefs) {
            this.contactInfoRefs = contactInfoRefs;
        }
    }
}
