
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * 
 A data type for Payment Status contextual list. Examples: Canceled, Complete, Failed, MoreInformation, Partial

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentStatusListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Canceled"/>
 *     &lt;xs:enumeration value="Complete"/>
 *     &lt;xs:enumeration value="Failed"/>
 *     &lt;xs:enumeration value="MoreInformation"/>
 *     &lt;xs:enumeration value="Partial"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum PaymentStatusListType implements Serializable {
    CANCELED("Canceled"), COMPLETE("Complete"), FAILED("Failed"), MORE_INFORMATION(
            "MoreInformation"), PARTIAL("Partial");
    private final String value;

    private PaymentStatusListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static PaymentStatusListType convert(String value) {
        for (PaymentStatusListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
