
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * PAYMENT STATUS definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentStatusType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="StatusCode"/>
 *     &lt;xs:element name="IncompletePayment" minOccurs="0">
 *       &lt;!-- Reference to inner class IncompletePayment -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaymentStatusType implements Serializable
{
    private String statusCode;
    private IncompletePayment incompletePayment;

    /** 
     * Get the 'StatusCode' element value. Overall Order payment Status Code.

     * 
     * @return value
     */
    public String getStatusCode() {
        return statusCode;
    }

    /** 
     * Set the 'StatusCode' element value. Overall Order payment Status Code.

     * 
     * @param statusCode
     */
    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    /** 
     * Get the 'IncompletePayment' element value.
     * 
     * @return value
     */
    public IncompletePayment getIncompletePayment() {
        return incompletePayment;
    }

    /** 
     * Set the 'IncompletePayment' element value.
     * 
     * @param incompletePayment
     */
    public void setIncompletePayment(IncompletePayment incompletePayment) {
        this.incompletePayment = incompletePayment;
    }
    /** 
     * In-complete Payment information, including partially completed payments, payment verification required and failed payments.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IncompletePayment" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="StatusCode"/>
     *       &lt;xs:element ref="ns:Associations"/>
     *       &lt;xs:element ref="ns:Remarks" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class IncompletePayment implements Serializable
    {
        private String statusCode;
        private Associations associations;
        private Remarks remarks;

        /** 
         * Get the 'StatusCode' element value. In-complete Payment Status Code.

        Encoding Scheme: IATA Padis Codeset - List for data element 9321 (Application error, coded)

        Note: This status includes partially completed payments, payment verification required and failed payments.
         * 
         * @return value
         */
        public String getStatusCode() {
            return statusCode;
        }

        /** 
         * Set the 'StatusCode' element value. In-complete Payment Status Code.

        Encoding Scheme: IATA Padis Codeset - List for data element 9321 (Application error, coded)

        Note: This status includes partially completed payments, payment verification required and failed payments.
         * 
         * @param statusCode
         */
        public void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        /** 
         * Get the 'Associations' element value.
         * 
         * @return value
         */
        public Associations getAssociations() {
            return associations;
        }

        /** 
         * Set the 'Associations' element value.
         * 
         * @param associations
         */
        public void setAssociations(Associations associations) {
            this.associations = associations;
        }

        /** 
         * Get the 'Remarks' element value.
         * 
         * @return value
         */
        public Remarks getRemarks() {
            return remarks;
        }

        /** 
         * Set the 'Remarks' element value.
         * 
         * @param remarks
         */
        public void setRemarks(Remarks remarks) {
            this.remarks = remarks;
        }
    }
}
