
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * PENALTY definition.NDC Capability Model: PENALTY

 ============
 Representation(s)
 ============
 • Core Penalty
 • Detail Penalty

 ============
 Feature(s)
 ============
 • Penalty Indicators (Cancellation fees apply; Change of Itinerary fees apply; Refundable ticket and/ or fare; Reusable ticket and/ or fare; Upgrade fee applies)
 • Applicable Fee Remarks
 • Penalty Type (Cancellation, No Show, Upgrade, etc.)
 • Penalty Application (IATA Padis Codeset FAT - Fare or Application Penalty Type)
 • Penalty Amount, represented as percentage or fixed value, with Amount Application (MinimumPenaltyAmount, MaximumPenaltyAmount, Other) and Applicable Fee Remarks

 ============
 Metadata
 ============
 • PenaltyMetadata
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PenaltyType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:RemarkType" name="ApplicableFeeRemarks" minOccurs="0"/>
 *     &lt;xs:element name="Details" minOccurs="0">
 *       &lt;!-- Reference to inner class Details -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="CancelFeeInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="ChangeFeeInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="RefundableInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="ReuseInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="UpgradeFeeInd"/>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ObjectKey"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class PenaltyType implements Serializable
{
    private RemarkType applicableFeeRemarks;
    private Details details;
    private Boolean cancelFeeInd;
    private Boolean changeFeeInd;
    private Boolean refundableInd;
    private Boolean reuseInd;
    private Boolean upgradeFeeInd;
    private String refs;
    private String objectKey;

    /** 
     * Get the 'ApplicableFeeRemarks' element value. Applicable Fee Remark(s).
     * 
     * @return value
     */
    public RemarkType getApplicableFeeRemarks() {
        return applicableFeeRemarks;
    }

    /** 
     * Set the 'ApplicableFeeRemarks' element value. Applicable Fee Remark(s).
     * 
     * @param applicableFeeRemarks
     */
    public void setApplicableFeeRemarks(RemarkType applicableFeeRemarks) {
        this.applicableFeeRemarks = applicableFeeRemarks;
    }

    /** 
     * Get the 'Details' element value.
     * 
     * @return value
     */
    public Details getDetails() {
        return details;
    }

    /** 
     * Set the 'Details' element value.
     * 
     * @param details
     */
    public void setDetails(Details details) {
        this.details = details;
    }

    /** 
     * Get the 'CancelFeeInd' attribute value. When true, Cancellation fee(s) may apply.
     * 
     * @return value
     */
    public Boolean getCancelFeeInd() {
        return cancelFeeInd;
    }

    /** 
     * Set the 'CancelFeeInd' attribute value. When true, Cancellation fee(s) may apply.
     * 
     * @param cancelFeeInd
     */
    public void setCancelFeeInd(Boolean cancelFeeInd) {
        this.cancelFeeInd = cancelFeeInd;
    }

    /** 
     * Get the 'ChangeFeeInd' attribute value. When true, Change of Itinerary fee(s) may apply.
     * 
     * @return value
     */
    public Boolean getChangeFeeInd() {
        return changeFeeInd;
    }

    /** 
     * Set the 'ChangeFeeInd' attribute value. When true, Change of Itinerary fee(s) may apply.
     * 
     * @param changeFeeInd
     */
    public void setChangeFeeInd(Boolean changeFeeInd) {
        this.changeFeeInd = changeFeeInd;
    }

    /** 
     * Get the 'RefundableInd' attribute value. When true, this is a refundable ticket and/ or fare.
     * 
     * @return value
     */
    public Boolean getRefundableInd() {
        return refundableInd;
    }

    /** 
     * Set the 'RefundableInd' attribute value. When true, this is a refundable ticket and/ or fare.
     * 
     * @param refundableInd
     */
    public void setRefundableInd(Boolean refundableInd) {
        this.refundableInd = refundableInd;
    }

    /** 
     * Get the 'ReuseInd' attribute value. When true, this is a reusable ticket and/ or fare.
     * 
     * @return value
     */
    public Boolean getReuseInd() {
        return reuseInd;
    }

    /** 
     * Set the 'ReuseInd' attribute value. When true, this is a reusable ticket and/ or fare.
     * 
     * @param reuseInd
     */
    public void setReuseInd(Boolean reuseInd) {
        this.reuseInd = reuseInd;
    }

    /** 
     * Get the 'UpgradeFeeInd' attribute value. When true, Upgrade fee(s) may apply.
     * 
     * @return value
     */
    public Boolean getUpgradeFeeInd() {
        return upgradeFeeInd;
    }

    /** 
     * Set the 'UpgradeFeeInd' attribute value. When true, Upgrade fee(s) may apply.
     * 
     * @param upgradeFeeInd
     */
    public void setUpgradeFeeInd(Boolean upgradeFeeInd) {
        this.upgradeFeeInd = upgradeFeeInd;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }

    /** 
     * Get the 'ObjectKey' attribute value. Object globally unique Instance ID. Example: obj1
     * 
     * @return value
     */
    public String getObjectKey() {
        return objectKey;
    }

    /** 
     * Set the 'ObjectKey' attribute value. Object globally unique Instance ID. Example: obj1
     * 
     * @param objectKey
     */
    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }
    /** 
     * Penalty Conditions and Penalty Amount detailed information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Details" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Detail" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Detail -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Details implements Serializable
    {
        private List<Detail> detailList = new ArrayList<Detail>();

        /** 
         * Get the list of 'Detail' element items.
         * 
         * @return list
         */
        public List<Detail> getDetailList() {
            return detailList;
        }

        /** 
         * Set the list of 'Detail' element items.
         * 
         * @param list
         */
        public void setDetailList(List<Detail> list) {
            detailList = list;
        }
        /** 
         * Penalty detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Detail" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="Type"/>
         *       &lt;xs:element type="xs:string" name="Application" minOccurs="0"/>
         *       &lt;xs:element name="Amounts" minOccurs="0">
         *         &lt;!-- Reference to inner class Amounts -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class Detail implements Serializable
        {
            private String type;
            private String application;
            private Amounts amounts;
            private String refs;

            /** 
             * Get the 'Type' element value. Penalty Type.
            Examples: Cancellation, Change, NoShow, Upgrade, Other
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'Type' element value. Penalty Type.
            Examples: Cancellation, Change, NoShow, Upgrade, Other
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }

            /** 
             * Get the 'Application' element value. Penalty application type.

            Encoding scheme: IATA Padis Codeset FAT - Fare or Application Penalty Type
             * 
             * @return value
             */
            public String getApplication() {
                return application;
            }

            /** 
             * Set the 'Application' element value. Penalty application type.

            Encoding scheme: IATA Padis Codeset FAT - Fare or Application Penalty Type
             * 
             * @param application
             */
            public void setApplication(String application) {
                this.application = application;
            }

            /** 
             * Get the 'Amounts' element value.
             * 
             * @return value
             */
            public Amounts getAmounts() {
                return amounts;
            }

            /** 
             * Set the 'Amounts' element value.
             * 
             * @param amounts
             */
            public void setAmounts(Amounts amounts) {
                this.amounts = amounts;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }
            /** 
             * Penalty Amount(s) with Penalty Amount Application and Remarks.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amounts" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Amount" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Amount -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Amounts implements Serializable
            {
                private List<Amount> amountList = new ArrayList<Amount>();

                /** 
                 * Get the list of 'Amount' element items.
                 * 
                 * @return list
                 */
                public List<Amount> getAmountList() {
                    return amountList;
                }

                /** 
                 * Set the list of 'Amount' element items.
                 * 
                 * @param list
                 */
                public void setAmountList(List<Amount> list) {
                    amountList = list;
                }
                /** 
                 * Penalty Amount detail.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:choice>
                 *         &lt;xs:element ref="ns:CurrencyAmountValue"/>
                 *         &lt;xs:element ref="ns:PercentageValue"/>
                 *       &lt;/xs:choice>
                 *       &lt;xs:element type="xs:string" name="AmountApplication" minOccurs="0"/>
                 *       &lt;xs:element type="ns:RemarkType" name="ApplicableFeeRemarks" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Amount implements Serializable
                {
                    private int choiceSelect = -1;
                    private static final int CURRENCY_AMOUNT_VALUE_CHOICE = 0;
                    private static final int PERCENTAGE_VALUE_CHOICE = 1;
                    private CurrencyAmountValue currencyAmountValue;
                    private PercentageValue percentageValue;
                    private String amountApplication;
                    private RemarkType applicableFeeRemarks;

                    private void setChoiceSelect(int choice) {
                        if (choiceSelect == -1) {
                            choiceSelect = choice;
                        } else if (choiceSelect != choice) {
                            throw new IllegalStateException(
                                    "Need to call clearChoiceSelect() before changing existing choice");
                        }
                    }

                    /** 
                     * Clear the choice selection.
                     */
                    public void clearChoiceSelect() {
                        choiceSelect = -1;
                    }

                    /** 
                     * Check if CurrencyAmountValue is current selection for choice.
                     * 
                     * @return <code>true</code> if selection, <code>false</code> if not
                     */
                    public boolean ifCurrencyAmountValue() {
                        return choiceSelect == CURRENCY_AMOUNT_VALUE_CHOICE;
                    }

                    /** 
                     * Get the 'CurrencyAmountValue' element value. Penalty monetary value amount and currency code.
                     * 
                     * @return value
                     */
                    public CurrencyAmountValue getCurrencyAmountValue() {
                        return currencyAmountValue;
                    }

                    /** 
                     * Set the 'CurrencyAmountValue' element value. Penalty monetary value amount and currency code.
                     * 
                     * @param currencyAmountValue
                     */
                    public void setCurrencyAmountValue(
                            CurrencyAmountValue currencyAmountValue) {
                        setChoiceSelect(CURRENCY_AMOUNT_VALUE_CHOICE);
                        this.currencyAmountValue = currencyAmountValue;
                    }

                    /** 
                     * Check if PercentageValue is current selection for choice.
                     * 
                     * @return <code>true</code> if selection, <code>false</code> if not
                     */
                    public boolean ifPercentageValue() {
                        return choiceSelect == PERCENTAGE_VALUE_CHOICE;
                    }

                    /** 
                     * Get the 'PercentageValue' element value.
                     * 
                     * @return value
                     */
                    public PercentageValue getPercentageValue() {
                        return percentageValue;
                    }

                    /** 
                     * Set the 'PercentageValue' element value.
                     * 
                     * @param percentageValue
                     */
                    public void setPercentageValue(
                            PercentageValue percentageValue) {
                        setChoiceSelect(PERCENTAGE_VALUE_CHOICE);
                        this.percentageValue = percentageValue;
                    }

                    /** 
                     * Get the 'AmountApplication' element value. Penalty Amount Application.
                    Examples: MinimumPenaltyAmount, MaximumPenaltyAmount, Other
                     * 
                     * @return value
                     */
                    public String getAmountApplication() {
                        return amountApplication;
                    }

                    /** 
                     * Set the 'AmountApplication' element value. Penalty Amount Application.
                    Examples: MinimumPenaltyAmount, MaximumPenaltyAmount, Other
                     * 
                     * @param amountApplication
                     */
                    public void setAmountApplication(String amountApplication) {
                        this.amountApplication = amountApplication;
                    }

                    /** 
                     * Get the 'ApplicableFeeRemarks' element value. Applicable Fee Remark(s).
                     * 
                     * @return value
                     */
                    public RemarkType getApplicableFeeRemarks() {
                        return applicableFeeRemarks;
                    }

                    /** 
                     * Set the 'ApplicableFeeRemarks' element value. Applicable Fee Remark(s).
                     * 
                     * @param applicableFeeRemarks
                     */
                    public void setApplicableFeeRemarks(
                            RemarkType applicableFeeRemarks) {
                        this.applicableFeeRemarks = applicableFeeRemarks;
                    }
                }
            }
        }
    }
}
