
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * A telephone number is a sequence of digits assigned to a fixed-line telephone subscriber station connected to a telephone line or to a wireless electronic telephony device, such as a radio telephone or a mobile telephone, or to other devices for data transmission via the public switched telephone network (PSTN) or other private networks.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PhoneTypeAIDM">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Label" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CountryDialingCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="AreaCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="PhoneNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="Extension" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PhoneTypeAIDM implements Serializable
{
    private String label;
    private String countryDialingCode;
    private BigDecimal areaCode;
    private BigDecimal phoneNumber;
    private BigDecimal extension;

    /** 
     * Get the 'Label' element value. Used to differentiate multiple Phone numbers of one contact. 
    Examples: Work, Home, Mobile
     * 
     * @return value
     */
    public String getLabel() {
        return label;
    }

    /** 
     * Set the 'Label' element value. Used to differentiate multiple Phone numbers of one contact. 
    Examples: Work, Home, Mobile
     * 
     * @param label
     */
    public void setLabel(String label) {
        this.label = label;
    }

    /** 
     * Get the 'CountryDialingCode' element value. Numeric telephone dialing prefixes for the member countries of the International Telecommunication Union (ITU).
     * 
     * @return value
     */
    public String getCountryDialingCode() {
        return countryDialingCode;
    }

    /** 
     * Set the 'CountryDialingCode' element value. Numeric telephone dialing prefixes for the member countries of the International Telecommunication Union (ITU).
     * 
     * @param countryDialingCode
     */
    public void setCountryDialingCode(String countryDialingCode) {
        this.countryDialingCode = countryDialingCode;
    }

    /** 
     * Get the 'AreaCode' element value. Phone number area code.  Example: 813
     * 
     * @return value
     */
    public BigDecimal getAreaCode() {
        return areaCode;
    }

    /** 
     * Set the 'AreaCode' element value. Phone number area code.  Example: 813
     * 
     * @param areaCode
     */
    public void setAreaCode(BigDecimal areaCode) {
        this.areaCode = areaCode;
    }

    /** 
     * Get the 'PhoneNumber' element value. Phone number text.
    Eg: +1 999-999-9999 ext 1234, 
    617-9976
    Note: This may be a simple, un-structured phone number, such as +01 999-999-9999 ext 1234 or combined with the additional attributes to create a structured phone number.
     * 
     * @return value
     */
    public BigDecimal getPhoneNumber() {
        return phoneNumber;
    }

    /** 
     * Set the 'PhoneNumber' element value. Phone number text.
    Eg: +1 999-999-9999 ext 1234, 
    617-9976
    Note: This may be a simple, un-structured phone number, such as +01 999-999-9999 ext 1234 or combined with the additional attributes to create a structured phone number.
     * 
     * @param phoneNumber
     */
    public void setPhoneNumber(BigDecimal phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    /** 
     * Get the 'Extension' element value. Phone extension number.  Example: 1234
     * 
     * @return value
     */
    public BigDecimal getExtension() {
        return extension;
    }

    /** 
     * Set the 'Extension' element value. Phone extension number.  Example: 1234
     * 
     * @param extension
     */
    public void setExtension(BigDecimal extension) {
        this.extension = extension;
    }
}
