
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Traveler Authentication Challenge  Answer definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PinPhraseAnswerType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Status" minOccurs="0">
 *       &lt;!-- Reference to inner class Status -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="PIN"/>
 *     &lt;xs:element type="xs:string" name="PoolQuestion" minOccurs="0"/>
 *     &lt;xs:element type="ns:AuthAccountType" name="AuthAccount" minOccurs="0"/>
 *     &lt;xs:element name="Device" minOccurs="0">
 *       &lt;!-- Reference to inner class Device -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="OriginalTransactionID" minOccurs="0">
 *       &lt;!-- Reference to inner class OriginalTransactionID -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PinPhraseAnswerType implements Serializable
{
    private Status status;
    private String poolQuestion;
    private AuthAccountType authAccount;
    private Device device;
    private OriginalTransactionID originalTransactionID;

    /** 
     * Get the 'Status' element value.
     * 
     * @return value
     */
    public Status getStatus() {
        return status;
    }

    /** 
     * Set the 'Status' element value.
     * 
     * @param status
     */
    public void setStatus(Status status) {
        this.status = status;
    }

    /** 
     * Get the 'PoolQuestion' element value. Original Credentialing Question. Example: What is a memorable place?
     * 
     * @return value
     */
    public String getPoolQuestion() {
        return poolQuestion;
    }

    /** 
     * Set the 'PoolQuestion' element value. Original Credentialing Question. Example: What is a memorable place?
     * 
     * @param poolQuestion
     */
    public void setPoolQuestion(String poolQuestion) {
        this.poolQuestion = poolQuestion;
    }

    /** 
     * Get the 'AuthAccount' element value. Pre-defined Account information.
     * 
     * @return value
     */
    public AuthAccountType getAuthAccount() {
        return authAccount;
    }

    /** 
     * Set the 'AuthAccount' element value. Pre-defined Account information.
     * 
     * @param authAccount
     */
    public void setAuthAccount(AuthAccountType authAccount) {
        this.authAccount = authAccount;
    }

    /** 
     * Get the 'Device' element value.
     * 
     * @return value
     */
    public Device getDevice() {
        return device;
    }

    /** 
     * Set the 'Device' element value.
     * 
     * @param device
     */
    public void setDevice(Device device) {
        this.device = device;
    }

    /** 
     * Get the 'OriginalTransactionID' element value.
     * 
     * @return value
     */
    public OriginalTransactionID getOriginalTransactionID() {
        return originalTransactionID;
    }

    /** 
     * Set the 'OriginalTransactionID' element value.
     * 
     * @param originalTransactionID
     */
    public void setOriginalTransactionID(
            OriginalTransactionID originalTransactionID) {
        this.originalTransactionID = originalTransactionID;
    }
    /** 
     * Traveler Authentication process status.
    Examples:
    Y- Customer authenticated
    N- Customer not authenticated
    A- An authentication attempt occurred but could not be completed
    U- Unable to perform authentication
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Status" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Status implements Serializable
    {
        private String string;
        private String context;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'Context' attribute value. Authentication Status Context.
         * 
         * @return value
         */
        public String getContext() {
            return context;
        }

        /** 
         * Set the 'Context' attribute value. Authentication Status Context.
         * 
         * @param context
         */
        public void setContext(String context) {
            this.context = context;
        }
    }
    /** 
     * Mobile Device information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Device" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:DeviceType">
     *         &lt;xs:sequence>
     *           &lt;xs:element ref="ns:Position" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Device extends DeviceType implements Serializable
    {
        private PositionType position;

        /** 
         * Get the 'Position' element value. Device Location geocoding information.
         * 
         * @return value
         */
        public PositionType getPosition() {
            return position;
        }

        /** 
         * Set the 'Position' element value. Device Location geocoding information.
         * 
         * @param position
         */
        public void setPosition(PositionType position) {
            this.position = position;
        }
    }
    /** 
     * The identifier of the original transaction that initiated this Traveler authentication. Example: TRN12345
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginalTransactionID" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" use="optional" name="source"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OriginalTransactionID implements Serializable
    {
        private String string;
        private String source;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'source' attribute value. ID or name of the source of this Transaction ID.  Examples: UA, ABC123

        Note: If this is an airline ID, use IATA/ A4A (two or three character) Airline Designator Code Encoding Scheme.
         * 
         * @return value
         */
        public String getSource() {
            return source;
        }

        /** 
         * Set the 'source' attribute value. ID or name of the source of this Transaction ID.  Examples: UA, ABC123

        Note: If this is an airline ID, use IATA/ A4A (two or three character) Airline Designator Code Encoding Scheme.
         * 
         * @param source
         */
        public void setSource(String source) {
            this.source = source;
        }
    }
}
