
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Traveler Authentication Challenge Question definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PinPhraseQuestionType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Status" minOccurs="0">
 *       &lt;!-- Reference to inner class Status -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Challenge">
 *       &lt;xs:complexType>
 *         &lt;xs:choice>
 *           &lt;xs:element type="xs:string" name="SourceURL"/>
 *           &lt;xs:element name="Parameters">
 *             &lt;!-- Reference to inner class Parameters -->
 *           &lt;/xs:element>
 *         &lt;/xs:choice>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:MultiAssociationType" name="Associations"/>
 *     &lt;xs:element type="ns:AuthAccountType" name="AuthAccount" minOccurs="0"/>
 *     &lt;xs:element name="Device" minOccurs="0">
 *       &lt;!-- Reference to inner class Device -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="OriginalTransactionID" minOccurs="0">
 *       &lt;!-- Reference to inner class OriginalTransactionID -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PinPhraseQuestionType implements Serializable
{
    private Status status;
    private int challengeSelect = -1;
    private static final int CHALLENGE_SOURCE_URL_CHOICE = 0;
    private static final int PARAMETERS_CHOICE = 1;
    private String challengeSourceURL;
    private Parameters parameters;
    private MultiAssociationType associations;
    private AuthAccountType authAccount;
    private Device device;
    private OriginalTransactionID originalTransactionID;

    /** 
     * Get the 'Status' element value.
     * 
     * @return value
     */
    public Status getStatus() {
        return status;
    }

    /** 
     * Set the 'Status' element value.
     * 
     * @param status
     */
    public void setStatus(Status status) {
        this.status = status;
    }

    private void setChallengeSelect(int choice) {
        if (challengeSelect == -1) {
            challengeSelect = choice;
        } else if (challengeSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChallengeSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChallengeSelect() {
        challengeSelect = -1;
    }

    /** 
     * Check if ChallengeSourceURL is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifChallengeSourceURL() {
        return challengeSelect == CHALLENGE_SOURCE_URL_CHOICE;
    }

    /** 
     * Get the 'SourceURL' element value. URL to source location for authentication service, instructions, etc.
     * 
     * @return value
     */
    public String getChallengeSourceURL() {
        return challengeSourceURL;
    }

    /** 
     * Set the 'SourceURL' element value. URL to source location for authentication service, instructions, etc.
     * 
     * @param challengeSourceURL
     */
    public void setChallengeSourceURL(String challengeSourceURL) {
        setChallengeSelect(CHALLENGE_SOURCE_URL_CHOICE);
        this.challengeSourceURL = challengeSourceURL;
    }

    /** 
     * Check if Parameters is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifParameters() {
        return challengeSelect == PARAMETERS_CHOICE;
    }

    /** 
     * Get the 'Parameters' element value. Pin Phrase Challenge information, including source URL and challenge parameters.
     * 
     * @return value
     */
    public Parameters getParameters() {
        return parameters;
    }

    /** 
     * Set the 'Parameters' element value. Pin Phrase Challenge information, including source URL and challenge parameters.
     * 
     * @param parameters
     */
    public void setParameters(Parameters parameters) {
        setChallengeSelect(PARAMETERS_CHOICE);
        this.parameters = parameters;
    }

    /** 
     * Get the 'Associations' element value. Traveler Authentication Request Association(s), including Order, Order Item, Passenger, Group, Offer Item and Service.
     * 
     * @return value
     */
    public MultiAssociationType getAssociations() {
        return associations;
    }

    /** 
     * Set the 'Associations' element value. Traveler Authentication Request Association(s), including Order, Order Item, Passenger, Group, Offer Item and Service.
     * 
     * @param associations
     */
    public void setAssociations(MultiAssociationType associations) {
        this.associations = associations;
    }

    /** 
     * Get the 'AuthAccount' element value. Pre-defined Account information.
     * 
     * @return value
     */
    public AuthAccountType getAuthAccount() {
        return authAccount;
    }

    /** 
     * Set the 'AuthAccount' element value. Pre-defined Account information.
     * 
     * @param authAccount
     */
    public void setAuthAccount(AuthAccountType authAccount) {
        this.authAccount = authAccount;
    }

    /** 
     * Get the 'Device' element value.
     * 
     * @return value
     */
    public Device getDevice() {
        return device;
    }

    /** 
     * Set the 'Device' element value.
     * 
     * @param device
     */
    public void setDevice(Device device) {
        this.device = device;
    }

    /** 
     * Get the 'OriginalTransactionID' element value.
     * 
     * @return value
     */
    public OriginalTransactionID getOriginalTransactionID() {
        return originalTransactionID;
    }

    /** 
     * Set the 'OriginalTransactionID' element value.
     * 
     * @param originalTransactionID
     */
    public void setOriginalTransactionID(
            OriginalTransactionID originalTransactionID) {
        this.originalTransactionID = originalTransactionID;
    }
    /** 
     * Traveler Authentication process status.
    Examples:
    Y- Customer authenticated
    N- Customer not authenticated
    A- An authentication attempt occurred but could not be completed
    U- Unable to perform authentication
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Status" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Status implements Serializable
    {
        private String string;
        private String context;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'Context' attribute value. Authentication Status Context.
         * 
         * @return value
         */
        public String getContext() {
            return context;
        }

        /** 
         * Set the 'Context' attribute value. Authentication Status Context.
         * 
         * @param context
         */
        public void setContext(String context) {
            this.context = context;
        }
    }
    /** 
     * End User Parameters, including challenge question and phrase prompt.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Parameters">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="ChallengeQuestion" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="PhrasePrompt" minOccurs="0"/>
     *       &lt;xs:element name="Positions" minOccurs="0">
     *         &lt;!-- Reference to inner class Positions -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Parameters implements Serializable
    {
        private String challengeQuestion;
        private String phrasePrompt;
        private Positions positions;

        /** 
         * Get the 'ChallengeQuestion' element value. Challenge Question.
        Example: What is a memorable place?
         * 
         * @return value
         */
        public String getChallengeQuestion() {
            return challengeQuestion;
        }

        /** 
         * Set the 'ChallengeQuestion' element value. Challenge Question.
        Example: What is a memorable place?
         * 
         * @param challengeQuestion
         */
        public void setChallengeQuestion(String challengeQuestion) {
            this.challengeQuestion = challengeQuestion;
        }

        /** 
         * Get the 'PhrasePrompt' element value. Answer Characters Prompt.
        Example: Please provide the 1st, 3rd, 4th and the last characters from your memorable place.
         * 
         * @return value
         */
        public String getPhrasePrompt() {
            return phrasePrompt;
        }

        /** 
         * Set the 'PhrasePrompt' element value. Answer Characters Prompt.
        Example: Please provide the 1st, 3rd, 4th and the last characters from your memorable place.
         * 
         * @param phrasePrompt
         */
        public void setPhrasePrompt(String phrasePrompt) {
            this.phrasePrompt = phrasePrompt;
        }

        /** 
         * Get the 'Positions' element value.
         * 
         * @return value
         */
        public Positions getPositions() {
            return positions;
        }

        /** 
         * Set the 'Positions' element value.
         * 
         * @param positions
         */
        public void setPositions(Positions positions) {
            this.positions = positions;
        }
        /** 
         * Requested Character Positions.

        Note: This is a character position array that may be used in association with the Prompt.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Positions" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:integer" name="Position" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Positions implements Serializable
        {
            private List<BigInteger> positionList = new ArrayList<BigInteger>();

            /** 
             * Get the list of 'Position' element items. Character Position. Example: 5
             * 
             * @return list
             */
            public List<BigInteger> getPositionList() {
                return positionList;
            }

            /** 
             * Set the list of 'Position' element items. Character Position. Example: 5
             * 
             * @param list
             */
            public void setPositionList(List<BigInteger> list) {
                positionList = list;
            }
        }
    }
    /** 
     * Traveler Device information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Device" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:DeviceType">
     *         &lt;xs:sequence>
     *           &lt;xs:element ref="ns:Position" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Device extends DeviceType implements Serializable
    {
        private PositionType position;

        /** 
         * Get the 'Position' element value. Device Location geocoding information.
         * 
         * @return value
         */
        public PositionType getPosition() {
            return position;
        }

        /** 
         * Set the 'Position' element value. Device Location geocoding information.
         * 
         * @param position
         */
        public void setPosition(PositionType position) {
            this.position = position;
        }
    }
    /** 
     * The identifier of the original transaction that initiated this Traveler authentication. Example: TRN12345
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginalTransactionID" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" use="optional" name="source"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OriginalTransactionID implements Serializable
    {
        private String string;
        private String source;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'source' attribute value. ID or name of the source of this Transaction ID.  Examples: UA, ABC123

        Note: If this is an airline ID, use IATA 2 character or ICAO 3 letter  Airline Designator Code Encoding Scheme.


         * 
         * @return value
         */
        public String getSource() {
            return source;
        }

        /** 
         * Set the 'source' attribute value. ID or name of the source of this Transaction ID.  Examples: UA, ABC123

        Note: If this is an airline ID, use IATA 2 character or ICAO 3 letter  Airline Designator Code Encoding Scheme.


         * 
         * @param source
         */
        public void setSource(String source) {
            this.source = source;
        }
    }
}
