
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

/** 
 * A data type for Augmented Message Policy information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PolicyAugmentationType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Policy" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Policy -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PolicyAugmentationType implements Serializable
{
    private List<Policy> policyList = new ArrayList<Policy>();

    /** 
     * Get the list of 'Policy' element items.
     * 
     * @return list
     */
    public List<Policy> getPolicyList() {
        return policyList;
    }

    /** 
     * Set the list of 'Policy' element items.
     * 
     * @param list
     */
    public void setPolicyList(List<Policy> list) {
        policyList = list;
    }
    /** 
     * Policy Augmentation Detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Policy" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:any maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Policy implements Serializable
    {
        private List<Element> anyList = new ArrayList<Element>();
        private String refs;

        /** 
         * Get the list of any items.
         * 
         * @return list
         */
        public List<Element> getAnyList() {
            return anyList;
        }

        /** 
         * Set the list of any items.
         * 
         * @param list
         */
        public void setAnyList(List<Element> list) {
            anyList = list;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any object instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any object instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
}
