
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for Policy Notification and Text, e.g. for sensitive data notification and/or handling.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PolicyDefaultType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Policy" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Policy -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PolicyDefaultType implements Serializable
{
    private List<Policy> policyList = new ArrayList<Policy>();

    /** 
     * Get the list of 'Policy' element items.
     * 
     * @return list
     */
    public List<Policy> getPolicyList() {
        return policyList;
    }

    /** 
     * Set the list of 'Policy' element items.
     * 
     * @param list
     */
    public void setPolicyList(List<Policy> list) {
        policyList = list;
    }
    /** 
     * Policy Detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Policy" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:boolean" name="DataPolicyInd" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="PolicyID" minOccurs="0"/>
     *       &lt;xs:element name="Type" minOccurs="0"/>
     *       &lt;xs:choice>
     *         &lt;xs:element type="xs:string" name="Description"/>
     *         &lt;xs:element ref="ns:PolicyLink"/>
     *       &lt;/xs:choice>
     *       &lt;xs:element ref="ns:NodePath" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Policy implements Serializable
    {
        private Boolean dataPolicyInd;
        private String policyID;
        private boolean type;
        private int choiceSelect = -1;
        private static final int DESCRIPTION_CHOICE = 0;
        private static final int POLICY_LINK_CHOICE = 1;
        private String description;
        private PolicyLink policyLink;
        private NodePathType nodePath;
        private String refs;

        /** 
         * Get the 'DataPolicyInd' element value. When true, data handling policy(s) apply.
         * 
         * @return value
         */
        public Boolean getDataPolicyInd() {
            return dataPolicyInd;
        }

        /** 
         * Set the 'DataPolicyInd' element value. When true, data handling policy(s) apply.
         * 
         * @param dataPolicyInd
         */
        public void setDataPolicyInd(Boolean dataPolicyInd) {
            this.dataPolicyInd = dataPolicyInd;
        }

        /** 
         * Get the 'PolicyID' element value. Policy Code or ID.  Example: DATA1
         * 
         * @return value
         */
        public String getPolicyID() {
            return policyID;
        }

        /** 
         * Set the 'PolicyID' element value. Policy Code or ID.  Example: DATA1
         * 
         * @param policyID
         */
        public void setPolicyID(String policyID) {
            this.policyID = policyID;
        }

        /** 
         * Check if the 'Type' element is present.
         * 
         * @return <code>true</code> if present, <code>false</code> if not
         */
        public boolean ifTypePresent() {
            return type;
        }

        /** 
         * Set flag for 'Type' element present.
         * 
         * @param type
         */
        public void flagTypePresent(boolean type) {
            this.type = type;
        }

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if Description is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifDescription() {
            return choiceSelect == DESCRIPTION_CHOICE;
        }

        /** 
         * Get the 'Description' element value. Policy short description.
         * 
         * @return value
         */
        public String getDescription() {
            return description;
        }

        /** 
         * Set the 'Description' element value. Policy short description.
         * 
         * @param description
         */
        public void setDescription(String description) {
            setChoiceSelect(DESCRIPTION_CHOICE);
            this.description = description;
        }

        /** 
         * Check if PolicyLink is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPolicyLink() {
            return choiceSelect == POLICY_LINK_CHOICE;
        }

        /** 
         * Get the 'PolicyLink' element value.
         * 
         * @return value
         */
        public PolicyLink getPolicyLink() {
            return policyLink;
        }

        /** 
         * Set the 'PolicyLink' element value.
         * 
         * @param policyLink
         */
        public void setPolicyLink(PolicyLink policyLink) {
            setChoiceSelect(POLICY_LINK_CHOICE);
            this.policyLink = policyLink;
        }

        /** 
         * Get the 'NodePath' element value. Message Property Path information for this policy-associated element.
         * 
         * @return value
         */
        public NodePathType getNodePath() {
            return nodePath;
        }

        /** 
         * Set the 'NodePath' element value. Message Property Path information for this policy-associated element.
         * 
         * @param nodePath
         */
        public void setNodePath(NodePathType nodePath) {
            this.nodePath = nodePath;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any object instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any object instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
}
