
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The address used for postal service. Examples are post office boxes address, postal physical address, postal code
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PostalAddressType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Label" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Street" minOccurs="0" maxOccurs="2"/>
 *     &lt;xs:element type="xs:string" name="BuildingRoom" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="POBox" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PostalCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CityName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CountrySubdivisionName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CountryName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CountryCode" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PostalAddressType implements Serializable
{
    private String label;
    private List<String> streetList = new ArrayList<String>();
    private String buildingRoom;
    private String POBox;
    private String postalCode;
    private String cityName;
    private String countrySubdivisionName;
    private String countryName;
    private String countryCode;

    /** 
     * Get the 'Label' element value. Used to differentiate multiple Postal Addresses of one contact.  Examples: AddressAtOrigin or AddressAtDestination
     * 
     * @return value
     */
    public String getLabel() {
        return label;
    }

    /** 
     * Set the 'Label' element value. Used to differentiate multiple Postal Addresses of one contact.  Examples: AddressAtOrigin or AddressAtDestination
     * 
     * @param label
     */
    public void setLabel(String label) {
        this.label = label;
    }

    /** 
     * Get the list of 'Street' element items. Street name and number corresponding to the postal address. Examples: Main Street, 100 Main Street
     * 
     * @return list
     */
    public List<String> getStreetList() {
        return streetList;
    }

    /** 
     * Set the list of 'Street' element items. Street name and number corresponding to the postal address. Examples: Main Street, 100 Main Street
     * 
     * @param list
     */
    public void setStreetList(List<String> list) {
        streetList = list;
    }

    /** 
     * Get the 'BuildingRoom' element value. Additional address information including building name, room, apartment, or suite number.
     * 
     * @return value
     */
    public String getBuildingRoom() {
        return buildingRoom;
    }

    /** 
     * Set the 'BuildingRoom' element value. Additional address information including building name, room, apartment, or suite number.
     * 
     * @param buildingRoom
     */
    public void setBuildingRoom(String buildingRoom) {
        this.buildingRoom = buildingRoom;
    }

    /** 
     * Get the 'POBox' element value. Post office box.  Example: P.O. Box 21
     * 
     * @return value
     */
    public String getPOBox() {
        return POBox;
    }

    /** 
     * Set the 'POBox' element value. Post office box.  Example: P.O. Box 21
     * 
     * @param POBox
     */
    public void setPOBox(String POBox) {
        this.POBox = POBox;
    }

    /** 
     * Get the 'PostalCode' element value. Postal code. Examples: 11001, 11001-2345
     * 
     * @return value
     */
    public String getPostalCode() {
        return postalCode;
    }

    /** 
     * Set the 'PostalCode' element value. Postal code. Examples: 11001, 11001-2345
     * 
     * @param postalCode
     */
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    /** 
     * Get the 'CityName' element value. The name, expressed as text, of the city, town or village.
     * 
     * @return value
     */
    public String getCityName() {
        return cityName;
    }

    /** 
     * Set the 'CityName' element value. The name, expressed as text, of the city, town or village.
     * 
     * @param cityName
     */
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    /** 
     * Get the 'CountrySubdivisionName' element value. The name, expressed as text, of the subdivision of a country.
     * 
     * @return value
     */
    public String getCountrySubdivisionName() {
        return countrySubdivisionName;
    }

    /** 
     * Set the 'CountrySubdivisionName' element value. The name, expressed as text, of the subdivision of a country.
     * 
     * @param countrySubdivisionName
     */
    public void setCountrySubdivisionName(String countrySubdivisionName) {
        this.countrySubdivisionName = countrySubdivisionName;
    }

    /** 
     * Get the 'CountryName' element value. The name, expressed as text, of the country.
     * 
     * @return value
     */
    public String getCountryName() {
        return countryName;
    }

    /** 
     * Set the 'CountryName' element value. The name, expressed as text, of the country.
     * 
     * @param countryName
     */
    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    /** 
     * Get the 'CountryCode' element value. ISO Country Code. Examples: US, FR.
     * 
     * @return value
     */
    public String getCountryCode() {
        return countryCode;
    }

    /** 
     * Set the 'CountryCode' element value. ISO Country Code. Examples: US, FR.
     * 
     * @param countryCode
     */
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }
}
