
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Contains Shopping Preference choices, ie allowing to specify Airline, Alliance, Flight, Transfer and other shopping preferences.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Preference">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:AirlinePreferences" minOccurs="0"/>
 *       &lt;xs:element ref="ns:AlliancePreferences" minOccurs="0"/>
 *       &lt;xs:element ref="ns:FarePreferences" minOccurs="0"/>
 *       &lt;xs:element ref="ns:FlightPreferences" minOccurs="0"/>
 *       &lt;xs:element ref="ns:PricingMethodPreference" minOccurs="0"/>
 *       &lt;xs:element ref="ns:SegMaxTimePreferences" minOccurs="0"/>
 *       &lt;xs:element ref="ns:ServicePricingOnlyPreference" minOccurs="0"/>
 *       &lt;xs:element ref="ns:TransferPreferences" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class Preference implements Serializable
{
    private AirlinePreferencesType airlinePreferences;
    private AlliancePreferencesType alliancePreferences;
    private FarePreferencesType farePreferences;
    private FlightPreferencesType flightPreferences;
    private BestPricingPreferencesType pricingMethodPreference;
    private FltSegmentMaxTimePreferencesType segMaxTimePreferences;
    private ServicePricingOnlyPreference servicePricingOnlyPreference;
    private TransferPreferencesType transferPreferences;

    /** 
     * Get the 'AirlinePreferences' element value.
     * 
     * @return value
     */
    public AirlinePreferencesType getAirlinePreferences() {
        return airlinePreferences;
    }

    /** 
     * Set the 'AirlinePreferences' element value.
     * 
     * @param airlinePreferences
     */
    public void setAirlinePreferences(AirlinePreferencesType airlinePreferences) {
        this.airlinePreferences = airlinePreferences;
    }

    /** 
     * Get the 'AlliancePreferences' element value.
     * 
     * @return value
     */
    public AlliancePreferencesType getAlliancePreferences() {
        return alliancePreferences;
    }

    /** 
     * Set the 'AlliancePreferences' element value.
     * 
     * @param alliancePreferences
     */
    public void setAlliancePreferences(
            AlliancePreferencesType alliancePreferences) {
        this.alliancePreferences = alliancePreferences;
    }

    /** 
     * Get the 'FarePreferences' element value.
     * 
     * @return value
     */
    public FarePreferencesType getFarePreferences() {
        return farePreferences;
    }

    /** 
     * Set the 'FarePreferences' element value.
     * 
     * @param farePreferences
     */
    public void setFarePreferences(FarePreferencesType farePreferences) {
        this.farePreferences = farePreferences;
    }

    /** 
     * Get the 'FlightPreferences' element value.
     * 
     * @return value
     */
    public FlightPreferencesType getFlightPreferences() {
        return flightPreferences;
    }

    /** 
     * Set the 'FlightPreferences' element value.
     * 
     * @param flightPreferences
     */
    public void setFlightPreferences(FlightPreferencesType flightPreferences) {
        this.flightPreferences = flightPreferences;
    }

    /** 
     * Get the 'PricingMethodPreference' element value. Contains information to identify how reservation was re-priced to obtain best published fare (Eg. best fare in same cabin, best fare in all cabins, other parameters to select best fare).
     * 
     * @return value
     */
    public BestPricingPreferencesType getPricingMethodPreference() {
        return pricingMethodPreference;
    }

    /** 
     * Set the 'PricingMethodPreference' element value. Contains information to identify how reservation was re-priced to obtain best published fare (Eg. best fare in same cabin, best fare in all cabins, other parameters to select best fare).
     * 
     * @param pricingMethodPreference
     */
    public void setPricingMethodPreference(
            BestPricingPreferencesType pricingMethodPreference) {
        this.pricingMethodPreference = pricingMethodPreference;
    }

    /** 
     * Get the 'SegMaxTimePreferences' element value.
     * 
     * @return value
     */
    public FltSegmentMaxTimePreferencesType getSegMaxTimePreferences() {
        return segMaxTimePreferences;
    }

    /** 
     * Set the 'SegMaxTimePreferences' element value.
     * 
     * @param segMaxTimePreferences
     */
    public void setSegMaxTimePreferences(
            FltSegmentMaxTimePreferencesType segMaxTimePreferences) {
        this.segMaxTimePreferences = segMaxTimePreferences;
    }

    /** 
     * Get the 'ServicePricingOnlyPreference' element value.
     * 
     * @return value
     */
    public ServicePricingOnlyPreference getServicePricingOnlyPreference() {
        return servicePricingOnlyPreference;
    }

    /** 
     * Set the 'ServicePricingOnlyPreference' element value.
     * 
     * @param servicePricingOnlyPreference
     */
    public void setServicePricingOnlyPreference(
            ServicePricingOnlyPreference servicePricingOnlyPreference) {
        this.servicePricingOnlyPreference = servicePricingOnlyPreference;
    }

    /** 
     * Get the 'TransferPreferences' element value.
     * 
     * @return value
     */
    public TransferPreferencesType getTransferPreferences() {
        return transferPreferences;
    }

    /** 
     * Set the 'TransferPreferences' element value.
     * 
     * @param transferPreferences
     */
    public void setTransferPreferences(
            TransferPreferencesType transferPreferences) {
        this.transferPreferences = transferPreferences;
    }
}
