
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * A data type for Preference Type list constraint.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PreferencesLevelListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Preferred"/>
 *     &lt;xs:enumeration value="Required"/>
 *     &lt;xs:enumeration value="Exclude"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum PreferencesLevelListType implements Serializable {
    PREFERRED("Preferred"), REQUIRED("Required"), EXCLUDE("Exclude");
    private final String value;

    private PreferencesLevelListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static PreferencesLevelListType convert(String value) {
        for (PreferencesLevelListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
