
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * CORE PRICE definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceCoreType">
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="ApproxInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="RefundAllInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="TaxIncludedInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="OtherChargeInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="AutoExchangeInd"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class PriceCoreType implements Serializable
{
    private String refs;
    private Boolean approxInd;
    private Boolean refundAllInd;
    private Boolean taxIncludedInd;
    private Boolean otherChargeInd;
    private Boolean autoExchangeInd;

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }

    /** 
     * Get the 'ApproxInd' attribute value. When true, this price is approximate.
     * 
     * @return value
     */
    public Boolean getApproxInd() {
        return approxInd;
    }

    /** 
     * Set the 'ApproxInd' attribute value. When true, this price is approximate.
     * 
     * @param approxInd
     */
    public void setApproxInd(Boolean approxInd) {
        this.approxInd = approxInd;
    }

    /** 
     * Get the 'RefundAllInd' attribute value. When true, all price amounts are refundable.
     * 
     * @return value
     */
    public Boolean getRefundAllInd() {
        return refundAllInd;
    }

    /** 
     * Set the 'RefundAllInd' attribute value. When true, all price amounts are refundable.
     * 
     * @param refundAllInd
     */
    public void setRefundAllInd(Boolean refundAllInd) {
        this.refundAllInd = refundAllInd;
    }

    /** 
     * Get the 'TaxIncludedInd' attribute value. When true, price-associated tax(es) have been specified and included.
     * 
     * @return value
     */
    public Boolean getTaxIncludedInd() {
        return taxIncludedInd;
    }

    /** 
     * Set the 'TaxIncludedInd' attribute value. When true, price-associated tax(es) have been specified and included.
     * 
     * @param taxIncludedInd
     */
    public void setTaxIncludedInd(Boolean taxIncludedInd) {
        this.taxIncludedInd = taxIncludedInd;
    }

    /** 
     * Get the 'OtherChargeInd' attribute value. When true, price-associated fee(s)/ surcharge(s) have been specified and included in Price.
     * 
     * @return value
     */
    public Boolean getOtherChargeInd() {
        return otherChargeInd;
    }

    /** 
     * Set the 'OtherChargeInd' attribute value. When true, price-associated fee(s)/ surcharge(s) have been specified and included in Price.
     * 
     * @param otherChargeInd
     */
    public void setOtherChargeInd(Boolean otherChargeInd) {
        this.otherChargeInd = otherChargeInd;
    }

    /** 
     * Get the 'AutoExchangeInd' attribute value. When true, pricing has been returned from an auto-exchanging application .
     * 
     * @return value
     */
    public Boolean getAutoExchangeInd() {
        return autoExchangeInd;
    }

    /** 
     * Set the 'AutoExchangeInd' attribute value. When true, pricing has been returned from an auto-exchanging application .
     * 
     * @param autoExchangeInd
     */
    public void setAutoExchangeInd(Boolean autoExchangeInd) {
        this.autoExchangeInd = autoExchangeInd;
    }
}
