
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Core Priced Flight Offer definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricedFlightOfferCoreType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:OfferPriceLeadType" name="OfferPrice"/>
 *     &lt;xs:element ref="ns:FareDetail" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="LeadPricedInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="LeadPricingIncInd"/>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class PricedFlightOfferCoreType implements Serializable
{
    private OfferPriceLeadType offerPrice;
    private FareDetailType fareDetail;
    private Boolean leadPricedInd;
    private Boolean leadPricingIncInd;
    private String refs;

    /** 
     * Get the 'OfferPrice' element value. Fare Offer and Lead Calendar Pricing information.
     * 
     * @return value
     */
    public OfferPriceLeadType getOfferPrice() {
        return offerPrice;
    }

    /** 
     * Set the 'OfferPrice' element value. Fare Offer and Lead Calendar Pricing information.
     * 
     * @param offerPrice
     */
    public void setOfferPrice(OfferPriceLeadType offerPrice) {
        this.offerPrice = offerPrice;
    }

    /** 
     * Get the 'FareDetail' element value.
     * 
     * @return value
     */
    public FareDetailType getFareDetail() {
        return fareDetail;
    }

    /** 
     * Set the 'FareDetail' element value.
     * 
     * @param fareDetail
     */
    public void setFareDetail(FareDetailType fareDetail) {
        this.fareDetail = fareDetail;
    }

    /** 
     * Get the 'LeadPricedInd' attribute value. 
                      When true, this is a lead pricing generated priced flight offer.
                    
     * 
     * @return value
     */
    public Boolean getLeadPricedInd() {
        return leadPricedInd;
    }

    /** 
     * Set the 'LeadPricedInd' attribute value. 
                      When true, this is a lead pricing generated priced flight offer.
                    
     * 
     * @param leadPricedInd
     */
    public void setLeadPricedInd(Boolean leadPricedInd) {
        this.leadPricedInd = leadPricedInd;
    }

    /** 
     * Get the 'LeadPricingIncInd' attribute value. 
                      When true, additional lead pricing offers are included with this proced flight offer.
                    
     * 
     * @return value
     */
    public Boolean getLeadPricingIncInd() {
        return leadPricingIncInd;
    }

    /** 
     * Set the 'LeadPricingIncInd' attribute value. 
                      When true, additional lead pricing offers are included with this proced flight offer.
                    
     * 
     * @param leadPricingIncInd
     */
    public void setLeadPricingIncInd(Boolean leadPricingIncInd) {
        this.leadPricingIncInd = leadPricingIncInd;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
