
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * A data type for Message Processing Results.

 May include errors, business warnings, alternate offers indicator, supplemental marketing messages and/ or additional information required to complete a transaction.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProcessingResultType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:MarketingInfoType" name="Marketing" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class ProcessingResultType implements Serializable
{
    private MarketingInfoType marketing;
    private String refs;

    /** 
     * Get the 'Marketing' element value. Marketing Messages and Information.

    Notes: Marketing messages specified here apply to all message results, e.g. they are at a message-wide level.
     * 
     * @return value
     */
    public MarketingInfoType getMarketing() {
        return marketing;
    }

    /** 
     * Set the 'Marketing' element value. Marketing Messages and Information.

    Notes: Marketing messages specified here apply to all message results, e.g. they are at a message-wide level.
     * 
     * @param marketing
     */
    public void setMarketing(MarketingInfoType marketing) {
        this.marketing = marketing;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
