
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Geographical search radius.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RadiusAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="Application"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Area"/>
 *   &lt;xs:attribute type="ns:DistanceUnitListType" use="optional" name="UOM"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class RadiusAttrGroup implements Serializable
{
    private String application;
    private String area;
    private DistanceUnitListType UOM;

    /** 
     * Get the 'Application' attribute value. Search radius application. Example: Driving
     * 
     * @return value
     */
    public String getApplication() {
        return application;
    }

    /** 
     * Set the 'Application' attribute value. Search radius application. Example: Driving
     * 
     * @param application
     */
    public void setApplication(String application) {
        this.application = application;
    }

    /** 
     * Get the 'Area' attribute value. A maximum search radius value, e.g. distance from specified location. Example: 20
     * 
     * @return value
     */
    public String getArea() {
        return area;
    }

    /** 
     * Set the 'Area' attribute value. A maximum search radius value, e.g. distance from specified location. Example: 20
     * 
     * @param area
     */
    public void setArea(String area) {
        this.area = area;
    }

    /** 
     * Get the 'UOM' attribute value. Distance unit of measure. Examples: Miles, Kilometers
     * 
     * @return value
     */
    public DistanceUnitListType getUOM() {
        return UOM;
    }

    /** 
     * Set the 'UOM' attribute value. Distance unit of measure. Examples: Miles, Kilometers
     * 
     * @param UOM
     */
    public void setUOM(DistanceUnitListType UOM) {
        this.UOM = UOM;
    }
}
