
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for a Rendering Parameter, typically for XSLT.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RenderingParameterType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Parameter" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Parameter -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class RenderingParameterType implements Serializable
{
    private List<Parameter> parameterList = new ArrayList<Parameter>();
    private String refs;

    /** 
     * Get the list of 'Parameter' element items.
     * 
     * @return list
     */
    public List<Parameter> getParameterList() {
        return parameterList;
    }

    /** 
     * Set the list of 'Parameter' element items.
     * 
     * @param list
     */
    public void setParameterList(List<Parameter> list) {
        parameterList = list;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Rendering Instruction Parameter detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Parameter" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Name"/>
     *       &lt;xs:element type="xs:string" name="Value"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Parameter implements Serializable
    {
        private String name;
        private String value;

        /** 
         * Get the 'Name' element value. Rendering Parameter Name.
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'Name' element value. Rendering Parameter Name.
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }

        /** 
         * Get the 'Value' element value. Rendering Parameter Value.
         * 
         * @return value
         */
        public String getValue() {
            return value;
        }

        /** 
         * Set the 'Value' element value. Rendering Parameter Value.
         * 
         * @param value
         */
        public void setValue(String value) {
            this.value = value;
        }
    }
}
