
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Recursive element to allow nested selections of services from a bundle of services.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RequestedServiceType">
 *   &lt;!-- Reference to class com.gridnine.xtrip.server.gds.tandc.wsmodel.RequestedServiceType -->
 * &lt;/xs:complexType>
 * </pre>
 */
public class RequestedServiceType implements Serializable
{
    private String serviceDefinitionID;
    private List<RequestedServiceType> selectedServiceList = new ArrayList<RequestedServiceType>();

    /** 
     * Get the 'ServiceDefinitionID' element value. Id to defined a selected ServiceDefinition from the selected bundle.
     * 
     * @return value
     */
    public String getServiceDefinitionID() {
        return serviceDefinitionID;
    }

    /** 
     * Set the 'ServiceDefinitionID' element value. Id to defined a selected ServiceDefinition from the selected bundle.
     * 
     * @param serviceDefinitionID
     */
    public void setServiceDefinitionID(String serviceDefinitionID) {
        this.serviceDefinitionID = serviceDefinitionID;
    }

    /** 
     * Get the list of 'SelectedService' element items. Reference to the Service Definition selected by the passenger
     * 
     * @return list
     */
    public List<RequestedServiceType> getSelectedServiceList() {
        return selectedServiceList;
    }

    /** 
     * Set the list of 'SelectedService' element items. Reference to the Service Definition selected by the passenger
     * 
     * @param list
     */
    public void setSelectedServiceList(List<RequestedServiceType> list) {
        selectedServiceList = list;
    }
}
