
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * A data type for MERCHANDISE RETAILER Supplier Role, Core Representation.

 Notes:
 1. This is a representation of common (role-agnostic) properties associated with this Actor definition.
 2. This type is used as (derived) base type for all Roles associated with this Actor.
 3. This type is derived from SupplierCoreRepType.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetailerType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:SupplierCoreRepType">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:RetailerID"/>
 *         &lt;xs:element ref="ns:Contacts" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RetailerType extends SupplierCoreRepType implements Serializable
{
    private RetailerID retailerID;
    private Contacts contacts;

    /** 
     * Get the 'RetailerID' element value.
     * 
     * @return value
     */
    public RetailerID getRetailerID() {
        return retailerID;
    }

    /** 
     * Set the 'RetailerID' element value.
     * 
     * @param retailerID
     */
    public void setRetailerID(RetailerID retailerID) {
        this.retailerID = retailerID;
    }

    /** 
     * Get the 'Contacts' element value.
     * 
     * @return value
     */
    public Contacts getContacts() {
        return contacts;
    }

    /** 
     * Set the 'Contacts' element value.
     * 
     * @param contacts
     */
    public void setContacts(Contacts contacts) {
        this.contacts = contacts;
    }
}
