
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Unique Secure Payment Merchant (SPM)-assigned transaction reference number. Example: VEw4TkFrakFYMmEreXdoZE5xZUU=
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SPM_TxnReference">
 *   &lt;xs:complexType>
 *     &lt;xs:simpleContent>
 *       &lt;xs:extension base="xs:string">
 *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
 *       &lt;/xs:extension>
 *     &lt;/xs:simpleContent>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class SPMTxnReference implements Serializable
{
    private String string;
    private String context;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'Context' attribute value. Transaction Reference context.
     * 
     * @return value
     */
    public String getContext() {
        return context;
    }

    /** 
     * Set the 'Context' attribute value. Transaction Reference context.
     * 
     * @param context
     */
    public void setContext(String context) {
        this.context = context;
    }
}
