
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Seat-related Metadata, including Seat and Seat Map.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Seat">
 *   &lt;xs:complexType>
 *     &lt;xs:choice maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class SeatInner -->
 *     &lt;/xs:choice>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class Seat implements Serializable
{
    private List<SeatInner> seatList = new ArrayList<SeatInner>();

    /** 
     * Get the list of 'Seat' element items.
     * 
     * @return list
     */
    public List<SeatInner> getSeatList() {
        return seatList;
    }

    /** 
     * Set the list of 'Seat' element items.
     * 
     * @param list
     */
    public void setSeatList(List<SeatInner> list) {
        seatList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" maxOccurs="unbounded">
     *   &lt;xs:element ref="ns:SeatMetadatas"/>
     *   &lt;xs:element ref="ns:SeatMapMetadatas"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class SeatInner implements Serializable
    {
        private int seatListSelect = -1;
        private static final int SEAT_METADATAS_CHOICE = 0;
        private static final int SEAT_MAP_METADATAS_CHOICE = 1;
        private SeatMetadatas seatMetadatas;
        private SeatMapMetadatas seatMapMetadatas;

        private void setSeatListSelect(int choice) {
            if (seatListSelect == -1) {
                seatListSelect = choice;
            } else if (seatListSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearSeatListSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearSeatListSelect() {
            seatListSelect = -1;
        }

        /** 
         * Check if SeatMetadatas is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifSeatMetadatas() {
            return seatListSelect == SEAT_METADATAS_CHOICE;
        }

        /** 
         * Get the 'SeatMetadatas' element value.
         * 
         * @return value
         */
        public SeatMetadatas getSeatMetadatas() {
            return seatMetadatas;
        }

        /** 
         * Set the 'SeatMetadatas' element value.
         * 
         * @param seatMetadatas
         */
        public void setSeatMetadatas(SeatMetadatas seatMetadatas) {
            setSeatListSelect(SEAT_METADATAS_CHOICE);
            this.seatMetadatas = seatMetadatas;
        }

        /** 
         * Check if SeatMapMetadatas is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifSeatMapMetadatas() {
            return seatListSelect == SEAT_MAP_METADATAS_CHOICE;
        }

        /** 
         * Get the 'SeatMapMetadatas' element value.
         * 
         * @return value
         */
        public SeatMapMetadatas getSeatMapMetadatas() {
            return seatMapMetadatas;
        }

        /** 
         * Set the 'SeatMapMetadatas' element value.
         * 
         * @param seatMapMetadatas
         */
        public void setSeatMapMetadatas(SeatMapMetadatas seatMapMetadatas) {
            setSeatListSelect(SEAT_MAP_METADATAS_CHOICE);
            this.seatMapMetadatas = seatMapMetadatas;
        }
    }
}
