
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * The SeatAvailability transaction set returns data used to construct respective seat maps with fully integrated fees for any identified premium seats.

 The message also returns multi-media content at the message level with media content references at the individual service level.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatAvailabilityRS">
 *   &lt;xs:complexType>
 *     &lt;xs:choice>
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:Document"/>
 *         &lt;xs:element type="ns:SuccessType" name="Success"/>
 *         &lt;xs:element type="ns:WarningsType" name="Warnings" minOccurs="0"/>
 *         &lt;xs:element type="ns:ProcessingResultType" name="Processing" minOccurs="0"/>
 *         &lt;xs:element ref="ns:ShoppingResponseID" minOccurs="0"/>
 *         &lt;xs:element type="ns:SeatAvailResParamsType" name="Parameters" minOccurs="0"/>
 *         &lt;xs:element name="ALaCarteOffer" minOccurs="0">
 *           &lt;!-- Reference to inner class ALaCarteOffer -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="SeatMap" maxOccurs="unbounded">
 *           &lt;!-- Reference to inner class SeatMap -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="ns:SeatAvailResMetadataType" name="Metadata" minOccurs="0"/>
 *         &lt;xs:element name="DataLists" minOccurs="0">
 *           &lt;!-- Reference to inner class DataLists -->
 *         &lt;/xs:element>
 *         &lt;xs:element ref="ns:Policies" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:element ref="ns:Errors"/>
 *     &lt;/xs:choice>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class SeatAvailabilityRS implements Serializable
{
    private int choiceSelect = -1;
    private static final int DOCUMENT_CHOICE = 0;
    private static final int ERRORS_CHOICE = 1;
    private MsgDocumentType document;
    private SuccessType success;
    private WarningsType warnings;
    private ProcessingResultType processing;
    private ShoppingResponseIDType shoppingResponseID;
    private SeatAvailResParamsType parameters;
    private ALaCarteOffer ALaCarteOffer1;
    private List<SeatMap> seatMapList = new ArrayList<SeatMap>();
    private SeatAvailResMetadataType metadata;
    private DataLists dataLists;
    private Policies policies;
    private ErrorsType errors;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Document is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDocument() {
        return choiceSelect == DOCUMENT_CHOICE;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.document = document;
    }

    /** 
     * Get the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @return value
     */
    public SuccessType getSuccess() {
        return success;
    }

    /** 
     * Set the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @param success
     */
    public void setSuccess(SuccessType success) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.success = success;
    }

    /** 
     * Get the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @return value
     */
    public WarningsType getWarnings() {
        return warnings;
    }

    /** 
     * Set the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @param warnings
     */
    public void setWarnings(WarningsType warnings) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.warnings = warnings;
    }

    /** 
     * Get the 'Processing' element value.
     * 
     * @return value
     */
    public ProcessingResultType getProcessing() {
        return processing;
    }

    /** 
     * Set the 'Processing' element value.
     * 
     * @param processing
     */
    public void setProcessing(ProcessingResultType processing) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.processing = processing;
    }

    /** 
     * Get the 'ShoppingResponseID' element value.
     * 
     * @return value
     */
    public ShoppingResponseIDType getShoppingResponseID() {
        return shoppingResponseID;
    }

    /** 
     * Set the 'ShoppingResponseID' element value.
     * 
     * @param shoppingResponseID
     */
    public void setShoppingResponseID(ShoppingResponseIDType shoppingResponseID) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.shoppingResponseID = shoppingResponseID;
    }

    /** 
     * Get the 'Parameters' element value. Search Result Parameters that influence overall message results.

    Note: These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by this specification. 
     * 
     * @return value
     */
    public SeatAvailResParamsType getParameters() {
        return parameters;
    }

    /** 
     * Set the 'Parameters' element value. Search Result Parameters that influence overall message results.

    Note: These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by this specification. 
     * 
     * @param parameters
     */
    public void setParameters(SeatAvailResParamsType parameters) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.parameters = parameters;
    }

    /** 
     * Get the 'ALaCarteOffer' element value.
     * 
     * @return value
     */
    public ALaCarteOffer getALaCarteOffer1() {
        return ALaCarteOffer1;
    }

    /** 
     * Set the 'ALaCarteOffer' element value.
     * 
     * @param ALaCarteOffer1
     */
    public void setALaCarteOffer1(ALaCarteOffer ALaCarteOffer1) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.ALaCarteOffer1 = ALaCarteOffer1;
    }

    /** 
     * Get the list of 'SeatMap' element items.
     * 
     * @return list
     */
    public List<SeatMap> getSeatMapList() {
        return seatMapList;
    }

    /** 
     * Set the list of 'SeatMap' element items.
     * 
     * @param list
     */
    public void setSeatMapList(List<SeatMap> list) {
        setChoiceSelect(DOCUMENT_CHOICE);
        seatMapList = list;
    }

    /** 
     * Get the 'Metadata' element value. Metadata List(s).
     * 
     * @return value
     */
    public SeatAvailResMetadataType getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value. Metadata List(s).
     * 
     * @param metadata
     */
    public void setMetadata(SeatAvailResMetadataType metadata) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.metadata = metadata;
    }

    /** 
     * Get the 'DataLists' element value.
     * 
     * @return value
     */
    public DataLists getDataLists() {
        return dataLists;
    }

    /** 
     * Set the 'DataLists' element value.
     * 
     * @param dataLists
     */
    public void setDataLists(DataLists dataLists) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.dataLists = dataLists;
    }

    /** 
     * Get the 'Policies' element value. Message Policy information.
     * 
     * @return value
     */
    public Policies getPolicies() {
        return policies;
    }

    /** 
     * Set the 'Policies' element value. Message Policy information.
     * 
     * @param policies
     */
    public void setPolicies(Policies policies) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.policies = policies;
    }

    /** 
     * Check if Errors is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifErrors() {
        return choiceSelect == ERRORS_CHOICE;
    }

    /** 
     * Get the 'Errors' element value.
     * 
     * @return value
     */
    public ErrorsType getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value.
     * 
     * @param errors
     */
    public void setErrors(ErrorsType errors) {
        setChoiceSelect(ERRORS_CHOICE);
        this.errors = errors;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Container for standalone optional OfferItems. This supports the shopping basket concept. The main purpose of this structure is to reduce the size of the message by inserting Offer Items which are applicable to multiple flight-related Offers.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ALaCarteOffer" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:OfferType">
     *         &lt;xs:sequence>
     *           &lt;xs:element type="ns:ALaCarteOfferItemType" name="ALaCarteOfferItem" maxOccurs="unbounded"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ALaCarteOffer extends OfferType implements Serializable
    {
        private List<ALaCarteOfferItemType> ALaCarteOfferItemList = new ArrayList<ALaCarteOfferItemType>();

        /** 
         * Get the list of 'ALaCarteOfferItem' element items. One Service or Service  Bundle which is priced per unit. A La Carte Offer Items are optional and variable quantities of these can be selected by any of the eligible passengers for the applicable segments and/or price classes.
         * 
         * @return list
         */
        public List<ALaCarteOfferItemType> getALaCarteOfferItemList() {
            return ALaCarteOfferItemList;
        }

        /** 
         * Set the list of 'ALaCarteOfferItem' element items. One Service or Service  Bundle which is priced per unit. A La Carte Offer Items are optional and variable quantities of these can be selected by any of the eligible passengers for the applicable segments and/or price classes.
         * 
         * @param list
         */
        public void setALaCarteOfferItemList(List<ALaCarteOfferItemType> list) {
            ALaCarteOfferItemList = list;
        }
    }
    /** 
     * Returns a list of cabins and the seats within it.
    
    When the Cabin Layout is returned, this information can be used by the Seller to render a graphical Seat Map.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatMap" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="SegmentRef">
     *         &lt;xs:complexType>
     *           &lt;xs:simpleContent>
     *             &lt;xs:extension base="xs:string">
     *               &lt;xs:attribute type="xs:string" use="optional" name="OnPoint"/>
     *               &lt;xs:attribute type="xs:string" use="optional" name="OffPoint"/>
     *             &lt;/xs:extension>
     *           &lt;/xs:simpleContent>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="Cabin" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Cabin -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SeatMap implements Serializable
    {
        private String segmentRefString;
        private String segmentRefOnPoint;
        private String segmentRefOffPoint;
        private List<Cabin> cabinList = new ArrayList<Cabin>();

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getSegmentRefString() {
            return segmentRefString;
        }

        /** 
         * Set the extension value.
         * 
         * @param segmentRefString
         */
        public void setSegmentRefString(String segmentRefString) {
            this.segmentRefString = segmentRefString;
        }

        /** 
         * Get the 'OnPoint' attribute value. Flight slice on point. Example: TPA

        Encoding Scheme: IATA/ A4A (three character) Airport or City Code
         * 
         * @return value
         */
        public String getSegmentRefOnPoint() {
            return segmentRefOnPoint;
        }

        /** 
         * Set the 'OnPoint' attribute value. Flight slice on point. Example: TPA

        Encoding Scheme: IATA/ A4A (three character) Airport or City Code
         * 
         * @param segmentRefOnPoint
         */
        public void setSegmentRefOnPoint(String segmentRefOnPoint) {
            this.segmentRefOnPoint = segmentRefOnPoint;
        }

        /** 
         * Get the 'OffPoint' attribute value. Flight slice off point. Example: LHR

        Encoding Scheme: IATA/ A4A (three character) Airport or City Code
         * 
         * @return value
         */
        public String getSegmentRefOffPoint() {
            return segmentRefOffPoint;
        }

        /** 
         * Set the 'OffPoint' attribute value. Flight slice off point. Example: LHR

        Encoding Scheme: IATA/ A4A (three character) Airport or City Code
         * 
         * @param segmentRefOffPoint
         */
        public void setSegmentRefOffPoint(String segmentRefOffPoint) {
            this.segmentRefOffPoint = segmentRefOffPoint;
        }

        /** 
         * Get the list of 'Cabin' element items.
         * 
         * @return list
         */
        public List<Cabin> getCabinList() {
            return cabinList;
        }

        /** 
         * Set the list of 'Cabin' element items.
         * 
         * @param list
         */
        public void setCabinList(List<Cabin> list) {
            cabinList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Cabin" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="CabinType" minOccurs="0">
         *         &lt;!-- Reference to inner class CabinType -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="CabinLayout" minOccurs="0">
         *         &lt;!-- Reference to inner class CabinLayout -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Component" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Component -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Row" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Row -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:boolean" name="UpperDeckInd"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Cabin implements Serializable
        {
            private CabinType cabinType;
            private CabinLayout cabinLayout;
            private List<Component> componentList = new ArrayList<Component>();
            private List<Row> rowList = new ArrayList<Row>();
            private Boolean upperDeckInd;

            /** 
             * Get the 'CabinType' element value.
             * 
             * @return value
             */
            public CabinType getCabinType() {
                return cabinType;
            }

            /** 
             * Set the 'CabinType' element value.
             * 
             * @param cabinType
             */
            public void setCabinType(CabinType cabinType) {
                this.cabinType = cabinType;
            }

            /** 
             * Get the 'CabinLayout' element value.
             * 
             * @return value
             */
            public CabinLayout getCabinLayout() {
                return cabinLayout;
            }

            /** 
             * Set the 'CabinLayout' element value.
             * 
             * @param cabinLayout
             */
            public void setCabinLayout(CabinLayout cabinLayout) {
                this.cabinLayout = cabinLayout;
            }

            /** 
             * Get the list of 'Component' element items.
             * 
             * @return list
             */
            public List<Component> getComponentList() {
                return componentList;
            }

            /** 
             * Set the list of 'Component' element items.
             * 
             * @param list
             */
            public void setComponentList(List<Component> list) {
                componentList = list;
            }

            /** 
             * Get the list of 'Row' element items.
             * 
             * @return list
             */
            public List<Row> getRowList() {
                return rowList;
            }

            /** 
             * Set the list of 'Row' element items.
             * 
             * @param list
             */
            public void setRowList(List<Row> list) {
                rowList = list;
            }

            /** 
             * Get the 'UpperDeckInd' attribute value. When true, this seat is on the upper deck.
             * 
             * @return value
             */
            public Boolean getUpperDeckInd() {
                return upperDeckInd;
            }

            /** 
             * Set the 'UpperDeckInd' attribute value. When true, this seat is on the upper deck.
             * 
             * @param upperDeckInd
             */
            public void setUpperDeckInd(Boolean upperDeckInd) {
                this.upperDeckInd = upperDeckInd;
            }
            /** 
             * Cabin type. Examples: First Class, Business Class

            Encoding Scheme: PADIS codeset element 9873 - Cabin Class of Service
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CabinType" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="Code"/>
             *       &lt;xs:element type="xs:string" name="Definition" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="TableName" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="Link" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class CabinType implements Serializable
            {
                private String name;
                private String code;
                private String definition;
                private String tableName;
                private String link;

                /** 
                 * Get the 'Name' element value. Cabin class marketing name. Example: Premium Economy
                 * 
                 * @return value
                 */
                public String getName() {
                    return name;
                }

                /** 
                 * Set the 'Name' element value. Cabin class marketing name. Example: Premium Economy
                 * 
                 * @param name
                 */
                public void setName(String name) {
                    this.name = name;
                }

                /** 
                 * Get the 'Code' element value. Code value. Example: 003
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'Code' element value. Code value. Example: 003
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }

                /** 
                 * Get the 'Definition' element value. Code Definition. Example: Travel Agency
                 * 
                 * @return value
                 */
                public String getDefinition() {
                    return definition;
                }

                /** 
                 * Set the 'Definition' element value. Code Definition. Example: Travel Agency
                 * 
                 * @param definition
                 */
                public void setDefinition(String definition) {
                    this.definition = definition;
                }

                /** 
                 * Get the 'TableName' element value. Code set table name.
                 * 
                 * @return value
                 */
                public String getTableName() {
                    return tableName;
                }

                /** 
                 * Set the 'TableName' element value. Code set table name.
                 * 
                 * @param tableName
                 */
                public void setTableName(String tableName) {
                    this.tableName = tableName;
                }

                /** 
                 * Get the 'Link' element value. Codeset location uri.  Example: http://anysite.com/codeset
                 * 
                 * @return value
                 */
                public String getLink() {
                    return link;
                }

                /** 
                 * Set the 'Link' element value. Codeset location uri.  Example: http://anysite.com/codeset
                 * 
                 * @param link
                 */
                public void setLink(String link) {
                    this.link = link;
                }
            }
            /** 
             * Row detail.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CabinLayout" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Columns" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Columns -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Rows">
             *         &lt;xs:complexType>
             *           &lt;xs:sequence>
             *             &lt;xs:element type="xs:integer" name="First"/>
             *             &lt;xs:element type="xs:integer" name="Last"/>
             *           &lt;/xs:sequence>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element name="WingPosition" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class WingPosition -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="ExitRowPosition" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class ExitRowPosition -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class CabinLayout implements Serializable
            {
                private List<Columns> columnList = new ArrayList<Columns>();
                private BigInteger rowsFirst;
                private BigInteger rowsLast;
                private List<WingPosition> wingPositionList = new ArrayList<WingPosition>();
                private List<ExitRowPosition> exitRowPositionList = new ArrayList<ExitRowPosition>();

                /** 
                 * Get the list of 'Columns' element items.
                 * 
                 * @return list
                 */
                public List<Columns> getColumnList() {
                    return columnList;
                }

                /** 
                 * Set the list of 'Columns' element items.
                 * 
                 * @param list
                 */
                public void setColumnList(List<Columns> list) {
                    columnList = list;
                }

                /** 
                 * Get the 'First' element value. First row number. Example: 08
                 * 
                 * @return value
                 */
                public BigInteger getRowsFirst() {
                    return rowsFirst;
                }

                /** 
                 * Set the 'First' element value. First row number. Example: 08
                 * 
                 * @param rowsFirst
                 */
                public void setRowsFirst(BigInteger rowsFirst) {
                    this.rowsFirst = rowsFirst;
                }

                /** 
                 * Get the 'Last' element value. Last row number.  Example: 44
                 * 
                 * @return value
                 */
                public BigInteger getRowsLast() {
                    return rowsLast;
                }

                /** 
                 * Set the 'Last' element value. Last row number.  Example: 44
                 * 
                 * @param rowsLast
                 */
                public void setRowsLast(BigInteger rowsLast) {
                    this.rowsLast = rowsLast;
                }

                /** 
                 * Get the list of 'WingPosition' element items.
                 * 
                 * @return list
                 */
                public List<WingPosition> getWingPositionList() {
                    return wingPositionList;
                }

                /** 
                 * Set the list of 'WingPosition' element items.
                 * 
                 * @param list
                 */
                public void setWingPositionList(List<WingPosition> list) {
                    wingPositionList = list;
                }

                /** 
                 * Get the list of 'ExitRowPosition' element items.
                 * 
                 * @return list
                 */
                public List<ExitRowPosition> getExitRowPositionList() {
                    return exitRowPositionList;
                }

                /** 
                 * Set the list of 'ExitRowPosition' element items.
                 * 
                 * @param list
                 */
                public void setExitRowPositionList(List<ExitRowPosition> list) {
                    exitRowPositionList = list;
                }
                /** 
                 * Seat column to identify a particular seat position on an aircraft
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Columns" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:string">
                 *         &lt;xs:attribute type="xs:string" use="optional" name="Position"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Columns implements Serializable
                {
                    private String string;
                    private String position;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getString() {
                        return string;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param string
                     */
                    public void setString(String string) {
                        this.string = string;
                    }

                    /** 
                     * Get the 'Position' attribute value. Column position in of the seat.
                    Example: A (AISLE SEAT)

                    For maximum interoperability, refer to IATA PADIS Code List for data element 9825 - Seat Characteristic, Coded.
                     * 
                     * @return value
                     */
                    public String getPosition() {
                        return position;
                    }

                    /** 
                     * Set the 'Position' attribute value. Column position in of the seat.
                    Example: A (AISLE SEAT)

                    For maximum interoperability, refer to IATA PADIS Code List for data element 9825 - Seat Characteristic, Coded.
                     * 
                     * @param position
                     */
                    public void setPosition(String position) {
                        this.position = position;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="WingPosition" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="LastRow"/>
                 *       &lt;xs:element type="xs:string" name="FirstRow"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class WingPosition implements Serializable
                {
                    private String lastRow;
                    private String firstRow;

                    /** 
                     * Get the 'LastRow' element value. Last row number.
                    Example: 16
                     * 
                     * @return value
                     */
                    public String getLastRow() {
                        return lastRow;
                    }

                    /** 
                     * Set the 'LastRow' element value. Last row number.
                    Example: 16
                     * 
                     * @param lastRow
                     */
                    public void setLastRow(String lastRow) {
                        this.lastRow = lastRow;
                    }

                    /** 
                     * Get the 'FirstRow' element value. First row number.
                    Example: 5
                     * 
                     * @return value
                     */
                    public String getFirstRow() {
                        return firstRow;
                    }

                    /** 
                     * Set the 'FirstRow' element value. First row number.
                    Example: 5
                     * 
                     * @param firstRow
                     */
                    public void setFirstRow(String firstRow) {
                        this.firstRow = firstRow;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExitRowPosition" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="RowPosition" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class RowPosition -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ExitRowPosition implements Serializable
                {
                    private List<RowPosition> rowPositionList = new ArrayList<RowPosition>();

                    /** 
                     * Get the list of 'RowPosition' element items.
                     * 
                     * @return list
                     */
                    public List<RowPosition> getRowPositionList() {
                        return rowPositionList;
                    }

                    /** 
                     * Set the list of 'RowPosition' element items.
                     * 
                     * @param list
                     */
                    public void setRowPositionList(List<RowPosition> list) {
                        rowPositionList = list;
                    }
                    /** 
                     * EXIT row detail.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RowPosition" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="First">
                     *         &lt;xs:complexType>
                     *           &lt;xs:simpleContent>
                     *             &lt;xs:extension base="xs:string">
                     *               &lt;xs:attribute type="xs:integer" name="Columns"/>
                     *             &lt;/xs:extension>
                     *           &lt;/xs:simpleContent>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="Last">
                     *         &lt;xs:complexType>
                     *           &lt;xs:simpleContent>
                     *             &lt;xs:extension base="xs:string">
                     *               &lt;xs:attribute type="xs:integer" name="Columns"/>
                     *             &lt;/xs:extension>
                     *           &lt;/xs:simpleContent>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *       &lt;xs:element type="xs:string" name="Position" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class RowPosition implements Serializable
                    {
                        private String firstString;
                        private BigInteger firstColumns;
                        private String lastString;
                        private BigInteger lastColumns;
                        private String position;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public String getFirstString() {
                            return firstString;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param firstString
                         */
                        public void setFirstString(String firstString) {
                            this.firstString = firstString;
                        }

                        /** 
                         * Get the 'Columns' attribute value. Specifies the exit row position in wide body Aircraft.
                         * 
                         * @return value
                         */
                        public BigInteger getFirstColumns() {
                            return firstColumns;
                        }

                        /** 
                         * Set the 'Columns' attribute value. Specifies the exit row position in wide body Aircraft.
                         * 
                         * @param firstColumns
                         */
                        public void setFirstColumns(BigInteger firstColumns) {
                            this.firstColumns = firstColumns;
                        }

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public String getLastString() {
                            return lastString;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param lastString
                         */
                        public void setLastString(String lastString) {
                            this.lastString = lastString;
                        }

                        /** 
                         * Get the 'Columns' attribute value. Specifies the exit row position in wide body Aircraft.
                         * 
                         * @return value
                         */
                        public BigInteger getLastColumns() {
                            return lastColumns;
                        }

                        /** 
                         * Set the 'Columns' attribute value. Specifies the exit row position in wide body Aircraft.
                         * 
                         * @param lastColumns
                         */
                        public void setLastColumns(BigInteger lastColumns) {
                            this.lastColumns = lastColumns;
                        }

                        /** 
                         * Get the 'Position' element value. Exit row position.
                        Examples:
                        B (Back)
                        C (Center section)
                        F (Front)
                        FB (Front and Back)
                        FMB (Front, Middle and Back)
                        L (Left side section)
                        LC (Left center section)
                        R (Right side section)
                        RC (Right center section)

                        Encoding Scheme: IATA PADIS Code List for data element 3227 - Place/Location Qualifier
                         * 
                         * @return value
                         */
                        public String getPosition() {
                            return position;
                        }

                        /** 
                         * Set the 'Position' element value. Exit row position.
                        Examples:
                        B (Back)
                        C (Center section)
                        F (Front)
                        FB (Front and Back)
                        FMB (Front, Middle and Back)
                        L (Left side section)
                        LC (Left center section)
                        R (Right side section)
                        RC (Right center section)

                        Encoding Scheme: IATA PADIS Code List for data element 3227 - Place/Location Qualifier
                         * 
                         * @param position
                         */
                        public void setPosition(String position) {
                            this.position = position;
                        }
                    }
                }
            }
            /** 
             * Non-Seat Cabin Component information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Component" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Type"/>
             *       &lt;xs:element name="Location">
             *         &lt;xs:complexType>
             *           &lt;xs:sequence>
             *             &lt;xs:element name="RowPosition">
             *               &lt;xs:complexType>
             *                 &lt;xs:sequence>
             *                   &lt;xs:element type="xs:string" name="Begin"/>
             *                   &lt;xs:element type="xs:string" name="End" minOccurs="0"/>
             *                   &lt;xs:element type="ns:BeforeOrAfterListType" name="BeforeOrAfter" minOccurs="0"/>
             *                   &lt;xs:element type="xs:string" name="ColumnPosition" maxOccurs="unbounded"/>
             *                   &lt;xs:element type="xs:string" name="Orientation" minOccurs="0"/>
             *                 &lt;/xs:sequence>
             *               &lt;/xs:complexType>
             *             &lt;/xs:element>
             *           &lt;/xs:sequence>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element name="Dimensions" minOccurs="0">
             *         &lt;!-- Reference to inner class Dimensions -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Component implements Serializable
            {
                private String type;
                private String locationBegin;
                private String locationEnd;
                private BeforeOrAfterListType locationBeforeOrAfter;
                private List<String> locationColumnPositionList = new ArrayList<String>();
                private String locationOrientation;
                private Dimensions dimensions;

                /** 
                 * Get the 'Type' element value. Cabin component.
                Examples:
                701 (Movable compartment divider)
                702 (Convertible seats)
                AR (Air phone)
                BA (Bar)
                BK (Bulkhead)
                CL (Closet)
                G (Galley)
                LA (Lavatory)
                LG (Luggage storage)
                MV (Movie screen)
                SO (Storage space)
                ST (Stairs to upper deck)
                TA (Table)

                Encoding Scheme: IATA PADIS Code List for data element 9978 - Cabin Facilities Characteristic
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'Type' element value. Cabin component.
                Examples:
                701 (Movable compartment divider)
                702 (Convertible seats)
                AR (Air phone)
                BA (Bar)
                BK (Bulkhead)
                CL (Closet)
                G (Galley)
                LA (Lavatory)
                LG (Luggage storage)
                MV (Movie screen)
                SO (Storage space)
                ST (Stairs to upper deck)
                TA (Table)

                Encoding Scheme: IATA PADIS Code List for data element 9978 - Cabin Facilities Characteristic
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'Begin' element value. First row occupied by this item. Example: 13
                 * 
                 * @return value
                 */
                public String getLocationBegin() {
                    return locationBegin;
                }

                /** 
                 * Set the 'Begin' element value. First row occupied by this item. Example: 13
                 * 
                 * @param locationBegin
                 */
                public void setLocationBegin(String locationBegin) {
                    this.locationBegin = locationBegin;
                }

                /** 
                 * Get the 'End' element value. Last row occupied by this item. Example: 17
                 * 
                 * @return value
                 */
                public String getLocationEnd() {
                    return locationEnd;
                }

                /** 
                 * Set the 'End' element value. Last row occupied by this item. Example: 17
                 * 
                 * @param locationEnd
                 */
                public void setLocationEnd(String locationEnd) {
                    this.locationEnd = locationEnd;
                }

                /** 
                 * Get the 'BeforeOrAfter' element value. Location of the component relative to the row position defined (use values 'Before' or 'After').
                 * 
                 * @return value
                 */
                public BeforeOrAfterListType getLocationBeforeOrAfter() {
                    return locationBeforeOrAfter;
                }

                /** 
                 * Set the 'BeforeOrAfter' element value. Location of the component relative to the row position defined (use values 'Before' or 'After').
                 * 
                 * @param locationBeforeOrAfter
                 */
                public void setLocationBeforeOrAfter(
                        BeforeOrAfterListType locationBeforeOrAfter) {
                    this.locationBeforeOrAfter = locationBeforeOrAfter;
                }

                /** 
                 * Get the list of 'ColumnPosition' element items. All columns covered on the map by this item.
                 * 
                 * @return list
                 */
                public List<String> getLocationColumnPositionList() {
                    return locationColumnPositionList;
                }

                /** 
                 * Set the list of 'ColumnPosition' element items. All columns covered on the map by this item.
                 * 
                 * @param list
                 */
                public void setLocationColumnPositionList(List<String> list) {
                    locationColumnPositionList = list;
                }

                /** 
                 * Get the 'Orientation' element value. Orientation of Component in cabin row.

                Examples:
                1  Back
                2  Front
                3  Front and back
                4  Front, middle and back
                C  Center Section
                L  Left side section
                LC Left center section
                R  Right side section
                RC Right center section

                Encoding Scheme: IATA PADIS code list 3227
                 * 
                 * @return value
                 */
                public String getLocationOrientation() {
                    return locationOrientation;
                }

                /** 
                 * Set the 'Orientation' element value. Orientation of Component in cabin row.

                Examples:
                1  Back
                2  Front
                3  Front and back
                4  Front, middle and back
                C  Center Section
                L  Left side section
                LC Left center section
                R  Right side section
                RC Right center section

                Encoding Scheme: IATA PADIS code list 3227
                 * 
                 * @param locationOrientation
                 */
                public void setLocationOrientation(String locationOrientation) {
                    this.locationOrientation = locationOrientation;
                }

                /** 
                 * Get the 'Dimensions' element value.
                 * 
                 * @return value
                 */
                public Dimensions getDimensions() {
                    return dimensions;
                }

                /** 
                 * Set the 'Dimensions' element value.
                 * 
                 * @param dimensions
                 */
                public void setDimensions(Dimensions dimensions) {
                    this.dimensions = dimensions;
                }
                /** 
                 * Seat Dimensions.

                Note: Defines the size of this item in actual measurement units or defines how much space in relation to rows and columns the space of this item actually consumes.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Dimensions" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:choice>
                 *       &lt;xs:sequence>
                 *         &lt;xs:element type="xs:decimal" name="RowEquivalent"/>
                 *         &lt;xs:element type="xs:decimal" name="ColumnEquivalent"/>
                 *       &lt;/xs:sequence>
                 *       &lt;xs:element name="ActualSize">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element type="ns:SizeUnitSimpleType" name="UOM"/>
                 *             &lt;xs:element type="xs:string" name="Length"/>
                 *             &lt;xs:element type="xs:string" name="Width"/>
                 *           &lt;/xs:sequence>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:choice>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Dimensions implements Serializable
                {
                    private int dimensionsSelect = -1;
                    private static final int ROW_EQUIVALENT_CHOICE = 0;
                    private static final int ACTUAL_SIZE_CHOICE = 1;
                    private BigDecimal rowEquivalent;
                    private BigDecimal columnEquivalent;
                    private SizeUnitSimpleType actualSizeUOM;
                    private String actualSizeLength;
                    private String actualSizeWidth;

                    private void setDimensionsSelect(int choice) {
                        if (dimensionsSelect == -1) {
                            dimensionsSelect = choice;
                        } else if (dimensionsSelect != choice) {
                            throw new IllegalStateException(
                                    "Need to call clearDimensionsSelect() before changing existing choice");
                        }
                    }

                    /** 
                     * Clear the choice selection.
                     */
                    public void clearDimensionsSelect() {
                        dimensionsSelect = -1;
                    }

                    /** 
                     * Check if RowEquivalent is current selection for choice.
                     * 
                     * @return <code>true</code> if selection, <code>false</code> if not
                     */
                    public boolean ifRowEquivalent() {
                        return dimensionsSelect == ROW_EQUIVALENT_CHOICE;
                    }

                    /** 
                     * Get the 'RowEquivalent' element value. Length in number of ROWS value. Example: 2.5
                     * 
                     * @return value
                     */
                    public BigDecimal getRowEquivalent() {
                        return rowEquivalent;
                    }

                    /** 
                     * Set the 'RowEquivalent' element value. Length in number of ROWS value. Example: 2.5
                     * 
                     * @param rowEquivalent
                     */
                    public void setRowEquivalent(BigDecimal rowEquivalent) {
                        setDimensionsSelect(ROW_EQUIVALENT_CHOICE);
                        this.rowEquivalent = rowEquivalent;
                    }

                    /** 
                     * Get the 'ColumnEquivalent' element value. Width in number of COLUMNS value. Example: 2.5
                     * 
                     * @return value
                     */
                    public BigDecimal getColumnEquivalent() {
                        return columnEquivalent;
                    }

                    /** 
                     * Set the 'ColumnEquivalent' element value. Width in number of COLUMNS value. Example: 2.5
                     * 
                     * @param columnEquivalent
                     */
                    public void setColumnEquivalent(BigDecimal columnEquivalent) {
                        setDimensionsSelect(ROW_EQUIVALENT_CHOICE);
                        this.columnEquivalent = columnEquivalent;
                    }

                    /** 
                     * Check if ActualSize is current selection for choice.
                     * 
                     * @return <code>true</code> if selection, <code>false</code> if not
                     */
                    public boolean ifActualSize() {
                        return dimensionsSelect == ACTUAL_SIZE_CHOICE;
                    }

                    /** 
                     * Get the 'UOM' element value. First row number.
                    Example: 15
                     * 
                     * @return value
                     */
                    public SizeUnitSimpleType getActualSizeUOM() {
                        return actualSizeUOM;
                    }

                    /** 
                     * Set the 'UOM' element value. First row number.
                    Example: 15
                     * 
                     * @param actualSizeUOM
                     */
                    public void setActualSizeUOM(
                            SizeUnitSimpleType actualSizeUOM) {
                        setDimensionsSelect(ACTUAL_SIZE_CHOICE);
                        this.actualSizeUOM = actualSizeUOM;
                    }

                    /** 
                     * Get the 'Length' element value. Front to back LENGTH measurement value. Example: 70
                     * 
                     * @return value
                     */
                    public String getActualSizeLength() {
                        return actualSizeLength;
                    }

                    /** 
                     * Set the 'Length' element value. Front to back LENGTH measurement value. Example: 70
                     * 
                     * @param actualSizeLength
                     */
                    public void setActualSizeLength(String actualSizeLength) {
                        setDimensionsSelect(ACTUAL_SIZE_CHOICE);
                        this.actualSizeLength = actualSizeLength;
                    }

                    /** 
                     * Get the 'Width' element value. Front to back WIDTH measurement value. Example: 70
                     * 
                     * @return value
                     */
                    public String getActualSizeWidth() {
                        return actualSizeWidth;
                    }

                    /** 
                     * Set the 'Width' element value. Front to back WIDTH measurement value. Example: 70
                     * 
                     * @param actualSizeWidth
                     */
                    public void setActualSizeWidth(String actualSizeWidth) {
                        setDimensionsSelect(ACTUAL_SIZE_CHOICE);
                        this.actualSizeWidth = actualSizeWidth;
                    }
                }
            }
            /** 
             * Seat row, containing individual Seat instances.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Row" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Number"/>
             *       &lt;xs:element name="RowCharacteristics" minOccurs="0">
             *         &lt;!-- Reference to inner class RowCharacteristics -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Seat" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Seat -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Row implements Serializable
            {
                private String number;
                private RowCharacteristics rowCharacteristics;
                private List<Seat> seatList = new ArrayList<Seat>();

                /** 
                 * Get the 'Number' element value. Seat row number. Example: 2
                 * 
                 * @return value
                 */
                public String getNumber() {
                    return number;
                }

                /** 
                 * Set the 'Number' element value. Seat row number. Example: 2
                 * 
                 * @param number
                 */
                public void setNumber(String number) {
                    this.number = number;
                }

                /** 
                 * Get the 'RowCharacteristics' element value.
                 * 
                 * @return value
                 */
                public RowCharacteristics getRowCharacteristics() {
                    return rowCharacteristics;
                }

                /** 
                 * Set the 'RowCharacteristics' element value.
                 * 
                 * @param rowCharacteristics
                 */
                public void setRowCharacteristics(
                        RowCharacteristics rowCharacteristics) {
                    this.rowCharacteristics = rowCharacteristics;
                }

                /** 
                 * Get the list of 'Seat' element items.
                 * 
                 * @return list
                 */
                public List<Seat> getSeatList() {
                    return seatList;
                }

                /** 
                 * Set the list of 'Seat' element items.
                 * 
                 * @param list
                 */
                public void setSeatList(List<Seat> list) {
                    seatList = list;
                }
                /** 
                 * Seat characteristic following PADIS codeset 9864.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RowCharacteristics" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Code" maxOccurs="unbounded"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class RowCharacteristics implements Serializable
                {
                    private List<String> codeList = new ArrayList<String>();

                    /** 
                     * Get the list of 'Code' element items. Row characteristic. Use only if all seats within this row share the same characteristics.

                    Examples:
                    A (Extra Leg Room)
                    B (Buffer Row)
                    MV (Row With Movie Screen)

                    Encoding Scheme: IATA PADIS Code List for data element 9864 - Row Characteristic
                     * 
                     * @return list
                     */
                    public List<String> getCodeList() {
                        return codeList;
                    }

                    /** 
                     * Set the list of 'Code' element items. Row characteristic. Use only if all seats within this row share the same characteristics.

                    Examples:
                    A (Extra Leg Room)
                    B (Buffer Row)
                    MV (Row With Movie Screen)

                    Encoding Scheme: IATA PADIS Code List for data element 9864 - Row Characteristic
                     * 
                     * @param list
                     */
                    public void setCodeList(List<String> list) {
                        codeList = list;
                    }
                }
                /** 
                 * Seat column to identify a particular seat position on an aircraft
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Seat" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Column"/>
                 *       &lt;xs:element type="xs:string" name="SeatStatus" minOccurs="0"/>
                 *       &lt;xs:element name="SeatCharacteristics" minOccurs="0">
                 *         &lt;!-- Reference to inner class SeatCharacteristics -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:string" name="OfferItemRefs" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="SeatDefinitionRef" minOccurs="0" maxOccurs="unbounded"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Seat implements Serializable
                {
                    private String column;
                    private String seatStatus;
                    private SeatCharacteristics seatCharacteristics;
                    private String offerItemRefs;
                    private List<String> seatDefinitionRefList = new ArrayList<String>();

                    /** 
                     * Get the 'Column' element value.
                     * 
                     * @return value
                     */
                    public String getColumn() {
                        return column;
                    }

                    /** 
                     * Set the 'Column' element value.
                     * 
                     * @param column
                     */
                    public void setColumn(String column) {
                        this.column = column;
                    }

                    /** 
                     * Get the 'SeatStatus' element value. Seat status.

                    Encoding Scheme: IATA PADIS Code List for data element 9865 - Seat Occupation
                     * 
                     * @return value
                     */
                    public String getSeatStatus() {
                        return seatStatus;
                    }

                    /** 
                     * Set the 'SeatStatus' element value. Seat status.

                    Encoding Scheme: IATA PADIS Code List for data element 9865 - Seat Occupation
                     * 
                     * @param seatStatus
                     */
                    public void setSeatStatus(String seatStatus) {
                        this.seatStatus = seatStatus;
                    }

                    /** 
                     * Get the 'SeatCharacteristics' element value.
                     * 
                     * @return value
                     */
                    public SeatCharacteristics getSeatCharacteristics() {
                        return seatCharacteristics;
                    }

                    /** 
                     * Set the 'SeatCharacteristics' element value.
                     * 
                     * @param seatCharacteristics
                     */
                    public void setSeatCharacteristics(
                            SeatCharacteristics seatCharacteristics) {
                        this.seatCharacteristics = seatCharacteristics;
                    }

                    /** 
                     * Get the 'OfferItemRefs' element value. Reference to the price point applicable to this individual seat. Multiple seats can reference the same OfferItem.
                     * 
                     * @return value
                     */
                    public String getOfferItemRefs() {
                        return offerItemRefs;
                    }

                    /** 
                     * Set the 'OfferItemRefs' element value. Reference to the price point applicable to this individual seat. Multiple seats can reference the same OfferItem.
                     * 
                     * @param offerItemRefs
                     */
                    public void setOfferItemRefs(String offerItemRefs) {
                        this.offerItemRefs = offerItemRefs;
                    }

                    /** 
                     * Get the list of 'SeatDefinitionRef' element items. Assign additional propoerties of this seat instance by referencing a SeatDefinition (in DataLists).
                     * 
                     * @return list
                     */
                    public List<String> getSeatDefinitionRefList() {
                        return seatDefinitionRefList;
                    }

                    /** 
                     * Set the list of 'SeatDefinitionRef' element items. Assign additional propoerties of this seat instance by referencing a SeatDefinition (in DataLists).
                     * 
                     * @param list
                     */
                    public void setSeatDefinitionRefList(List<String> list) {
                        seatDefinitionRefList = list;
                    }
                    /** 
                     * Seat characteristic following PADIS codeset 9825.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatCharacteristics" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="Code" maxOccurs="unbounded"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class SeatCharacteristics implements
                        Serializable
                    {
                        private List<String> codeList = new ArrayList<String>();

                        /** 
                         * Get the list of 'Code' element items. Refers to aircraft seat characteristics; seat option codes.  Examples: E (EXIT ROW), M (Middle Seat), A (Aisle seat), L (Left side of aircraft), Q (Bulk Head).  Refer to PADIS code list 9825.

                        This Code may be further described in the SeatCharacteristicsList in DataLists.
                         * 
                         * @return list
                         */
                        public List<String> getCodeList() {
                            return codeList;
                        }

                        /** 
                         * Set the list of 'Code' element items. Refers to aircraft seat characteristics; seat option codes.  Examples: E (EXIT ROW), M (Middle Seat), A (Aisle seat), L (Left side of aircraft), Q (Bulk Head).  Refer to PADIS code list 9825.

                        This Code may be further described in the SeatCharacteristicsList in DataLists.
                         * 
                         * @param list
                         */
                        public void setCodeList(List<String> list) {
                            codeList = list;
                        }
                    }
                }
            }
        }
    }
    /** 
     * Data Lists(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DataLists" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PassengerList" minOccurs="0">
     *         &lt;!-- Reference to inner class PassengerList -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ContactList" minOccurs="0">
     *         &lt;!-- Reference to inner class ContactList -->
     *       &lt;/xs:element>
     *       &lt;xs:element ref="ns:BagDisclosureList" minOccurs="0"/>
     *       &lt;xs:element name="BaggageAllowanceList" minOccurs="0">
     *         &lt;!-- Reference to inner class BaggageAllowanceList -->
     *       &lt;/xs:element>
     *       &lt;xs:element ref="ns:ClassOfServiceList" minOccurs="0"/>
     *       &lt;xs:element ref="ns:ContentSourceList" minOccurs="0"/>
     *       &lt;xs:element name="DescriptionList" minOccurs="0">
     *         &lt;!-- Reference to inner class DescriptionList -->
     *       &lt;/xs:element>
     *       &lt;xs:element ref="ns:DisclosureList" minOccurs="0"/>
     *       &lt;xs:element ref="ns:FareList" minOccurs="0"/>
     *       &lt;xs:element name="FlightSegmentList" minOccurs="0">
     *         &lt;!-- Reference to inner class FlightSegmentList -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FlightList" minOccurs="0">
     *         &lt;!-- Reference to inner class FlightList -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="OriginDestinationList" minOccurs="0">
     *         &lt;!-- Reference to inner class OriginDestinationList -->
     *       &lt;/xs:element>
     *       &lt;xs:element ref="ns:InstructionsList" minOccurs="0"/>
     *       &lt;xs:element ref="ns:MediaList" minOccurs="0"/>
     *       &lt;xs:element ref="ns:PenaltyList" minOccurs="0"/>
     *       &lt;xs:element name="PriceClassList" minOccurs="0">
     *         &lt;!-- Reference to inner class PriceClassList -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ServiceDefinitionList" minOccurs="0">
     *         &lt;!-- Reference to inner class ServiceDefinitionList -->
     *       &lt;/xs:element>
     *       &lt;xs:element ref="ns:TermsList" minOccurs="0"/>
     *       &lt;xs:element name="SeatDefinitionList" minOccurs="0">
     *         &lt;!-- Reference to inner class SeatDefinitionList -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DataLists implements Serializable
    {
        private PassengerList passengerList;
        private ContactList contactList;
        private ListOfBagDisclosureType bagDisclosureList;
        private BaggageAllowanceList baggageAllowanceList;
        private ListOfClassOfServiceType classOfServiceList;
        private ListOfContentSourceType contentSourceList;
        private DescriptionList descriptionList;
        private ListOfDisclosureType disclosureList;
        private FareList fareList;
        private FlightSegmentList flightSegmentList;
        private FlightList flightList;
        private OriginDestinationList originDestinationList;
        private ListOfOfferInstructionsType instructionsList;
        private ListOfMediaType mediaList;
        private ListOfOfferPenaltyType penaltyList;
        private PriceClassList priceClassList;
        private ServiceDefinitionList serviceDefinitionList;
        private ListOfOfferTermsType termsList;
        private SeatDefinitionList seatDefinitionList;

        /** 
         * Get the 'PassengerList' element value.
         * 
         * @return value
         */
        public PassengerList getPassengerList() {
            return passengerList;
        }

        /** 
         * Set the 'PassengerList' element value.
         * 
         * @param passengerList
         */
        public void setPassengerList(PassengerList passengerList) {
            this.passengerList = passengerList;
        }

        /** 
         * Get the 'ContactList' element value.
         * 
         * @return value
         */
        public ContactList getContactList() {
            return contactList;
        }

        /** 
         * Set the 'ContactList' element value.
         * 
         * @param contactList
         */
        public void setContactList(ContactList contactList) {
            this.contactList = contactList;
        }

        /** 
         * Get the 'BagDisclosureList' element value.
         * 
         * @return value
         */
        public ListOfBagDisclosureType getBagDisclosureList() {
            return bagDisclosureList;
        }

        /** 
         * Set the 'BagDisclosureList' element value.
         * 
         * @param bagDisclosureList
         */
        public void setBagDisclosureList(
                ListOfBagDisclosureType bagDisclosureList) {
            this.bagDisclosureList = bagDisclosureList;
        }

        /** 
         * Get the 'BaggageAllowanceList' element value.
         * 
         * @return value
         */
        public BaggageAllowanceList getBaggageAllowanceList() {
            return baggageAllowanceList;
        }

        /** 
         * Set the 'BaggageAllowanceList' element value.
         * 
         * @param baggageAllowanceList
         */
        public void setBaggageAllowanceList(
                BaggageAllowanceList baggageAllowanceList) {
            this.baggageAllowanceList = baggageAllowanceList;
        }

        /** 
         * Get the 'ClassOfServiceList' element value.
         * 
         * @return value
         */
        public ListOfClassOfServiceType getClassOfServiceList() {
            return classOfServiceList;
        }

        /** 
         * Set the 'ClassOfServiceList' element value.
         * 
         * @param classOfServiceList
         */
        public void setClassOfServiceList(
                ListOfClassOfServiceType classOfServiceList) {
            this.classOfServiceList = classOfServiceList;
        }

        /** 
         * Get the 'ContentSourceList' element value.
         * 
         * @return value
         */
        public ListOfContentSourceType getContentSourceList() {
            return contentSourceList;
        }

        /** 
         * Set the 'ContentSourceList' element value.
         * 
         * @param contentSourceList
         */
        public void setContentSourceList(
                ListOfContentSourceType contentSourceList) {
            this.contentSourceList = contentSourceList;
        }

        /** 
         * Get the 'DescriptionList' element value.
         * 
         * @return value
         */
        public DescriptionList getDescriptionList() {
            return descriptionList;
        }

        /** 
         * Set the 'DescriptionList' element value.
         * 
         * @param descriptionList
         */
        public void setDescriptionList(DescriptionList descriptionList) {
            this.descriptionList = descriptionList;
        }

        /** 
         * Get the 'DisclosureList' element value.
         * 
         * @return value
         */
        public ListOfDisclosureType getDisclosureList() {
            return disclosureList;
        }

        /** 
         * Set the 'DisclosureList' element value.
         * 
         * @param disclosureList
         */
        public void setDisclosureList(ListOfDisclosureType disclosureList) {
            this.disclosureList = disclosureList;
        }

        /** 
         * Get the 'FareList' element value.
         * 
         * @return value
         */
        public FareList getFareList() {
            return fareList;
        }

        /** 
         * Set the 'FareList' element value.
         * 
         * @param fareList
         */
        public void setFareList(FareList fareList) {
            this.fareList = fareList;
        }

        /** 
         * Get the 'FlightSegmentList' element value.
         * 
         * @return value
         */
        public FlightSegmentList getFlightSegmentList() {
            return flightSegmentList;
        }

        /** 
         * Set the 'FlightSegmentList' element value.
         * 
         * @param flightSegmentList
         */
        public void setFlightSegmentList(FlightSegmentList flightSegmentList) {
            this.flightSegmentList = flightSegmentList;
        }

        /** 
         * Get the 'FlightList' element value.
         * 
         * @return value
         */
        public FlightList getFlightList() {
            return flightList;
        }

        /** 
         * Set the 'FlightList' element value.
         * 
         * @param flightList
         */
        public void setFlightList(FlightList flightList) {
            this.flightList = flightList;
        }

        /** 
         * Get the 'OriginDestinationList' element value.
         * 
         * @return value
         */
        public OriginDestinationList getOriginDestinationList() {
            return originDestinationList;
        }

        /** 
         * Set the 'OriginDestinationList' element value.
         * 
         * @param originDestinationList
         */
        public void setOriginDestinationList(
                OriginDestinationList originDestinationList) {
            this.originDestinationList = originDestinationList;
        }

        /** 
         * Get the 'InstructionsList' element value.
         * 
         * @return value
         */
        public ListOfOfferInstructionsType getInstructionsList() {
            return instructionsList;
        }

        /** 
         * Set the 'InstructionsList' element value.
         * 
         * @param instructionsList
         */
        public void setInstructionsList(
                ListOfOfferInstructionsType instructionsList) {
            this.instructionsList = instructionsList;
        }

        /** 
         * Get the 'MediaList' element value.
         * 
         * @return value
         */
        public ListOfMediaType getMediaList() {
            return mediaList;
        }

        /** 
         * Set the 'MediaList' element value.
         * 
         * @param mediaList
         */
        public void setMediaList(ListOfMediaType mediaList) {
            this.mediaList = mediaList;
        }

        /** 
         * Get the 'PenaltyList' element value.
         * 
         * @return value
         */
        public ListOfOfferPenaltyType getPenaltyList() {
            return penaltyList;
        }

        /** 
         * Set the 'PenaltyList' element value.
         * 
         * @param penaltyList
         */
        public void setPenaltyList(ListOfOfferPenaltyType penaltyList) {
            this.penaltyList = penaltyList;
        }

        /** 
         * Get the 'PriceClassList' element value.
         * 
         * @return value
         */
        public PriceClassList getPriceClassList() {
            return priceClassList;
        }

        /** 
         * Set the 'PriceClassList' element value.
         * 
         * @param priceClassList
         */
        public void setPriceClassList(PriceClassList priceClassList) {
            this.priceClassList = priceClassList;
        }

        /** 
         * Get the 'ServiceDefinitionList' element value.
         * 
         * @return value
         */
        public ServiceDefinitionList getServiceDefinitionList() {
            return serviceDefinitionList;
        }

        /** 
         * Set the 'ServiceDefinitionList' element value.
         * 
         * @param serviceDefinitionList
         */
        public void setServiceDefinitionList(
                ServiceDefinitionList serviceDefinitionList) {
            this.serviceDefinitionList = serviceDefinitionList;
        }

        /** 
         * Get the 'TermsList' element value.
         * 
         * @return value
         */
        public ListOfOfferTermsType getTermsList() {
            return termsList;
        }

        /** 
         * Set the 'TermsList' element value.
         * 
         * @param termsList
         */
        public void setTermsList(ListOfOfferTermsType termsList) {
            this.termsList = termsList;
        }

        /** 
         * Get the 'SeatDefinitionList' element value.
         * 
         * @return value
         */
        public SeatDefinitionList getSeatDefinitionList() {
            return seatDefinitionList;
        }

        /** 
         * Set the 'SeatDefinitionList' element value.
         * 
         * @param seatDefinitionList
         */
        public void setSeatDefinitionList(SeatDefinitionList seatDefinitionList) {
            this.seatDefinitionList = seatDefinitionList;
        }
        /** 
         * Passenger data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:PassengerType" name="Passenger" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PassengerList implements Serializable
        {
            private List<PassengerType> passengerList = new ArrayList<PassengerType>();

            /** 
             * Get the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @return list
             */
            public List<PassengerType> getPassengerList() {
                return passengerList;
            }

            /** 
             * Set the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @param list
             */
            public void setPassengerList(List<PassengerType> list) {
                passengerList = list;
            }
        }
        /** 
         * Contact data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ContactInformationType" name="ContactInformation" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ContactList implements Serializable
        {
            private List<ContactInformationType> contactInformationList = new ArrayList<ContactInformationType>();

            /** 
             * Get the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @return list
             */
            public List<ContactInformationType> getContactInformationList() {
                return contactInformationList;
            }

            /** 
             * Set the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @param list
             */
            public void setContactInformationList(
                    List<ContactInformationType> list) {
                contactInformationList = list;
            }
        }
        /** 
         * Checked or Carry-On Baggage Allowance detail. Use BaggageCategory to specify which of the two.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageAllowanceList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="BaggageAllowance" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class BaggageAllowance -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class BaggageAllowanceList implements Serializable
        {
            private List<BaggageAllowance> baggageAllowanceList = new ArrayList<BaggageAllowance>();

            /** 
             * Get the list of 'BaggageAllowance' element items.
             * 
             * @return list
             */
            public List<BaggageAllowance> getBaggageAllowanceList() {
                return baggageAllowanceList;
            }

            /** 
             * Set the list of 'BaggageAllowance' element items.
             * 
             * @param list
             */
            public void setBaggageAllowanceList(List<BaggageAllowance> list) {
                baggageAllowanceList = list;
            }
            /** 
             * Checked or Carry-On Baggage Allowance detail. Use BaggageCategory to specify which of the two.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageAllowance" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:BaggageCategoryListType" name="BaggageCategory"/>
             *       &lt;xs:element ref="ns:AllowanceDescription" minOccurs="0"/>
             *       &lt;xs:element ref="ns:DimensionAllowance" minOccurs="0"/>
             *       &lt;xs:element ref="ns:PieceAllowance" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element ref="ns:WeightAllowance" minOccurs="0"/>
             *       &lt;xs:element type="ns:BaggageDeterminingCarrierType" name="BaggageDeterminingCarrier" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="BaggageAllowanceID"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BaggageAllowance implements Serializable
            {
                private BaggageCategoryListType baggageCategory;
                private BagAllowanceDescType allowanceDescription;
                private BagAllowanceDimensionType dimensionAllowance;
                private List<BagAllowancePieceType> pieceAllowanceList = new ArrayList<BagAllowancePieceType>();
                private WeightAllowance weightAllowance;
                private BaggageDeterminingCarrierType baggageDeterminingCarrier;
                private String baggageAllowanceID;

                /** 
                 * Get the 'BaggageCategory' element value. Enumeration:

                CarryOn
                Checked
                 * 
                 * @return value
                 */
                public BaggageCategoryListType getBaggageCategory() {
                    return baggageCategory;
                }

                /** 
                 * Set the 'BaggageCategory' element value. Enumeration:

                CarryOn
                Checked
                 * 
                 * @param baggageCategory
                 */
                public void setBaggageCategory(
                        BaggageCategoryListType baggageCategory) {
                    this.baggageCategory = baggageCategory;
                }

                /** 
                 * Get the 'AllowanceDescription' element value.
                 * 
                 * @return value
                 */
                public BagAllowanceDescType getAllowanceDescription() {
                    return allowanceDescription;
                }

                /** 
                 * Set the 'AllowanceDescription' element value.
                 * 
                 * @param allowanceDescription
                 */
                public void setAllowanceDescription(
                        BagAllowanceDescType allowanceDescription) {
                    this.allowanceDescription = allowanceDescription;
                }

                /** 
                 * Get the 'DimensionAllowance' element value.
                 * 
                 * @return value
                 */
                public BagAllowanceDimensionType getDimensionAllowance() {
                    return dimensionAllowance;
                }

                /** 
                 * Set the 'DimensionAllowance' element value.
                 * 
                 * @param dimensionAllowance
                 */
                public void setDimensionAllowance(
                        BagAllowanceDimensionType dimensionAllowance) {
                    this.dimensionAllowance = dimensionAllowance;
                }

                /** 
                 * Get the list of 'PieceAllowance' element items.
                 * 
                 * @return list
                 */
                public List<BagAllowancePieceType> getPieceAllowanceList() {
                    return pieceAllowanceList;
                }

                /** 
                 * Set the list of 'PieceAllowance' element items.
                 * 
                 * @param list
                 */
                public void setPieceAllowanceList(
                        List<BagAllowancePieceType> list) {
                    pieceAllowanceList = list;
                }

                /** 
                 * Get the 'WeightAllowance' element value.
                 * 
                 * @return value
                 */
                public WeightAllowance getWeightAllowance() {
                    return weightAllowance;
                }

                /** 
                 * Set the 'WeightAllowance' element value.
                 * 
                 * @param weightAllowance
                 */
                public void setWeightAllowance(WeightAllowance weightAllowance) {
                    this.weightAllowance = weightAllowance;
                }

                /** 
                 * Get the 'BaggageDeterminingCarrier' element value. Baggage Determining Carrier as defined in resolution 722 (f), and who’s baggage rules apply.
                 * 
                 * @return value
                 */
                public BaggageDeterminingCarrierType getBaggageDeterminingCarrier() {
                    return baggageDeterminingCarrier;
                }

                /** 
                 * Set the 'BaggageDeterminingCarrier' element value. Baggage Determining Carrier as defined in resolution 722 (f), and who’s baggage rules apply.
                 * 
                 * @param baggageDeterminingCarrier
                 */
                public void setBaggageDeterminingCarrier(
                        BaggageDeterminingCarrierType baggageDeterminingCarrier) {
                    this.baggageDeterminingCarrier = baggageDeterminingCarrier;
                }

                /** 
                 * Get the 'BaggageAllowanceID' attribute value.
                 * 
                 * @return value
                 */
                public String getBaggageAllowanceID() {
                    return baggageAllowanceID;
                }

                /** 
                 * Set the 'BaggageAllowanceID' attribute value.
                 * 
                 * @param baggageAllowanceID
                 */
                public void setBaggageAllowanceID(String baggageAllowanceID) {
                    this.baggageAllowanceID = baggageAllowanceID;
                }
            }
        }
        /** 
         * Description Details
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DescriptionList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element ref="ns:Description" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class DescriptionList implements Serializable
        {
            private List<com.gridnine.xtrip.server.gds.tandc.wsmodel.Description> descriptionList = new ArrayList<com.gridnine.xtrip.server.gds.tandc.wsmodel.Description>();

            /** 
             * Get the list of 'Description' element items.
             * 
             * @return list
             */
            public List<com.gridnine.xtrip.server.gds.tandc.wsmodel.Description> getDescriptionList() {
                return descriptionList;
            }

            /** 
             * Set the list of 'Description' element items.
             * 
             * @param list
             */
            public void setDescriptionList(
                    List<com.gridnine.xtrip.server.gds.tandc.wsmodel.Description> list) {
                descriptionList = list;
            }
        }
        /** 
         * List of Flight Segments
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegmentList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ListOfFlightSegmentType" name="FlightSegment" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FlightSegmentList implements Serializable
        {
            private List<ListOfFlightSegmentType> flightSegmentList = new ArrayList<ListOfFlightSegmentType>();

            /** 
             * Get the list of 'FlightSegment' element items.
             * 
             * @return list
             */
            public List<ListOfFlightSegmentType> getFlightSegmentList() {
                return flightSegmentList;
            }

            /** 
             * Set the list of 'FlightSegment' element items.
             * 
             * @param list
             */
            public void setFlightSegmentList(List<ListOfFlightSegmentType> list) {
                flightSegmentList = list;
            }
        }
        /** 
         * List of Flight elements.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Flight" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Flight -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FlightList implements Serializable
        {
            private List<Flight> flightList = new ArrayList<Flight>();

            /** 
             * Get the list of 'Flight' element items.
             * 
             * @return list
             */
            public List<Flight> getFlightList() {
                return flightList;
            }

            /** 
             * Set the list of 'Flight' element items.
             * 
             * @param list
             */
            public void setFlightList(List<Flight> list) {
                flightList = list;
            }
            /** 
             * Journey information describing the travel between an airport/city where travel commences and an airport/city where travel ultimately terminates. A journey may be comprised of one or more segments. Note: This node will be renamed to journey in future releases.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Flight" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:TotalJourneyType" name="Journey" minOccurs="0"/>
             *       &lt;xs:element ref="ns:SegmentReferences"/>
             *       &lt;xs:element name="Settlement" minOccurs="0">
             *         &lt;!-- Reference to inner class Settlement -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
             *     &lt;xs:attribute type="xs:string" name="FlightKey"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * 
             * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
             *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
             * &lt;/xs:attributeGroup>
             * </pre>
             */
            public static class Flight implements Serializable
            {
                private TotalJourneyType journey;
                private SegmentReferences segmentReferences;
                private Settlement settlement;
                private String refs;
                private String flightKey;

                /** 
                 * Get the 'Journey' element value. Flight journey information.
                 * 
                 * @return value
                 */
                public TotalJourneyType getJourney() {
                    return journey;
                }

                /** 
                 * Set the 'Journey' element value. Flight journey information.
                 * 
                 * @param journey
                 */
                public void setJourney(TotalJourneyType journey) {
                    this.journey = journey;
                }

                /** 
                 * Get the 'SegmentReferences' element value.
                 * 
                 * @return value
                 */
                public SegmentReferences getSegmentReferences() {
                    return segmentReferences;
                }

                /** 
                 * Set the 'SegmentReferences' element value.
                 * 
                 * @param segmentReferences
                 */
                public void setSegmentReferences(
                        SegmentReferences segmentReferences) {
                    this.segmentReferences = segmentReferences;
                }

                /** 
                 * Get the 'Settlement' element value.
                 * 
                 * @return value
                 */
                public Settlement getSettlement() {
                    return settlement;
                }

                /** 
                 * Set the 'Settlement' element value.
                 * 
                 * @param settlement
                 */
                public void setSettlement(Settlement settlement) {
                    this.settlement = settlement;
                }

                /** 
                 * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @return value
                 */
                public String getRefs() {
                    return refs;
                }

                /** 
                 * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @param refs
                 */
                public void setRefs(String refs) {
                    this.refs = refs;
                }

                /** 
                 * Get the 'FlightKey' attribute value. A globally unique identifier for this Flight instance. Example: flight1
                 * 
                 * @return value
                 */
                public String getFlightKey() {
                    return flightKey;
                }

                /** 
                 * Set the 'FlightKey' attribute value. A globally unique identifier for this Flight instance. Example: flight1
                 * 
                 * @param flightKey
                 */
                public void setFlightKey(String flightKey) {
                    this.flightKey = flightKey;
                }
                /** 
                 * Interline Settlement information between airlines, including method of settlement, interline settlement value and currency.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Settlement" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Method"/>
                 *       &lt;xs:element type="ns:CurrencyAmountOptType" name="InterlineSettlementValue" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Settlement implements Serializable
                {
                    private String method;
                    private CurrencyAmountOptType interlineSettlementValue;

                    /** 
                     * Get the 'Method' element value. Service settlement method.
                    Examples:
                    AD (Internal Airline Document)
                    DS (Direct Settlement)
                    EA (EMD Associated or Internal Airline Document)
                    ES (EMD Standalone )
                    FI (Fare Integrated)
                    MA (Flight Associated, Settled via MCO)
                    MS (Standalone, Settled via MCO)

                    Encoding Scheme: IATA PADIS Codeset SST (Service Settlement Type)
                     * 
                     * @return value
                     */
                    public String getMethod() {
                        return method;
                    }

                    /** 
                     * Set the 'Method' element value. Service settlement method.
                    Examples:
                    AD (Internal Airline Document)
                    DS (Direct Settlement)
                    EA (EMD Associated or Internal Airline Document)
                    ES (EMD Standalone )
                    FI (Fare Integrated)
                    MA (Flight Associated, Settled via MCO)
                    MS (Standalone, Settled via MCO)

                    Encoding Scheme: IATA PADIS Codeset SST (Service Settlement Type)
                     * 
                     * @param method
                     */
                    public void setMethod(String method) {
                        this.method = method;
                    }

                    /** 
                     * Get the 'InterlineSettlementValue' element value. Settlement (Price) Value. Example: 300 (USD)

                    Note: This represents a Settlement value that is only used between the POA and ORA.
                     * 
                     * @return value
                     */
                    public CurrencyAmountOptType getInterlineSettlementValue() {
                        return interlineSettlementValue;
                    }

                    /** 
                     * Set the 'InterlineSettlementValue' element value. Settlement (Price) Value. Example: 300 (USD)

                    Note: This represents a Settlement value that is only used between the POA and ORA.
                     * 
                     * @param interlineSettlementValue
                     */
                    public void setInterlineSettlementValue(
                            CurrencyAmountOptType interlineSettlementValue) {
                        this.interlineSettlementValue = interlineSettlementValue;
                    }
                }
            }
        }
        /** 
         * List of Origin/Destination elements.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element ref="ns:OriginDestination" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OriginDestinationList implements Serializable
        {
            private List<OriginDestination> originDestinationList = new ArrayList<OriginDestination>();

            /** 
             * Get the list of 'OriginDestination' element items.
             * 
             * @return list
             */
            public List<OriginDestination> getOriginDestinationList() {
                return originDestinationList;
            }

            /** 
             * Set the list of 'OriginDestination' element items.
             * 
             * @param list
             */
            public void setOriginDestinationList(List<OriginDestination> list) {
                originDestinationList = list;
            }
        }
        /** 
         * Price Class list.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceClassList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:PriceClassType" name="PriceClass" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PriceClassList implements Serializable
        {
            private List<PriceClassType> priceClassList = new ArrayList<PriceClassType>();

            /** 
             * Get the list of 'PriceClass' element items.
             * 
             * @return list
             */
            public List<PriceClassType> getPriceClassList() {
                return priceClassList;
            }

            /** 
             * Set the list of 'PriceClass' element items.
             * 
             * @param list
             */
            public void setPriceClassList(List<PriceClassType> list) {
                priceClassList = list;
            }
        }
        /** 
         * Description and characteristics of a Service
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceDefinitionList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ServiceDefinitionType" name="ServiceDefinition" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ServiceDefinitionList implements Serializable
        {
            private List<ServiceDefinitionType> serviceDefinitionList = new ArrayList<ServiceDefinitionType>();

            /** 
             * Get the list of 'ServiceDefinition' element items.
             * 
             * @return list
             */
            public List<ServiceDefinitionType> getServiceDefinitionList() {
                return serviceDefinitionList;
            }

            /** 
             * Set the list of 'ServiceDefinition' element items.
             * 
             * @param list
             */
            public void setServiceDefinitionList(
                    List<ServiceDefinitionType> list) {
                serviceDefinitionList = list;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatDefinitionList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="SeatDefinition" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class SeatDefinition -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SeatDefinitionList implements Serializable
        {
            private List<SeatDefinition> seatDefinitionList = new ArrayList<SeatDefinition>();

            /** 
             * Get the list of 'SeatDefinition' element items.
             * 
             * @return list
             */
            public List<SeatDefinition> getSeatDefinitionList() {
                return seatDefinitionList;
            }

            /** 
             * Set the list of 'SeatDefinition' element items.
             * 
             * @param list
             */
            public void setSeatDefinitionList(List<SeatDefinition> list) {
                seatDefinitionList = list;
            }
            /** 
             * Seat information by aircraft section.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatDefinition" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Description" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Description -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="ns:SeatMapMessageType" name="Marketing" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="SeatCharacteristicCode" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element type="ns:SizeUnitSimpleType" name="UOM" minOccurs="0"/>
             *       &lt;xs:element type="xs:decimal" name="SeatWidthLow" minOccurs="0"/>
             *       &lt;xs:element type="xs:decimal" name="SeatPitchLow" minOccurs="0"/>
             *       &lt;xs:element name="Keywords" minOccurs="0">
             *         &lt;!-- Reference to inner class Keywords -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="SeatDefinitionID"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class SeatDefinition implements Serializable
            {
                private List<Description> descriptionList = new ArrayList<Description>();
                private SeatMapMessageType marketing;
                private List<String> seatCharacteristicCodeList = new ArrayList<String>();
                private SizeUnitSimpleType UOM;
                private BigDecimal seatWidthLow;
                private BigDecimal seatPitchLow;
                private Keywords keywords;
                private String seatDefinitionID;

                /** 
                 * Get the list of 'Description' element items.
                 * 
                 * @return list
                 */
                public List<Description> getDescriptionList() {
                    return descriptionList;
                }

                /** 
                 * Set the list of 'Description' element items.
                 * 
                 * @param list
                 */
                public void setDescriptionList(List<Description> list) {
                    descriptionList = list;
                }

                /** 
                 * Get the 'Marketing' element value. Images and/or links for the entire section defined by the range of rows.
                 * 
                 * @return value
                 */
                public SeatMapMessageType getMarketing() {
                    return marketing;
                }

                /** 
                 * Set the 'Marketing' element value. Images and/or links for the entire section defined by the range of rows.
                 * 
                 * @param marketing
                 */
                public void setMarketing(SeatMapMessageType marketing) {
                    this.marketing = marketing;
                }

                /** 
                 * Get the list of 'SeatCharacteristicCode' element items. Refers to aircraft seat characteristics; seat option codes.  Examples: E (EXIT ROW), M (Middle Seat), A (Aisle seat), L (Left side of aircraft), Q (Bulk Head).  Refer to PADIS code list 9825.
                 * 
                 * @return list
                 */
                public List<String> getSeatCharacteristicCodeList() {
                    return seatCharacteristicCodeList;
                }

                /** 
                 * Set the list of 'SeatCharacteristicCode' element items. Refers to aircraft seat characteristics; seat option codes.  Examples: E (EXIT ROW), M (Middle Seat), A (Aisle seat), L (Left side of aircraft), Q (Bulk Head).  Refer to PADIS code list 9825.
                 * 
                 * @param list
                 */
                public void setSeatCharacteristicCodeList(List<String> list) {
                    seatCharacteristicCodeList = list;
                }

                /** 
                 * Get the 'UOM' element value. Associated Keyword Unit of Measure, if relevant. Example: INCH
                 * 
                 * @return value
                 */
                public SizeUnitSimpleType getUOM() {
                    return UOM;
                }

                /** 
                 * Set the 'UOM' element value. Associated Keyword Unit of Measure, if relevant. Example: INCH
                 * 
                 * @param UOM
                 */
                public void setUOM(SizeUnitSimpleType UOM) {
                    this.UOM = UOM;
                }

                /** 
                 * Get the 'SeatWidthLow' element value. Lowest Width Measurement value for this section. Example: 20
                 * 
                 * @return value
                 */
                public BigDecimal getSeatWidthLow() {
                    return seatWidthLow;
                }

                /** 
                 * Set the 'SeatWidthLow' element value. Lowest Width Measurement value for this section. Example: 20
                 * 
                 * @param seatWidthLow
                 */
                public void setSeatWidthLow(BigDecimal seatWidthLow) {
                    this.seatWidthLow = seatWidthLow;
                }

                /** 
                 * Get the 'SeatPitchLow' element value. Lowest Pitch Measurement value for this section. Example: 32
                 * 
                 * @return value
                 */
                public BigDecimal getSeatPitchLow() {
                    return seatPitchLow;
                }

                /** 
                 * Set the 'SeatPitchLow' element value. Lowest Pitch Measurement value for this section. Example: 32
                 * 
                 * @param seatPitchLow
                 */
                public void setSeatPitchLow(BigDecimal seatPitchLow) {
                    this.seatPitchLow = seatPitchLow;
                }

                /** 
                 * Get the 'Keywords' element value.
                 * 
                 * @return value
                 */
                public Keywords getKeywords() {
                    return keywords;
                }

                /** 
                 * Set the 'Keywords' element value.
                 * 
                 * @param keywords
                 */
                public void setKeywords(Keywords keywords) {
                    this.keywords = keywords;
                }

                /** 
                 * Get the 'SeatDefinitionID' attribute value.
                 * 
                 * @return value
                 */
                public String getSeatDefinitionID() {
                    return seatDefinitionID;
                }

                /** 
                 * Set the 'SeatDefinitionID' attribute value.
                 * 
                 * @param seatDefinitionID
                 */
                public void setSeatDefinitionID(String seatDefinitionID) {
                    this.seatDefinitionID = seatDefinitionID;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Description" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:sequence>
                 *         &lt;xs:element name="Text" minOccurs="0">
                 *           &lt;!-- Reference to inner class Text -->
                 *         &lt;/xs:element>
                 *         &lt;xs:element type="xs:string" name="MarkupStyle" minOccurs="0"/>
                 *       &lt;/xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Link" minOccurs="0"/>
                 *       &lt;xs:element name="Media" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class Media -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Description implements Serializable
                {
                    private Text text;
                    private String markupStyle;
                    private String link;
                    private List<Media> mediaList = new ArrayList<Media>();

                    /** 
                     * Get the 'Text' element value.
                     * 
                     * @return value
                     */
                    public Text getText() {
                        return text;
                    }

                    /** 
                     * Set the 'Text' element value.
                     * 
                     * @param text
                     */
                    public void setText(Text text) {
                        this.text = text;
                    }

                    /** 
                     * Get the 'MarkupStyle' element value. Mark-up Style. Example: HTML
                     * 
                     * @return value
                     */
                    public String getMarkupStyle() {
                        return markupStyle;
                    }

                    /** 
                     * Set the 'MarkupStyle' element value. Mark-up Style. Example: HTML
                     * 
                     * @param markupStyle
                     */
                    public void setMarkupStyle(String markupStyle) {
                        this.markupStyle = markupStyle;
                    }

                    /** 
                     * Get the 'Link' element value. LINK to Description information source.
                     * 
                     * @return value
                     */
                    public String getLink() {
                        return link;
                    }

                    /** 
                     * Set the 'Link' element value. LINK to Description information source.
                     * 
                     * @param link
                     */
                    public void setLink(String link) {
                        this.link = link;
                    }

                    /** 
                     * Get the list of 'Media' element items.
                     * 
                     * @return list
                     */
                    public List<Media> getMediaList() {
                        return mediaList;
                    }

                    /** 
                     * Set the list of 'Media' element items.
                     * 
                     * @param list
                     */
                    public void setMediaList(List<Media> list) {
                        mediaList = list;
                    }
                    /** 
                     * Description value.
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Text" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:string">
                     *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * 
                     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
                     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
                     * &lt;/xs:attributeGroup>
                     * </pre>
                     */
                    public static class Text implements Serializable
                    {
                        private String string;
                        private String refs;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public String getString() {
                            return string;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param string
                         */
                        public void setString(String string) {
                            this.string = string;
                        }

                        /** 
                         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                         * 
                         * @return value
                         */
                        public String getRefs() {
                            return refs;
                        }

                        /** 
                         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                         * 
                         * @param refs
                         */
                        public void setRefs(String refs) {
                            this.refs = refs;
                        }
                    }
                    /** 
                     * Description-associated Media Object(s).
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Media" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:choice>
                     *       &lt;xs:element type="ns:UniqueIDContextType" name="ObjectID"/>
                     *       &lt;xs:element ref="ns:MediaLink"/>
                     *       &lt;xs:element type="ns:UniqueIDContextType" name="AttachmentID"/>
                     *     &lt;/xs:choice>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Media implements Serializable
                    {
                        private int mediaListSelect = -1;
                        private static final int OBJECT_ID_CHOICE = 0;
                        private static final int MEDIA_LINK_CHOICE = 1;
                        private static final int ATTACHMENT_ID_CHOICE = 2;
                        private UniqueIDContextType objectID;
                        private MediaLink mediaLink;
                        private UniqueIDContextType attachmentID;

                        private void setMediaListSelect(int choice) {
                            if (mediaListSelect == -1) {
                                mediaListSelect = choice;
                            } else if (mediaListSelect != choice) {
                                throw new IllegalStateException(
                                        "Need to call clearMediaListSelect() before changing existing choice");
                            }
                        }

                        /** 
                         * Clear the choice selection.
                         */
                        public void clearMediaListSelect() {
                            mediaListSelect = -1;
                        }

                        /** 
                         * Check if ObjectID is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifObjectID() {
                            return mediaListSelect == OBJECT_ID_CHOICE;
                        }

                        /** 
                         * Get the 'ObjectID' element value. Description-associated MEDIA OBJECT ID or Key. Example: IMG1
                         * 
                         * @return value
                         */
                        public UniqueIDContextType getObjectID() {
                            return objectID;
                        }

                        /** 
                         * Set the 'ObjectID' element value. Description-associated MEDIA OBJECT ID or Key. Example: IMG1
                         * 
                         * @param objectID
                         */
                        public void setObjectID(UniqueIDContextType objectID) {
                            setMediaListSelect(OBJECT_ID_CHOICE);
                            this.objectID = objectID;
                        }

                        /** 
                         * Check if MediaLink is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifMediaLink() {
                            return mediaListSelect == MEDIA_LINK_CHOICE;
                        }

                        /** 
                         * Get the 'MediaLink' element value. Description-associated MEDIA LINK.
                         * 
                         * @return value
                         */
                        public MediaLink getMediaLink() {
                            return mediaLink;
                        }

                        /** 
                         * Set the 'MediaLink' element value. Description-associated MEDIA LINK.
                         * 
                         * @param mediaLink
                         */
                        public void setMediaLink(MediaLink mediaLink) {
                            setMediaListSelect(MEDIA_LINK_CHOICE);
                            this.mediaLink = mediaLink;
                        }

                        /** 
                         * Check if AttachmentID is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifAttachmentID() {
                            return mediaListSelect == ATTACHMENT_ID_CHOICE;
                        }

                        /** 
                         * Get the 'AttachmentID' element value. Description-associated Media Attachment ID. Example: ATT1.
                         * 
                         * @return value
                         */
                        public UniqueIDContextType getAttachmentID() {
                            return attachmentID;
                        }

                        /** 
                         * Set the 'AttachmentID' element value. Description-associated Media Attachment ID. Example: ATT1.
                         * 
                         * @param attachmentID
                         */
                        public void setAttachmentID(
                                UniqueIDContextType attachmentID) {
                            setMediaListSelect(ATTACHMENT_ID_CHOICE);
                            this.attachmentID = attachmentID;
                        }
                    }
                }
                /** 
                 * Seat Description Key-Value Word Pairs.
                Examples:
                ReclineDegree - 25
                BedLengthLowEnd - 68
                BedLengthHighEnd - 78
                WidthLowEnd - 20
                WidthHighEnd - 21.5
                PitchLowEnd - 32
                PitchHighEnd - 34.4

                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Keywords" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="ns:KeyWordType" name="KeyWord" maxOccurs="unbounded"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Keywords implements Serializable
                {
                    private List<KeyWordType> keyWordList = new ArrayList<KeyWordType>();

                    /** 
                     * Get the list of 'KeyWord' element items. Key-Value detail.
                     * 
                     * @return list
                     */
                    public List<KeyWordType> getKeyWordList() {
                        return keyWordList;
                    }

                    /** 
                     * Set the list of 'KeyWord' element items. Key-Value detail.
                     * 
                     * @param list
                     */
                    public void setKeyWordList(List<KeyWordType> list) {
                        keyWordList = list;
                    }
                }
            }
        }
    }
}
