
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * SEAT LOCATION definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatLocationType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Column" minOccurs="0"/>
 *     &lt;xs:element name="Row" minOccurs="0">
 *       &lt;!-- Reference to inner class Row -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Characteristics" minOccurs="0">
 *       &lt;!-- Reference to inner class Characteristics -->
 *     &lt;/xs:element>
 *     &lt;xs:element ref="ns:Associations" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SeatLocationType implements Serializable
{
    private String column;
    private Row row;
    private Characteristics characteristics;
    private Associations associations;

    /** 
     * Get the 'Column' element value. Seat column. Example: A
     * 
     * @return value
     */
    public String getColumn() {
        return column;
    }

    /** 
     * Set the 'Column' element value. Seat column. Example: A
     * 
     * @param column
     */
    public void setColumn(String column) {
        this.column = column;
    }

    /** 
     * Get the 'Row' element value.
     * 
     * @return value
     */
    public Row getRow() {
        return row;
    }

    /** 
     * Set the 'Row' element value.
     * 
     * @param row
     */
    public void setRow(Row row) {
        this.row = row;
    }

    /** 
     * Get the 'Characteristics' element value.
     * 
     * @return value
     */
    public Characteristics getCharacteristics() {
        return characteristics;
    }

    /** 
     * Set the 'Characteristics' element value.
     * 
     * @param characteristics
     */
    public void setCharacteristics(Characteristics characteristics) {
        this.characteristics = characteristics;
    }

    /** 
     * Get the 'Associations' element value.
     * 
     * @return value
     */
    public Associations getAssociations() {
        return associations;
    }

    /** 
     * Set the 'Associations' element value.
     * 
     * @param associations
     */
    public void setAssociations(Associations associations) {
        this.associations = associations;
    }
    /** 
     * Seat row number and row characterisitcs 
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Row" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Number" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Type" minOccurs="0"/>
     *       &lt;xs:element type="ns:SeatDataType" name="SeatData" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Row implements Serializable
    {
        private String number;
        private String type;
        private SeatDataType seatData;
        private String refs;

        /** 
         * Get the 'Number' element value. Seat row number. Example: 2
         * 
         * @return value
         */
        public String getNumber() {
            return number;
        }

        /** 
         * Set the 'Number' element value. Seat row number. Example: 2
         * 
         * @param number
         */
        public void setNumber(String number) {
            this.number = number;
        }

        /** 
         * Get the 'Type' element value. Row characteristic.
        Examples:
        A (Extra Leg Room)
        B (Buffer Row)
        MV (Row With Movie Screen)

        Encoding Scheme: IATA PADIS Code List for data element 9864 - Row Characteristic
         * 
         * @return value
         */
        public String getType() {
            return type;
        }

        /** 
         * Set the 'Type' element value. Row characteristic.
        Examples:
        A (Extra Leg Room)
        B (Buffer Row)
        MV (Row With Movie Screen)

        Encoding Scheme: IATA PADIS Code List for data element 9864 - Row Characteristic
         * 
         * @param type
         */
        public void setType(String type) {
            this.type = type;
        }

        /** 
         * Get the 'SeatData' element value. Seat Details for the entire Row.
         * 
         * @return value
         */
        public SeatDataType getSeatData() {
            return seatData;
        }

        /** 
         * Set the 'SeatData' element value. Seat Details for the entire Row.
         * 
         * @param seatData
         */
        public void setSeatData(SeatDataType seatData) {
            this.seatData = seatData;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
    /** 
     * Seat row Characteristic(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Characteristics" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Characteristic" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Characteristic -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Characteristics implements Serializable
    {
        private List<Characteristic> characteristicList = new ArrayList<Characteristic>();

        /** 
         * Get the list of 'Characteristic' element items.
         * 
         * @return list
         */
        public List<Characteristic> getCharacteristicList() {
            return characteristicList;
        }

        /** 
         * Set the list of 'Characteristic' element items.
         * 
         * @param list
         */
        public void setCharacteristicList(List<Characteristic> list) {
            characteristicList = list;
        }
        /** 
         * Refers to aircraft seat characteristics; seat option codes.  Examples: E (EXIT ROW), M (Middle Seat), A (Aisle seat), L (Left side of aircraft), Q (Bulk Head).  Refer to PADIS code list 9825.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Characteristic" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:CodesetType">
         *         &lt;xs:sequence>
         *           &lt;xs:element ref="ns:Remarks" minOccurs="0"/>
         *         &lt;/xs:sequence>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Characteristic extends CodesetType implements
            Serializable
        {
            private Remarks remarks;

            /** 
             * Get the 'Remarks' element value. Additional Seat Remark(s).
             * 
             * @return value
             */
            public Remarks getRemarks() {
                return remarks;
            }

            /** 
             * Set the 'Remarks' element value. Additional Seat Remark(s).
             * 
             * @param remarks
             */
            public void setRemarks(Remarks remarks) {
                this.remarks = remarks;
            }
        }
    }
}
