
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * A data type for Message Security.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SecurityType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="DutyCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="IATA" minOccurs="0"/>
 *     &lt;xs:element name="PseudoCityCode" minOccurs="0">
 *       &lt;!-- Reference to inner class PseudoCityCode -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="LNIATA" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ERSP" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Department" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="DepartmentCode" minOccurs="0"/>
 *     &lt;xs:element name="AirlineSpecificCodes" minOccurs="0">
 *       &lt;xs:simpleType>
 *         &lt;!-- Reference to inner class AirlineSpecificCodes -->
 *       &lt;/xs:simpleType>
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SecurityType implements Serializable
{
    private String dutyCode;
    private String IATA;
    private PseudoCityCode pseudoCityCode;
    private String LNIATA;
    private String ERSP;
    private String department;
    private String departmentCode;
    private AirlineSpecificCodes airlineSpecificCodes;

    /** 
     * Get the 'DutyCode' element value. Agent duty code
     * 
     * @return value
     */
    public String getDutyCode() {
        return dutyCode;
    }

    /** 
     * Set the 'DutyCode' element value. Agent duty code
     * 
     * @param dutyCode
     */
    public void setDutyCode(String dutyCode) {
        this.dutyCode = dutyCode;
    }

    /** 
     * Get the 'IATA' element value. Agency IATA number
     * 
     * @return value
     */
    public String getIATA() {
        return IATA;
    }

    /** 
     * Set the 'IATA' element value. Agency IATA number
     * 
     * @param IATA
     */
    public void setIATA(String IATA) {
        this.IATA = IATA;
    }

    /** 
     * Get the 'PseudoCityCode' element value.
     * 
     * @return value
     */
    public PseudoCityCode getPseudoCityCode() {
        return pseudoCityCode;
    }

    /** 
     * Set the 'PseudoCityCode' element value.
     * 
     * @param pseudoCityCode
     */
    public void setPseudoCityCode(PseudoCityCode pseudoCityCode) {
        this.pseudoCityCode = pseudoCityCode;
    }

    /** 
     * Get the 'LNIATA' element value. LNIATA Number – CRT Address/Terminal ID
     * 
     * @return value
     */
    public String getLNIATA() {
        return LNIATA;
    }

    /** 
     * Set the 'LNIATA' element value. LNIATA Number – CRT Address/Terminal ID
     * 
     * @param LNIATA
     */
    public void setLNIATA(String LNIATA) {
        this.LNIATA = LNIATA;
    }

    /** 
     * Get the 'ERSP' element value. ERSP Number: The eight digit IATA
    assigned ERSP code.
     * 
     * @return value
     */
    public String getERSP() {
        return ERSP;
    }

    /** 
     * Set the 'ERSP' element value. ERSP Number: The eight digit IATA
    assigned ERSP code.
     * 
     * @param ERSP
     */
    public void setERSP(String ERSP) {
        this.ERSP = ERSP;
    }

    /** 
     * Get the 'Department' element value. Department/Identifier
     * 
     * @return value
     */
    public String getDepartment() {
        return department;
    }

    /** 
     * Set the 'Department' element value. Department/Identifier
     * 
     * @param department
     */
    public void setDepartment(String department) {
        this.department = department;
    }

    /** 
     * Get the 'DepartmentCode' element value. Carrier/GDS Department Code
     * 
     * @return value
     */
    public String getDepartmentCode() {
        return departmentCode;
    }

    /** 
     * Set the 'DepartmentCode' element value. Carrier/GDS Department Code
     * 
     * @param departmentCode
     */
    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }

    /** 
     * Get the 'AirlineSpecificCodes' element value. Airline specific codes applicable for the Services record owner or the carrier specified in bytes 23-25, defined as follows:
    Code Definition
    RES = all reservation centers
    ATO = all airline ticket offices
    CTO = all city ticket offices
    WEB = website
     * 
     * @return value
     */
    public AirlineSpecificCodes getAirlineSpecificCodes() {
        return airlineSpecificCodes;
    }

    /** 
     * Set the 'AirlineSpecificCodes' element value. Airline specific codes applicable for the Services record owner or the carrier specified in bytes 23-25, defined as follows:
    Code Definition
    RES = all reservation centers
    ATO = all airline ticket offices
    CTO = all city ticket offices
    WEB = website
     * 
     * @param airlineSpecificCodes
     */
    public void setAirlineSpecificCodes(
            AirlineSpecificCodes airlineSpecificCodes) {
        this.airlineSpecificCodes = airlineSpecificCodes;
    }
    /** 
     * Pseudo City code. Example: AAA2
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PseudoCityCode" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" name="Owner"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PseudoCityCode implements Serializable
    {
        private String string;
        private String owner;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'Owner' attribute value. Defines where the PCC was created. For example 1A, 1P, 1S
         * 
         * @return value
         */
        public String getOwner() {
            return owner;
        }

        /** 
         * Set the 'Owner' attribute value. Defines where the PCC was created. For example 1A, 1P, 1S
         * 
         * @param owner
         */
        public void setOwner(String owner) {
            this.owner = owner;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="RES"/>
     *     &lt;xs:enumeration value="ATO"/>
     *     &lt;xs:enumeration value="CTO"/>
     *     &lt;xs:enumeration value="WEB"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum AirlineSpecificCodes implements Serializable {
        RES, ATO, CTO, WEB
    }
}
