
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * A data type for Core Seller Actor Group Representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SellerCoreRepType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:ActorObjectType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Type" minOccurs="0"/>
 *         &lt;xs:element ref="ns:Contacts" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SellerCoreRepType extends ActorObjectType implements Serializable
{
    private String name;
    private String type;
    private Contacts contacts;

    /** 
     * Get the 'Name' element value. Agency Seller Name.  Example: Carson Travel
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Agency Seller Name.  Example: Carson Travel
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'Type' element value. Agency Seller Type.  Examples: TravelAgency, OnlineTravelAgency, TravelManagementCompany
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value. Agency Seller Type.  Examples: TravelAgency, OnlineTravelAgency, TravelManagementCompany
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'Contacts' element value.
     * 
     * @return value
     */
    public Contacts getContacts() {
        return contacts;
    }

    /** 
     * Set the 'Contacts' element value.
     * 
     * @param contacts
     */
    public void setContacts(Contacts contacts) {
        this.contacts = contacts;
    }
}
