
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * A data type for Service Associations.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceAssocListItemType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Airport"/>
 *     &lt;xs:enumeration value="Disclosure"/>
 *     &lt;xs:enumeration value="MediaGroup"/>
 *     &lt;xs:enumeration value="MediaItem"/>
 *     &lt;xs:enumeration value="Offer"/>
 *     &lt;xs:enumeration value="OfferItem"/>
 *     &lt;xs:enumeration value="Penalty"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum ServiceAssocListItemType implements Serializable {
    AIRPORT("Airport"), DISCLOSURE("Disclosure"), MEDIA_GROUP("MediaGroup"), MEDIA_ITEM(
            "MediaItem"), OFFER("Offer"), OFFER_ITEM("OfferItem"), PENALTY(
            "Penalty");
    private final String value;

    private ServiceAssocListItemType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static ServiceAssocListItemType convert(String value) {
        for (ServiceAssocListItemType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
