
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * SERVICE COMBINATION RULES representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceCombinationType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Combination" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Combination -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ServiceCombinationType implements Serializable
{
    private List<Combination> combinationList = new ArrayList<Combination>();

    /** 
     * Get the list of 'Combination' element items.
     * 
     * @return list
     */
    public List<Combination> getCombinationList() {
        return combinationList;
    }

    /** 
     * Set the list of 'Combination' element items.
     * 
     * @param list
     */
    public void setCombinationList(List<Combination> list) {
        combinationList = list;
    }
    /** 
     * Service Combination detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Combination" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Rule"/>
     *       &lt;xs:choice>
     *         &lt;xs:element ref="ns:ServiceID" maxOccurs="unbounded"/>
     *         &lt;xs:element ref="ns:ServiceReference" maxOccurs="unbounded"/>
     *       &lt;/xs:choice>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Combination implements Serializable
    {
        private String rule;
        private int choiceSelect = -1;
        private static final int SERVICE_ID_LIST_CHOICE = 0;
        private static final int SERVICE_REFERENCE_LIST_CHOICE = 1;
        private List<ServiceIDType> serviceIDList = new ArrayList<ServiceIDType>();
        private List<ServiceReference> serviceReferenceList = new ArrayList<ServiceReference>();

        /** 
         * Get the 'Rule' element value. Service Combination Rule.
        Examples: Permitted, NotPermitted, Other
         * 
         * @return value
         */
        public String getRule() {
            return rule;
        }

        /** 
         * Set the 'Rule' element value. Service Combination Rule.
        Examples: Permitted, NotPermitted, Other
         * 
         * @param rule
         */
        public void setRule(String rule) {
            this.rule = rule;
        }

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if ServiceIDList is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifServiceIDList() {
            return choiceSelect == SERVICE_ID_LIST_CHOICE;
        }

        /** 
         * Get the list of 'ServiceID' element items.
         * 
         * @return list
         */
        public List<ServiceIDType> getServiceIDList() {
            return serviceIDList;
        }

        /** 
         * Set the list of 'ServiceID' element items.
         * 
         * @param list
         */
        public void setServiceIDList(List<ServiceIDType> list) {
            setChoiceSelect(SERVICE_ID_LIST_CHOICE);
            serviceIDList = list;
        }

        /** 
         * Check if ServiceReferenceList is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifServiceReferenceList() {
            return choiceSelect == SERVICE_REFERENCE_LIST_CHOICE;
        }

        /** 
         * Get the list of 'ServiceReference' element items.
         * 
         * @return list
         */
        public List<ServiceReference> getServiceReferenceList() {
            return serviceReferenceList;
        }

        /** 
         * Set the list of 'ServiceReference' element items.
         * 
         * @param list
         */
        public void setServiceReferenceList(List<ServiceReference> list) {
            setChoiceSelect(SERVICE_REFERENCE_LIST_CHOICE);
            serviceReferenceList = list;
        }
    }
}
