
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * OPTIONAL SERVICE CORE definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceCoreType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="ns:ServiceID"/>
 *     &lt;xs:element type="xs:string" name="Name"/>
 *     &lt;xs:element type="ns:ServiceEncodingType" name="Encoding" minOccurs="0"/>
 *     &lt;xs:element ref="ns:TimeLimits" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" default="OC" name="FeeMethod" minOccurs="0"/>
 *     &lt;xs:element type="ns:ServiceDescriptionType" name="Descriptions"/>
 *     &lt;xs:element name="Settlement" minOccurs="0">
 *       &lt;!-- Reference to inner class Settlement -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:ServicePriceType" name="Price" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element name="BookingInstructions" minOccurs="0">
 *       &lt;!-- Reference to inner class BookingInstructions -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="ValidatingCarrier" minOccurs="0"/>
 *     &lt;xs:element type="ns:ServiceAssocType" name="Associations" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:BaggageDeterminingCarrierType" name="BaggageDeterminingCarrier" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BDC_AnalysisResult" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ObjectKey"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class ServiceCoreType implements Serializable
{
    private ServiceIDType serviceID;
    private String name;
    private ServiceEncodingType encoding;
    private TimeLimits timeLimits;
    private String feeMethod;
    private ServiceDescriptionType descriptions;
    private Settlement settlement;
    private List<ServicePriceType> priceList = new ArrayList<ServicePriceType>();
    private BookingInstructions bookingInstructions;
    private String validatingCarrier;
    private List<ServiceAssocType> associationList = new ArrayList<ServiceAssocType>();
    private BaggageDeterminingCarrierType baggageDeterminingCarrier;
    private String BDCAnalysisResult;
    private String refs;
    private String objectKey;

    /** 
     * Get the 'ServiceID' element value.
     * 
     * @return value
     */
    public ServiceIDType getServiceID() {
        return serviceID;
    }

    /** 
     * Set the 'ServiceID' element value.
     * 
     * @param serviceID
     */
    public void setServiceID(ServiceIDType serviceID) {
        this.serviceID = serviceID;
    }

    /** 
     * Get the 'Name' element value. Service name. Example: Lounge Pass
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Service name. Example: Lounge Pass
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'Encoding' element value. Service Codes and Reason for Issuance.
     * 
     * @return value
     */
    public ServiceEncodingType getEncoding() {
        return encoding;
    }

    /** 
     * Set the 'Encoding' element value. Service Codes and Reason for Issuance.
     * 
     * @param encoding
     */
    public void setEncoding(ServiceEncodingType encoding) {
        this.encoding = encoding;
    }

    /** 
     * Get the 'TimeLimits' element value.
     * 
     * @return value
     */
    public TimeLimits getTimeLimits() {
        return timeLimits;
    }

    /** 
     * Set the 'TimeLimits' element value.
     * 
     * @param timeLimits
     */
    public void setTimeLimits(TimeLimits timeLimits) {
        this.timeLimits = timeLimits;
    }

    /** 
     * Get the 'FeeMethod' element value. Two character generic code to identify ticket level charges, fees and taxes.
     * 
     * @return value
     */
    public String getFeeMethod() {
        return feeMethod;
    }

    /** 
     * Set the 'FeeMethod' element value. Two character generic code to identify ticket level charges, fees and taxes.
     * 
     * @param feeMethod
     */
    public void setFeeMethod(String feeMethod) {
        this.feeMethod = feeMethod;
    }

    /** 
     * Get the 'Descriptions' element value. SERVICE Description.

    Note: Supports plain text, multimedia and code and link references.
     * 
     * @return value
     */
    public ServiceDescriptionType getDescriptions() {
        return descriptions;
    }

    /** 
     * Set the 'Descriptions' element value. SERVICE Description.

    Note: Supports plain text, multimedia and code and link references.
     * 
     * @param descriptions
     */
    public void setDescriptions(ServiceDescriptionType descriptions) {
        this.descriptions = descriptions;
    }

    /** 
     * Get the 'Settlement' element value.
     * 
     * @return value
     */
    public Settlement getSettlement() {
        return settlement;
    }

    /** 
     * Set the 'Settlement' element value.
     * 
     * @param settlement
     */
    public void setSettlement(Settlement settlement) {
        this.settlement = settlement;
    }

    /** 
     * Get the list of 'Price' element items. Optional SERVICE PRICE.

    Notes: This Price amount may be set to zero if pricing has been applied at the Offer Item level.
     * 
     * @return list
     */
    public List<ServicePriceType> getPriceList() {
        return priceList;
    }

    /** 
     * Set the list of 'Price' element items. Optional SERVICE PRICE.

    Notes: This Price amount may be set to zero if pricing has been applied at the Offer Item level.
     * 
     * @param list
     */
    public void setPriceList(List<ServicePriceType> list) {
        priceList = list;
    }

    /** 
     * Get the 'BookingInstructions' element value.
     * 
     * @return value
     */
    public BookingInstructions getBookingInstructions() {
        return bookingInstructions;
    }

    /** 
     * Set the 'BookingInstructions' element value.
     * 
     * @param bookingInstructions
     */
    public void setBookingInstructions(BookingInstructions bookingInstructions) {
        this.bookingInstructions = bookingInstructions;
    }

    /** 
     * Get the 'ValidatingCarrier' element value. Validating Carrier Airline Designator.
    A two-character alpha-numeric code assigned according to the IATA Resolution 762 or a three-letter airline designator assigned by ICAO.  Refer to IATA Airline Coding Directory .  Example: BA
     * 
     * @return value
     */
    public String getValidatingCarrier() {
        return validatingCarrier;
    }

    /** 
     * Set the 'ValidatingCarrier' element value. Validating Carrier Airline Designator.
    A two-character alpha-numeric code assigned according to the IATA Resolution 762 or a three-letter airline designator assigned by ICAO.  Refer to IATA Airline Coding Directory .  Example: BA
     * 
     * @param validatingCarrier
     */
    public void setValidatingCarrier(String validatingCarrier) {
        this.validatingCarrier = validatingCarrier;
    }

    /** 
     * Get the list of 'Associations' element items. Other Service Association(s).
     * 
     * @return list
     */
    public List<ServiceAssocType> getAssociationList() {
        return associationList;
    }

    /** 
     * Set the list of 'Associations' element items. Other Service Association(s).
     * 
     * @param list
     */
    public void setAssociationList(List<ServiceAssocType> list) {
        associationList = list;
    }

    /** 
     * Get the 'BaggageDeterminingCarrier' element value. Baggage Determining Carrier as defined in resolution 722 (f), and who’s baggage rules apply.
     * 
     * @return value
     */
    public BaggageDeterminingCarrierType getBaggageDeterminingCarrier() {
        return baggageDeterminingCarrier;
    }

    /** 
     * Set the 'BaggageDeterminingCarrier' element value. Baggage Determining Carrier as defined in resolution 722 (f), and who’s baggage rules apply.
     * 
     * @param baggageDeterminingCarrier
     */
    public void setBaggageDeterminingCarrier(
            BaggageDeterminingCarrierType baggageDeterminingCarrier) {
        this.baggageDeterminingCarrier = baggageDeterminingCarrier;
    }

    /** 
     * Get the 'BDC_AnalysisResult' element value. In concert with BaggageDeterminingCarrier data field, specifies the reason for the carrier code.

    Encoding Scheme: IATA PADIS Code List for data element RES.
     * 
     * @return value
     */
    public String getBDCAnalysisResult() {
        return BDCAnalysisResult;
    }

    /** 
     * Set the 'BDC_AnalysisResult' element value. In concert with BaggageDeterminingCarrier data field, specifies the reason for the carrier code.

    Encoding Scheme: IATA PADIS Code List for data element RES.
     * 
     * @param BDCAnalysisResult
     */
    public void setBDCAnalysisResult(String BDCAnalysisResult) {
        this.BDCAnalysisResult = BDCAnalysisResult;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }

    /** 
     * Get the 'ObjectKey' attribute value. Object globally unique Instance ID. Example: obj1
     * 
     * @return value
     */
    public String getObjectKey() {
        return objectKey;
    }

    /** 
     * Set the 'ObjectKey' attribute value. Object globally unique Instance ID. Example: obj1
     * 
     * @param objectKey
     */
    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }
    /** 
     * Interline Settlement information between airlines, including method of settlement, interline settlement value and currency.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Settlement" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Method"/>
     *       &lt;xs:element type="ns:CurrencyAmountOptType" name="InterlineSettlementValue" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Settlement implements Serializable
    {
        private String method;
        private CurrencyAmountOptType interlineSettlementValue;

        /** 
         * Get the 'Method' element value. Service settlement method.
        Examples:
        AD (Internal Airline Document)
        DS (Direct Settlement)
        EA (EMD Associated or Internal Airline Document)
        ES (EMD Standalone )
        FI (Fare Integrated)
        MA (Flight Associated, Settled via MCO)
        MS (Standalone, Settled via MCO)

        Encoding Scheme: IATA PADIS Codeset SST (Service Settlement Type)
         * 
         * @return value
         */
        public String getMethod() {
            return method;
        }

        /** 
         * Set the 'Method' element value. Service settlement method.
        Examples:
        AD (Internal Airline Document)
        DS (Direct Settlement)
        EA (EMD Associated or Internal Airline Document)
        ES (EMD Standalone )
        FI (Fare Integrated)
        MA (Flight Associated, Settled via MCO)
        MS (Standalone, Settled via MCO)

        Encoding Scheme: IATA PADIS Codeset SST (Service Settlement Type)
         * 
         * @param method
         */
        public void setMethod(String method) {
            this.method = method;
        }

        /** 
         * Get the 'InterlineSettlementValue' element value. Settlement (Price) Value. Example: 300 (USD)

        Note: This represents a Settlement value that is only used between the POA and ORA.
         * 
         * @return value
         */
        public CurrencyAmountOptType getInterlineSettlementValue() {
            return interlineSettlementValue;
        }

        /** 
         * Set the 'InterlineSettlementValue' element value. Settlement (Price) Value. Example: 300 (USD)

        Note: This represents a Settlement value that is only used between the POA and ORA.
         * 
         * @param interlineSettlementValue
         */
        public void setInterlineSettlementValue(
                CurrencyAmountOptType interlineSettlementValue) {
            this.interlineSettlementValue = interlineSettlementValue;
        }
    }
    /** 
     * Optional service booking instructions to include SSR, OSI and Upgrade Method.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BookingInstructions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="SSRCode" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element type="xs:string" name="OSIText" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element type="xs:string" name="Method" minOccurs="0"/>
     *       &lt;xs:element name="UpgradeMethod" minOccurs="0">
     *         &lt;!-- Reference to inner class UpgradeMethod -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element type="xs:string" name="Equipment" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class BookingInstructions implements Serializable
    {
        private List<String> SSRCodeList = new ArrayList<String>();
        private List<String> OSITextList = new ArrayList<String>();
        private String method;
        private UpgradeMethod upgradeMethod;
        private List<String> textList = new ArrayList<String>();
        private String equipment;

        /** 
         * Get the list of 'SSRCode' element items. Passenger assistance SSR code value.
        Examples:
        EXST (EXTRA SEAT REQUIRED)
        INFT (INFANT ACCOMPANYING ADULT PASSENGER)
        PETC (PASSENGER TRAVELING WITH PET IN CABIN)
        UMNR (UNACCOMPANIED MINOR)

        For maximum interoperability, it is recommended that IATA (four character) Special Service Request (SSR) Code values be used. Select an enumerated value from the list of enter a four character SSR code string.

        =notes=
        1. Although optional in the schema, some SSR codes may require associated description elements.
         * 
         * @return list
         */
        public List<String> getSSRCodeList() {
            return SSRCodeList;
        }

        /** 
         * Set the list of 'SSRCode' element items. Passenger assistance SSR code value.
        Examples:
        EXST (EXTRA SEAT REQUIRED)
        INFT (INFANT ACCOMPANYING ADULT PASSENGER)
        PETC (PASSENGER TRAVELING WITH PET IN CABIN)
        UMNR (UNACCOMPANIED MINOR)

        For maximum interoperability, it is recommended that IATA (four character) Special Service Request (SSR) Code values be used. Select an enumerated value from the list of enter a four character SSR code string.

        =notes=
        1. Although optional in the schema, some SSR codes may require associated description elements.
         * 
         * @param list
         */
        public void setSSRCodeList(List<String> list) {
            SSRCodeList = list;
        }

        /** 
         * Get the list of 'OSIText' element items. Other service information (OSI) text.
        Example: PAX VIP MEMBER OF PARLIAMENT
         * 
         * @return list
         */
        public List<String> getOSITextList() {
            return OSITextList;
        }

        /** 
         * Set the list of 'OSIText' element items. Other service information (OSI) text.
        Example: PAX VIP MEMBER OF PARLIAMENT
         * 
         * @param list
         */
        public void setOSITextList(List<String> list) {
            OSITextList = list;
        }

        /** 
         * Get the 'Method' element value. PNR booking method.
        Example: AE (BY SSR - SPECIAL SERVICE REQUEST)

        For maximum interoperability, refer to IATA PADIS Code List for data element 9750. Select a code value or enter a value that is bilaterally agreed upon between trading partners.
         * 
         * @return value
         */
        public String getMethod() {
            return method;
        }

        /** 
         * Set the 'Method' element value. PNR booking method.
        Example: AE (BY SSR - SPECIAL SERVICE REQUEST)

        For maximum interoperability, refer to IATA PADIS Code List for data element 9750. Select a code value or enter a value that is bilaterally agreed upon between trading partners.
         * 
         * @param method
         */
        public void setMethod(String method) {
            this.method = method;
        }

        /** 
         * Get the 'UpgradeMethod' element value.
         * 
         * @return value
         */
        public UpgradeMethod getUpgradeMethod() {
            return upgradeMethod;
        }

        /** 
         * Set the 'UpgradeMethod' element value.
         * 
         * @param upgradeMethod
         */
        public void setUpgradeMethod(UpgradeMethod upgradeMethod) {
            this.upgradeMethod = upgradeMethod;
        }

        /** 
         * Get the list of 'Text' element items. Data center instructions.
         * 
         * @return list
         */
        public List<String> getTextList() {
            return textList;
        }

        /** 
         * Set the list of 'Text' element items. Data center instructions.
         * 
         * @param list
         */
        public void setTextList(List<String> list) {
            textList = list;
        }

        /** 
         * Get the 'Equipment' element value. Aircraft equipment information.
         * 
         * @return value
         */
        public String getEquipment() {
            return equipment;
        }

        /** 
         * Set the 'Equipment' element value. Aircraft equipment information.
         * 
         * @param equipment
         */
        public void setEquipment(String equipment) {
            this.equipment = equipment;
        }
        /** 
         * Upgrade method.
        Example: AE (BY SSR - SPECIAL SERVICE REQUEST)

        For maximum interoperability, refer to IATA PADIS Code List for data element 9750. Select a code value or enter a value that is bilaterally agreed upon between trading partners.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UpgradeMethod" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" use="optional" name="NewClass"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class UpgradeMethod implements Serializable
        {
            private String string;
            private String newClass;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'NewClass' attribute value. New class of service.
            Example: B
             * 
             * @return value
             */
            public String getNewClass() {
                return newClass;
            }

            /** 
             * Set the 'NewClass' attribute value. New class of service.
            Example: B
             * 
             * @param newClass
             */
            public void setNewClass(String newClass) {
                this.newClass = newClass;
            }
        }
    }
}
