
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * OPTIONAL SERVICE FULFILLMENT representation, including Date/ Time Period, Location, Fulfillment Company.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceFulfillmentType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="OfferValidDates" minOccurs="0">
 *       &lt;!-- Reference to inner class OfferValidDates -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:FulfillmentPartnerType" name="Provider" minOccurs="0"/>
 *     &lt;xs:element name="Location" minOccurs="0">
 *       &lt;!-- Reference to inner class Location -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class ServiceFulfillmentType implements Serializable
{
    private OfferValidDates offerValidDates;
    private FulfillmentPartnerType provider;
    private Location location;
    private String refs;

    /** 
     * Get the 'OfferValidDates' element value.
     * 
     * @return value
     */
    public OfferValidDates getOfferValidDates() {
        return offerValidDates;
    }

    /** 
     * Set the 'OfferValidDates' element value.
     * 
     * @param offerValidDates
     */
    public void setOfferValidDates(OfferValidDates offerValidDates) {
        this.offerValidDates = offerValidDates;
    }

    /** 
     * Get the 'Provider' element value. Information about the company or party that will fulfill the service.
     * 
     * @return value
     */
    public FulfillmentPartnerType getProvider() {
        return provider;
    }

    /** 
     * Set the 'Provider' element value. Information about the company or party that will fulfill the service.
     * 
     * @param provider
     */
    public void setProvider(FulfillmentPartnerType provider) {
        this.provider = provider;
    }

    /** 
     * Get the 'Location' element value.
     * 
     * @return value
     */
    public Location getLocation() {
        return location;
    }

    /** 
     * Set the 'Location' element value.
     * 
     * @param location
     */
    public void setLocation(Location location) {
        this.location = location;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Service Fulfillment Period.

    Note: This is the start and end date/time period(s) the service may be fullfilled or used.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferValidDates" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:CoreDateGrpType" name="Start" minOccurs="0"/>
     *       &lt;xs:element type="ns:CoreDateGrpType" name="End" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OfferValidDates implements Serializable
    {
        private CoreDateGrpType start;
        private CoreDateGrpType end;

        /** 
         * Get the 'Start' element value. The EARLIEST date the associated optional service is available or may be used.  Example: 2017-01-13
         * 
         * @return value
         */
        public CoreDateGrpType getStart() {
            return start;
        }

        /** 
         * Set the 'Start' element value. The EARLIEST date the associated optional service is available or may be used.  Example: 2017-01-13
         * 
         * @param start
         */
        public void setStart(CoreDateGrpType start) {
            this.start = start;
        }

        /** 
         * Get the 'End' element value. The LATEST date the associated optional service is available or may be used. Example: 2017-03-13
         * 
         * @return value
         */
        public CoreDateGrpType getEnd() {
            return end;
        }

        /** 
         * Set the 'End' element value. The LATEST date the associated optional service is available or may be used. Example: 2017-03-13
         * 
         * @param end
         */
        public void setEnd(CoreDateGrpType end) {
            this.end = end;
        }
    }
    /** 
     * Information about the location where the service will be fulfilled.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Location" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:AirportFulfillmentLocation"/>
     *       &lt;xs:element ref="ns:OtherFulfillmentLocation"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Location implements Serializable
    {
        private SrvcLocationAirportType airportFulfillmentLocation;
        private SrvcLocationAddressType otherFulfillmentLocation;

        /** 
         * Get the 'AirportFulfillmentLocation' element value.
         * 
         * @return value
         */
        public SrvcLocationAirportType getAirportFulfillmentLocation() {
            return airportFulfillmentLocation;
        }

        /** 
         * Set the 'AirportFulfillmentLocation' element value.
         * 
         * @param airportFulfillmentLocation
         */
        public void setAirportFulfillmentLocation(
                SrvcLocationAirportType airportFulfillmentLocation) {
            this.airportFulfillmentLocation = airportFulfillmentLocation;
        }

        /** 
         * Get the 'OtherFulfillmentLocation' element value.
         * 
         * @return value
         */
        public SrvcLocationAddressType getOtherFulfillmentLocation() {
            return otherFulfillmentLocation;
        }

        /** 
         * Set the 'OtherFulfillmentLocation' element value.
         * 
         * @param otherFulfillmentLocation
         */
        public void setOtherFulfillmentLocation(
                SrvcLocationAddressType otherFulfillmentLocation) {
            this.otherFulfillmentLocation = otherFulfillmentLocation;
        }
    }
}
