
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * MINIMUM/ MAXIMUM Service Ordering Quantity definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceItemQuantityType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="MinimumQuantity" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="MaximumQuantity" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ServiceItemQuantityType implements Serializable
{
    private String minimumQuantity;
    private String maximumQuantity;

    /** 
     * Get the 'MinimumQuantity' element value. The MINIMUM Quantity of the Service Item that may be ordered.
    Example: 2
     * 
     * @return value
     */
    public String getMinimumQuantity() {
        return minimumQuantity;
    }

    /** 
     * Set the 'MinimumQuantity' element value. The MINIMUM Quantity of the Service Item that may be ordered.
    Example: 2
     * 
     * @param minimumQuantity
     */
    public void setMinimumQuantity(String minimumQuantity) {
        this.minimumQuantity = minimumQuantity;
    }

    /** 
     * Get the 'MaximumQuantity' element value. The MAXIMUM Quantity of the Service Item that may be ordered.
    Example: 4
     * 
     * @return value
     */
    public String getMaximumQuantity() {
        return maximumQuantity;
    }

    /** 
     * Set the 'MaximumQuantity' element value. The MAXIMUM Quantity of the Service Item that may be ordered.
    Example: 4
     * 
     * @param maximumQuantity
     */
    public void setMaximumQuantity(String maximumQuantity) {
        this.maximumQuantity = maximumQuantity;
    }
}
