
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The ServiceList transaction set returns a list of all applicable ancillary services that meet request qualifiers and flights.

 The message supports shopping for additional a la carte services to compliment any selected offer, as well as shopping for specialty service items not generally included in an initial offer but rather based on service search filters, e.g. sports equipment specialty baggage and unaccompanied minor fees.

 The message also returns multi-media content at the message level and media references at the individual service level.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceListRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:PointOfSale" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element type="ns:SrvListReqParamsType" name="Parameters" minOccurs="0"/>
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:ShoppingResponseID" minOccurs="0"/>
 *         &lt;xs:element name="Query" minOccurs="0">
 *           &lt;!-- Reference to inner class Query -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *       &lt;xs:element ref="ns:Preference" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Qualifier" minOccurs="0"/>
 *       &lt;xs:element type="ns:ItineraryType" name="JourneyData" minOccurs="0"/>
 *       &lt;xs:element name="DataLists" minOccurs="0">
 *         &lt;!-- Reference to inner class DataLists -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:SrvListReqMetadataType" name="Metadata" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Policies" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class ServiceListRQ implements Serializable
{
    private PointOfSaleType pointOfSale;
    private MsgDocumentType document;
    private MsgPartiesType party;
    private SrvListReqParamsType parameters;
    private ShoppingResponseIDType shoppingResponseID;
    private Query query;
    private Preference preference;
    private Qualifier qualifier;
    private ItineraryType journeyData;
    private DataLists dataLists;
    private SrvListReqMetadataType metadata;
    private Policies policies;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'PointOfSale' element value.
     * 
     * @return value
     */
    public PointOfSaleType getPointOfSale() {
        return pointOfSale;
    }

    /** 
     * Set the 'PointOfSale' element value.
     * 
     * @param pointOfSale
     */
    public void setPointOfSale(PointOfSaleType pointOfSale) {
        this.pointOfSale = pointOfSale;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    /** 
     * Get the 'Parameters' element value. Parameters that influence overall message results.

    Note: These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by this specification. 
     * 
     * @return value
     */
    public SrvListReqParamsType getParameters() {
        return parameters;
    }

    /** 
     * Set the 'Parameters' element value. Parameters that influence overall message results.

    Note: These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by this specification. 
     * 
     * @param parameters
     */
    public void setParameters(SrvListReqParamsType parameters) {
        this.parameters = parameters;
    }

    /** 
     * Get the 'ShoppingResponseID' element value.
     * 
     * @return value
     */
    public ShoppingResponseIDType getShoppingResponseID() {
        return shoppingResponseID;
    }

    /** 
     * Set the 'ShoppingResponseID' element value.
     * 
     * @param shoppingResponseID
     */
    public void setShoppingResponseID(ShoppingResponseIDType shoppingResponseID) {
        this.shoppingResponseID = shoppingResponseID;
    }

    /** 
     * Get the 'Query' element value. Choice between entering: 
    1) Cached Shopping Offer IDs
    2) Detailed Query Parameters
     * 
     * @return value
     */
    public Query getQuery() {
        return query;
    }

    /** 
     * Set the 'Query' element value. Choice between entering: 
    1) Cached Shopping Offer IDs
    2) Detailed Query Parameters
     * 
     * @param query
     */
    public void setQuery(Query query) {
        this.query = query;
    }

    /** 
     * Get the 'Preference' element value.
     * 
     * @return value
     */
    public Preference getPreference() {
        return preference;
    }

    /** 
     * Set the 'Preference' element value.
     * 
     * @param preference
     */
    public void setPreference(Preference preference) {
        this.preference = preference;
    }

    /** 
     * Get the 'Qualifier' element value.
     * 
     * @return value
     */
    public Qualifier getQualifier() {
        return qualifier;
    }

    /** 
     * Set the 'Qualifier' element value.
     * 
     * @param qualifier
     */
    public void setQualifier(Qualifier qualifier) {
        this.qualifier = qualifier;
    }

    /** 
     * Get the 'JourneyData' element value. Existing Flight Itinerary Information.
     * 
     * @return value
     */
    public ItineraryType getJourneyData() {
        return journeyData;
    }

    /** 
     * Set the 'JourneyData' element value. Existing Flight Itinerary Information.
     * 
     * @param journeyData
     */
    public void setJourneyData(ItineraryType journeyData) {
        this.journeyData = journeyData;
    }

    /** 
     * Get the 'DataLists' element value.
     * 
     * @return value
     */
    public DataLists getDataLists() {
        return dataLists;
    }

    /** 
     * Set the 'DataLists' element value.
     * 
     * @param dataLists
     */
    public void setDataLists(DataLists dataLists) {
        this.dataLists = dataLists;
    }

    /** 
     * Get the 'Metadata' element value. Metadata List(s).
     * 
     * @return value
     */
    public SrvListReqMetadataType getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value. Metadata List(s).
     * 
     * @param metadata
     */
    public void setMetadata(SrvListReqMetadataType metadata) {
        this.metadata = metadata;
    }

    /** 
     * Get the 'Policies' element value. Message Policy information.
     * 
     * @return value
     */
    public Policies getPolicies() {
        return policies;
    }

    /** 
     * Set the 'Policies' element value. Message Policy information.
     * 
     * @param policies
     */
    public void setPolicies(Policies policies) {
        this.policies = policies;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Core Service List query parameters.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Query" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element type="ns:FlightType" name="OriginDestination" maxOccurs="unbounded"/>
     *       &lt;xs:element ref="ns:OrderID"/>
     *       &lt;xs:element name="Offers">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element name="Offer" maxOccurs="unbounded">
     *               &lt;!-- Reference to inner class Offer -->
     *             &lt;/xs:element>
     *           &lt;/xs:sequence>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Query implements Serializable
    {
        private int querySelect = -1;
        private static final int ORIGIN_DESTINATION_LIST_CHOICE = 0;
        private static final int ORDER_ID_CHOICE = 1;
        private static final int OFFERS_CHOICE = 2;
        private List<FlightType> originDestinationList = new ArrayList<FlightType>();
        private OrderIDType orderID;
        private List<Offer> offerList = new ArrayList<Offer>();

        private void setQuerySelect(int choice) {
            if (querySelect == -1) {
                querySelect = choice;
            } else if (querySelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearQuerySelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearQuerySelect() {
            querySelect = -1;
        }

        /** 
         * Check if OriginDestinationList is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOriginDestinationList() {
            return querySelect == ORIGIN_DESTINATION_LIST_CHOICE;
        }

        /** 
         * Get the list of 'OriginDestination' element items. Origin and Destination.
         * 
         * @return list
         */
        public List<FlightType> getOriginDestinationList() {
            return originDestinationList;
        }

        /** 
         * Set the list of 'OriginDestination' element items. Origin and Destination.
         * 
         * @param list
         */
        public void setOriginDestinationList(List<FlightType> list) {
            setQuerySelect(ORIGIN_DESTINATION_LIST_CHOICE);
            originDestinationList = list;
        }

        /** 
         * Check if OrderID is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOrderID() {
            return querySelect == ORDER_ID_CHOICE;
        }

        /** 
         * Get the 'OrderID' element value.
         * 
         * @return value
         */
        public OrderIDType getOrderID() {
            return orderID;
        }

        /** 
         * Set the 'OrderID' element value.
         * 
         * @param orderID
         */
        public void setOrderID(OrderIDType orderID) {
            setQuerySelect(ORDER_ID_CHOICE);
            this.orderID = orderID;
        }

        /** 
         * Check if OfferList is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOffers() {
            return querySelect == OFFERS_CHOICE;
        }

        /** 
         * Get the list of 'Offer' element items. Airline Offers.
         * 
         * @return list
         */
        public List<Offer> getOfferList() {
            return offerList;
        }

        /** 
         * Set the list of 'Offer' element items. Airline Offers.
         * 
         * @param list
         */
        public void setOfferList(List<Offer> list) {
            setQuerySelect(OFFERS_CHOICE);
            offerList = list;
        }
        /** 
         * Offer Details.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Offer" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ItemID_Type" name="OfferID"/>
         *       &lt;xs:element name="OfferItemIDs">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element ref="ns:OfferItemID" maxOccurs="unbounded"/>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Offer implements Serializable
        {
            private ItemIDType offerID;
            private List<OfferItemID> offerItemIDList = new ArrayList<OfferItemID>();

            /** 
             * Get the 'OfferID' element value. Globally unique Offer instance ID. It is not recommended to exceed 64, and it is not recommended to use dashes. Example: QWASZXERDFCVTYGHBNUIJKNMF67D5F9GHR567SWER41SD458F9456FMDIRTN34DF
             * 
             * @return value
             */
            public ItemIDType getOfferID() {
                return offerID;
            }

            /** 
             * Set the 'OfferID' element value. Globally unique Offer instance ID. It is not recommended to exceed 64, and it is not recommended to use dashes. Example: QWASZXERDFCVTYGHBNUIJKNMF67D5F9GHR567SWER41SD458F9456FMDIRTN34DF
             * 
             * @param offerID
             */
            public void setOfferID(ItemIDType offerID) {
                this.offerID = offerID;
            }

            /** 
             * Get the list of 'OfferItemID' element items. Offer items.
             * 
             * @return list
             */
            public List<OfferItemID> getOfferItemIDList() {
                return offerItemIDList;
            }

            /** 
             * Set the list of 'OfferItemID' element items. Offer items.
             * 
             * @param list
             */
            public void setOfferItemIDList(List<OfferItemID> list) {
                offerItemIDList = list;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DataLists" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PassengerList" minOccurs="0">
     *         &lt;!-- Reference to inner class PassengerList -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ContactList" minOccurs="0">
     *         &lt;!-- Reference to inner class ContactList -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DataLists implements Serializable
    {
        private PassengerList passengerList;
        private ContactList contactList;

        /** 
         * Get the 'PassengerList' element value.
         * 
         * @return value
         */
        public PassengerList getPassengerList() {
            return passengerList;
        }

        /** 
         * Set the 'PassengerList' element value.
         * 
         * @param passengerList
         */
        public void setPassengerList(PassengerList passengerList) {
            this.passengerList = passengerList;
        }

        /** 
         * Get the 'ContactList' element value.
         * 
         * @return value
         */
        public ContactList getContactList() {
            return contactList;
        }

        /** 
         * Set the 'ContactList' element value.
         * 
         * @param contactList
         */
        public void setContactList(ContactList contactList) {
            this.contactList = contactList;
        }
        /** 
         * Passenger data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:PassengerType" name="Passenger" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PassengerList implements Serializable
        {
            private List<PassengerType> passengerList = new ArrayList<PassengerType>();

            /** 
             * Get the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @return list
             */
            public List<PassengerType> getPassengerList() {
                return passengerList;
            }

            /** 
             * Set the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @param list
             */
            public void setPassengerList(List<PassengerType> list) {
                passengerList = list;
            }
        }
        /** 
         * Contact data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ContactInformationType" name="ContactInformation" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ContactList implements Serializable
        {
            private List<ContactInformationType> contactInformationList = new ArrayList<ContactInformationType>();

            /** 
             * Get the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @return list
             */
            public List<ContactInformationType> getContactInformationList() {
                return contactInformationList;
            }

            /** 
             * Set the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @param list
             */
            public void setContactInformationList(
                    List<ContactInformationType> list) {
                contactInformationList = list;
            }
        }
    }
}
