
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for Optional Service Price.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServicePriceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CurrencyAmountOptType" name="Total"/>
 *     &lt;xs:element name="RefundableValue" minOccurs="0">
 *       &lt;!-- Reference to inner class RefundableValue -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Details" minOccurs="0">
 *       &lt;!-- Reference to inner class Details -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:TaxDetailType" name="Taxes" minOccurs="0"/>
 *     &lt;xs:element type="ns:FeeSurchargeType" name="Fees" minOccurs="0"/>
 *     &lt;xs:element ref="ns:PassengerReferences" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class ServicePriceType implements Serializable
{
    private CurrencyAmountOptType total;
    private RefundableValue refundableValue;
    private Details details;
    private TaxDetailType taxes;
    private FeeSurchargeType fees;
    private PassengerReferences passengerReferences;
    private String refs;

    /** 
     * Get the 'Total' element value. Total price. Example: 6000 USD

    Note: This is the total price INCLUDING base price, taxes and fees/ surcharges.
     * 
     * @return value
     */
    public CurrencyAmountOptType getTotal() {
        return total;
    }

    /** 
     * Set the 'Total' element value. Total price. Example: 6000 USD

    Note: This is the total price INCLUDING base price, taxes and fees/ surcharges.
     * 
     * @param total
     */
    public void setTotal(CurrencyAmountOptType total) {
        this.total = total;
    }

    /** 
     * Get the 'RefundableValue' element value.
     * 
     * @return value
     */
    public RefundableValue getRefundableValue() {
        return refundableValue;
    }

    /** 
     * Set the 'RefundableValue' element value.
     * 
     * @param refundableValue
     */
    public void setRefundableValue(RefundableValue refundableValue) {
        this.refundableValue = refundableValue;
    }

    /** 
     * Get the 'Details' element value.
     * 
     * @return value
     */
    public Details getDetails() {
        return details;
    }

    /** 
     * Set the 'Details' element value.
     * 
     * @param details
     */
    public void setDetails(Details details) {
        this.details = details;
    }

    /** 
     * Get the 'Taxes' element value. Ticket Tax/fee/charge details to indicate taxes that apply to country of commencement of travel and routing.
     * 
     * @return value
     */
    public TaxDetailType getTaxes() {
        return taxes;
    }

    /** 
     * Set the 'Taxes' element value. Ticket Tax/fee/charge details to indicate taxes that apply to country of commencement of travel and routing.
     * 
     * @param taxes
     */
    public void setTaxes(TaxDetailType taxes) {
        this.taxes = taxes;
    }

    /** 
     * Get the 'Fees' element value. Individual fee/ surcharge information would appear on the accountable document.
     * 
     * @return value
     */
    public FeeSurchargeType getFees() {
        return fees;
    }

    /** 
     * Set the 'Fees' element value. Individual fee/ surcharge information would appear on the accountable document.
     * 
     * @param fees
     */
    public void setFees(FeeSurchargeType fees) {
        this.fees = fees;
    }

    /** 
     * Get the 'PassengerReferences' element value.
     * 
     * @return value
     */
    public PassengerReferences getPassengerReferences() {
        return passengerReferences;
    }

    /** 
     * Set the 'PassengerReferences' element value.
     * 
     * @param passengerReferences
     */
    public void setPassengerReferences(PassengerReferences passengerReferences) {
        this.passengerReferences = passengerReferences;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Amount or Percent value indicating the refund value of the service.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RefundableValue" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element type="ns:CurrencyAmountOptType" name="Amount"/>
     *       &lt;xs:element type="xs:decimal" name="Percentage"/>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class RefundableValue implements Serializable
    {
        private int refundableValueSelect = -1;
        private static final int AMOUNT_CHOICE = 0;
        private static final int PERCENTAGE_CHOICE = 1;
        private CurrencyAmountOptType amount;
        private BigDecimal percentage;

        private void setRefundableValueSelect(int choice) {
            if (refundableValueSelect == -1) {
                refundableValueSelect = choice;
            } else if (refundableValueSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearRefundableValueSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearRefundableValueSelect() {
            refundableValueSelect = -1;
        }

        /** 
         * Check if Amount is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAmount() {
            return refundableValueSelect == AMOUNT_CHOICE;
        }

        /** 
         * Get the 'Amount' element value. Price breakdown amount in currency. Example: 800 USD

        Note: This is the individual price excluding base price, taxes and fees/ surcharges.
         * 
         * @return value
         */
        public CurrencyAmountOptType getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' element value. Price breakdown amount in currency. Example: 800 USD

        Note: This is the individual price excluding base price, taxes and fees/ surcharges.
         * 
         * @param amount
         */
        public void setAmount(CurrencyAmountOptType amount) {
            setRefundableValueSelect(AMOUNT_CHOICE);
            this.amount = amount;
        }

        /** 
         * Check if Percentage is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPercentage() {
            return refundableValueSelect == PERCENTAGE_CHOICE;
        }

        /** 
         * Get the 'Percentage' element value. Commission percentage. Example: 20
         * 
         * @return value
         */
        public BigDecimal getPercentage() {
            return percentage;
        }

        /** 
         * Set the 'Percentage' element value. Commission percentage. Example: 20
         * 
         * @param percentage
         */
        public void setPercentage(BigDecimal percentage) {
            setRefundableValueSelect(PERCENTAGE_CHOICE);
            this.percentage = percentage;
        }
    }
    /** 
     * Price breakdown details.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Details" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="SubTotal" minOccurs="0">
     *         &lt;!-- Reference to inner class SubTotal -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Detail" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Detail -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Details implements Serializable
    {
        private SubTotal subTotal;
        private List<Detail> detailList = new ArrayList<Detail>();

        /** 
         * Get the 'SubTotal' element value.
         * 
         * @return value
         */
        public SubTotal getSubTotal() {
            return subTotal;
        }

        /** 
         * Set the 'SubTotal' element value.
         * 
         * @param subTotal
         */
        public void setSubTotal(SubTotal subTotal) {
            this.subTotal = subTotal;
        }

        /** 
         * Get the list of 'Detail' element items.
         * 
         * @return list
         */
        public List<Detail> getDetailList() {
            return detailList;
        }

        /** 
         * Set the list of 'Detail' element items.
         * 
         * @param list
         */
        public void setDetailList(List<Detail> list) {
            detailList = list;
        }
        /** 
         * Price breakdown sub-total.

        Notes:
        1. This is the total all price breakdown items, excluding tax and/ or surcharge.
        2. Subtotal may be specified as Currency (simple and detail); Award/ Redemption; or combination of Partial Currency and Award Redemption.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SubTotal" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:choice>
         *       &lt;xs:element ref="ns:SimpleCurrencyPrice" minOccurs="0"/>
         *       &lt;xs:element ref="ns:EncodedCurrencyPrice" minOccurs="0"/>
         *       &lt;xs:element ref="ns:DetailCurrencyPrice" minOccurs="0"/>
         *       &lt;xs:element ref="ns:CombinationPricing" minOccurs="0"/>
         *       &lt;xs:element ref="ns:AwardPricing" minOccurs="0"/>
         *     &lt;/xs:choice>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SubTotal implements Serializable
        {
            private int subTotalSelect = -1;
            private static final int SIMPLE_CURRENCY_PRICE_CHOICE = 0;
            private static final int ENCODED_CURRENCY_PRICE_CHOICE = 1;
            private static final int DETAIL_CURRENCY_PRICE_CHOICE = 2;
            private static final int COMBINATION_PRICING_CHOICE = 3;
            private static final int AWARD_PRICING_CHOICE = 4;
            private SimpleCurrencyPrice simpleCurrencyPrice;
            private EncodedCurrencyPrice encodedCurrencyPrice;
            private DetailCurrencyPriceType detailCurrencyPrice;
            private CombinationPriceType combinationPricing;
            private AwardPriceUnitType awardPricing;

            private void setSubTotalSelect(int choice) {
                if (subTotalSelect == -1) {
                    subTotalSelect = choice;
                } else if (subTotalSelect != choice) {
                    throw new IllegalStateException(
                            "Need to call clearSubTotalSelect() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearSubTotalSelect() {
                subTotalSelect = -1;
            }

            /** 
             * Check if SimpleCurrencyPrice is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifSimpleCurrencyPrice() {
                return subTotalSelect == SIMPLE_CURRENCY_PRICE_CHOICE;
            }

            /** 
             * Get the 'SimpleCurrencyPrice' element value.
             * 
             * @return value
             */
            public SimpleCurrencyPrice getSimpleCurrencyPrice() {
                return simpleCurrencyPrice;
            }

            /** 
             * Set the 'SimpleCurrencyPrice' element value.
             * 
             * @param simpleCurrencyPrice
             */
            public void setSimpleCurrencyPrice(
                    SimpleCurrencyPrice simpleCurrencyPrice) {
                setSubTotalSelect(SIMPLE_CURRENCY_PRICE_CHOICE);
                this.simpleCurrencyPrice = simpleCurrencyPrice;
            }

            /** 
             * Check if EncodedCurrencyPrice is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifEncodedCurrencyPrice() {
                return subTotalSelect == ENCODED_CURRENCY_PRICE_CHOICE;
            }

            /** 
             * Get the 'EncodedCurrencyPrice' element value.
             * 
             * @return value
             */
            public EncodedCurrencyPrice getEncodedCurrencyPrice() {
                return encodedCurrencyPrice;
            }

            /** 
             * Set the 'EncodedCurrencyPrice' element value.
             * 
             * @param encodedCurrencyPrice
             */
            public void setEncodedCurrencyPrice(
                    EncodedCurrencyPrice encodedCurrencyPrice) {
                setSubTotalSelect(ENCODED_CURRENCY_PRICE_CHOICE);
                this.encodedCurrencyPrice = encodedCurrencyPrice;
            }

            /** 
             * Check if DetailCurrencyPrice is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifDetailCurrencyPrice() {
                return subTotalSelect == DETAIL_CURRENCY_PRICE_CHOICE;
            }

            /** 
             * Get the 'DetailCurrencyPrice' element value.
             * 
             * @return value
             */
            public DetailCurrencyPriceType getDetailCurrencyPrice() {
                return detailCurrencyPrice;
            }

            /** 
             * Set the 'DetailCurrencyPrice' element value.
             * 
             * @param detailCurrencyPrice
             */
            public void setDetailCurrencyPrice(
                    DetailCurrencyPriceType detailCurrencyPrice) {
                setSubTotalSelect(DETAIL_CURRENCY_PRICE_CHOICE);
                this.detailCurrencyPrice = detailCurrencyPrice;
            }

            /** 
             * Check if CombinationPricing is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifCombinationPricing() {
                return subTotalSelect == COMBINATION_PRICING_CHOICE;
            }

            /** 
             * Get the 'CombinationPricing' element value.
             * 
             * @return value
             */
            public CombinationPriceType getCombinationPricing() {
                return combinationPricing;
            }

            /** 
             * Set the 'CombinationPricing' element value.
             * 
             * @param combinationPricing
             */
            public void setCombinationPricing(
                    CombinationPriceType combinationPricing) {
                setSubTotalSelect(COMBINATION_PRICING_CHOICE);
                this.combinationPricing = combinationPricing;
            }

            /** 
             * Check if AwardPricing is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifAwardPricing() {
                return subTotalSelect == AWARD_PRICING_CHOICE;
            }

            /** 
             * Get the 'AwardPricing' element value.
             * 
             * @return value
             */
            public AwardPriceUnitType getAwardPricing() {
                return awardPricing;
            }

            /** 
             * Set the 'AwardPricing' element value.
             * 
             * @param awardPricing
             */
            public void setAwardPricing(AwardPriceUnitType awardPricing) {
                setSubTotalSelect(AWARD_PRICING_CHOICE);
                this.awardPricing = awardPricing;
            }
        }
        /** 
         * Price details.

        Note: This price does not include taxes and fee/ surcharges.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Detail" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="Application" minOccurs="0"/>
         *       &lt;xs:element type="ns:CurrencyAmountOptType" name="Amount"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Detail implements Serializable
        {
            private String application;
            private CurrencyAmountOptType amount;

            /** 
             * Get the 'Application' element value. Price application.  Example: Base Fare
             * 
             * @return value
             */
            public String getApplication() {
                return application;
            }

            /** 
             * Set the 'Application' element value. Price application.  Example: Base Fare
             * 
             * @param application
             */
            public void setApplication(String application) {
                this.application = application;
            }

            /** 
             * Get the 'Amount' element value. Price breakdown amount.  Example: 60 USD

            Notes:
            1. This is the individual price excluding base price, taxes and fees/ surcharges.
             * 
             * @return value
             */
            public CurrencyAmountOptType getAmount() {
                return amount;
            }

            /** 
             * Set the 'Amount' element value. Price breakdown amount.  Example: 60 USD

            Notes:
            1. This is the individual price excluding base price, taxes and fees/ surcharges.
             * 
             * @param amount
             */
            public void setAmount(CurrencyAmountOptType amount) {
                this.amount = amount;
            }
        }
    }
}
